/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: tpk.p,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 2.3 $	$Date: 1997/03/17 23:40:20 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: tpk.p,v $
 * Revision 2.3  1997/03/17 23:40:20  milind
 * Added Idle Notification Functionality:
 * The new Macros in converse.h for this are:
 * CsdSetNotifyIdle(fn1, fn2)
 * CsdStartNotifyIdle()
 * CsdStopNotifyIdle()
 *
 * Revision 2.2  1995/11/15 21:04:20  jyelon
 * changed 'MyChareID' to 'ThisChareID'
 *
 * Revision 2.1  1995/10/27  21:55:28  jyelon
 * Changed CmiNumPe to CkNumPes or CNumPes or CmiNumPes
 *
 * Revision 2.0  1995/07/05  20:13:28  brunner
 * Separated out multi stuff, and including in charm_pgms tree
 *
 * Revision 1.2  1995/04/24  22:42:39  narain
 * *** empty log message ***
 *
 * Revision 1.1  1995/02/25  01:27:08  jyelon
 * Initial revision
 *
 ***************************************************************************/
#include "testpgm.interface"
#include "tpk.interface"
module tpk {

#include "qd.h"
#define MAX 30 

message {
	ChareIDType chareid;
	int size;
	int count;
} MSG1;

message [MSG2] {

	int *x;
	int size;
	int count;
	ChareIDType chareid;

	pack jam(in ,out, length)
	MSG2 *in;
	MSG1 **out;
	int *length;
	{
		int i;
		int *temp;
		*length = sizeof(MSG1) + sizeof(int) * in->size;
		(*out) = (MSG1 *) CkAllocPackBuffer(in, *length);
		temp = (int *) (*out + 1);
		for (i=0; i<in->size; i++)
			temp[i] = in->x[i];
		(*out)->size = in->size;
		(*out)->count = in->count;
		(*out)->chareid = in->chareid;
		/* CkFreeMsg(in); */
	}

	unpack unjam(in, out)
	MSG1 *in;
	MSG2 **out;
	{
		int i;
		int *temp;

		(*out) = (MSG2 *) CkAllocMsg(MSG2);
		(*out)->x = (int *) CkAlloc(sizeof(int)*in->size);
		temp = (int *) (in + 1); 
		for (i=0; i<in->size; i++)
			(*out)->x[i] = temp[i];
		(*out)->size = in->size;
		(*out)->count = in->count;
		(*out)->chareid = in->chareid;
	}
} MSG2;

chare start {

    	int iteration;
    	EntryPointType retEP;
    	ChareIDType retID;

 	entry begin:(message main_test::INIT_MSG *imsg)
	{
     		int i;
	     	MSG2 *msg;

     		iteration = imsg->iteration;
     		retEP = imsg->retEP;
     		retID = imsg->retID;


     		msg = (MSG2 *) CkAllocMsg(MSG2);
     		msg->x = (int *) CkAlloc(2*sizeof(int));
     		for (i=0; i<2; i++)
			msg->x[i] = i;
		msg->size = 2;
		msg->count = 0;
     		CreateChare(fib, fib@GOAL, msg, NULL_VID, 1); 
		StartQuiescence(Quiescence, &ThisChareID);
		CkFreeMsg(imsg);
	}


	entry Quiescence: (message QUIESCENCE_MSG *dmsg) 
	{
		main_test::IT_MSG *imsg;
		CkPrintf("TPK:Quiescence Detected.\n");
		imsg = (main_test::IT_MSG *) CkAllocMsg (main_test::IT_MSG);
		imsg->iteration = iteration;

		SendMsg(retEP, imsg, &retID);
		CkFreeMsg(dmsg);
	}

}

chare fib {

int top;
ChareIDType chareid;

entry GOAL: (message MSG2 *msg)
{
	int i; 
	int nextpe;
	MSG2 *tmsg;

	if (msg->count < 20)
	{
/*		CkPrintf("[%d] GOAL:: ", CkMyPe());
		for (i=0; i<msg->size; i++)
			CkPrintf("%2d ", msg->x[i]);
		CkPrintf("\n");
*/		if (msg->count == 0)
			top = 1;
		else
		{
			top = 0;
			chareid = msg->chareid;
		}	
		if(!(msg->count % 25))
		   CkPrintf("%d, ", msg->count);
		nextpe = rand() % CkNumPes();
		tmsg = (MSG2 *) CkAllocMsg(MSG2);
		tmsg->size = msg->size + 1;
		tmsg->count = msg->count + 1;
		tmsg->chareid = ThisChareID;
		tmsg->x = (int *) CkAlloc(sizeof(int)*tmsg->size);
		for (i=0; i<tmsg->size; i++)
			tmsg->x[i] = i;	
     		CreateChare(fib, fib@GOAL, tmsg, NULL_VID, nextpe); 
		CkFreeMsg(msg);
	}
	else
	{
		chareid = msg->chareid;
		CkPrintf("Starting backwards \n");
		PrivateCall(SendResponseBack(msg));
	}
}

entry RESPONSE : (message MSG2 *msg)
{
	int i; 

	if (!top)
	{
/*		CkPrintf("[%d] GOAL:: ", CkMyPe());
		for (i=0; i<msg->size; i++)
			CkPrintf("%2d ", msg->x[i]);
		CkPrintf("\n");
*/		PrivateCall(SendResponseBack(msg));
	}
	else
		{
		CkPrintf("Awaiting Quiescence \n");
		CkFreeMsg(msg);
		}
}

private SendResponseBack(msg)
MSG2 *msg;
{
	int i;
	MSG2 *tmsg;

	tmsg = (MSG2 *) CkAllocMsg(MSG2);
	tmsg->size = msg->size - 1;
        if(!(tmsg->size%25))
		CkPrintf("%d, ", tmsg->size);
	tmsg->x = (int *) CkAlloc(sizeof(int)*tmsg->size);
	for (i=0; i<tmsg->size; i++)
		tmsg->x[i] = i;	
	SendMsg(fib@RESPONSE, tmsg, &chareid);
	CkFreeMsg(msg);
}
}

void initfn()
{
}

}
