/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: pgl.p,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 2.2 $	$Date: 1995/11/15 21:04:20 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: pgl.p,v $
 * Revision 2.2  1995/11/15 21:04:20  jyelon
 * changed 'MyChareID' to 'ThisChareID'
 *
 * Revision 2.1  1995/10/27  21:55:28  jyelon
 * Changed CmiNumPe to CkNumPes or CNumPes or CmiNumPes
 *
 * Revision 2.0  1995/07/05  20:13:28  brunner
 * Separated out multi stuff, and including in charm_pgms tree
 *
 * Revision 1.2  1995/04/24  22:42:39  narain
 * *** empty log message ***
 *
 * Revision 1.1  1995/02/25  01:27:08  jyelon
 * Initial revision
 *
 ***************************************************************************/
#include "pg.int"
#include "testpgm.interface"
#include "pgl.interface"

module pgl {

#include "qd.h"
    
message {
    ChareNumType pgCoord ;
    int iteration;
    EntryPointType retEP;
    ChareIDType retID;
} START_MESSAGE ;

message {
    char lowup[10] ;
    char evenodd[10] ;
} TEST_MESSAGE ;

message {
    int sender ;
} TEST_MESSAGE2 ;

message {
    varSize int tenStuff[] ;
} VARSIZE_MESSAGE ;

message {
	ChareNumType bocnum;
}TMP_MSG;

readonly ChareNumType pgcoord;

void initfn()
{
	pgcoord = PG::CreateRootGroup();
	ReadInit(pgcoord);
}

BranchOffice TestBoc {
    int me, gotBack ;
    int lower, odd ;
    ChareIDType myBocID ;
    ChareNumType myBocNum ;
    ChareNumType coordBoc ;
    int finalGid ;

    int iteration;
    EntryPointType retEP;
    ChareIDType retID;
    
    
    entry start : (message START_MESSAGE *inMsg)
    {
	coordBoc = inMsg->pgCoord ;
	me = CkMyPe() ;
	myBocNum = ThisBOC;
	myBocID = ThisChareID;
	gotBack = 0 ;

     	iteration = inMsg->iteration;
     	retEP = inMsg->retEP;
     	retID = inMsg->retID;


	if (me < CkNumPes()/2) lower = 1 ;
	else lower = 0 ;

	if (me % 2 == 0) odd = 0 ;
	else odd = 1 ;

	PG::Partition(coordBoc, 0, 0, 0, lower, LowerUpperPart, myBocNum) ;
	StartQuiescence(qdetect, &myBocID) ;
	CkFreeMsg(inMsg);

    } /* end entry start */


    entry LowerUpperPart : (message PG::PARTITION_CREATED *inMsg)
    {
	int luGid ;
	TEST_MESSAGE *outMsg ;

	luGid = inMsg->newGid ;

	PG::Partition(coordBoc, luGid, 0, odd, 0, OddEvenPart, myBocNum) ;
	CkFreeMsg(inMsg);
    }


    entry OddEvenPart : (message PG::PARTITION_CREATED *inMsg)
    {
	int i, totalSize ;
	TEST_MESSAGE *outMsg1 ;
	VARSIZE_MESSAGE *vMsg ;

	finalGid = inMsg->newGid ;
	totalSize = 10 ;
	outMsg1 = (TEST_MESSAGE *)CkAllocMsg(TEST_MESSAGE) ;
	vMsg = (VARSIZE_MESSAGE *)CkAllocMsg(VARSIZE_MESSAGE, &totalSize) ;
	for(i=0;i<10;i++) {
	    vMsg->tenStuff[i] = i+100 ;
	}
	SetRefNumber(outMsg1, me) ;
	
	if (odd) strcpy(outMsg1->evenodd, "odd") ;
	else strcpy(outMsg1->evenodd, "even") ;
	
	if (lower) strcpy(outMsg1->lowup, "lower") ;
	else strcpy(outMsg1->lowup, "upper") ;

        PG::Multicast(coordBoc,finalGid,outMsg1,deliverEp,myBocNum) ;
        PG::Multicast(coordBoc,finalGid,vMsg,varsizeEp,myBocNum) ;
	CkFreeMsg(inMsg);
    }
    


    entry deliverEp : (message TEST_MESSAGE *msg) {
	int ref, i ;
	TEST_MESSAGE2 *msg2 ;

	ref = GetRefNumber(msg) ;
	CkPrintf("PGL:**** I am NODE %d and I am %s and %s, as is my sender %d?\n", me, msg->lowup, msg->evenodd,ref) ;

	msg2 = (TEST_MESSAGE2 *)CkAllocMsg(TEST_MESSAGE2) ;
	msg2->sender = me ;
	CkFreeMsg(msg);
	}


    entry varsizeEp : (message VARSIZE_MESSAGE *vMsg) {
	int i ;

	CkPrintf("PGL:Got varsize message - 10 ints\n") ;
	for(i=0;i<10;i++) {
	    CkPrintf("PGL:%d ",vMsg->tenStuff[i]) ;
	}
	CkPrintf("PGL:\n") ;
	CkFreeMsg(vMsg);
    }

    entry qdetect : (message QUIESCENCE_MSG *qmsg) {
	if(me==0) {
	    CkPrintf("PGL:Quiescence detected\n") ;
	}
        PG::Synchronize(coordBoc, finalGid, 49, qmsg, groupSync, myBocID) ;
    }

    entry groupSync : (message QUIESCENCE_MSG *qmsg) {

	CkPrintf("PGL:Group %d on pe %d has syncronized.\n",finalGid,me) ;
        PG::Synchronize(coordBoc, 0, 50, qmsg, allSync, myBocID) ;
    }

    entry allSync : (message QUIESCENCE_MSG *qmsg) {
	main_test::IT_MSG *imsg;


	if(me==0) {
	    CkPrintf("PGL:All processors (group 0) have synchronized... exiting.\n") ;
	imsg = (main_test::IT_MSG *) CkAllocMsg (main_test::IT_MSG);
	imsg->iteration = iteration;

	SendMsg(retEP, imsg, &retID);
	CkFreeMsg(qmsg);
	}
    }


} /* end boc */


chare start {
    ChareNumType testBoc, pgCoord ;
    int iteration;
    EntryPointType retEP;
    ChareIDType retID;
    
 entry begin:(message main_test::INIT_MSG *imsg)
	 {
     START_MESSAGE *startMsg ;

     iteration = imsg->iteration;
     retEP = imsg->retEP;
     retID = imsg->retID;
     pgCoord = pgcoord;
     startMsg = (START_MESSAGE *)CkAllocMsg(START_MESSAGE) ;
     startMsg->pgCoord = pgCoord ;
     startMsg->iteration = iteration;
     startMsg->retEP = retEP;
     startMsg->retID = retID;
     CreateBoc(TestBoc, TestBoc@start, startMsg, bocCreated, &ThisChareID) ;
     CkFreeMsg(imsg);
     }

 entry bocCreated: (message TMP_MSG *msg)
 {
	CkFreeMsg(msg);
 }
}

} /* end module */
