#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <time.h>

#include "applu.h"

verify(xcr, xce, xci)
double xcr[5], xce[5], xci;
{
	double epsilon, tmp;
	double xrr[5], xre[5], xri;
	int m;

	if(nx==12 && ny==12 && nz==12) {
		epsilon = 1.0e-8;
		xrr[0] = 1.6196343210976702e-02;
		xrr[1] = 2.1976745164821318e-03;
		xrr[2] = 1.5179927653399185e-03;
		xrr[3] = 1.5029584435994323e-03;
		xrr[4] = 3.4264073155896461e-02;
		xre[0] = 6.4223319957960924e-04;
		xre[1] = 8.4144342047347926e-05;
		xre[2] = 5.8588269616485186e-05;
		xre[3] = 5.8474222595157350e-05;
		xre[4] = 1.3103347914111294e-03;
		xri = 7.8418928865937083e+00;
		for(m=0;m<5;m++) {
			tmp = ABS((xcr[m]-xrr[m])/xrr[m]);
			if(tmp>epsilon){
				fprintf(outp, "Verification Test for Residuals Failed\n");
				goto label100;
			}
		}
		fprintf(outp,"Verification Test for Residuals is Successful\n");
label100:
		for(m=0;m<5;m++) {
			tmp = ABS((xce[m]-xre[m])/xre[m]);
			if(tmp>epsilon){
				fprintf(outp, "Verification Test for Solution Errors Failed\n");
				goto label200;
			}
		}
		fprintf(outp,"Verification Test for Solution Errors is Successful\n");
label200:
		tmp = ABS((xci-xri)/xri);
		if(tmp>epsilon){
			fprintf(outp, "Verification Test for Surface Integral Failed\n");
		}
		else
		fprintf(outp,"Verification Test for Surface Integral is Successful\n");
	}
	else if(nx==64 && ny==64 && nz==64) {
		epsilon = 1.0e-8;
		xrr[0] = 7.7902107606689367e+02;
		xrr[1] = 6.3402765259692870e+01;
		xrr[2] = 1.9499249727292479e+02;
		xrr[3] = 1.7845301160418537e+02;
		xrr[4] = 1.8384760349464247e+03;
		xre[0] = 2.9964085685471943e+01;
		xre[1] = 2.8194576365003349e+00;
		xre[2] = 7.3473412698774742e+00;
		xre[3] = 6.7139225687777051e+00;
		xre[4] = 7.0715315688392578e+01;
		xri = 2.6030925604886277e+01;
		for(m=0;m<5;m++) {
			tmp = ABS((xcr[m]-xrr[m])/xrr[m]);
			if(tmp>epsilon){
				fprintf(outp, "Verification Test for Residuals Failed\n");
				goto label300;
			}
		}
		fprintf(outp,"Verification Test for Residuals is Successful\n");
label300:
		for(m=0;m<5;m++) {
			tmp = ABS((xce[m]-xre[m])/xre[m]);
			if(tmp>epsilon){
				fprintf(outp, "Verification Test for Solution Errors Failed\n");
				goto label400;
			}
		}
		fprintf(outp,"Verification Test for Solution Errors is Successful\n");
label400:
		tmp = ABS((xci-xri)/xri);
		if(tmp>epsilon){
			fprintf(outp, "Verification Test for Surface Integral Failed\n");
		}
		else
		fprintf(outp,"Verification Test for Surface Integral is Successful\n");
	}
	else if(nx==102 && ny==102 && nz==102) {
		epsilon = 1.0e-8;
		xrr[0] = 3.5532672969982736e+03;
		xrr[1] = 2.6214750795310692e+02;
		xrr[2] = 8.8333721850952190e+02;
		xrr[3] = 7.7812774739425265e+02;
		xrr[4] = 7.3087969592545314e+03;
		xre[0] = 1.1401176380212709e+02;
		xre[1] = 8.1098963655421574e+00;
		xre[2] = 2.8480597317698308e+01;
		xre[3] = 2.5905394567832939e+01;
		xre[4] = 2.6054907504857413e+02;
		xri = 4.7887162703308227e+01;
		for(m=0;m<5;m++) {
			tmp = ABS((xcr[m]-xrr[m])/xrr[m]);
			if(tmp>epsilon){
				fprintf(outp, "Verification Test for Residuals Failed\n");
				goto label500;
			}
		}
		fprintf(outp,"Verification Test for Residuals is Successful\n");
label500:
		for(m=0;m<5;m++) {
			tmp = ABS((xce[m]-xre[m])/xre[m]);
			if(tmp>epsilon){
				fprintf(outp, "Verification Test for Solution Errors Failed\n");
				goto label600;
			}
		}
		fprintf(outp,"Verification Test for Solution Errors is Successful\n");
label600:
		tmp = ABS((xci-xri)/xri);
		if(tmp>epsilon){
			fprintf(outp, "Verification Test for Surface Integral Failed\n");
		}
		else
		fprintf(outp,"Verification Test for Surface Integral is Successful\n");
	}
	else {
		fprintf(outp,"No ref values provided for the problem params\n");
	}
}

