#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <time.h>

#include "applu.h"

ssor()
{
	int idmax[5], jdmax[5], kdmax[5], imax[5], jmax[5], kmax[5];
	double delunm[5], tstart, tend, tmp;
	int lnorm, i, j, k, m,l, istep;

	lnorm = 2;
	tmp = 1.0/(omega*(2.0-omega));
	rhs();
	if(lnorm==1) {
		maxnorm(nx,ny,nz,imax,jmax,kmax,rsd,rsdnm);
		if(ipr==1) {
			fprintf(outp,"Initial Residual Norms\n\n");
			for(m=0;m<5;m++) {
				fprintf(outp,"%e,%d,%d,%d\n",rsdnm[m],imax[m],jmax[m],kmax[m]);
				fprintf(outp,"\n");
			}
		}
	}
	else if (lnorm == 2) {
		l2norm(nx,ny,nz,rsd,rsdnm);
		if(ipr==1) {
			fprintf(outp,"Initial Residual Norms\n\n");
			for(m=0;m<5;m++) {
				fprintf(outp,"RMS-norm of steady-state residual for %s pde = %e\n",name[m],rsdnm[m]);
			}
			fprintf(outp,"\n");
		}
	}
	tstart = timer();
	for(istep=1;istep<=itmax;istep++) {
		if((mod(istep, inorm)==0)&&(ipr==1)) {
			fprintf(outp, "pseudo-time SSOR iteration no.=  %d\n", istep);
			fprintf(outp,"\n");
		}
		for(k=1;k<(nz-1);k++) {
			for(j=1;j<(ny-1);j++) {
				for(i=1;i<(nx-1);i++) {
					for(m=0;m<5;m++) {
						rsd[k][j][i][m] = dt*rsd[k][j][i][m];
					}
				}
			}
		}
		jacld();
		blts(nx,ny,nz,omega,rsd,a,b,c,d);
		jacu();
		buts(nx,ny,nz,omega,rsd,d,a,b,c);
		for(k=1;k<(nz-1);k++) {
			for(j=1;j<(ny-1);j++) {
				for(i=1;i<(nx-1);i++) {
					for(m=0;m<5;m++) {
						u[k][j][i][m] += (tmp*rsd[k][j][i][m]);
					}
				}
			}
		}
		if(mod(istep, inorm)==0) {
			if(lnorm==1) {
				maxnorm(nx,ny,nz,idmax,jdmax,kdmax,rsd,delunm);
				if(ipr==1) {
					for(m=0;m<5;m++)
						fprintf(outp,"%e,%d,%d,%d\n",delunm[m],idmax[m],
							jdmax[m],kdmax[m]);
					fprintf(outp,"\n");
				}
			}
			else if (lnorm==2) {
				l2norm(nx,ny,nz,rsd,delunm);
				if(ipr==1) {
					for(m=0;m<5;m++)
						fprintf(outp,"RMS-norm of SSOR-iteration correction for %s pde = %e\n",name[m],delunm[m]);
					fprintf(outp,"\n");
				}
			}
		}
		rhs();
		if((mod(istep,inorm)==0)||(istep==itmax)) {
			if(lnorm==1) {
				maxnorm(nx,ny,nz,imax,jmax,kmax,rsd,rsdnm);
				if(ipr==1) {
					for(m=0;m<5;m++)
						fprintf(outp,"%e,%d,%d,%d\n",rsdnm[m],imax[m],
							jmax[m],kmax[m]);
					fprintf(outp,"\n");
				}
			}
			else if (lnorm==2) {
				l2norm(nx,ny,nz,rsd,rsdnm);
				if(ipr==1) {
					for(m=0;m<5;m++)
						fprintf(outp,"RMS-norm of steady-state residual for %s pde = %e\n",name[m],rsdnm[m]);
					fprintf(outp,"\n");
				}
			}
		}
		if((rsdnm[0]<tolrsd[0])&&
		(rsdnm[1]<tolrsd[1])&&
		(rsdnm[2]<tolrsd[2])&&
		(rsdnm[3]<tolrsd[3])&&
		(rsdnm[4]<tolrsd[4])) {
			fprintf(outp,"%d\n",istep);
			return;
		}
	}
	tend = timer();
	ttotal = tend - tstart;
}
