#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <time.h>

#include "applu.h"

rhs()
{
	int i,j,k,m;
	double flux[isiz1][5];
	double u21, q, tmp, u21i, u31i, u41i, u51i;
	double u21im1, u31im1, u41im1, u51im1;
	double u31, u21j, u31j, u41j, u51j;
	double u21jm1, u31jm1, u41jm1, u51jm1;
	double u41, u21k, u31k, u41k, u51k;
	double u21km1, u31km1, u41km1, u51km1;

	for(k=0;k<nz;k++) {
		for(j=0;j<ny;j++) {
			for(i=0;i<nx;i++) {
				for(m=0;m<5;m++) {
					rsd[k][j][i][m] = -frct[k][j][i][m];
				}
			}
		}
	}
	/****xi-direction flux differences*/
	for(k=1;k<(nz-1);k++) {
		for(j=1;j<(ny-1);j++) {
			for(i=0;i<nx;i++) {
				flux[i][0] = u[k][j][i][1];
				u21 = u[k][j][i][1] / u[k][j][i][0];
				q = 0.5*(u[k][j][i][1]*u[k][j][i][1]
						+u[k][j][i][2]*u[k][j][i][2]
						+u[k][j][i][3]*u[k][j][i][3])
					   /u[k][j][i][0];
				flux[i][1] = u[k][j][i][1]*u21+c2*(u[k][j][i][4]-q);
				flux[i][2] = u[k][j][i][2]*u21;
				flux[i][3] = u[k][j][i][3]*u21;
				flux[i][4] = (c1*u[k][j][i][4]-c2*q)*u21;
			}
			for(i=1;i<(nx-1);i++) {
				for(m=0;m<5;m++) {
					rsd[k][j][i][m] -= (tx2*(flux[i+1][m]-flux[i-1][m])); 
				}
			}
			for(i=1;i<nx;i++) {
				tmp = 1.0/u[k][j][i][0];
				u21i = tmp*u[k][j][i][1];
				u31i = tmp*u[k][j][i][2];
				u41i = tmp*u[k][j][i][3];
				u51i = tmp*u[k][j][i][4];
				tmp = 1.0/u[k][j][i-1][0];
				u21im1 = tmp*u[k][j][i-1][1];
				u31im1 = tmp*u[k][j][i-1][2];
				u41im1 = tmp*u[k][j][i-1][3];
				u51im1 = tmp*u[k][j][i-1][4];
				flux[i][1] = (4.0/3.0)*tx3*(u21i-u21im1);
				flux[i][2] = tx3*(u31i-u31im1);
				flux[i][3] = tx3*(u41i-u41im1);
				flux[i][4] = 0.5*(1.0-c1*c5)
					*tx3*((u21i*u21i+u31i*u31i+u41i*u41i)
						 -(u21im1*u21im1+u31im1*u31im1+u41im1*u41im1))
					+(1.0/6.0)*tx3*(u21i*u21i-u21im1*u21im1)
					+c1*c5*tx3*(u51i-u51im1);
			}
			for(i=1;i<(nx-1);i++) {
				rsd[k][j][i][0]+= dx1*tx1*
					(u[k][j][i-1][0]-2.0*u[k][j][i][0]+u[k][j][i+1][0]);
				rsd[k][j][i][1]+= tx3*c3*c4*(flux[i+1][1]-flux[i][1])
					+ dx2*tx1*
					(u[k][j][i-1][1]-2.0*u[k][j][i][1]+u[k][j][i+1][1]);
				rsd[k][j][i][2]+= tx3*c3*c4*(flux[i+1][2]-flux[i][2])
					+ dx3*tx1*
					(u[k][j][i-1][2]-2.0*u[k][j][i][2]+u[k][j][i+1][2]);
				rsd[k][j][i][3]+= tx3*c3*c4*(flux[i+1][3]-flux[i][3])
					+ dx4*tx1*
					(u[k][j][i-1][3]-2.0*u[k][j][i][3]+u[k][j][i+1][3]);
				rsd[k][j][i][4]+= tx3*c3*c4*(flux[i+1][4]-flux[i][4])
					+ dx5*tx1*
					(u[k][j][i-1][4]-2.0*u[k][j][i][4]+u[k][j][i+1][4]);
			}
			for(m=0;m<5;m++) {
				rsd[k][j][1][m] -= (dssp*
					(5.0*u[k][j][1][m]
					 -4.0*u[k][j][2][m]
					 +u[k][j][3][m]));
				rsd[k][j][2][m] -= (dssp*
					(-4.0*u[k][j][1][m]
					 +6.0*u[k][j][2][m]
					 -4.0*u[k][j][3][m]
					 +u[k][j][4][m]));
			}
			for(i=3;i<(nx-3);i++) {
				for(m=0;m<5;m++) {
					rsd[k][j][i][m] -= (dssp*
						(u[k][j][i-2][m]
						-4.0*u[k][j][i-1][m]
					 	+6.0*u[k][j][i][m]
					 	-4.0*u[k][j][i+1][m]
					 	+u[k][j][i+2][m]));
				}
			}
			for(m=0;m<5;m++) {
				rsd[k][j][nx-3][m] -= (dssp*
						(u[k][j][nx-5][m]
						-4.0*u[k][j][nx-4][m]
					 	+6.0*u[k][j][nx-3][m]
					 	-4.0*u[k][j][nx-2][m]));
				rsd[k][j][nx-2][m] -= (dssp*
						(u[k][j][nx-4][m]
						-4.0*u[k][j][nx-3][m]
					 	+5.0*u[k][j][nx-2][m]));
			}
		}
	}
	/****eta-direction flux differences*/
	for(k=1;k<(nz-1);k++) {
		for(i=1;i<(nx-1);i++) {
			for(j=0;j<ny;j++) {
				flux[j][0] = u[k][j][i][2];
				u31 = u[k][j][i][2] / u[k][j][i][0];
				q = 0.5*(u[k][j][i][1]*u[k][j][i][1]
						+u[k][j][i][2]*u[k][j][i][2]
						+u[k][j][i][3]*u[k][j][i][3])
					   /u[k][j][i][0];
				flux[j][1] = u[k][j][i][1]*u31;
				flux[j][2] = u[k][j][i][2]*u31+c2*(u[k][j][i][4]-q);
				flux[j][3] = u[k][j][i][3]*u31;
				flux[j][4] = (c1*u[k][j][i][4]-c2*q)*u31;
			}
			for(j=1;j<(ny-1);j++) {
				for(m=0;m<5;m++) {
					rsd[k][j][i][m] -= (ty2*(flux[j+1][m]-flux[j-1][m])); 
				}
			}
			for(j=1;j<ny;j++) {
				tmp = 1.0/u[k][j][i][0];
				u21j = tmp*u[k][j][i][1];
				u31j = tmp*u[k][j][i][2];
				u41j = tmp*u[k][j][i][3];
				u51j = tmp*u[k][j][i][4];
				tmp = 1.0/u[k][j-1][i][0];
				u21jm1 = tmp*u[k][j-1][i][1];
				u31jm1 = tmp*u[k][j-1][i][2];
				u41jm1 = tmp*u[k][j-1][i][3];
				u51jm1 = tmp*u[k][j-1][i][4];
				flux[j][1] = ty3*(u21j-u21jm1);
				flux[j][2] = (4.0/3.0)*ty3*(u31j-u31jm1);
				flux[j][3] = ty3*(u41j-u41jm1);
				flux[j][4] = 0.5*(1.0-c1*c5)
					*ty3*((u21j*u21j+u31j*u31j+u41j*u41j)
						 -(u21jm1*u21jm1+u31jm1*u31jm1+u41jm1*u41jm1))
					+(1.0/6.0)*ty3*(u31j*u31j-u31jm1*u31jm1)
					+c1*c5*ty3*(u51j-u51jm1);
			}
			for(j=1;j<(ny-1);j++) {
				rsd[k][j][i][0]+= dy1*ty1*
					(u[k][j-1][i][0]-2.0*u[k][j][i][0]+u[k][j+1][i][0]);
				rsd[k][j][i][1]+= ty3*c3*c4*(flux[j+1][1]-flux[j][1])
					+ dy2*ty1*
					(u[k][j-1][i][1]-2.0*u[k][j][i][1]+u[k][j+1][i][1]);
				rsd[k][j][i][2]+= ty3*c3*c4*(flux[j+1][2]-flux[j][2])
					+ dy3*ty1*
					(u[k][j-1][i][2]-2.0*u[k][j][i][2]+u[k][j+1][i][2]);
				rsd[k][j][i][3]+= ty3*c3*c4*(flux[j+1][3]-flux[j][3])
					+ dy4*ty1*
					(u[k][j-1][i][3]-2.0*u[k][j][i][3]+u[k][j+1][i][3]);
				rsd[k][j][i][4]+= ty3*c3*c4*(flux[j+1][4]-flux[j][4])
					+ dy5*ty1*
					(u[k][j-1][i][4]-2.0*u[k][j][i][4]+u[k][j+1][i][4]);
			}
			for(m=0;m<5;m++) {
				rsd[k][1][i][m] -= (dssp*
					(5.0*u[k][1][i][m]
					 -4.0*u[k][2][i][m]
					 +u[k][3][i][m]));
				rsd[k][2][i][m] -= (dssp*
					(-4.0*u[k][1][i][m]
					 +6.0*u[k][2][i][m]
					 -4.0*u[k][3][i][m]
					 +u[k][4][i][m]));
			}
			for(j=3;j<(ny-3);j++) {
				for(m=0;m<5;m++) {
					rsd[k][j][i][m] -= (dssp*
						(u[k][j-2][i][m]
						-4.0*u[k][j-1][i][m]
					 	+6.0*u[k][j][i][m]
					 	-4.0*u[k][j+1][i][m]
					 	+u[k][j+2][i][m]));
				}
			}
			for(m=0;m<5;m++) {
				rsd[k][ny-3][i][m] -= (dssp*
						(u[k][ny-5][i][m]
						-4.0*u[k][ny-4][i][m]
					 	+6.0*u[k][ny-3][i][m]
					 	-4.0*u[k][ny-2][i][m]));
				rsd[k][ny-2][i][m] -= (dssp*
						(u[k][ny-4][i][m]
						-4.0*u[k][ny-3][i][m]
					 	+5.0*u[k][ny-2][i][m]));
			}
		}
	}
	/****zeta-direction flux differences*/
	for(j=1;j<(ny-1);j++) {
		for(i=1;i<(nx-1);i++) {
			for(k=0;k<nz;k++) {
				flux[k][0] = u[k][j][i][3];
				u41 = u[k][j][i][3] / u[k][j][i][0];
				q = 0.5*(u[k][j][i][1]*u[k][j][i][1]
						+u[k][j][i][2]*u[k][j][i][2]
						+u[k][j][i][3]*u[k][j][i][3])
					   /u[k][j][i][0];
				flux[k][1] = u[k][j][i][1]*u41;
				flux[k][2] = u[k][j][i][2]*u41;
				flux[k][3] = u[k][j][i][3]*u41+c2*(u[k][j][i][4]-q);
				flux[k][4] = (c1*u[k][j][i][4]-c2*q)*u41;
			}
			for(k=1;k<(nz-1);k++) {
				for(m=0;m<5;m++) {
					rsd[k][j][i][m] -= (tz2*(flux[k+1][m]-flux[k-1][m])); 
				}
			}
			for(k=1;k<nz;k++) {
				tmp = 1.0/u[k][j][i][0];
				u21k = tmp*u[k][j][i][1];
				u31k = tmp*u[k][j][i][2];
				u41k = tmp*u[k][j][i][3];
				u51k = tmp*u[k][j][i][4];
				tmp = 1.0/u[k-1][j][i][0];
				u21km1 = tmp*u[k-1][j][i][1];
				u31km1 = tmp*u[k-1][j][i][2];
				u41km1 = tmp*u[k-1][j][i][3];
				u51km1 = tmp*u[k-1][j][i][4];
				flux[k][1] = tz3*(u21k-u21km1);
				flux[k][2] = tz3*(u31k-u31km1);
				flux[k][3] = (4.0/3.0)*tz3*(u41k-u41km1);
				flux[k][4] = 0.5*(1.0-c1*c5)
					*tz3*((u21k*u21k+u31k*u31k+u41k*u41k)
						 -(u21km1*u21km1+u31km1*u31km1+u41km1*u41km1))
					+(1.0/6.0)*tz3*(u41k*u41k-u41km1*u41km1)
					+c1*c5*tz3*(u51k-u51km1);
			}
			for(k=1;k<(nz-1);k++) {
				rsd[k][j][i][0]+= dz1*tz1*
					(u[k-1][j][i][0]-2.0*u[k][j][i][0]+u[k+1][j][i][0]);
				rsd[k][j][i][1]+= tz3*c3*c4*(flux[k+1][1]-flux[k][1])
					+ dz2*tz1*
					(u[k-1][j][i][1]-2.0*u[k][j][i][1]+u[k+1][j][i][1]);
				rsd[k][j][i][2]+= tz3*c3*c4*(flux[k+1][2]-flux[k][2])
					+ dz3*tz1*
					(u[k-1][j][i][2]-2.0*u[k][j][i][2]+u[k+1][j][i][2]);
				rsd[k][j][i][3]+= tz3*c3*c4*(flux[k+1][3]-flux[k][3])
					+ dz4*tz1*
					(u[k-1][j][i][3]-2.0*u[k][j][i][3]+u[k+1][j][i][3]);
				rsd[k][j][i][4]+= tz3*c3*c4*(flux[k+1][4]-flux[k][4])
					+ dz5*tz1*
					(u[k-1][j][i][4]-2.0*u[k][j][i][4]+u[k+1][j][i][4]);
			}
			for(m=0;m<5;m++) {
				rsd[1][j][i][m] -= (dssp*
					(5.0*u[1][j][i][m]
					 -4.0*u[2][j][i][m]
					 +u[3][j][i][m]));
				rsd[2][j][i][m] -= (dssp*
					(-4.0*u[1][j][i][m]
					 +6.0*u[2][j][i][m]
					 -4.0*u[3][j][i][m]
					 +u[4][j][i][m]));
			}
			for(k=3;k<(nz-3);k++) {
				for(m=0;m<5;m++) {
					rsd[k][j][i][m] -= (dssp*
						(u[k-2][j][i][m]
						-4.0*u[k-1][j][i][m]
					 	+6.0*u[k][j][i][m]
					 	-4.0*u[k+1][j][i][m]
					 	+u[k+2][j][i][m]));
				}
			}
			for(m=0;m<5;m++) {
				rsd[nz-3][j][i][m] -= (dssp*
						(u[nz-5][j][i][m]
						-4.0*u[nz-4][j][i][m]
					 	+6.0*u[nz-3][j][i][m]
					 	-4.0*u[nz-2][j][i][m]));
				rsd[nz-2][j][i][m] -= (dssp*
						(u[nz-4][j][i][m]
						-4.0*u[nz-3][j][i][m]
					 	+5.0*u[nz-2][j][i][m]));
			}
		}
	}
}

