#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <time.h>

#include "applu.h"

FILE *outp;

double c1 = 1.4;
double c2 = 0.4;
double c3 = 1.0e-1;
double c4 = 1.0;
double c5 = 1.4;

int nx, ny, nz, ii1, ii2, ji1, ji2, ki1, ki2, idum1;
double dxi,deta,dzeta,tx1,tx2,tx3,ty1,ty2,ty3,tz1,tz2,tz3;

double dx1,dx2,dx3,dx4,dx5,dy1,dy2,dy3,dy4,dy5,dz1,dz2,dz3,dz4,dz5,dssp;

double u[isiz3][isiz2][isiz1][5];
double rsd[isiz3][isiz2][isiz1][5];
double frct[isiz3][isiz2][isiz1][5];

int ipr, iout, inorm;

int itmax,invert;
double dt, omega,tolrsd[5],rsdnm[5],errnm[5],frc, ttotal;

double a[isiz3][isiz2][isiz1][5][5];
double b[isiz3][isiz2][isiz1][5][5];
double c[isiz3][isiz2][isiz1][5][5];
double d[isiz3][isiz2][isiz1][5][5];

double ce[13][5];

char *name[5] = {"first","second","third","fourth","fifth"};

main()
{
	FILE *inp;
	int i,j,k,m;

	inp = fopen("applu.input","r");
	fscanf(inp,"%d",&iout);
	fscanf(inp,"%d%d",&ipr,&inorm);
	fscanf(inp,"%d",&itmax);
	fscanf(inp,"%lf",&dt);
	fscanf(inp,"%d",&invert);
	fscanf(inp,"%lf",&omega);
	for(i=0;i<5;i++)
		fscanf(inp,"%lf",&tolrsd[i]);
	fscanf(inp,"%d%d%d",&nx,&ny,&nz);
	fclose(inp);
	if(iout==7)
		outp = fopen("output.data", "w");
	else
		outp = stdout;
	if(nx < 5 || ny < 5 || nz < 5)
	{
		fprintf(stderr, "Problem Size Too Small.\n");
		exit(1);
	}
	if(nx > isiz1 || ny > isiz2 || nz > isiz3)
	{
		fprintf(stderr, "Problem Size Too Large.\n");
		exit(1);
	}

	dxi = 1.0/(nx-1);
	deta = 1.0/(ny-1);
	dzeta = 1.0/(nz-1);

	tx1 = 1.0/(dxi*dxi);
	tx2 = 1.0/(2.0*dxi);
	tx3 = 1.0/dxi;

	ty1 = 1.0/(deta*deta);
	ty2 = 1.0/(2.0*deta);
	ty3 = 1.0/deta;

	tz1 = 1.0/(dzeta*dzeta);
	tz2 = 1.0/(2.0*deta);
	tz3 = 1.0/dzeta;

	ii1 = 1;
	ii2 = nx-2;
	ji1 = 1;
	ji2 = ny-3;
	ki1 = 2;
	ki2 = nz-2;

	dx1 = dx2 = dx3 = dx4 = dx5 = 0.75;
	dy1 = dy2 = dy3 = dy4 = dy5 = 0.75;
	dz1 = dz2 = dz3 = dz4 = dz5 = 1.0;

	dssp = max3(dx1,dy1,dz1)/4.0;

	ce[0][0] = 2.0;
	ce[1][0] = 0.0;
	ce[2][0] = 0.0;
	ce[3][0] = 4.0;
	ce[4][0] = 5.0;
	ce[5][0] = 3.0;
	ce[6][0] = 5.0e-1;
	ce[7][0] = 2.0e-2;
	ce[8][0] = 1.0e-2;
	ce[9][0] = 3.0e-2;
	ce[10][0] = 5.0e-1;
	ce[11][0] = 4.0e-1;
	ce[12][0] = 3.0e-1;

	ce[0][1] = 1.0;
	ce[1][1] = 0.0;
	ce[2][1] = 0.0;
	ce[3][1] = 0.0;
	ce[4][1] = 1.0;
	ce[5][1] = 2.0;
	ce[6][1] = 3.0;
	ce[7][1] = 1.0e-2;
	ce[8][1] = 3.0e-2;
	ce[9][1] = 2.0e-2;
	ce[10][1] = 4.0e-1;
	ce[11][1] = 3.0e-1;
	ce[12][1] = 5.0e-1;

	ce[0][2] = 2.0;
	ce[1][2] = 2.0;
	ce[2][2] = 0.0;
	ce[3][2] = 0.0;
	ce[4][2] = 0.0;
	ce[5][2] = 2.0;
	ce[6][2] = 3.0;
	ce[7][2] = 4.0e-2;
	ce[8][2] = 3.0e-2;
	ce[9][2] = 5.0e-2;
	ce[10][2] = 3.0e-1;
	ce[11][2] = 5.0e-1;
	ce[12][2] = 4.0e-1;

	ce[0][3] = 2.0;
	ce[1][3] = 2.0;
	ce[2][3] = 0.0;
	ce[3][3] = 0.0;
	ce[4][3] = 0.0;
	ce[5][3] = 2.0;
	ce[6][3] = 3.0;
	ce[7][3] = 3.0e-2;
	ce[8][3] = 5.0e-2;
	ce[9][3] = 4.0e-2;
	ce[10][3] = 2.0e-1;
	ce[11][3] = 1.0e-1;
	ce[12][3] = 3.0e-1;

	ce[0][4] = 5.0;
	ce[1][4] = 4.0;
	ce[2][4] = 3.0;
	ce[3][4] = 2.0;
	ce[4][4] = 1.0e-1;
	ce[5][4] = 4.0e-1;
	ce[6][4] = 3.0e-1;
	ce[7][4] = 5.0e-2;
	ce[8][4] = 4.0e-2;
	ce[9][4] = 3.0e-2;
	ce[10][4] = 1.0e-1;
	ce[11][4] = 3.0e-1;
	ce[12][4] = 2.0e-1;

	setbv();
	setiv();
	erhs();
	ssor();
	error();
	pintgr();
	verify(rsdnm,errnm,frc);
	fprintf(outp,"Total CPU Time = %e\n",ttotal);
	fclose(outp);
	exit(0);
}

