#include <stdio.h>
#include <math.h>
#include <sys/types.h>
#include <time.h>

#include "applu.h"

error()
{
	int imax[5], jmax[5], kmax[5];
	double u000ijk[5], errmax[5];
	int lnorm, m, i, j, k;
	double tmp;

	lnorm = 2;
	if(lnorm==1) {
		for(m=0;m<5;m++) {
			errmax[m] = -1.0e+20;
		}
		for(k=1;k<(nz-1);k++) {
			for(j=1;j<(ny-1);j++) {
				for(i=1;i<(nx-1);i++) {
					for(m=0;m<5;m++)
					exact(i,j,k,m,&u000ijk[m]);
					for(m=0;m<5;m++) {
						tmp = ABS(u000ijk[m]-u[k][j][i][m]);
						if(tmp > errmax[m]) {
							errmax[m] = tmp;
							imax[m] = i;
							jmax[m] = j;
							kmax[m] = k;
						}
					}
				}
			}
		}
		for(m=0;m<5;m++) {
			fprintf(outp,"%e %d %d %d\n",errmax[m],imax[m],jmax[m],kmax[m]);
		}
	}
	else if(lnorm==2) {
		for(m=0;m<5;m++) {
			errnm[m] = 0.0;
		}
		for(k=1;k<(nz-1);k++) {
			for(j=1;j<(ny-1);j++) {
				for(i=1;i<(nx-1);i++) {
					for(m=0;m<5;m++)
						exact(i,j,k,m,&u000ijk[m]);
					for(m=0;m<5;m++) {
						tmp = (u000ijk[m]-u[k][j][i][m]);
						errnm[m] = errnm[m] + tmp*tmp;
					}
				}
			}
		}
		for(m=0;m<5;m++) {
			errnm[m] = sqrt(errnm[m]/((nx-2)*(ny-2)*(nz-2)));
		}
		for(m=0;m<5;m++) {
			fprintf(outp, "RMS-norm of error in soln. to %s pde = %e\n", 
				name[m], errnm[m]);
		}
	}
}

