/***************************************************************************
 * RCS INFORMATION:
 *
 *      $RCSfile: core_macros.h,v $
 *      $Author: sanjeev $        $Locker:  $                $State: Exp $
 *      $Revision: 1.1 $      $Date: 1995/03/13 16:19:11 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: core_macros.h,v $
 * Revision 1.1  1995/03/13  16:19:11  sanjeev
 * Initial revision
 *
 ***************************************************************************/



#ifndef CORE_MACROS
#define CORE_MACROS

/**********************************************************************
   This file provides access macros for extracting the fields of the core
   sections of a message. The organization of a message is as follows 

           -------------------------------------
           | core | ldb | pad | user | priority |
           -------------------------------------

   The sizes of the fields are as follows:

       envelope      : sizeof(ENVELOPE) 
			(ENVELOPE is defined in env_macros.h)
                        First 2 words in ENVELOPE are the core fields.

       ldb           : LDB_ELEM_SIZE is a global variable defined by the
			load balancing module

       pad	     : padding to ensure that the message header ends at a
 		       double word boundary.

       user          : the user message data.

       priority      : bit-vector (variable size) 
***********************************************************************/


extern int HEADER_SIZE;
extern int LDB_ELEM_SIZE ;



#define TOTAL_MSG_SIZE(usrsize, priosize) (HEADER_SIZE + priosize + usrsize)
#define CHARRED(x) ((char *) (x))



/**  MACROS FOR CORE1 FIELD  ******************************************/
/* The following macros assume that -core- points to the core1 field, which
   is the first word in the ENVELOPE, and is organized as follows : 
7 bits blank| 1 bit priotype| 20 language bits| 1 needsLdb bit| 3 category bits
*/

#define GetCore_Language(core1)  \
	(int)(( (*(int *)(core1)) >> 4 ) & 0x000fffff)

#define SetCore_Language(core1,x)  \
	(*(int *)(core1)) = ( ((*(int *)(core1)) & 0xff00000f) | (x<<4) )

#define GetCore_destPeFixed(core1) \
	(int)(( (*(int *)(core1)) >> 3 ) & 0x00000001)

#define SetCore_destPeFixed(core1,x) \
	(*(int *)(core1)) = ( ((*(int *)(core1)) & 0xfffffff7) | (x<<3) )

#define GetCore_Category(core1) \
	(int)( (*(int *)(core1)) & 0x00000007 )

#define SetCore_Category(core1,x) \
	(*(int *)(core1)) = ( ((*(int *)(core1)) & 0xfffffff8) | x )

#define GetCore_PrioType(core1)  \
	(int)(( (*(int *)(core1)) >> 24 ) & 0x00000001)

#define SetCore_PrioType(core1,x)  \
	(*(int *)(core1)) = ( ((*(int *)(core1)) & 0xf1ffffff) | (x<<24) )



/**  MACROS FOR CORE2 FIELD  ******************************************/
/* The following macros assume that -core1- points to the core1 field,
   which is the first word in the ENVELOPE. core2 is the next word after core1.
   Meaning of core2 field :
Case 1 : GetCore_PrioType == 0 : this field has the signed integer priority,
	 with a default of 0.
Case 2 : GetCore_PrioType == 1 : the message has a bit-vector priority.
	 The bit-vector is stored in a field at the end of the user-message.
         Now core2 = 12 bits priosize + 20 bits ldb field offset 
	 "priosize" gives the size in BYTES of the bit-vector.
	 "offset" gives the offset in BYTES of the priority field from
	 core1. i.e. the priority field begins at ((char *)core1 + offset).
*/

#define GetCore_IntegerPrio(core1)  \
	(int)( *((int *)(core1)+1) )

#define SetCore_IntegerPrio(core1,x)  \
	*((int *)(core1)+1) = x 

#define GetCore_PrioOffset(core1)  \
	(int)( *((int *)(core1)+1) & 0x000fffff)

#define SetCore_PrioOffset(core1,x)  \
	*((int *)(core1)+1) = ( (*((int *)(core1)+1) & 0xfff00000) | x )

#define GetCore_PrioSize(core1)  \
	(int)( *((int *)(core1)+1) >> 20 )

#define SetCore_PrioSize(core1,x)  \
	*((int *)(core1)+1) = ( (*((int *)(core1)+1) & 0x000fffff) | (x<<20) )



/**  EXTRA MACROS FOR PRIORITY FIELDS  *********************************/

#define GetCore_PriorityPtr(core, priorityptr) {\
    if ( GetCore_PrioType(core) == 0 ) \
        priorityptr = (PVECTOR *)((char *)core + 4) ; \
    else  \
        priorityptr = (PVECTOR *)((char *)core + *((int *)GetCore_PrioOffset(core)));\
}

#define COPY_PRIORITY(env1, env2) {\
	if ( GetCore_PrioType(env1) == 0 ) { \
		SetCore_PrioType(env2,0) ; \
		SetCore_IntegerPrio(env2, GetCore_IntegerPrio(env1)) ; \
	} \
	else { \
        	char *ptr1, *ptr2; \
        	ptr1 = (char *)env1 + *((int *)GetCore_PrioOffset(env1));\
        	ptr2 = (char *)env2 + *((int *)GetCore_PrioOffset(env2));\
        	memcpy( ((char *) ptr2), ((char *) ptr1), \
                                GetCore_PrioSize(env1) );   \
	} \
}


#endif
