/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: node_ldb.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/04/14 06:51:25 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: node_ldb.c,v $
 * Revision 1.4  1995/04/14  06:51:25  milind
 * changed all Mc Functions to Cmi Functions
 *
 * Revision 1.3  1995/04/02  00:48:13  sanjeev
 * changes for separating Converse
 *
 * Revision 1.2  1994/12/02  00:00:51  sanjeev
 * interop stuff
 *
 * Revision 1.1  1994/11/03  17:39:38  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /home/kale/milind/RCS/node_ldb.c,v 1.4 1995/04/14 06:51:25 milind Exp $";
#include <math.h>
#include "chare.h"
#include "stat.h"
#include "ldb.h"
#include "node.globals.h"

#define  CONTROLLER(pe) (((pe + 1)%CLUSTER_SIZE == 0) || ((pe + 1 ) == numPe))
#define LdbMyLoad() total_work_cluster


int LdbProcessMsg();
void LdbPeriodicRedist();
void LdbPeriodicStatus();
void LdbPeriodicKidStatus();
void LdbPeriodicBossStatus();
void LdbPeriodicKidsRedist();
void LdbPeriodicBossesRedist();

int start_my_cluster, end_my_cluster, size_my_cluster;
int total_work_cluster=0;

LdbBocInit()
{
	BOC_BLOCK *bocBlock;

	bocBlock = (BOC_BLOCK *) CreateBocBlock(sizeof(int));
	bocBlock->boc_num = LdbBocNum;
	SetBocDataPtr(LdbBocNum, (void *) (bocBlock + 1));
	TRACE(CkPrintf("Node %d: LdbBocInit: BocDataTbl entry filled.\n",CmiMyPe()));

	LdbInit();
	StatInit();
	srand(CmiMyPe());
	TreeLdbQueue = (void *) FIFO_Create();
	delete_ptr = CmiMyPe() +  (rand() % CLUSTER_SIZE);
	init_work_cluster();
}

LdbSentUpdateStatus(pe)
int pe;
{
}


/*****************************************************************/
/** Initialize Periodic Checks.					**/
/*****************************************************************/
LdbPeriodicCheckInit()
{
	if (numPe > 1)
	{
		if (CONTROLLER(CmiMyPe()))
		{
			if (numPe > CLUSTER_SIZE)
				CallBocAfter(LdbPeriodicBossStatus, LdbBocNum, 
				    BOSS_STATUS_UPDATE_INTERVAL);
			CallBocAfter(LdbPeriodicRedist, LdbBocNum,
			    BOSS_REDIST_UPDATE_INTERVAL);
		}
		else
			CallBocAfter(LdbPeriodicKidStatus, LdbBocNum, 
			    KID_STATUS_UPDATE_INTERVAL);
	}
}

/*****************************************************************/
/** Initialize the LDB variables here.				**/
/*****************************************************************/
LdbInit()
{
	int i;
	ENVELOPE *env;
	LDB_ELEMENT *ldb;

	TRACE(CkPrintf("Enter Node LdbInit()\n"));

	numPe = CmiNumPe();
	controller = CONTROLLER(CmiMyPe());
	mycontroller = MyController(CmiMyPe());

TRACE(CkPrintf("[%d] LdbInit: numPe=%d, controller=%d, mycontroller=%d\n",
CmiMyPe(), numPe, controller, mycontroller));

	if (numPe%CLUSTER_SIZE == 0) numBoss = numPe/CLUSTER_SIZE;
	else numBoss = numPe/CLUSTER_SIZE + 1;

	insert_msg = (InsertMsg *) CkAllocMsg(sizeof(InsertMsg));
	insert_msg->pe = CmiMyPe();
	insert_env = (ENVELOPE *) ENVELOPE_UPTR(insert_msg);
	SetEnv_EP(insert_env, LdbNbrStatus_EP);
	SetEnv_destPeFixed(insert_env, TRUE);
	SetEnv_category(insert_env, IMMEDIATEcat);
	SetEnv_msgType(insert_env, LdbMsg);
	/* fill the LdbBlock with load status */
	ldb = LDB_ELEMENT_PTR(insert_env);
	ldb->srcPE = CmiMyPe();
	ldb->type = INSERT;

	if (!controller)
	{
		/* allocate a message to be sent to the controller */
		status_msg = (DummyMsg *) CkAllocMsg(sizeof(DummyMsg));
		status_env = (ENVELOPE *) ENVELOPE_UPTR(status_msg);
		SetEnv_EP(status_env, LdbNbrStatus_EP);
		SetEnv_destPE(status_env, mycontroller);
		SetEnv_destPeFixed(status_env, TRUE);
		SetEnv_category(status_env, IMMEDIATEcat);
		SetEnv_msgType(status_env, LdbMsg);
		/* fill the LdbBlock with load status */
		ldb = LDB_ELEMENT_PTR(status_env);
		ldb->srcPE = CmiMyPe();
		ldb->type = STATUS;

		SetEnv_destPE(insert_env, mycontroller);
	}
	else
	{
		end_my_cluster = CmiMyPe();
		start_my_cluster = (end_my_cluster/CLUSTER_SIZE) * CLUSTER_SIZE;
		size_my_cluster = end_my_cluster - start_my_cluster; 

		/* allocate a message to be sent to the kids */
		delete_msg = (DeleteMsg *) CkAllocMsg(sizeof(DeleteMsg));
		delete_msg->deletes = 0;
		delete_env = (ENVELOPE *) ENVELOPE_UPTR(delete_msg);
		SetEnv_EP(delete_env, LdbNbrStatus_EP);
		SetEnv_destPeFixed(delete_env, TRUE);
		SetEnv_category(delete_env, IMMEDIATEcat);
		SetEnv_msgType(delete_env, LdbMsg);
		/* fill the LdbBlock with load status */
		ldb = LDB_ELEMENT_PTR(delete_env);
		ldb->srcPE = CmiMyPe();
		ldb->type = DELETE;

		/* allocate a message to be sent to the kids */
		redist_msg = (RedistributionMsg *)
		    CkAllocMsg(sizeof(RedistributionMsg));
		redist_env = (ENVELOPE *) ENVELOPE_UPTR(redist_msg);
		SetEnv_EP(redist_env, LdbNbrStatus_EP);
		SetEnv_destPeFixed(redist_env, TRUE);
		SetEnv_category(redist_env, IMMEDIATEcat);
		SetEnv_msgType(redist_env, LdbMsg);
		/* fill the LdbBlock with load status */
		ldb = LDB_ELEMENT_PTR(redist_env);
		ldb->srcPE = CmiMyPe();
		ldb->type = REDISTRIBUTION;


		for (i=0; i<CLUSTER_SIZE; i++)
			load_cluster[i] = 0;

		if (numBoss > 1)
		{
			exchanges = (int) (log((double) numBoss) /
			    log((double) 2.0));

			TRACE(CkPrintf("[%d] Ldbinit: log(numBoss)=%f, log(2.0)=%f, exchanged=%f\n",
			    CmiMyPe(), log((double) numBoss), log((double) 2.0),
			    log((double) numBoss)/log((double) 2.0)));

			TRACE(CkPrintf("[%d] LdbInit: exchanges=%d, numBoss=%d\n",
			    CmiMyPe(), exchanges, numBoss));

			for (i=0; i<exchanges; i++)
			{
				int boss_index;

				boss_index = flipi(CmiMyPe(), i);
				load_boss[i] = 0;
				nbr_boss[i] = (CLUSTER_SIZE-1) + boss_index*CLUSTER_SIZE;
			}
			for (i=0; i<exchanges; i++)
			{
				boss_statusMsg[i] = (DummyMsg *) CkAllocMsg(sizeof(DummyMsg));
				env = (ENVELOPE *)
				    ENVELOPE_UPTR(boss_statusMsg[i]);
				SetEnv_EP(env, LdbNbrStatus_EP);
				SetEnv_destPE(env, nbr_boss[i]);
				SetEnv_destPeFixed(env, TRUE);
				SetEnv_category(env, IMMEDIATEcat);
				SetEnv_msgType(env, LdbMsg);

				/* fill the LdbBlock with load status */
				ldb = LDB_ELEMENT_PTR(env);
				ldb->type = STATUS;
				ldb->srcPE = CmiMyPe();
			}
		}
	}
}


/*****************************************************************/
/** This entry point is called to record Nbr. status. Currently	**/
/** I don't think it's ever called.				**/
/*****************************************************************/
int LdbProcessMsg(msgPtr, localdataPtr)
void *msgPtr;
void *localdataPtr;
{
	int i;
	LDB_ELEMENT *ldb = LDB_UPTR(msgPtr);
	ENVELOPE *env = (ENVELOPE *) ENVELOPE_UPTR(msgPtr);

	if (GetEnv_msgType(env) != LdbMsg)
		CkPrintf("*** ERROR *** Ldb strategy received unknown message.\n");

	switch (ldb->type) {
		case INSERT:
			get_status(get_index(ldb->srcPE), ldb);
			TokenStrategy((InsertMsg *) msgPtr);
			break;

		case DELETE:
			{
			ENVELOPE *work;
			DeleteMsg *dmsg = (DeleteMsg *) msgPtr;
			for (i=0; i<dmsg->deletes; i++) {
				FIFO_DeQueue(TreeLdbQueue, &work);
				if (work == NULL) {
					CkPrintf("[%d] *** ERROR *** No message exists to delete.\n", CmiMyPe());
					return;
				}
				SetEnv_destPE(work, dmsg->pe[i]);
				SetEnv_destPeFixed(work, TRUE);
				ldb = LDB_ELEMENT_PTR(work);
				ldb->type = OTHER;
				TRACE(CkPrintf("[%d] DELETE: destPE=%d\n",
			    	CmiMyPe(), dmsg->pe[i]));
				if (GetEnv_destPE(work) == CmiMyPe())
					QsEnqMsg(work);
				else
					CkSend(GetEnv_destPE(work), TotalMsgSize(work), work);
			    	}
			}
			break;

		case REDISTRIBUTION:
			{
				RedistributionMsg * rmsg = (RedistributionMsg *) msgPtr;
				TRACE(CkPrintf("[%d] REDISTRIBUTION: no=%d\n",
					CmiMyPe(), rmsg->exchanges));
				for (i=0; i<rmsg->exchanges; i++)
					insert_work_cluster(rmsg->pe[i]);
			}
			break;

		case STATUS:
			if ((ldb->srcPE != CmiNumPe()) && 
				(ldb->srcPE != CmiMyPe()) && (numPe > 1)) 
					get_status(get_index(ldb->srcPE), ldb);
			break;

		case OTHER:
			CkPrintf("*** ERROR *** Unknown option in LdbProcessMsg.\n");
			break;
	}
}


/*****************************************************************/
/** Once a message is recd. this function is called to strip off**/
/** any ldb related information. For this strategy this message **/
/** does more than just provide status information. It doubles  **/
/** up as a message to insert a token, to delete a token and to **/
/** receive redistributed tokens.				**/
/*****************************************************************/
LdbStripMsg(env)
ENVELOPE * env;
{
}


/*****************************************************************/
/** Function is called when a new chare is recd. from the net.	**/
/*****************************************************************/
Ldb_NewChare_FromNet(x)
ENVELOPE *x;
{
	if (controller)
		CkPrintf("*** ERROR *** New chare sent to Manager.\n");
	else
	{
		TRACE(CkPrintf("[%d] Ldb_NewChare_Net:: Message from outside. \n",
		    CmiMyPe()));
		QsEnqMsg(x);
	}
}


/*****************************************************************/
/** Function is called when a new chare is recd. from local.	**/
/*****************************************************************/
Ldb_NewChare_FromLocal(x)
ENVELOPE *x;
{
TRACE(CkPrintf("[%d] Created new chare message.\n", CmiMyPe()));
	if (controller)
		CkPrintf("*** ERROR *** New chare created on Manager\n");
	else
	{
		void *msg;

		msg = USER_MSG_PTR(x);
		FIFO_EnQueue(TreeLdbQueue, x);
		load_worker++;
		if (load_worker > MAX_WORKER_LOAD) {
			insert_msg->no = load_worker;
			LdbFillBlock(insert_env);
			COPY_AND_SEND(insert_env);
			load_worker=0;
		}
		TRACE(else CkPrintf("[%d] New chare message stored.\n",
					 CmiMyPe()));
	}
}


/*****************************************************************/
/** This function fills in the ldb information before sending	**/
/** out a message.						**/
/*****************************************************************/
LdbFillBlock(env)
ENVELOPE *env;
{
	LDB_ELEMENT * ldb;

	ldb = LDB_ELEMENT_PTR(env);
	ldb->srcPE = CmiMyPe();
	if (CONTROLLER(ldb->srcPE)) ldb->piggybackLoad = LdbMyLoad();
	else	ldb->piggybackLoad = QsMyLoad();
}







/*****************************************************************/
/** Get status report for this message.				**/
/*****************************************************************/
get_status(index, ldb)
int index;
LDB_ELEMENT *ldb;
{
	TRACE(CkPrintf("[%d] get_status: srcPE=%d, load=%d\n",
	    CmiMyPe(), ldb->srcPE, ldb->piggybackLoad));
	if (CONTROLLER(ldb->srcPE)) {
		load_boss[index] = ldb->piggybackLoad;
		do_redistribution(ldb->srcPE, load_boss[index]);
	}
	else load_cluster[index] = ldb->piggybackLoad;
}


/*****************************************************************/
/** Now follow a bunch of useless functions. We plan to do 	**/
/** something with them in the future.				**/
/*****************************************************************/
LdbPrintNodeNeighbours()
{
}


LdbAddSysBocEps()
{
	EpTable[LdbNbrStatus_EP] =  LdbProcessMsg;
}


LdbProcessorIdle()
{
}


/*****************************************************************/
/** This function determines the least loaded processor.	**/
/*****************************************************************/
LdbLeastLoadPe()
{
	int kid_load;
	int pe = LdbLeastLoadBosses();

	if (pe==-1) pe = LdbLeastLoadKids();
	return pe;
}


/*****************************************************************/
/** This function is used to determine the least loaded kid of	**/
/** a manager.							**/
/*****************************************************************/
LdbLeastLoadKids()
{
	int pe;
	int index;
	int min_pe = 0;
	int min = HUGE_INT;

	for (pe=start_my_cluster; pe<end_my_cluster; pe++) {
		index = get_index(pe);
		if (load_cluster[index] < min) {
			min = load_cluster[index];
			min_pe = pe;
		}
	}
	if (min < KID_SATURATION) return(min_pe);
	return -1;
}


/*****************************************************************/
/** This function is used to determine the least loaded managers**/
/** in the dimensional neighbors graph.				**/
/*****************************************************************/
LdbLeastLoadBosses()
{
	int i, j;
	int min_pe;
	int min = HUGE_INT;
	static int start_pe = 0;

	if (numBoss <= 1) return -1;
	for (j=0; j<exchanges; j++) {
		i = (start_pe + j) % exchanges;
		if (load_boss[i] < min) {
			min = load_boss[i];
			min_pe = nbr_boss[i];
		}
	}
	if (min < BOSS_SATURATION) {
		start_pe = min_pe;
		return min_pe;
	}
	return -1;
}



/*****************************************************************/
/** Functions to periodically send status. The kids send their 	**/
/** status to their managers, while the managers send their	**/
/** status to their neighbors in the dimensional exchange.	**/
/*****************************************************************/
void LdbPeriodicStatus(bocNum)
ChareNumType bocNum;
{
}


void LdbPeriodicKidStatus(bocNum)
ChareNumType bocNum;
{
	LDB_ELEMENT * ldb;
	int load = QsMyLoad();

	/* fill the LdbBlock with load status */
	ldb = LDB_ELEMENT_PTR(status_env);
	ldb->piggybackLoad = load;
	if (load_worker) {
		insert_msg->no = load_worker;
TRACE(CkPrintf("[%d] Sending insert_msg message to boss, work=%d\n",
CmiMyPe(), load_worker));  
		COPY_AND_SEND(insert_env);
		load_worker=0;
	}
	else {
TRACE(CkPrintf("[%d] Sending status message to boss, work=%d\n",
CmiMyPe(), load_worker));  
		COPY_AND_SEND(status_env);
	}
	CallBocAfter(LdbPeriodicKidStatus, LdbBocNum, KID_STATUS_UPDATE_INTERVAL);
}



void LdbPeriodicBossStatus(bocNum)
ChareNumType bocNum;
{
	ENVELOPE *env;
	LDB_ELEMENT * ldb;
	static int index = 0;

	/* fill the LdbBlock with load status */
	env = (ENVELOPE *) ENVELOPE_UPTR(boss_statusMsg[index]);
	ldb = LDB_ELEMENT_PTR(env);
	ldb->piggybackLoad = LdbMyLoad();
	COPY_AND_SEND(env);
	index = (index+1) % exchanges;
	CallBocAfter(LdbPeriodicBossStatus, LdbBocNum, 
	    BOSS_STATUS_UPDATE_INTERVAL);
}


/*****************************************************************/
/** These functions are called to periodically redistribute	**/
/** load among various managers.				**/
/*****************************************************************/
void LdbPeriodicRedist(bocNum)
ChareNumType bocNum;
{
	/* LdbPeriodicBossesRedist(bocNum); */ 
	LdbPeriodicKidsRedist(bocNum);
	CallBocAfter(LdbPeriodicRedist, LdbBocNum, BOSS_REDIST_UPDATE_INTERVAL);
}


void LdbPeriodicKidsRedist(bocNum)
ChareNumType bocNum;
{
	int i, pe;
	int index;
	int picked;
	BOOLEAN done;
	ENVELOPE *env;
	

	done = FALSE;
	while (!done)
	{
		picked=0;
		delete_msg->deletes = 0;
		for (i=start_my_cluster; i<end_my_cluster; i++) {
			index = get_index(i);
			if (load_cluster[index] < KID_SATURATION) {
				if (delete_work_cluster(&pe, CmiMyPe(), i)) {
					delete_msg->pe[delete_msg->deletes++] = i;
					SetEnv_destPE(delete_env, pe);
					LdbFillBlock(delete_env);
					COPY_AND_SEND(delete_env);
					delete_msg->deletes=0;
					picked++;
					load_cluster[index]++;
				}
				else {
					done = TRUE;
					break;
				}
			}
		}
		if (!picked) done = TRUE;
	}
}

void LdbPeriodicBossesRedist(bocNum)
ChareNumType bocNum;
{
	int i;

	for (i=0; i<exchanges; i++)
		if (load_boss[i] < BOSS_SATURATION)
			if (SendTokens(nbr_boss[i], 1)) load_boss[i]++;
			else break;
}

/*****************************************************************/
/** In the following strategies we decide what to do with a new	**/
/** free chare, or the corresponding token.			**/
/*****************************************************************/
LdbStrategy(x)
ENVELOPE *x;
{
}


TokenStrategy(msg)
InsertMsg *msg;
{
	int i;
	ENVELOPE * env = (ENVELOPE *) ENVELOPE_UPTR(msg);
	LDB_ELEMENT *ldb = LDB_ELEMENT_PTR(env);
	int least_loaded_pe = LdbLeastLoadPe();

TRACE(CkPrintf("[%d] TokenStrategy: srcPE=%d, destPE=%d, work_from=%d, work=%d\n",
	    CmiMyPe(), ldb->srcPE, least_loaded_pe,
	    msg->pe, msg->no));

	for (i=0; i<msg->no; i++)
		insert_work_cluster(msg->pe);
	if (least_loaded_pe >= 0) {
		int pe;

		if (CONTROLLER(least_loaded_pe)) {
			delete_work_cluster(&pe, least_loaded_pe, -1);
			SendManager(pe, least_loaded_pe);
		}
		else {
			delete_work_cluster(&pe, CmiMyPe(), least_loaded_pe);
			SendManagee(pe, least_loaded_pe);
		}
		increment_load(least_loaded_pe);
	}
}


/*****************************************************************/
/** Send token to manager.										**/
/*****************************************************************/
SendManager(pe, least_loaded_pe)
int pe, least_loaded_pe;
{
    redist_msg->exchanges = 1;
    redist_msg->pe[0] = pe;
    SetEnv_destPE(redist_env, least_loaded_pe);

    LdbFillBlock(redist_env);
    COPY_AND_SEND(redist_env);
}

/*****************************************************************/
/** Send token to managee.										**/
/*****************************************************************/
SendManagee(pe, least_loaded_pe)
int pe, least_loaded_pe;
{
    delete_msg->deletes=0;
    delete_msg->pe[delete_msg->deletes++] = least_loaded_pe;
    SetEnv_destPE(delete_env, pe);
    LdbFillBlock(delete_env);
    SetEnv_destPeFixed(delete_env, TRUE);
    COPY_AND_SEND(delete_env);
}



/*****************************************************************/
/** Send "number" tokens to processor "pe".			**/
/*****************************************************************/
SendTokens(pe, number)
int pe;
int number;
{
	int i;
	int tope;

TRACE(CkPrintf("[%d] SendTokens: sending %d tokens to %d\n",
CmiMyPe(), number, pe));

	SetEnv_destPE(redist_env, pe);
	for (i=0; i<number; i++) {
		if (delete_work_cluster(&tope, pe, -1)) 
			redist_msg->pe[i] = tope;
		else break;
	}
	if (i>0) {
TRACE(CkPrintf("[%d] SendTokens: can send %d tokens to %d\n",
CmiMyPe(), i, pe));

		redist_msg->exchanges = i;
		LdbFillBlock(redist_env);
		COPY_AND_SEND(redist_env);
	}
}


/*****************************************************************/
/** Get the index of the ith dimensional neighbor for a manager.**/
/*****************************************************************/
flipi(n, i)
unsigned int n, i;
{
	n /= CLUSTER_SIZE;
	return( ((n & (1<<i)) ^ (1<<i)) | (n & ~(1<<i)));
}


/*****************************************************************/
/** Increments the status for the corresponding manager/kid.	**/
/*****************************************************************/
increment_load(least_loaded_pe)
int least_loaded_pe;
{
	int index;

	index = get_index(least_loaded_pe);
	if (CONTROLLER(least_loaded_pe)) load_boss[index] ++;
	else load_cluster[index] += 1;
}


/*****************************************************************/
/** Get the index of the manager (0..(dim-1)) or the kid	**/
/** 0..(CLUSTER_SIZE-1)						**/
/*****************************************************************/
get_index(m)
unsigned int m;
{
	int i;

	if (CONTROLLER(m)) {
		int n = CmiMyPe();
		for (i=0; i<exchanges; i++) if (m == nbr_boss[i]) return i;
	}
	else return (m % CLUSTER_SIZE);
	CkPrintf("[%d] *** ERROR *** get_index has wrong index for %d.\n",
			CmiMyPe(), m);
	return -1;
}


/*****************************************************************/
/** This function redistributes tokens amongst the managers.	**/
/*****************************************************************/
do_redistribution(other, other_load)
int other, other_load;
{
	int number;
	ENVELOPE *env;
	int my_load = LdbMyLoad();

	number = 0;
	if ((my_load > other_load) && (other_load < CLUSTER_SIZE))
		number = (my_load - other_load)/2;

	if (number > MAX_EXCHANGES) number = MAX_EXCHANGES;
	SendTokens(other, number);
}


/*****************************************************************/
/** This function returns the id of my controller.		**/
/*****************************************************************/
MyController(x)
int x;
{
	x = x / CLUSTER_SIZE;
	x = (x+1)*CLUSTER_SIZE;
	if (x>numPe-1)
		return numPe-1;
	return x-1;
}

insert_work_cluster(pe)
{
TRACE(CkPrintf("[%d] inserT_work_cluster: pe=%d\n", CmiMyPe(), pe));
	total_work_cluster++;
	work_cluster[pe] ++;
}

delete_work_cluster(pe, cluster, to)
int *pe, cluster, to;
{
	int i;
	int start_index;
	int start_other, end_other, size_other;

	*pe = -1;
	if (!total_work_cluster) return 0;
TRACE(CkPrintf("[%d] delete_work_cluster: cluster=%d, to=%d, total=%d\n",
CmiMyPe(), cluster, to, total_work_cluster));

	if ((cluster==CmiMyPe()) && (to!=-1)) {

		if (work_cluster[to]) 
			*pe = to;
		else {
			i=0;
			start_index = delete_ptr = start_my_cluster;
			for (i=0; i<size_my_cluster; i++) { 
				if (work_cluster[delete_ptr]) break;
				delete_ptr = start_my_cluster + 
					(i+start_index)%size_my_cluster;
			}
			if (i < size_my_cluster)
				*pe = delete_ptr;
			else {
				start_other = end_my_cluster;
				end_other = start_my_cluster;
				size_other = CmiNumPe() - size_my_cluster - 1;
			}
		}
	}
	else {
		int end = cluster;
		int start = (end/CLUSTER_SIZE) * CLUSTER_SIZE;
		int size  = end  - start; 

TRACE(CkPrintf("[%d] delete_work_cluster: start=%d, end=%d, size=%d\n",
CmiMyPe(), start, end, size));
		i=0;
		start_index = delete_ptr = start;
		for (i=0; i<size; i++) {
			if (work_cluster[delete_ptr]) break;
			delete_ptr = start + (start_index+i)%size;
		}
		if (i < size)
			*pe = delete_ptr;
		else {
			start_other = end;
			end_other = start;
			size_other = CmiNumPe() - size -1;
		}
	}

	/* i have checked my cluster, now i need to check other clusters */
	if (*pe == -1) {
TRACE(CkPrintf("[%d] delete_work_cluster: start_other=%d, end_other=%d, size_other=%d\n",
CmiMyPe(), start_other, end_other, size_other));
		i=0;
		delete_ptr = start_other;
		for (i=0; i<size_other; i++) { 
			if (work_cluster[delete_ptr]) break;
			delete_ptr = (delete_ptr+1)%CmiNumPe(); 
		}
		if (i < size_other)
			*pe = delete_ptr;
	}

	if (*pe != -1) { 
TRACE(CkPrintf("[%d] delete_work_cluster: select from pe %d\n", 
CmiMyPe(), *pe));
		if (CONTROLLER(*pe))
			CkPrintf("[%d] *** ERROR *** Controller %d cannot have work.\n",
					CmiMyPe(), *pe);
		if (!work_cluster[*pe]) 
			CkPrintf("[%d] ***ERROR *** delete_work_cluster: wrong pe=%d\n",
					CmiMyPe(), *pe);
		work_cluster[*pe]--;
		total_work_cluster--;
		return 1;
	}
	else	
		return 0;
}

init_work_cluster()
{ 
    	int i;
    	work_cluster = (int *) CkAlloc(sizeof(int)*CmiNumPe());
    	for (i=0; i<CmiNumPe(); i++) work_cluster[i] = 0;
}

