/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ldb.h,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/04/02 00:48:17 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: ldb.h,v $
 * Revision 1.3  1995/04/02  00:48:17  sanjeev
 * changes for separating Converse
 *
 * Revision 1.2  1994/11/11  05:23:48  brunner
 * Removed ident added by accident with RCS header
 *
 * Revision 1.1  1994/11/07  15:39:02  brunner
 * Initial revision
 *
 ***************************************************************************/
#define STATUS 0
#define INSERT 1
#define DELETE 2
#define REDISTRIBUTION 3
#define OTHER 4

#define MAXINT  0xffff
#define HUGE_INT 9999999

#define MAX_BOSSES 32
#define CLUSTER_SIZE 16
#define MAX_EXCHANGES  6
#define MAX_DELETES 4

#define KID_SATURATION			1
#define MINIMUM_KID_LOAD 		3
#define KID_STATUS_UPDATE_INTERVAL  	50

#define BOSS_SATURATION			1
#define MINIMUM_BOSS_LOAD 		1
#define BOSS_STATUS_UPDATE_INTERVAL  	75
#define BOSS_REDIST_UPDATE_INTERVAL	500

#define MIN_DISTRIBUTION 3
#define MAX_WORKER_LOAD 1

typedef struct ldb_element {
    int type;
	PeNumType srcPE;
	int	piggybackLoad;
} LDB_ELEMENT;

int LDB_ELEM_SIZE = sizeof(LDB_ELEMENT);
int   NeedLdbStripMsg = 1;

typedef struct {
	int pe;
	int no;
} InsertMsg;

typedef struct {
	int deletes;
	int pe[MAX_DELETES];
} DeleteMsg;

typedef struct message4 {
    int exchanges;
    int pe[MAX_EXCHANGES];
} RedistributionMsg;

int numPe;
int exchanges;
int mycontroller;
BOOLEAN controller;

int numBoss;
int nbr_boss[MAX_BOSSES];
int load_boss[MAX_BOSSES];

int load_worker;
int *work_cluster;
int load_cluster[CLUSTER_SIZE];

ENVELOPE *redist_env;
ENVELOPE *status_env, *insert_env, *delete_env;

InsertMsg *insert_msg;
DeleteMsg *delete_msg;
RedistributionMsg *redist_msg;
DummyMsg *boss_statusMsg[MAX_BOSSES], *status_msg;

void * TreeLdbQueue;
int delete_ptr;



