/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: new_ldb.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/04/14 06:55:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: new_ldb.c,v $
 * Revision 1.2  1995/04/14  06:55:35  milind
 * changed all Mc functions to Cmi functions
 *
 * Revision 1.1  1994/11/03  17:39:25  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /home/kale/milind/RCS/new_ldb.c,v 1.2 1995/04/14 06:55:35 milind Exp $";
#include <math.h>
#include "chare.h"
#include "stat.h"
#include "new_ldb.h"
#include "node.globals.h"

#define  CONTROLLER(pe) (((pe + 1)%CLUSTER_SIZE == 0) || ((pe + 1 ) == numPe))
#define  LdbMyLoad()	heap_index


int sent_update=0;
int local_chares=0;
void *LdbFreeChareQueue;

int LdbPeriodicKidStatus();

void SendKid();
void LdbPeriodicBossStatus();

int LdbProcessMsg();

LdbBocInit()
{
	BOC_BLOCK *bocBlock;

	bocBlock = (BOC_BLOCK *) CreateBocBlock(sizeof(DATA_BR_LDB));
	bocBlock->boc_num = LdbBocNum;
	SetBocDataPtr(LdbBocNum, (void *) (bocBlock + 1));
	init_heap();
	init_table();
	LdbInit();
	StatInit();
	srand(CmiMyPe());
}

LdbSentUpdateStatus(pe) int pe; { }


/*****************************************************************/
/** Initialize Periodic Checks.					**/
/*****************************************************************/
LdbPeriodicCheckInit()
{
	if (numPe > 1) {
		if (CONTROLLER(CmiMyPe())) {
			if (numPe > CLUSTER_SIZE)
				CallBocAfter(LdbPeriodicBossStatus, LdbBocNum, 
				    BOSS_STATUS_UPDATE_INTERVAL);
		}
		else {
			CallBocOnCondition(LdbPeriodicKidStatus, LdbBocNum);
		}
	}
}

/*****************************************************************/
/** Initialize the LDB variables here.				**/
/*****************************************************************/
LdbInit()
{
	int i;
	ENVELOPE *env;
	LDB_ELEMENT *ldb;

	numPe = CmiNumPe();
	controller = CONTROLLER(CmiMyPe());
	mycontroller = MyController(CmiMyPe());

	if (numPe%CLUSTER_SIZE == 0) numBoss = numPe/CLUSTER_SIZE;
	else numBoss = numPe/CLUSTER_SIZE + 1;

	insert_msg = (OperationMsg *) CkAllocMsg(sizeof(OperationMsg));
	insert_env = (ENVELOPE *) ENVELOPE_UPTR(insert_msg);
	SetEnv_EP(insert_env, LdbNbrStatus_EP);
	SetEnv_destPeFixed(insert_env, TRUE);
	SetEnv_category(insert_env, IMMEDIATEcat);
	SetEnv_msgType(insert_env, LdbMsg);
	/* fill the LdbBlock with load status */
	ldb = LDB_ELEMENT_PTR(insert_env);
	ldb->srcPE = CmiMyPe();
	ldb->type = INSERT;

	if (!controller) {
		/* allocate a message to be sent to the controller */
		status_msg = (OperationMsg *) CkAllocMsg(sizeof(OperationMsg));
		status_env = (ENVELOPE *) ENVELOPE_UPTR(status_msg);
		SetEnv_EP(status_env, LdbNbrStatus_EP);
		SetEnv_destPE(status_env, mycontroller);
		SetEnv_destPeFixed(status_env, TRUE);
		SetEnv_category(status_env, IMMEDIATEcat);
		SetEnv_msgType(status_env, LdbMsg);
		/* fill the LdbBlock with load status */
		ldb = LDB_ELEMENT_PTR(status_env);
		ldb->srcPE = CmiMyPe();
		ldb->type = STATUS;

		SetEnv_destPE(insert_env, mycontroller);
	} else {

		/* allocate a message to be sent to the kids */
		delete_msg = (OperationMsg *) CkAllocMsg(sizeof(OperationMsg));
		delete_env = (ENVELOPE *) ENVELOPE_UPTR(delete_msg);
		SetEnv_EP(delete_env, LdbNbrStatus_EP);
		SetEnv_destPeFixed(delete_env, TRUE);
		SetEnv_category(delete_env, IMMEDIATEcat);
		SetEnv_msgType(delete_env, LdbMsg);
		/* fill the LdbBlock with load status */
		ldb = LDB_ELEMENT_PTR(delete_env);
		ldb->srcPE = CmiMyPe();
		ldb->type = DELETE;

		/* allocate a message to be sent to the kids */
		redist_msg = (RedistributionMsg *)
		    CkAllocMsg(sizeof(RedistributionMsg));
		redist_env = (ENVELOPE *) ENVELOPE_UPTR(redist_msg);
		SetEnv_EP(redist_env, LdbNbrStatus_EP);
		SetEnv_destPeFixed(redist_env, TRUE);
		SetEnv_category(redist_env, IMMEDIATEcat);
		SetEnv_msgType(redist_env, LdbMsg);
		/* fill the LdbBlock with load status */
		ldb = LDB_ELEMENT_PTR(redist_env);
		ldb->srcPE = CmiMyPe();
		ldb->type = REDISTRIBUTION;


		for (i=0; i<CLUSTER_SIZE; i++) load_cluster[i] = 0;

		if (numBoss > 1) {
			exchanges = (int) (log((double) numBoss) /
			    log((double) 2.0));

			TRACE(CkPrintf("[%d] Ldbinit: log(numBoss)=%f, log(2.0)=%f, exchanged=%f\n",
			    CmiMyPe(), log((double) numBoss), log((double) 2.0),
			    log((double) numBoss)/log((double) 2.0)));

			TRACE(CkPrintf("[%d] LdbInit: exchanges=%d, numBoss=%d\n",
			    CmiMyPe(), exchanges, numBoss));

			for (i=0; i<exchanges; i++) {
				int boss_index;

				boss_index = flipi(CmiMyPe(), i);
				load_boss[i] = 0;
				nbr_boss[i] = (CLUSTER_SIZE-1) + boss_index*CLUSTER_SIZE;
			}
			for (i=0; i<exchanges; i++) {
				boss_statusMsg[i] = (DummyMsg *) CkAllocMsg(sizeof(DummyMsg));
				env = (ENVELOPE *)
				    ENVELOPE_UPTR(boss_statusMsg[i]);
				SetEnv_EP(env, LdbNbrStatus_EP);
				SetEnv_destPE(env, nbr_boss[i]);
				SetEnv_destPeFixed(env, TRUE);
				SetEnv_category(env, IMMEDIATEcat);
				SetEnv_msgType(env, LdbMsg);

				/* fill the LdbBlock with load status */
				ldb = LDB_ELEMENT_PTR(env);
				ldb->type = STATUS;
				ldb->srcPE = CmiMyPe();
			}
		}
	}
}


/*****************************************************************/
/** This entry point is called to record Nbr. status. Currently	**/
/** I don't think it's ever called.				**/
/*****************************************************************/
int LdbProcessMsg(msgPtr, localdataPtr)
void *msgPtr;
void *localdataPtr;
{
	int i;
	ENVELOPE *work;
	OperationMsg *msg;
	RedistributionMsg *rmsg;
	LDB_ELEMENT *ldb = LDB_UPTR(msgPtr);
	int index = get_index(ldb->srcPE);
	ENVELOPE *env = (ENVELOPE *) ENVELOPE_UPTR(msgPtr);

	if (GetEnv_msgType(env) != LdbMsg)
		CkPrintf("*** ERROR *** Ldb strategy received unknown message.\n");

	switch (ldb->type) {
		case INSERT:
			get_status(index, ldb);
			TokenStrategy((OperationMsg *) msgPtr);
			break;

		case DELETE:
			msg = (OperationMsg *) msgPtr;
			for (i=0; i<msg->exchanges; i++) {
				delete_table(msg->token[i].priority, &work);
				SetEnv_destPE(work, msg->token[i].pe);
				ldb = LDB_ELEMENT_PTR(work);
				ldb->type = OTHER;

TRACE(CkPrintf("[%d] DELETE: priority=%d, destPE=%d\n",
CmiMyPe(), msg->token[i].priority, msg->token[i].pe));

				if (GetEnv_destPE(work) == CmiMyPe()) {
					SetEnv_destPeFixed(work, TRUE);
					QsEnqMsg(work);
					sent_update = 0;
				}
				else
					CkSend(GetEnv_destPE(work), TotalMsgSize(work), work);
			}
			break;

		case REDISTRIBUTION:
			rmsg = (RedistributionMsg *) msgPtr;
			for (i=0; i<rmsg->exchanges; i++) insert_heap(&(rmsg->tokens[i]));
			break;

		case STATUS:
			if (CONTROLLER(ldb->srcPE))
				DoRedistribution(ldb->srcPE, load_boss[get_index(ldb->srcPE)]);
			else SendKid(ldb->srcPE);
			break;

		case OTHER:
			CkPrintf("*** ERROR *** Unknown option in LdbRecvUpdateStatus.\n");
			break;
	}
}


/*****************************************************************/
/** Once a message is recd. this function is called to strip off**/
/** any ldb related information. For this strategy this message **/
/** does more than just provide status information. It doubles  **/
/** up as a message to insert a token, to delete a token and to **/
/** receive redistributed tokens.				**/
/*****************************************************************/
LdbStripMsg(env)
ENVELOPE * env;
{
	LDB_ELEMENT *ldb;

	ldb = LDB_ELEMENT_PTR(env);
	/*possible Neighbour update status from piggyback info from Node only*/
	if ((numPe > 1) && (ldb->srcPE != CmiMyPe())
	    && (ldb->srcPE != CmiNumPe()))
		LdbRecvUpdateStatus(ldb, env, USER_MSG_PTR(env));
}


/*****************************************************************/
/** Function is called when a new chare is recd. from the net.	**/
/*****************************************************************/
Ldb_NewChare_FromNet(x)
ENVELOPE *x;
{
	if (controller) CkPrintf("*** ERROR *** New chare sent to Manager.\n");
	else {
		TRACE(CkPrintf("[%d] Ldb_NewChare_Net:: Message from outside. \n",
		    CmiMyPe()));
		SetEnv_destPeFixed(x, TRUE);
		QsEnqMsg(x);
		sent_update=0;
	}
}


/*****************************************************************/
/** Function is called when a new chare is recd. from local.	**/
/*****************************************************************/
Ldb_NewChare_FromLocal(x)
ENVELOPE *x;
{
	if (controller) CkPrintf("*** ERROR *** New chare created on Manager\n");
	else {
		void *msg;
		unsigned int *priority;

		if (local_chares==MAX_EXCHANGES) {
			insert_msg->exchanges = local_chares;
			local_chares=0;
			LdbFillBlock(insert_env);
			COPY_AND_SEND(insert_env);
		}
		msg = USER_MSG_PTR(x);
		priority = (unsigned int *) CkPriorityPtr(msg);
#ifdef BITVECTOR
		AssignPriority(insert_msg->token[local_chares].priority,
						 priority);
		insert_table(insert_msg->token[local_chares].priority, x);
		TRACE(insert_msg->token[local_chares].index =
				LdbHashFunction(insert_msg->token[local_chares].priority);)

#else

		TRACE(CkPrintf("LdbLocal: priority=%d\n", *priority));
		insert_table(*priority, x);
		AssignPriority(insert_msg->token[local_chares].priority,
					 *priority);
		TRACE(insert_msg->token[local_chares].index =	
					 LdbHashFunction(*priority);)
#endif
		insert_msg->token[local_chares].pe = CmiMyPe();
		local_chares++;
	}
}


/*****************************************************************/
/** This function fills in the ldb information before sending	**/
/** out a message.						**/
/*****************************************************************/
LdbFillBlock(env)
ENVELOPE *env;
{
	LDB_ELEMENT * ldb;

	ldb = LDB_ELEMENT_PTR(env);
	ldb->srcPE = CmiMyPe();
	if (CONTROLLER(ldb->srcPE)) ldb->piggybackLoad = LdbMyLoad();
	else	ldb->piggybackLoad = QsMyLoad();
}


/*****************************************************************/
/** This function is called to recv. status. In this case this  **/
/** function is used to do other things, like recv. insert, 	**/
/** delete or redistribution messages.				**/
/*****************************************************************/
LdbRecvUpdateStatus(ldb, env, msg)
LDB_ELEMENT * ldb;
ENVELOPE *env;
OperationMsg *msg;
{
	int index = get_index(ldb->srcPE);

	if ((GetEnv_msgType(env) == LdbMsg) && (ldb->type == STATUS)) {
		TRACE(CkPrintf("[%d] STATUS: srcPE=%d\n", CmiMyPe(), ldb->srcPE));
		get_status(index, ldb);
	}
}





/*****************************************************************/
/** Get status report for this message.				**/
/*****************************************************************/
get_status(index, ldb)
int index;
LDB_ELEMENT *ldb;
{
	TRACE(CkPrintf("[%d] get_status: srcPE=%d, load=%d\n",
	    CmiMyPe(), ldb->srcPE, ldb->piggybackLoad));
	if (CONTROLLER(ldb->srcPE)) load_boss[index] = ldb->piggybackLoad;
	else load_cluster[index] = ldb->piggybackLoad;
}


/*****************************************************************/
/** Now follow a bunch of useless functions. We plan to do 	**/
/** something with them in the future.				**/
/*****************************************************************/
LdbPrintNodeNeighbours() { }


LdbAddSysBocEps(BocEpTable)
FUNCTION_PTR BocEpTable[];
{
	BocEpTable[LdbNbrStatus_EP] =  LdbProcessMsg;
}


LdbProcessorIdle() { }


/*****************************************************************/
/** This function determines the least loaded processor.	**/
/*****************************************************************/
LdbLeastLoadPe()
{
	int kid_load;
	int pe = LdbLeastLoadKids(&kid_load);

	if (pe==-1) pe = LdbLeastLoadBosses();
	return pe;
}


/*****************************************************************/
/** This function is used to determine the least loaded kid of	**/
/** a manager.							**/
/*****************************************************************/
LdbLeastLoadKids(load)
int *load;
{
	int pe;
	int index;
	int min_pe = 0;
	int min = HUGE_INT;
	int start_pe, end_pe;

	end_pe = CmiMyPe();
	start_pe = (end_pe/CLUSTER_SIZE)*CLUSTER_SIZE;
	for (pe=start_pe; pe<end_pe; pe++) {
		index = get_index(pe);
		if (load_cluster[index] < min) {
			min = load_cluster[index];
			min_pe = pe;
		}
	}
	*load = min;
	if (min < KID_SATURATION) return(min_pe);
	return -1;
}


/*****************************************************************/
/** This function is used to determine the least loaded managers**/
/** in the dimensional neighbors graph.				**/
/*****************************************************************/
LdbLeastLoadBosses()
{
	int i, j;
	int min_pe;
	int min = HUGE_INT;
	static int start_pe = 0;

	if (numBoss <= 1) return -1;
	for (j=0; j<exchanges; j++) {
		i = (start_pe + j) % exchanges;
		if (load_boss[i] < min) {
			min = load_boss[i];
			min_pe = nbr_boss[i];
		}
	}
	if (min < BOSS_SATURATION) {
		start_pe = min_pe;
		return min_pe;
	}
	return -1;
}



/*****************************************************************/
/** Functions to periodically send status. The kids send their 	**/
/** status to their managers, while the managers send their	**/
/** status to their neighbors in the dimensional exchange.	**/
/*****************************************************************/
LdbPeriodicKidStatus(bocNum)
ChareNumType bocNum;
{
	if (local_chares) {
		insert_msg->exchanges = local_chares;
		LdbFillBlock(insert_env);
		COPY_AND_SEND(insert_env);
		local_chares=0;
	}
	else if (QsMyLoad()<=MINIMUM_KID_LOAD && !sent_update) {
		LDB_ELEMENT * ldb;

		/* fill the LdbBlock with load status */
		ldb = LDB_ELEMENT_PTR(status_env);
		ldb->piggybackLoad = 0;

		COPY_AND_SEND(status_env);
		sent_update=1;
TRACE(CkPrintf("[%d] LdbPeriodicKidStatus: sent status to manager.\n",
CmiMyPe()));
	}
	return FALSE;
}



void LdbPeriodicBossStatus(bocNum)
ChareNumType bocNum;
{
	ENVELOPE *env;
	LDB_ELEMENT * ldb;
	static int index = 0;
	int load = LdbMyLoad();


	/* fill the LdbBlock with load status */
	env = (ENVELOPE *) ENVELOPE_UPTR(boss_statusMsg[index]);
	ldb = LDB_ELEMENT_PTR(env);
	ldb->piggybackLoad = load;

	COPY_AND_SEND(env);
	index = (index+1) % exchanges;
	CallBocAfter(LdbPeriodicBossStatus, LdbBocNum, BOSS_STATUS_UPDATE_INTERVAL);
}


/*****************************************************************/
/** This functions is called to give load to kid.  **/
/*****************************************************************/
void SendKid(p)
int p;
{
	int i, index;
	TOKEN_TYPE *token;

    index = get_index(p);
	for (i=0; i<KID_SATURATION-load_cluster[index]; i++) {
		if (delete_heap(&token)) {
TRACE(CkPrintf("[%d] SendKid: send work to %d\n", CmiMyPe(), p));
			SendManagee(token, p);
			increment_load(p);
			CkFree(token);
		}
		else break;
	}
}


/*****************************************************************/
/** In the following strategies we decide what to do with a new	**/
/** free chare, or the corresponding token.			**/
/*****************************************************************/
TokenStrategy(msg)
OperationMsg *msg;
{
	int i;
	int load;
	ENVELOPE * env;
	LDB_ELEMENT *ldb;
	TOKEN_TYPE *token;
	int least_loaded_pe;

	for (i=0; i<msg->exchanges; i++) {
TRACE(CkPrintf("[%d] INSERT: inserting priority=%d, from=%d\n",
CmiMyPe(), msg->token[i].priority, msg->token[i].pe));
		insert_heap(&(msg->token[i]));
	}

	env = (ENVELOPE *) ENVELOPE_UPTR(msg);
	ldb = LDB_ELEMENT_PTR(env);
	if (CONTROLLER(ldb->srcPE)) least_loaded_pe = LdbLeastLoadKids(&load);
	else least_loaded_pe = LdbLeastLoadPe();

	while (least_loaded_pe >= 0) {
		if (!delete_heap(&token)) break;  
		if (CONTROLLER(least_loaded_pe)) SendManager(token, least_loaded_pe);
		else SendManagee(token, least_loaded_pe);
		CkFree(token);
		increment_load(least_loaded_pe);

		/* send work to other people */
		least_loaded_pe = LdbLeastLoadKids(&load);
	}
}


/*****************************************************************/
/** Send token to manager.										**/
/*****************************************************************/
SendManager(token, least_loaded_pe)
TOKEN_TYPE *token;
int least_loaded_pe;
{
	insert_msg->exchanges=1;
    insert_msg->token[0].pe = token->pe;
    TRACE(insert_msg->token[0].index = token->index;)
    CopyPriority(insert_msg->token[0].priority, token->priority);
    SetEnv_destPE(insert_env, least_loaded_pe);

    LdbFillBlock(insert_env);
    COPY_AND_SEND(insert_env);
TRACE(CkPrintf("[%d] SendManager: least_loaded=%d, pe=%d, priority=%d\n",
CmiMyPe(), least_loaded_pe, token->pe, token->priority));
}

/*****************************************************************/
/** Send token to managee.										**/
/*****************************************************************/
SendManagee(token, least_loaded_pe)
TOKEN_TYPE *token;
int least_loaded_pe;
{
	delete_msg->exchanges=1;
    delete_msg->token[0].pe = least_loaded_pe;
    TRACE(delete_msg->token[0].index = token->index;)
    CopyPriority(delete_msg->token[0].priority, token->priority);
    SetEnv_destPE(delete_env, token->pe);

    LdbFillBlock(delete_env);
    COPY_AND_SEND(delete_env);

TRACE(CkPrintf("[%d] SendManagee: least_loaded=%d, pe=%d, priority=%d\n",
CmiMyPe(), least_loaded_pe, token->pe, token->priority));
}



/*****************************************************************/
/** Send "number" tokens to processor "pe".			**/
/*****************************************************************/
SendTokens(pe, number)
int pe;
int number;
{
	int i;
	TOKEN_TYPE *token;

	SetEnv_destPE(redist_env, pe);
	for (i=0; i<number; i++) {
		if (delete_heap(&token)) {
			redist_msg->tokens[i].pe = token->pe;
			TRACE(redist_msg->tokens[i].index = token->index;)
			    CopyPriority(redist_msg->tokens[i].priority, 
			    token->priority);
			CkFree(token);
		} else break;
	}
	redist_msg->exchanges = i;
	if (i>0) {
		LdbFillBlock(redist_env);
		COPY_AND_SEND(redist_env);
	}
	TRACE(CkPrintf("[%d] SendTokens: no=%d, last_pe=%d, last_prio=%d\n",
	    CmiMyPe(), redist_msg->exchanges, 
	    redist_msg->tokens[i-1].pe, 
	    redist_msg->tokens[i-1].priority));
}


/*****************************************************************/
/** Get the index of the ith dimensional neighbor for a manager.**/
/*****************************************************************/
flipi(n, i)
unsigned int n, i;
{
	n /= CLUSTER_SIZE;
	return( ((n & (1<<i)) ^ (1<<i)) | (n & ~(1<<i)));
}


/*****************************************************************/
/** Increments the status for the corresponding manager/kid.	**/
/*****************************************************************/
increment_load(least_loaded_pe)
int least_loaded_pe;
{
	int index;

	index = get_index(least_loaded_pe);
	if (CONTROLLER(least_loaded_pe)) load_boss[index] ++;
	else load_cluster[index] += 1;
}


/*****************************************************************/
/** Get the index of the manager (0..(dim-1)) or the kid	**/
/** 0..(CLUSTER_SIZE-1)						**/
/*****************************************************************/
get_index(m)
unsigned int m;
{
	int i;

	if (CONTROLLER(m)) {
		int n = CmiMyPe();

		for (i=0; i<exchanges; i++)
			if (m == flipi(n, i))
				return i;
	} else return (m % CLUSTER_SIZE);
	return -1;
}


/*****************************************************************/
/** This function redistributes tokens amongst the managers.	**/
/*****************************************************************/
DoRedistribution(other, other_load)
int other, other_load;
{
	int i;
	int number;
	int SKIP = 1;
	int index = 0;
	ENVELOPE *env;
	int my_load = LdbMyLoad();

	number = 0;
	if (my_load > other_load) number = (my_load - other_load)/2;
	number = MAX_EXCHANGES/2;

	TRACE(CkPrintf("[%d] do_redist: my_load=%d, other_load=%d, number = %d\n",
	    CmiMyPe(), my_load, other_load, number));

	if (number > MAX_EXCHANGES) number = MAX_EXCHANGES;
	SendTokens(other, number);
	TRACE(CkPrintf("[%d] do_redist: Finish\n", CmiMyPe()));
}


/*****************************************************************/
/** This function returns the id of my controller.		**/
/*****************************************************************/
MyController(x)
int x;
{
	x = x / CLUSTER_SIZE;
	x = (x+1)*CLUSTER_SIZE;
	if (x>numPe-1) return numPe-1;
	return x-1;
}

/*****************************************************************/
/** Initialize hash table.					**/
/*****************************************************************/
init_table()
{
	int i;
	for (i=0; i<HASH_TABLE_SIZE; i++) hash_table[i] = NULL;
}


/*****************************************************************/
/** Insert an entry into the hash table.			**/
/*****************************************************************/
insert_table(priority, env)
#ifdef BITVECTOR
unsigned int priority[BITMAX];
#else
unsigned int priority;
#endif
ENVELOPE * env;
{
	ENTRY *new;
	int index = LdbHashFunction(priority);

	TRACE(_print_bit_vector("insert_table", index, priority);)

	if (index>=HASH_TABLE_SIZE || index <0) {
		TRACE(_print_bit_vector("insert_table", index, priority);)
		    CkPrintf("[%d] *** ERROR *** Illegal hash %d computed.\n",
		    CmiMyPe(), index);
	}

	new = (ENTRY *) CkAlloc(sizeof(ENTRY));
	CopyPriority(new->priority, priority);
	new->work = env;
	new->next = hash_table[index];
	hash_table[index] = new;
}


/*****************************************************************/
/** Delete an entry from the hash table.			**/
/*****************************************************************/
delete_table(priority, env)
#ifdef BITVECTOR
unsigned int priority[BITMAX];
#else
unsigned int priority;
#endif
ENVELOPE **env;
{
	ENTRY *current, *previous;
	int index = LdbHashFunction(priority);

	TRACE(_print_bit_vector("delete_table", index, priority));

	previous =  current = hash_table[index];
	if (current != NULL) {
		if (TokenEqual(current->priority, priority)) {
			*env = current->work;
			hash_table[index] = current->next;
			return;
		}

		current = current->next;
		while (current != NULL) {
			if (TokenEqual(current->priority, priority)) {
				*env = current->work;
				previous->next  = current->next;
				return;
			}
			current = current->next;
			previous = previous->next;
		}
	}
	*env = NULL;
	CkPrintf("[%d] *** ERROR *** Message not found in hash table %d.\n",
	    CmiMyPe(), index);
	TRACE(_print_bit_vector("delete_table", index, priority));
}


/*****************************************************************/
/** Initialize the heap.					**/
/*****************************************************************/
init_heap()
{
	int i;
	heap_index = 0;
	for (i=0; i<MAX_HEAP_SIZE; i++) heap[i] = (TOKEN_TYPE *) NULL;
}


/*****************************************************************/
/** Insert a new token into the heap.				**/
/*****************************************************************/
insert_heap(insert_item)
TOKEN_TYPE *insert_item;
{
	int i, j;
	TOKEN_TYPE *item;

	if (heap_index >= MAX_HEAP_SIZE)
		CkPrintf("*** ERROR *** Heap Size Exceeded.\n");
	item = (TOKEN_TYPE *) CkAlloc(sizeof(TOKEN_TYPE));
	item->pe = insert_item->pe;
	CopyPriority(item->priority, insert_item->priority);

	TRACE(item->index = insert_item->index;)
	TRACE(check_token("insert heap", item);)

	heap[heap_index++] = item;
	j = heap_index - 1;
	i = (heap_index - 2)/2;

	while ((i>=0) && (TokenGreaterThan(heap[i]->priority, item->priority))) {
		heap[j] = heap[i];
		j = i;
		if (i==0)
			break;
		i = (i-1)/2;
	}
	heap[j] = item;
}




/*****************************************************************/
/** Delete a token from the heap.				**/
/*****************************************************************/
delete_heap(item)
TOKEN_TYPE **item;
{
	int i, j;
	TOKEN_TYPE *temp;

	if (heap_index <= 0) return 0;
	*item = heap[0];

	TRACE(_print_bit_vector("delete_heap", LdbHashFunction(heap[0]->priority),
	    heap[0]->priority));
	TRACE(check_token("delete heap", *item));

	j=1;
	i=0;
	temp = heap[0] = heap[heap_index-1];
	heap[heap_index-1] = NULL;
	heap_index--;
	while (j <= heap_index-1)
	{
		if ((j < heap_index-1) &&
		    TokenGreaterThan(heap[j]->priority, 
		    heap[j+1]->priority))
			j=j+1;
		if  (TokenGreaterThan(heap[j]->priority, temp->priority)  ||
		    TokenEqual(temp->priority, heap[j]->priority))
			break;
		else
			heap[(j-1)/2] = heap[j];
		j = 2*j + 1;
	}
	heap[(j-1)/2] = temp;

	return 1;
}


/************************************************************************/
/* Hash function for bitvector and integer priorities.  		*/
/************************************************************************/

#ifdef BITVECTOR

/* if bit vector pointed by p > bit vector pointed by q return TRUE else
   return FALSE */
int GreaterThan(p, q)
unsigned int *p, *q;
{
	unsigned int	*p_ptr, *q_ptr;
	int	p_size, q_size, max_size, min_size, count;

	/* compare the first words */
	if ( (*p & 0x0ffffff) > (*q & 0x0ffffff) )
		return(TRUE);

	if ( (*p & 0x0ffffff) < (*q & 0x0ffffff) )
		return(FALSE);

	/* Proceed since the first words are Equal */
	p_ptr = p;
	q_ptr = q;

	/* get vector sizes */
	if ( (*p_ptr >> 24) > 24 )
		p_size = (( (*p_ptr >> 24) - 25) >> 5) + 2;
	else
		p_size = 1;

	if ( (*q_ptr >> 24) > 24 )
		q_size = (( (*q_ptr >> 24) - 25) >> 5) + 2;
	else
		q_size = 1;

	if ( p_size > q_size ) 
	{
		min_size = q_size;
		max_size = p_size;
	}
	else
	{
		min_size = p_size;
		max_size = q_size;
	}

	/* go to the 2nd word */
	p_ptr++;
	q_ptr++;
	count = 2;

	while ( (count <= min_size) && (*p_ptr == *q_ptr) )
	{
		p_ptr++;
		q_ptr++;
		count++;
	}

	if ( count <= min_size )
	{
		if ( *p_ptr > *q_ptr )
			return(TRUE);
		else
			return(FALSE);
	}
	else
	{
	    if ( count > max_size )
		return(FALSE);
	    else
	    {
		if ( max_size == p_size )
			while( count <= max_size )
			{
			   if ( *p_ptr != 0 )
				return(TRUE);
			   else
			   {
				p_ptr++;
				count++;
			   }
			}
		else
			while( count <= max_size )
			{
			   if ( *q_ptr != 0 )
				return(FALSE);
			   else
			   {
				q_ptr++;
				count++;
			   }
			}

		if ( count > max_size )
			return(FALSE);
	    }

	}

}


/* if bit vector pointed by p > bit vector pointed by q return TRUE else
   return FALSE */
int NotEqual(p, q)
unsigned *p, *q;
{
	unsigned	*p_ptr, *q_ptr;
	int		p_size, q_size, max_size, min_size, count;

	/* compare the first words */
	if ( (*p & 0x0ffffff) != (*q & 0x0ffffff) )
		return(TRUE);

	/* Proceed since the first words are Equal */
	p_ptr = p;
	q_ptr = q;

	/* get vector sizes */
	if ( (*p_ptr >> 24) > 24 )
		p_size = (( (*p_ptr >> 24) - 25) >> 5) + 2;
	else
		p_size = 1;

	if ( (*q_ptr >> 24) > 24 )
		q_size = (( (*q_ptr >> 24) - 25) >> 5) + 2;
	else
		q_size = 1;

	if ( p_size > q_size ) 
	{
		min_size = q_size;
		max_size = p_size;
	}
	else
	{
		min_size = p_size;
		max_size = q_size;
	}

	/* go to the 2nd word */
	p_ptr++;
	q_ptr++;
	count = 2;

	while ( (count <= min_size) && (*p_ptr == *q_ptr) )
	{
		p_ptr++;
		q_ptr++;
		count++;
	}

	if ( count <= min_size )
		return(TRUE);
	else
	{
	    if ( count > max_size )
		return(FALSE);
	    else
	    {
		if ( max_size == p_size )
		{
			while( count <= max_size )
			{
			   if ( *p_ptr != 0 )
				return(TRUE);
			   else
			   {
				p_ptr++;
				count++;
			   }
			}
		}
		else
		{
			while( count <= max_size )
			{
			   if ( *q_ptr != 0 )
				return(TRUE);
			   else
			   {
				q_ptr++;
				count++;
			   }
			}
		}

		if ( count > max_size )
			return(FALSE);
	    }

	}

}

LdbHashFunction(bit_vec)
unsigned int *bit_vec;
{
    	int vector_size;
	unsigned int *b_vec;
 	int index_1 = (*bit_vec & 0x0ffffff); 

    	if ( (*bit_vec >> 24) > 24)
       		vector_size =  ((((*bit_vec >> 24) - 25) >> 5) +2) << 2;
    	else
       		vector_size = 4;

    	if ( vector_size > 1 ) 
      		for (b_vec=bit_vec, b_vec++; b_vec<bit_vec+vector_size; b_vec++)
        		index_1 = ( index_1 ^ (*b_vec) ); 
    	if (index_1 < 0)  
        	index_1 = (-index_1);
    	index_1 = index_1 % HASH_TABLE_SIZE;
}


#else

int TokenGreaterThan(p,q)
unsigned int p, q;
{
	return (p > q);
}

int TokenEqual(p,q)
unsigned int p, q;
{
	return (p == q);
}


LdbHashFunction(bit_vec)
int bit_vec;
{
	return(bit_vec*MULTIPLICAND % HASH_TABLE_SIZE);
}

#endif

/*****************************************************************/
/** These are functions we need for debugging this strategy 	**/
/*****************************************************************/
/*
_print_bit_vector(s, index, vector_ptr)
char s[1000];
int index;
#ifdef BITVECTOR
unsigned        vector_ptr[BITMAX];
#else
unsigned        vector_ptr;
#endif
{
#ifdef BITVECTOR
        unsigned        *ptr, vector_length;
        int             vector_size;

        vector_length = (*vector_ptr >> 24) & 0x0ff;

        if ( vector_length <= 24 )
                vector_size = 1;
        else
                vector_size = ((vector_length - 25) >> 5) + 2;

        CkPrintf("[%d] %s: index=%d,  priority=", CmiMyPe(), s, index);
        for (ptr=vector_ptr; ptr < vector_ptr+vector_size; ptr++)
                CkPrintf("%u\t", *ptr);
        CkPrintf("\n");
#else
        CkPrintf("[%d] %s: index=%d,  priority=%d\n", CmiMyPe(), s, 
			index, vector_ptr);
#endif
}

check_token(s, token)
char s[1000];
TOKEN_TYPE *token;
{
	if (LdbHashFunction(token->priority) != token->index)
	{
		CkPrintf("[%d] *** ERROR *** Index=%d. \n", CmiMyPe(),
			LdbHashFunction(token->priority));
		_print_bit_vector(s, token->index, token->priority);
	}
}

*/
