/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ldb.h,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/04/14 06:55:35 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: ldb.h,v $
 * Revision 1.3  1995/04/14  06:55:35  milind
 * changed all Mc functions to Cmi functions
 *
 * Revision 1.2  1994/11/11  05:23:29  brunner
 * Removed ident added by accident with RCS header
 *
 * Revision 1.1  1994/11/07  15:38:57  brunner
 * Initial revision
 *
 ***************************************************************************/
#define STATUS 0
#define INSERT 1
#define DELETE 2
#define REDISTRIBUTION 3
#define OTHER 4

#define MAXINT  0xffff
#define HUGE_INT 9999999

#define MAX_BOSSES 32
#define CLUSTER_SIZE 8

#define  MAX_STEP  5
#define  MAX_EXCHANGES  6

#define KID_SATURATION			4
#define MINIMUM_KID_LOAD 		2
#define KID_STATUS_UPDATE_INTERVAL  	100

#define BOSS_SATURATION			3
#define MINIMUM_BOSS_LOAD 		1
#define BOSS_STATUS_UPDATE_INTERVAL  	75
#define BOSS_REDIST_UPDATE_INTERVAL	200

/** This is closely linked to the bitvec_int_macros.h **/
#define HASH_TABLE_SIZE 2003
#define MULTIPLICAND	367

#ifdef BITVECTOR
#define MAX_HEAP_SIZE 10000
#else
#define MAX_HEAP_SIZE 90000
#endif
#define BITMAX 6

typedef struct ldb_element {
    	int type;
	PeNumType srcPE;
	int	piggybackLoad;
} LDB_ELEMENT;

int LDB_ELEM_SIZE = sizeof(LDB_ELEMENT);
int   NeedLdbStripMsg = 1;

typedef struct {
    int dummy;
} DUMMY_MSG;

typedef struct {
    int dummy;
} STATUS_MSG;

typedef struct {
    int pe;
    TRACE(int index;)
#ifdef BITVECTOR
    unsigned int priority[BITMAX];
#else
    unsigned int priority;
#endif
} TOKEN_TYPE;

typedef struct {
    TOKEN_TYPE token; 
} OperationMsg;

typedef struct message4 {
    int exchanges;
    TOKEN_TYPE tokens[MAX_EXCHANGES];
} RedistributionMsg;

typedef struct data_manager_ldb {
    int dummy;
} DATA_MNGR_LDB;

typedef struct data_branch_ldb {
    int dummy;
} DATA_BR_LDB;


typedef struct ldb_status {
	int	peLoad;
	int	myLoadSent;
	int timeLoadSent;
	DUMMY_MSG *statusMsg;
	int statusMsgID;
} LDB_STATUS;

typedef struct entry {
#ifdef BITVECTOR
	unsigned int priority[BITMAX];
#else
	unsigned int priority;
#endif
	ENVELOPE *work;
	struct entry *next;
} ENTRY;



int numPe;

long status;
int exchanges;
int mycontroller;
BOOLEAN controller;
ENVELOPE *redist_env;
RedistributionMsg *redist_msg;
int load_cluster[CLUSTER_SIZE];
ENVELOPE *status_env, *insert_env, *delete_env;
OperationMsg *status_msg, *insert_msg, *delete_msg;

int numBoss;
int nbr_boss[MAX_BOSSES];
int  load_boss[MAX_BOSSES];
DummyMsg *boss_statusMsg[MAX_BOSSES];
ENVELOPE * store_exchange[MAX_EXCHANGES*MAX_STEP];

ENTRY *hash_table[HASH_TABLE_SIZE];

int heap_index;
TOKEN_TYPE *heap[MAX_HEAP_SIZE];


#ifdef BITVECTOR
#define AssignPriority(x,y) { \
	int i, vector_size, vector_length; \
 	for (i=0; i<BITMAX; i++) \
		x[i] = 0; \
	vector_length = (y[0] >> 24) & 0x0ff; \
	if ( vector_length <= 24 ) \
                vector_size = 1; \
        else \
                vector_size = ((vector_length - 25) >> 5) + 2; \
	if (vector_size > BITMAX) \
		CkPrintf("[%d] *** ERROR *** Illegal vector length %d.\n", \
			CmiMyPe(), vector_size);  \
	for (i=0; i<vector_size; i++) \
		x[i] = y[i]; \
}
#define CopyPriority(x,y) {int icp; for (icp=0; icp<BITMAX; icp++) x[icp] = y[icp];}
#else
#define AssignPriority(p,q) p=q
#define CopyPriority(p,q) p=q
#endif
