/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: node_ldb.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/04/14 06:59:44 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: node_ldb.c,v $
 * Revision 1.3  1995/04/14  06:59:44  milind
 * Changed all Mc functions to Cmi functions
 *
 * Revision 1.2  1994/12/02  00:00:31  sanjeev
 * interop stuff
 *
 * Revision 1.1  1994/11/03  17:39:40  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /home/kale/milind/RCS/node_ldb.c,v 1.3 1995/04/14 06:59:44 milind Exp $";
#include "chare.h"
#include "stat.h"
#include "ldb.h"
#include "node.globals.h"

#include <memory.h>

int FanFactor;

int lastPeZeroLoadIndex = 0;

void LdbPeriodicStatus();
void LdbPeriodicLowCheck();

LdbBocInit()
{
    BOC_BLOCK *bocBlock;

    bocBlock = (BOC_BLOCK *) CreateBocBlock(sizeof(DATA_BR_LDB));
    TRACE(CkPrintf("Node %d: LdbBocInit:created block with size %d\n",CmiMyPe(), sizeof(DATA_BR_LDB)));
    bocBlock->boc_num = LdbBocNum;
    SetBocDataPtr(LdbBocNum, (void *) (bocBlock + 1));
    TRACE(CkPrintf("Node %d: LdbBocInit: BocDataTbl entry filled.\n",CmiMyPe()));

    LdbInit();
    StatInit();
}


/*************************************
 * LDB Branch Office Chare Functions *
 *************************************/

LdbInit()
{
	int i;
	ENVELOPE *env;
	LDB_ELEMENT *ldb;

	TRACE(CkPrintf("Enter Node LdbInit()\n"));
	
	numPe = CmiNumPe();
	numNeighbours = McNumNeighbours(CmiMyPe());

	FanFactor = FF(numNeighbours);    /* Value for Fan Factor */

	if (numPe > 1)
	{
	    neighboursList = (int *) CkAlloc( numNeighbours * sizeof(int) );
            CkMemError(neighboursList);
	    McGetNodeNeighbours(CmiMyPe(), neighboursList );
	    statusList = (LDB_STATUS *) CkAlloc(numNeighbours * sizeof(LDB_STATUS)); 
            CkMemError(statusList);
	    LdbPrintNodeNeighbours();

	    for (i=0; i < numNeighbours; i++)
	    {
	        statusList[i].peLoad = 0;
	        statusList[i].myLoadSent = 0;

		/* Allocate status msgs and initialze */
	        statusList[i].statusMsg = (DUMMY_MSG *) CkAllocMsg(sizeof(DUMMY_MSG));
                CkMemError(statusList[i].statusMsg);
	        env = ENVELOPE_UPTR(statusList[i].statusMsg);
	        SetEnv_destPE(env, 0);
    	        SetEnv_category(env, IMMEDIATEcat);
    	        SetEnv_msgType(env, LdbMsg);
    	        SetEnv_destPeFixed(env, TRUE);
    
    	        SetEnv_boc_num(env, LdbBocNum);
    	        SetEnv_EP(env, LdbNbrStatus_EP);

	        /* fill the LdbBlock with load status */
	    }

	    deltaLoad = DELTALOAD;
	    deltaStatus = DELTASTATUS;
	    saturated = FALSE;


	    /* send Initial Status update msgs to all neighbours */
	    for (i=0; i < numNeighbours; i++)
	    {
	    	env = ENVELOPE_UPTR(statusList[i].statusMsg);
	    	SetEnv_destPE(env, neighboursList[i]); 

	    	/* fill the LdbBlock with load status */
    	    	ldb = LDB_ELEMENT_PTR(env);
    	        ldb->srcPE = CmiMyPe();
    	        ldb->piggybackLoad = 0;
		ldb->type = StatusMsg;
	    	/* McAsyncSend(GetEnv_destPE(env), TotalMsgSize(env),
			 env, &(statusList[i].statusMsgID));  */
		COPY_AND_SEND(env) ;  
	    }

	}
	else /* for a single processor */
	{
	    neighboursList = NULL;
	    statusList = NULL;
	}

	TRACE(CkPrintf("Node LdbInit() Done: numPe %d, numNeighbours %d\n",
		numPe, numNeighbours));
}

/**************************************************************
 * Retrieve ldb information from the ldb element in a message *
 **************************************************************/

LdbStripMsg(env)
ENVELOPE * env;
{
    LDB_ELEMENT *ldb;

    ldb = LDB_ELEMENT_PTR(env);
    if ((numPe > 1) && (ldb->srcPE != CmiMyPe()) 
        &&  (ldb->srcPE != CmiNumPe()))
    		LdbRecvUpdateStatus(ldb);
}

LdbRecvUpdateStatus(ldb)
LDB_ELEMENT * ldb;
{
  int i;
  
  i = McNeighboursIndex(CmiMyPe(), ldb->srcPE);
  if (i > -1)
      statusList[i].peLoad = ldb->piggybackLoad;
}

/************************************************************
 * If another processor sends this processor a single chare *
 * in response to a  request                                *
 ************************************************************/

Ldb_NewChare_FromNet(x) 
ENVELOPE *x;
{
  QsEnqMsg(x);
}

/***********************************************
 * Locally enqueue all locally produced chares *
 ***********************************************/

Ldb_NewChare_FromLocal(x)
ENVELOPE *x;
{
  QsEnqMsg(x);
}

/*********************************************************
 * Fill up the ldb element with the required information *
 *********************************************************/

LdbFillBlock(env)
ENVELOPE *env;
{
    LDB_ELEMENT * ldb;

    ldb = LDB_ELEMENT_PTR(env);
    ldb->srcPE = CmiMyPe();
    ldb->piggybackLoad = QsMyLoad();
    if (GetEnv_destPE(env) != CmiNumPe())
      LdbSentUpdateStatus(GetEnv_destPE(env));
}



/******************************************************************
 * This is an update of the latest status information of oneself  *
 * that one has sent to a neighbour, so as to prevent unnecessary *
 * status messages from being sent                                *
 ******************************************************************/

LdbSentUpdateStatus(peNum)
int peNum;
{
  int i;
  
  if (peNum >=0)
    {
      i = McNeighboursIndex(CmiMyPe(), peNum);
      if (i > -1)
	statusList[i].myLoadSent = QsMyLoad();
    }
}

/**************************************************************
 * Following the sending of chares to a requesting processor, *
 * its status information is locally updated                  *
 **************************************************************/

LdbUpdateStatus(peNum, sent)
     int peNum, sent;
{
  int i;
  
  if (peNum >=0)
    {
      i = McNeighboursIndex(CmiMyPe(), peNum);
      if (i > -1)
	statusList[i].peLoad += sent;
    }
}

/**********************************************************
 * Periodic broadcast of status information to neighbours *
 **********************************************************/

void LdbPeriodicStatus(bocNum)
ChareNumType bocNum;
{
    int i;
    int MyPeLoad;
    ENVELOPE *env; 
    LDB_ELEMENT * ldb;

    MyPeLoad = QsMyLoad();

    for (i=0; i < numNeighbours; i++)
        if( abs(MyPeLoad - statusList[i].myLoadSent) > deltaStatus )
	{
	    env = ENVELOPE_UPTR(statusList[i].statusMsg);
	    SetEnv_destPE(env, neighboursList[i]); 
	    statusList[i].myLoadSent = MyPeLoad;

	    /* fill the LdbBlock with load status */
    	    ldb = LDB_ELEMENT_PTR(env);
	    LdbFillBlock(env);
	    COPY_AND_SEND(env) ;  
	}
    CallBocAfter(LdbPeriodicStatus, LdbBocNum, STATUS_UPDATE_INTERVAL);
}

LdbPrintNodeNeighbours()
{
	int i;

	TRACE(CkPrintf("Node %d: Neighbours: ",CmiMyPe()));
	for (i=0; i < numNeighbours; i++)
		TRACE(CkPrintf("%d, ", neighboursList[i]));
	TRACE(CkPrintf("\n"));
}



/****************************************************************
 * Some Ldb messages are sent across - this defines the actions *
 * to be taken on the arrival of such messages                  *
 ****************************************************************/

LdbProcessMsg(msgPtr, localdataPtr)
void *msgPtr, *localdataPtr;
{
  ENVELOPE    *env;
  LDB_ELEMENT *ldb;
  int idlePE;

  ldb = LDB_UPTR(msgPtr);       
  env = ENVELOPE_UPTR(msgPtr);  

  switch (ldb->type) {

  case WorkRequest:		/* Receives request for work */
    idlePE = ldb->srcPE;	/* give my work to idlePE if I have enough. */
    LdbSendChares(idlePE);
    break;

  case PositiveReply:           /* Reply to request for work */
    MeltMessages(env);		
    break;

  case NegativeReply:           /* Reply to request for work */
  case StatusMsg :              /* Initial status messages   */
     break;                     /* No action - all work done in stripmsg */

  default:
    CkPrintf("*** ERROR *** Ldb strategy received unknown ldb type (ID=%d).\n",
	     ldb->type);
  }
  CkFreeMsg(msgPtr);		/* After processing the message, free it.*/
}

LdbAddSysBocEps()
{
   EpTable[LdbNbrStatus_EP] = LdbProcessMsg;
}

/***********************************************************
 * Respond to request for chares, send chares if possible, *
 * else send a negative reply                              *
 ***********************************************************/

LdbSendChares(idlePE)
     int idlePE;
{
  ENVELOPE * env;
  LDB_ELEMENT * ldb;
  int can_send, actually_sent, myLoad, did_send;
  
  myLoad = QsMyLoad();

  /* How many chares can I send ? */
  if (myLoad >= SendThresh)
    can_send =  ceil2((float)(myLoad - LowThresh)/FanFactor);
  else
    can_send = 0;
  
  if(can_send)
    {
      did_send = SendSomeFreeChares(idlePE, FALSE, can_send, &actually_sent);
      LdbUpdateStatus(idlePE,actually_sent);
    }
  if(can_send == 0 || did_send == 0)
    LdbNegReply(idlePE);
}

LdbNegReply(pe)
int pe;
{
  void *msg;
  LDB_ELEMENT *ldb;		

  msg = (void *)CkAllocMsg(sizeof(int),0); 

  ldb = LDB_UPTR(msg);
  ldb->type   = NegativeReply;	
  GeneralSendMsgBranch(LdbNbrStatus_EP,msg,pe,IMMEDIATEcat, LdbMsg, LdbBocNum);
}

/* ###If a processor is idle, do the same as a lowcheck with no repeat */

LdbProcessorIdle()
{
}


void LdbPeriodicLowCheck_norepeat()
{
  int load = QsMyLoad();           /* Is this right ? */
  int j, i;
  int mynum = CmiMyPe();
  
  if(load < LowThresh)
    for( i = 0; i < numNeighbours; i++)
      if(statusList[i].peLoad >= SendThresh)
	{
	  j = neighboursList[i];
	  LdbSendRequest(j);
	}
}

void LdbPeriodicLowCheck()
{
  LdbPeriodicLowCheck_norepeat();
  CallBocAfter(LdbPeriodicLowCheck, LdbBocNum, WORKCHECK_INTERVAL);
}

LdbSendRequest(pe)
int pe;
{
  void *msg;
  LDB_ELEMENT *ldb;		

  msg = (void *)CkAllocMsg(sizeof(int),0); 

  ldb = LDB_UPTR(msg);
  ldb->type   = WorkRequest;	
  GeneralSendMsgBranch(LdbNbrStatus_EP,msg,pe,IMMEDIATEcat, LdbMsg, LdbBocNum);
}

/************************************************************
 * These are the functions that are called periodically for *
 * Load balancing purposes                                  *
 ************************************************************/
LdbPeriodicCheckInit()
{
    if (numPe > 1)
    {  
	CallBocAfter(LdbPeriodicStatus, LdbBocNum, STATUS_UPDATE_INTERVAL); 
	CallBocAfter(LdbPeriodicLowCheck,LdbBocNum, WORKCHECK_INTERVAL);
    }
}


/****************************************************************
 * Send a message containing chares to the requesting processor *
 ****************************************************************/

SendSomeFreeChares(pe, fixed, NofChares,NofSent)
int pe, NofChares, *NofSent;
BOOLEAN fixed;
{	
  ENVELOPE *env;
  LDB_ELEMENT *ldb;	
  ENVELOPE *multEnv;	
  ENVELOPE_PTR *env_ptr;
  int   j,  num_done;	
  int TotalMessageSize;	

  num_done    = 0;	

  env_ptr = (ENVELOPE_PTR *) CkAlloc(sizeof(ENVELOPE_PTR)*NofChares); 
                        
  TotalMessageSize = 0;	
  
  for (j = 0 ; j < NofChares ; j++) { 
    QsPickFreeChare(&env);     
    if (env)   /* Pick as many of the needed chares as possible from queue */
      {
	num_done++;		
	SetEnv_destPE(env, pe); 
	SetEnv_destPeFixed(env, fixed);
	TotalMessageSize += TotalMsgSize(env);
	env_ptr[j] = env;	
      }
    else break;		
  }
  
  TRACE(CkPrintf("Req# =%3d, Actual# =%3d to pack (from PE#%3d =>PE#%3d)\n",
		 NofChares, num_done, CmiMyPe(),pe));
  
  *NofSent = num_done;
  
  if(num_done == 1)
    LdbSendAChare(pe, env_ptr[0]);
  else 
    if(num_done > 1)
      {
	PackMultipleMsgs(num_done,TotalMessageSize,env_ptr,&multEnv);
	TRACE(CkPrintf("env_ptr=%8d\n",env_ptr));
	ldb = LDB_ELEMENT_PTR(multEnv);   
	ldb->type = PositiveReply;              
	GeneralSendMsgBranch(LdbNbrStatus_EP, USER_MSG_PTR(multEnv), 
			     pe, IMMEDIATEcat, LdbMsg, LdbBocNum);
      }
  if (env_ptr) 
    CkFree(env_ptr);  
  return num_done;
}

/* Special case of a single chare to be sent - no packing need be done - just
   send the chare across */

LdbSendAChare(idlePE, env)
     int idlePE;
     ENVELOPE *env;
{
  SetEnv_destPE(env, idlePE);
  SetEnv_destPeFixed(env, FALSE);
  LdbSentUpdateStatus(idlePE); 
  CkSend(idlePE, TotalMsgSize(env), env);
}

/* If several chares are to be sent across, pack the envelopes into a message
   and send the message across */

PackMultipleMsgs(NoOfEnvs, Size, env_table, multEnv)
int NoOfEnvs, Size;
ENVELOPE_PTR *env_table;
ENVELOPE **multEnv;
{
  int TotalMessageSize;
  void *msg;
  int i,j;
  char *tmp_source, *tmp_dest_char, *debug;
  int *tmp_dest_int;
  ENVELOPE *env;

  TotalMessageSize = sizeof(int)*2 + sizeof(int)*NoOfEnvs + Size;
  /*                Size, number,  size of each,           total size */
  msg = (void *)CkAllocMsg(TotalMessageSize,0); 
  tmp_dest_int = (int *) msg;
  
  *tmp_dest_int = TotalMessageSize; 
  tmp_dest_int++;
  
  *tmp_dest_int = NoOfEnvs;
  tmp_dest_int++;
  
  tmp_dest_char = (char *)tmp_dest_int; 
  
  for (i = 0; i < NoOfEnvs; i++){
    env = env_table[i];

    /* Set header part here (length of one envelope)  */
    tmp_dest_int = (int *) tmp_dest_char;

    *tmp_dest_int= TotalMsgSize(env);
    tmp_dest_int++;

    tmp_dest_char= (char *) tmp_dest_int;

    tmp_source = (char *) env;
    memcpy(tmp_dest_char,tmp_source,TotalMsgSize(env));
    tmp_dest_char += TotalMsgSize(env); 
    CkFree(env);		
  } 
  *multEnv = ENVELOPE_UPTR(msg);   /* Finally, set ENVELOPE ptr to *multEnv */
}

/* Get individual chares out of the message and enqueue them in the local 
   queue */

MeltMessages(env)
ENVELOPE *env;
{
	int msgType;
	ENVELOPE *sub_env;
	void     *msg;
	char     *packets,*packetHead;
	int      numberPackets, packetLength, i;
	void     *packetBody;
	int *tmp_int;
	int      packetID, PE;

	packets = USER_MSG_PTR(env);
	packetLength  = * ((int *) packets) ;
	packetID      = (packetLength >> 16) & 0xff;   /* ?? */
	PE            = (packetLength >> 24) & 0xff;   /* ?? */

	numberPackets = * ((int *) packets + 1);
	packetHead    = (char *) ((int *) packets + 2);

	for (i = 0; i < numberPackets; i++) {
	  tmp_int = (int *) packetHead;
	  packetLength = *tmp_int;
	  packetHead =  (char *) (tmp_int + 1);  /* Points after the length */

	  packetBody   = (void *) CkAlloc(packetLength);
	  memcpy((char *) packetBody, packetHead, packetLength);

	  /* Reset processor dependent pointer part */
	  sub_env = (ENVELOPE *)packetBody; 
	  packetHead += packetLength;       
	  QsEnqMsg(sub_env);		    
	}
/*	CkFree(env);  */ /* After extracting is completed, free */
}



