/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: ldb.h,v $
 *	$Author: brunner $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1994/11/11 05:23:55 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: ldb.h,v $
 * Revision 1.2  1994/11/11  05:23:55  brunner
 * Removed ident added by accident with RCS header
 *
 * Revision 1.1  1994/11/07  15:39:03  brunner
 * Initial revision
 *
 ***************************************************************************/
typedef struct {
	int piggybackLoad;
	int type;
	int srcPE;
} LDB_ELEMENT;

#define WorkRequest    0
#define PositiveReply  1
#define NegativeReply -1
#define StatusMsg      2

#define ceil2(x) ((x != (int) x) ? (int) (x+1) : (int)x )

/************ Thresholds and Fan factor **********/

#define LowThresh   2
#define SendThresh  3
#define FF(numNeigh) ceil2(numNeigh/2.0)  /* Function to determine FanFactor */

int LDB_ELEM_SIZE = sizeof(LDB_ELEMENT);

typedef struct message1 {
    int dummy;
} DUMMY_MSG;

typedef struct message2 {
    int dummy;
} STATUS_MSG;

typedef struct data_manager_ldb {
    int dummy;
} DATA_MNGR_LDB;

typedef struct data_branch_ldb {
    int dummy;
} DATA_BR_LDB;


typedef struct ldb_status {
	int	peLoad;
	int myLoadSent;
	DUMMY_MSG *statusMsg;
} LDB_STATUS;


#define MAXINT  0xffff
#define DELTALOAD 1
#define DELTASTATUS 3
#define STATUS_UPDATE_INTERVAL  50
#define WORKCHECK_INTERVAL  50

int	numNeighbours;
int	numPe;
int * neighboursList;
LDB_STATUS * statusList;

int neighbourhoodLoad;
int deltaLoad;
int deltaStatus;
BOOLEAN	saturated; /* is the system (estimated to be) saturated? 1:0 */


typedef ENVELOPE *ENVELOPE_PTR; /* Jan 3 '94 Furuichi */

int   NeedLdbStripMsg = 1;




