/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: node_ldb.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.7 $	$Date: 1995/04/23 20:45:16 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: node_ldb.c,v $
 * Revision 1.7  1995/04/23  20:45:16  sanjeev
 * Removed couple of SetCore....
 *
 * Revision 1.6  1995/04/13  20:55:57  sanjeev
 * Changed Mc to Cmi
 *
 * Revision 1.5  1995/03/25  18:24:37  sanjeev
 * *** empty log message ***
 *
 * Revision 1.4  1995/03/24  16:42:12  sanjeev
 * *** empty log message ***
 *
 * Revision 1.3  1995/03/17  23:37:16  sanjeev
 * changes for better message format
 *
 * Revision 1.2  1994/12/02  00:00:29  sanjeev
 * interop stuff
 *
 * Revision 1.1  1994/11/03  17:39:16  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /home/kale/milind/RCS/node_ldb.c,v 1.7 1995/04/23 20:45:16 sanjeev Exp $";
#include "const.h"
#include "chare.h"
#include "stat.h"
#include "ldb.h"
#include "node.globals.h"


LdbBocInit()
{
    BOC_BLOCK *bocBlock;

    bocBlock = (BOC_BLOCK *) CreateBocBlock(sizeof(DATA_BR_LDB));
    TRACE(CkPrintf("Node %d: LdbBocInit:created block with size %d\n", 
			CmiMyPe(), sizeof(DATA_BR_LDB)));
    bocBlock->boc_num = LdbBocNum;
    SetBocDataPtr(LdbBocNum, (void *) (bocBlock + 1));
    TRACE(CkPrintf("Node %d: LdbBocInit: BocDataTbl entry filled.\n",CmiMyPe()));

    LdbInit();
    StatInit();
    srand(CmiMyPe());
}

LdbSentUpdateStatus(pe)
int pe;
{
}

LdbPeriodicCheckInit()
{
}


LdbProcessMsg(msgPtr, localdataPtr)
void *msgPtr, *localdataPtr;
{
	CkFreeMsg(msgPtr);
}


/* LDB Branch Office Chare Functions */

LdbInit()
{
	int i;

	TRACE(CkPrintf("Enter Node LdbInit()\n"));

	numPe = CmiNumPe();
	numNeighbours = McNumNeighbours(CmiMyPe());

	TRACE(CkPrintf("Node LdbInit() Done: numPe %d, numNeighbours %d\n",
		numPe, numNeighbours));
}


/* Load Balance messages received at the Node from the Network */
LdbStripMsg(env)
ENVELOPE * env;
{
}


Ldb_NewChare_FromNet(x)
ENVELOPE *x;
{
    CmiSetHandler(x,CallProcessMsg_Index) ;
    CqsEnQueue(SchedQueue,x);
}


Ldb_NewChare_FromLocal(x)
ENVELOPE *x;
{
	LdbStrategy(x);
}

/* This performs the RANDOM strategy for Load Balancing */
LdbStrategy(env)
ENVELOPE * env;
{
    int pe = rand() % CmiNumPe();

    SetEnv_destPE(env, pe);
    if (pe == CmiMyPe()) {
        CmiSetHandler(env,CallProcessMsg_Index) ;
    	CqsEnQueue(SchedQueue,env);
    }
    else
        CkSend(pe, TotalMsgSize(env), env); 
}



LdbFillBlock(env)
ENVELOPE *env;
{
}


LdbRecvUpdateStatus(ldb)
void * ldb;
{
}


LdbPrintNodeNeighbours()
{
	int i;

	TRACE(CkPrintf("Node %d: Neighbours: ",CmiMyPe()));
	for (i=0; i < numNeighbours; i++)
		TRACE(CkPrintf("%d, ", neighboursList[i]));
	TRACE(CkPrintf("\n"));
}


LdbAddSysBocEps()
{
   EpTable[LdbNbrStatus_EP] = LdbProcessMsg;
}


LdbProcessorIdle()
{
}
