/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: node_ldb.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/04/14 07:08:54 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: node_ldb.c,v $
 * Revision 1.3  1995/04/14  07:08:54  milind
 * Mc --> Cmi
 *
 * Revision 1.2  1994/12/02  00:00:27  sanjeev
 * interop stuff
 *
 * Revision 1.1  1994/11/03  17:39:19  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /home/kale/milind/RCS/node_ldb.c,v 1.3 1995/04/14 07:08:54 milind Exp $";
#include "const.h"
#include "chare.h"
#include "stat.h"
#include "ldb.h"
#include "node.globals.h"

#define TRACE(p)
#define TRACEP(p)
#define MAXINITCHARES 500
static int lastPeZeroLoadIndex = 0;
static int lastPeLowestPriorityIndex = 0;
static int chareCount;

extern PVECTOR *QsMyPriority();
extern PVECTOR *QsMySecondPriority();

void LdbPeriodicRedist();
void LdbPeriodicStatus();

LdbBocInit()
{
    BOC_BLOCK *bocBlock;

    bocBlock = (BOC_BLOCK *) CreateBocBlock(sizeof(DATA_BR_LDB));
    TRACE(CkPrintf("Node %d: LdbBocInit:created block with size %d\n",CmiMyPe(), sizeof(DATA_BR_LDB)));
    bocBlock->boc_num = LdbBocNum;
    SetBocDataPtr(LdbBocNum, (void *) (bocBlock + 1));
	
    TRACE(CkPrintf("Node %d: LdbBocInit: BocDataTbl entry filled.\n",CmiMyPe()));

    LdbInit();
    StatInit();
}


LdbPeriodicCheckInit()
{
    if (numPe > 1)
    {  
    	CallBocAfter(LdbPeriodicRedist, LdbBocNum, REDIST_UPDATE_INTERVAL);
	CallBocAfter(LdbPeriodicStatus, LdbBocNum, STATUS_UPDATE_INTERVAL);
    }
}


NeighbourStatus(msgPtr, localdataPtr)
void *msgPtr, *localdataPtr;
{
    DUMMY_MSG *statusMsg = (DUMMY_MSG *) msgPtr;
    LDB_ELEMENT *ldb;

    ldb = LDB_UPTR(statusMsg);
    LdbRecvUpdateStatus(ldb);
}


/* LDB Branch Office Chare Functions */

LdbInit()
{
	int i;
	ENVELOPE *env;
	LDB_ELEMENT *ldb;

	TRACE(CkPrintf("Enter Node LdbInit()\n"));

	numPe = CmiNumPe();
	numNeighbours = McNumNeighbours(CmiMyPe());
	chareCount = 0;

	if (numPe > 1)
	{
	    neighboursList = (int *) CkAlloc( (numNeighbours+1) * sizeof(int) );
            CkMemError(neighboursList);
	    McGetNodeNeighbours(CmiMyPe(), neighboursList );
	    neighboursList[numNeighbours] = CmiMyPe();
	    statusList = (LDB_STATUS *) CkAlloc(numNeighbours * sizeof(LDB_STATUS)); 
            CkMemError(statusList);
	    LdbPrintNodeNeighbours();

	    for (i=0; i < numNeighbours; i++)
	    {
		int j;
		PVECTOR *prio;

		prio = LOWESTPRIORITY;
		for (j=0; j < 8; j++, prio++)
		    *prio = 0xf0fff000;

	        statusList[i].peLoad = 0;
	        statusList[i].myLoadSent = 0;
	        statusList[i].timeLoadSent = 0;

		/* Allocate status msgs and initialze */
	        statusList[i].statusMsg = (DUMMY_MSG *) CkAllocMsg(sizeof(DUMMY_MSG));
                CkMemError(statusList[i].statusMsg);
	        env = ENVELOPE_UPTR(statusList[i].statusMsg);
	        env->destPE = 0;
    	        env->category = IMMEDIATEcat;
    	        env->msgType = LdbMsg;
    	        env->destPeFixed = TRUE;
    
#define CONTENT1 env->sysMsg.bocMsg
    	        CONTENT1.forBoc.chare_boc.boc_num = LdbBocNum;
    	        CONTENT1.EP = LdbNbrStatus_EP;

	        statusList[i].myLoadSent = 0;
		prio = (statusList[i].myPrioritySent);
	        PGEN_COPY_VECTOR(LOWESTPRIORITY, prio);

	        /* fill the LdbBlock with load status */
    	        ldb = LDB_ELEMENT_PTR(env);
    	        ldb->srcPE = CmiMyPe();
    	        ldb->msgHops = 100;
    	        ldb->piggybackLoad = 0;

		prio = ldb->piggybackPriority;
	        PGEN_COPY_VECTOR(LOWESTPRIORITY, prio);
	    }

	    lowestPriorityPe = neighboursList[0];
	    PGEN_COPY_VECTOR(LOWESTPRIORITY, lowestPriority);
	    leastLoadedPe = neighboursList[0];
	    leastLoad = MAXINT;
	    minHops = MINHOPS;
	    maxHops = MAXHOPS;
	    saturated = FALSE;


	    /* send Initial Status update msgs to all neighbours */
	    for (i=0; i < numNeighbours; i++)
	    {
		int j;
		PVECTOR *prio;

	    	env = ENVELOPE_UPTR(statusList[i].statusMsg);
	    	env->destPE = neighboursList[i]; 
	    	statusList[i].myLoadSent = 0;

		prio = (statusList[i].myPrioritySent);
	        PGEN_COPY_VECTOR(LOWESTPRIORITY, prio);

	    	/* fill the LdbBlock with load status */
    	    	ldb = LDB_ELEMENT_PTR(env);
    	    	ldb->piggybackLoad = 0;

		prio = ldb->piggybackPriority;
	        PGEN_COPY_VECTOR(LOWESTPRIORITY, prio);

	    	CmiAsyncSend(env->destPE, TotalMsgSize(env), env, &(statusList[i].statusMsgID));
	    }

	}
	else /* for a single processor */
	{
	    neighboursList = NULL;
	    statusList = NULL;
	}

	TRACE(CkPrintf("Node LdbInit() Done: numPe %d, numNeighbours %d\n",
		numPe, numNeighbours));
}


/* Load Balance messages received at the Node from the Network */
LdbStripMsg(env)
ENVELOPE * env;
{
    LDB_ELEMENT *ldb;

    ldb = LDB_ELEMENT_PTR(env);
    if ((numPe > 1) && (ldb->srcPE != CmiMyPe())
        &&  (ldb->srcPE != CmiNumPe()))
	LdbRecvUpdateStatus(ldb);
    ldb->srcpe = CmiMyPe();
    ldb->msghops++;
}


Ldb_NewChare_FromNet(x)
ENVELOPE *x;
{
	LdbStrategy(x);
}


Ldb_NewChare_FromLocal(x)
ENVELOPE *x;
{
	LdbStrategy(x);
}

/* Performs the NEIGHBOUR ROUND-ROBIN OR RANDOM strategy for Load Balancing */
LdbStrategy(env)
ENVELOPE * env;
{
    LDB_ELEMENT *ldb;
    int peNum, random_index;

    ldb = LDB_ELEMENT_PTR(env);

    /* Generate a random neighbour index for neighboursList */
    /*
    random_index = rand() % (numNeighbours+1);
    peNum = neighboursList[random_index];
    env->destPE = peNum;
    */

    chareCount++;
    random_index = chareCount % (numNeighbours+1);
    peNum = neighboursList[random_index];
    env->destPE = peNum;

    if (peNum == CmiMyPe())
    {
	QsEnqMsg(env);
    }
    else
    {
    	LdbFillBlock(env);
	LdbSentUpdateStatus(env->destPE);
	CkSend(env->destPE, TotalMsgSize(env), env);
    }
}


LdbFillBlock(env)
ENVELOPE *env;
{
    int j;
    LDB_ELEMENT * ldb;
    PVECTOR *prio, *myPrio;

    ldb = LDB_ELEMENT_PTR(env);
    ldb->srcPE = CmiMyPe();
    ldb->msgHops = 0;
    ldb->piggybackLoad = QsMyLoad();

    /* Init piggyback priority vector */
    for (prio=ldb->piggybackPriority,j=0; j < 8; j++,prio++)
	*prio = 0;
    prio = ldb->piggybackPriority;
    myPrio = QsMyPriority();
    for (j=0; j < 8; j++,myPrio++,prio++)
	*prio = *myPrio;
    TRACE(CkPrintf("LdbFillBlock(): *QsMyPriority %o, ldb->piggbackPriority %o\n", *(QsMyPriority()), *(ldb->piggybackPriority)));
    LdbSentUpdateStatus(GetEnv_destPE(env));
}


LdbRecvUpdateStatus(ldb)
LDB_ELEMENT * ldb;
{
    int i,j;
    PVECTOR *prio, *recvPrio;

    i = McNeighboursIndex(CmiMyPe(), ldb->srcPE);
    if (i > -1)
    {
        statusList[i].peLoad = ldb->piggybackLoad;
	/*
        if ( statusList[i].peLoad < leastLoad)
	{
	    leastLoad = statusList[i].peLoad;
	    leastLoadedPe = neighboursList[i]; 
	}
	*/

	/* Init priority vector */
	for (prio=statusList[i].pePriority,j=0; j < 8; j++,prio++)
	    *prio = 0;
	prio = statusList[i].pePriority;
	recvPrio = ldb->piggybackPriority;
        for (j=0; j < 8; j++,prio++,recvPrio++)
	     *prio = *recvPrio;
    TRACE(CkPrintf("LdbRecvUpdate(): *ldb->piggybackPriority %o, *statusList[i].pePriority %o\n", *(ldb->piggybackPriority), *(statusList[i].pePriority)));

    TRACE(CkPrintf("LdbRecvUpdate():Before Greater *lowestPriority %o, *statusList[i].pePriority %o\n", *lowestPriority, *(statusList[i].pePriority)));
        if ( GreaterThan(statusList[i].pePriority, lowestPriority) )
	{
	    for (j=0; j < 8; j++)
                lowestPriority[j] = statusList[i].pePriority[j];
	    lowestPriorityPe = neighboursList[i]; 
	}
    TRACE(CkPrintf("LdbRecvUpdate():After Greater *lowestPriority %o, *statusList[i].pePriority %o\n", *lowestPriority, *(statusList[i].pePriority)));

    }
}


LdbSentUpdateStatus(peNum)
int peNum;
{
    int i,j;
    PVECTOR *prio, *myPrio;

    i = McNeighboursIndex(CmiMyPe(), peNum);
    if (i > -1)
    {
	 statusList[i].myLoadSent = QsMyLoad();
	 /*statusList[i].timeLoadSent = McTimer();*/

	 /* Init priority vector */
	 for (prio=(statusList[i].myPrioritySent),j=0; j < 8; j++,prio++)
	     *prio = 0;
	 prio = (statusList[i].myPrioritySent);
    	 myPrio = QsMyPriority();
         for (j=0; j < 8; j++,myPrio++,prio++)
	     *prio = *myPrio;
    TRACE(CkPrintf("LdbSentUpdateStatus(): *QsMyPriority %o, status[i].myPrioritySent %o\n", *(QsMyPriority()), *(statusList[i].myPrioritySent) ));
    }
}


LdbLowestPriorityPe()
{
    int i,j;

    for (i=0; i < numNeighbours; i++)
        if ( GreaterThan((statusList[i].pePriority), lowestPriority) )
	{
    TRACEP(CkPrintf("LdbLowestPriorityPe(): i %d, PE %d, *lowestPriority %o, *statusList[i].pePriority %o\n", i, neighboursList[i], *lowestPriority, *(statusList[i].pePriority)));

	    for (j=0; j < 8; j++)
                lowestPriority[j] = statusList[i].pePriority[j];
	    lowestPriorityPe = neighboursList[i]; 
	}

    /* RoundRobin selection of a Neighbour if lowestPriority = LOWESTPRIORITY*/
    if (*lowestPriority == 0xf0fff000)
    {
	lastPeLowestPriorityIndex++;
	lastPeLowestPriorityIndex = lastPeLowestPriorityIndex % numNeighbours;
	lowestPriorityPe = neighboursList[lastPeLowestPriorityIndex]; 
    }
    TRACE(CkPrintf("LdbLowestPriorityPe(): lowestPrioPe %d, *lowestPriority %o\n", lowestPriorityPe, *lowestPriority));
}


LdbLeastLoadPe()
{
    int i;

    /* get leastloaded PE and the least Load */
    for (i=0; i < numNeighbours; i++)
        if ( statusList[i].peLoad < leastLoad)
	{
	    leastLoad = statusList[i].peLoad;
	    leastLoadedPe = neighboursList[i]; 
	}

    /* RoundRobin selection of a Neighbour if leastLoad == 0 */
    if (leastLoad == 0)
    {
	lastPeZeroLoadIndex = (lastPeZeroLoadIndex + 1) % numNeighbours;
	leastLoadedPe = neighboursList[lastPeZeroLoadIndex]; 
    }

}


void LdbPeriodicRedist(bocNum)
ChareNumType bocNum;
{
    int i,j;
    int MyPeLoad;
    ENVELOPE *env;
    PVECTOR *prio, *lowestPrio, *MyPriority;
    LDB_ELEMENT * ldb;

  if (chareCount > MAXINITCHARES)
  {
    NUM_REDIST_CALLS();

    MyPeLoad = QsMyLoad();
    MyPriority = QsMySecondPriority();
    /*leastLoad = MAXINT;
    LdbLeastLoadPe();*/
    lowestPrio = LOWESTPRIORITY;
    prio = lowestPriority;
    for (j=0; j < 8; j++,lowestPrio++,prio++)
	*prio = *lowestPrio;
    LdbLowestPriorityPe();

    if ( GreaterThan(lowestPriority, MyPriority) )
    {
	QsPickSecondFreeChare(&env);
	if (env)
	{
	    env->destPE = lowestPriorityPe;
	    env->destPeFixed = FALSE;
    	    LdbFillBlock(env);
    	    ldb = LDB_ELEMENT_PTR(env);
	    ldb->msgHops = 2;
	    LdbSentUpdateStatus(env->destPE);

TRACEP(CkPrintf("REDIST CHARE: TO DestPE %d: *MySecondPriority %o, *lowestPriority %o, \n", lowestPriorityPe, *MyPriority, *lowestPriority));

	    CkSend(env->destPE, TotalMsgSize(env), env);
	}
    }
  }

    /* call LdbPeriodicRedist() AGAIN after REDIST_UPDATE_INTERVAL time */
    CallBocAfter(LdbPeriodicRedist, LdbBocNum, REDIST_UPDATE_INTERVAL);
}


void LdbPeriodicStatus(bocNum)
ChareNumType bocNum;
{
    int i, j;
    int MyPeLoad;
    ENVELOPE *env;
    DUMMY_MSG *statusMsg;
    LDB_ELEMENT * ldb;
    PVECTOR *prio, *myPrio, *MyPriority;

  /*if (chareCount > MAXINITCHARES)*/
  {
    NUM_STATUS_CALLS();
    MyPeLoad = QsMyLoad();
    MyPriority = QsMyPriority();

    for (i=0; i < numNeighbours; i++)
        if ( NotEqual(MyPriority, (statusList[i].myPrioritySent) ) )
	{
	  if (AsyncMessageSent(statusList[i].statusMsgID))
	  {
	    env = ENVELOPE_UPTR(statusList[i].statusMsg);
	    env->destPE = neighboursList[i]; 
	    statusList[i].myLoadSent = MyPeLoad;

	    /* Init myPrioritySent priority vector */
	    for (prio=(statusList[i].myPrioritySent),j=0; j < 8; j++,prio++)
	        *prio = 0;
	    prio = (statusList[i].myPrioritySent);
	    myPrio = MyPriority;
	    for (j=0; j < 8; j++,prio++,myPrio++)
	        *prio = *myPrio;

	    /* fill the LdbBlock with load and Priority status */
    	    ldb = LDB_ELEMENT_PTR(env);
    	    ldb->piggybackLoad = MyPeLoad;

    	    /* Init piggyback priority vector */
    	    for (prio=(ldb->piggybackPriority),j=0; j < 8; j++,prio++)
		*prio = 0;
    	    prio = ldb->piggybackPriority;
	    myPrio = MyPriority;
	    for (j=0; j < 8; j++,prio++,myPrio++)
	        *prio = *myPrio;

TRACE(CkPrintf("SEND STATUS: TO DestPE %d: *MyPriority %o, *myPrioritySent %o\n", env->destPE, *MyPriority, *(statusList[i].myPrioritySent)));

	    CmiAsyncSend(env->destPE, TotalMsgSize(env), env, &(statusList[i].statusMsgID));
	  }
	}
  }

    /* call LdbPeriodicStatus() AGAIN after STATUS_UPDATE_INTERVAL time */
    CallBocAfter(LdbPeriodicStatus, LdbBocNum, STATUS_UPDATE_INTERVAL);
}



LdbPrintNodeNeighbours()
{
	int i;

	TRACE(CkPrintf("Node %d: Neighbours: ",CmiMyPe()));
	for (i=0; i < numNeighbours; i++)
		TRACE(CkPrintf("%d, ", neighboursList[i]));
	TRACE(CkPrintf("\n"));
}


LdbNodeAddSysBocEps()
{
   EpTable[LdbNbrStatus_EP] = NeighbourStatus;
}

/************************************************************************/
/* Each node fills in its local ldb statistics into the defined ldb 	*/
/* statistics data type. The LDB_STATS_DATA_TYPE and the variable	*/
/* Ldb_Stats_Data_Size = sizeof(LDB_STATS_DATA_TYPE) are defined in the	*/
/* file ldb.h for this load balancing module.				*/
/************************************************************************/

Ldb_Fill_Stats_Data(data)
LDB_STATS_DATA_TYPE *data;
{
}


/************************************************************************/
/* This is called from node 0, and initializes the data structure that	*/
/* is used to keep track of the statistics from all the nodes.		*/
/************************************************************************/

Ldb_Init_Stats_Data_Area()
{
}


/************************************************************************/
/* When a node receives a statistics message from another node, it uses	*/
/* this function to extract the ldb statistics related information.	*/
/************************************************************************/

Ldb_Extract_Stats_Data(srcpe, data)
PeNumType srcpe;
LDB_STATS_DATA_TYPE *data;
{
}


/************************************************************************/
/* This function is called by node 0, when the statistics messages from	*/
/* all the nodes have been received, and this function will then print	*/
/* out the relevant information.					*/ 
/************************************************************************/

Ldb_Print_Stats_Data()
{
/*
	totalChares = 0;
	totalHops = 0;
	CkPrintf("Printing Load Balancing Statistics\n");
	for (k=0; k < CmiNumPe(); k++) {
		totalChares += HostLdbStatistics[k][14];
		totalHops += HostLdbStatistics[k][8];
	}

	for (k=0; k < CmiNumPe(); k++)
	{
		CkPrintf("NODE %d: Ch[I %d,O %d, LDB %d], ForCh[I %d,O %d], NbrSt[C %d,O %d], Redis[C %d,O %d], BOC[I %d,O %d]\n",
		    k, HostLdbStatistics[k][0], HostLdbStatistics[k][1], HostLdbStatistics[k][14], HostLdbStatistics[k][2],
		    HostLdbStatistics[k][3], HostLdbStatistics[k][7], HostLdbStatistics[k][5], HostLdbStatistics[k][6],
		    HostLdbStatistics[k][4], HostLdbStatistics[k][9], HostLdbStatistics[k][10]);
	}
	CkPrintf("\n");

	if (CmiNumPe() > 1)
		CkPrintf("Total Chares Load Balanced %d, Total Hops %d, Average Hops %f\n",
		    totalChares, totalHops, ((float) totalHops)/((float) totalChares));
*/
}



LdbProcessorIdle()
{
}
