/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: node_ldb.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1995/04/14 07:05:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: node_ldb.c,v $
 * Revision 1.5  1995/04/14  07:05:05  milind
 * Mc --> Cmi
 *
 * Revision 1.4  1995/03/25  18:24:43  sanjeev
 * *** empty log message ***
 *
 * Revision 1.3  1994/12/02  00:00:25  sanjeev
 * interop stuff
 *
 * Revision 1.2  1994/11/22  06:00:04  narain
 * Edited get_index to correctly return the index of the other manager in the
 * multiple manager case. Also corrected LdbStripMsg to call LdbRecv.. only
 * on controllers..
 *
 * Narain
 *
 * Revision 1.1  1994/11/03  17:39:21  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /home/kale/milind/RCS/node_ldb.c,v 1.5 1995/04/14 07:05:05 milind Exp $";
#include <math.h>
#include "chare.h"
#include "stat.h"
#include "ldb.h"
#include "node.globals.h"

#define  CONTROLLER(pe)  (((pe + 1)%CLUSTER_SIZE == 0) || ((pe + 1 ) == numPe))

void *LdbFreeChareQueue;

void LdbPeriodicRedist();
void LdbPeriodicKidsRedist();
void LdbPeriodicBossesRedist();

void LdbPeriodicStatus();
void LdbPeriodicKidStatus();
void LdbPeriodicBossStatus();

flipi(n, i)
unsigned int n, i;
{
	n /= CLUSTER_SIZE;
        return( ((n & (1<<i)) ^ (1<<i)) | (n & ~(1<<i)));
}


increment_load(least_loaded_pe)
int least_loaded_pe;
{
	int index;

	index = get_index(least_loaded_pe);
	if (CONTROLLER(least_loaded_pe))
		load_boss[index] ++;
	else
		load_cluster[index] += 1;
}

get_index(m)
unsigned int m;
{
	int i;
		
	if (CONTROLLER(m))
	{
		int n = CmiMyPe();

		for (i=0; i<exchanges; i++)
			if (m % CLUSTER_SIZE == flipi(n, i))
				return i;
	}
	else
		return (m % CLUSTER_SIZE);
	return -1;
}

do_redistribution(other, other_load)
int other, other_load;
{
	int i;
	int number;
	int SKIP = 1;
	int index = 0;
	ENVELOPE *env;
	int my_load = LdbMyLoad();

	number = 0;
	if (my_load > other_load)
		number = (my_load - other_load)/2;
#ifdef PRIORITY
	number = MAX_EXCHANGES/2;
#endif

TRACE(CkPrintf("[%d] do_redist: my_load=%d, other_load=%d, number = %d\n",
	 CmiMyPe(), my_load, other_load, number));	

	if (number > MAX_EXCHANGES)
		number = MAX_EXCHANGES;
	/*
	while (!LdbEmptyQueue() && index<number)
	{
		for (i=0; i<SKIP; i++)
		{
			LdbPickFreeChare(&env);
			if (env==NULL)
				break;
			else
				store_exchange[index++] = env;
		}
		if (env==NULL)
			break;
		else
			SendFreeChare(other, FALSE);	
	}	
	for (i=0; i<index; i++)
		LdbEnqMsg(store_exchange[i]);
	*/
	for (i=0; i<number; i++)
		SendFreeChare(other, FALSE);
TRACE(CkPrintf("[%d] do_redist: Finish\n", CmiMyPe()));	
}

MyController(x)
int x;
{
	x = x / CLUSTER_SIZE;
	x = (x+1)*CLUSTER_SIZE;
	if (x>numPe-1)
		return numPe-1;
	return x-1;
}


LdbBocInit()
{
	BOC_BLOCK *bocBlock;

	bocBlock = (BOC_BLOCK *) CreateBocBlock(sizeof(DATA_BR_LDB));
	TRACE(CkPrintf("Node %d: LdbBocInit:created block with size %d\n", 
	    CmiMyPe(), sizeof(DATA_BR_LDB)));
	bocBlock->boc_num = LdbBocNum;
	SetBocDataPtr(LdbBocNum, (void *) (bocBlock + 1));
	TRACE(CkPrintf("Node %d: LdbBocInit: BocDataTbl entry filled.\n",CmiMyPe()));

	LdbInit();
	StatInit();
	srand(CmiMyPe());
}

LdbSentUpdateStatus(pe)
int pe;
{
}


LdbPeriodicCheckInit()
{
	if (numPe > 1)
	{
		if (CONTROLLER(CmiMyPe()))
		{
			if (numPe > CLUSTER_SIZE)
				CallBocAfter(LdbPeriodicBossStatus, LdbBocNum, 
		    			BOSS_STATUS_UPDATE_INTERVAL);
			CallBocAfter(LdbPeriodicRedist, LdbBocNum,
		    		BOSS_REDIST_UPDATE_INTERVAL);
		}
		else
			CallBocAfter(LdbPeriodicKidStatus, LdbBocNum, 
		    		KID_STATUS_UPDATE_INTERVAL);
	}
}


LdbProcessMsg(msgPtr, localdataPtr)
void *msgPtr, *localdataPtr;
{
	CkFreeMsg(msgPtr);
}


/* LDB Branch Office Chare Functions */

LdbInit()
{
	int i;
	void *CqsCreate();
	ENVELOPE *env;
	LDB_ELEMENT *ldb;

	TRACE(CkPrintf("Enter Node LdbInit()\n"));

	numPe = CmiNumPe();

	controller = CONTROLLER(CmiMyPe());
	mycontroller = MyController(CmiMyPe());
	if (!controller)
	{
		statusMsg = (DummyMsg *) CkAllocMsg(sizeof(DummyMsg));
		env = (ENVELOPE *) ENVELOPE_UPTR(statusMsg);
		SetEnv_EP(env, LdbNbrStatus_EP);
		SetEnv_destPE(env, mycontroller);
		SetEnv_destPeFixed(env, TRUE);
		SetEnv_category(env, IMMEDIATEcat);
		SetEnv_msgType(env, LdbMsg);

		/* fill the LdbBlock with load status */
		ldb = LDB_ELEMENT_PTR(env);
		ldb->srcPE = CmiMyPe();
	
	}
	else
	{

		LdbFreeChareQueue = CqsCreate();
		for (i=0; i<CLUSTER_SIZE; i++)
			load_cluster[i] = 0;
		if (numPe%CLUSTER_SIZE == 0)
			numBoss = numPe/CLUSTER_SIZE;
		else
			numBoss = numPe/CLUSTER_SIZE + 1;

		if (numBoss > 1)
		{
			exchanges = (int) (log((double) numBoss) /
						 log((double) 2.0));

TRACE(CkPrintf("[%d] Ldbinit: log(numBoss)=%f, log(2.0)=%f, exchanged=%f\n",
		CmiMyPe(), log((double) numBoss), log((double) 2.0),
		log((double) numBoss)/log((double) 2.0)));

TRACE(CkPrintf("[%d] LdbInit: exchanges=%d, numBoss=%d\n",
	CmiMyPe(), exchanges, numBoss));

			for (i=0; i<exchanges; i++)
			{
				int boss_index;
	
				boss_index = flipi(CmiMyPe(), i);
				load_boss[i] = 0;
				nbr_boss[i] = (CLUSTER_SIZE-1) + boss_index*CLUSTER_SIZE;
			}
			for (i=0; i<exchanges; i++)
			{
				boss_statusMsg[i] = (DummyMsg *) CkAllocMsg(sizeof(DummyMsg));
				env = (ENVELOPE *) 
					ENVELOPE_UPTR(boss_statusMsg[i]);
				SetEnv_EP(env, LdbNbrStatus_EP);
				SetEnv_destPE(env, nbr_boss[i]);
				SetEnv_destPeFixed(env, TRUE);
				SetEnv_category(env, IMMEDIATEcat);
				SetEnv_msgType(env, LdbMsg);
	
				/* fill the LdbBlock with load status */
				ldb = LDB_ELEMENT_PTR(env);
				ldb->srcPE = CmiMyPe();
			}
		}
	}
}


/* Load Balance messages received at the Node from the Network */
LdbStripMsg(env)
ENVELOPE * env;
{
	LDB_ELEMENT *ldb;

	ldb = LDB_ELEMENT_PTR(env);

	/*possible Neighbour update status from piggyback info from Node only*/
	if ((numPe > 1) && (ldb->srcPE != CmiMyPe()) 
            &&  (ldb->srcPE != CmiNumPe()) && controller)
		LdbRecvUpdateStatus(ldb, (GetEnv_msgType(env)==LdbMsg));
}


Ldb_NewChare_FromNet(x)
ENVELOPE *x;
{
	if (controller)
		LdbStrategy(x);
	else
	{
		TRACE(CkPrintf("[%d] Ldb_NewChare_Net:: Message from outside. \n",
		    CmiMyPe()));
		QsEnqMsg(x);
	}
}


Ldb_NewChare_FromLocal(x)
ENVELOPE *x;
{
	x->destPE = mycontroller;
	if (controller)
	{
		TRACE(CkPrintf("[%d] Ldb_NewChare_Local:: Queuing up.\n",
		    CmiMyPe()));
		LdbEnqMsg(x);
	}
	else
	{
		TRACE(CkPrintf("[%d] Ldb_NewChare_Local:: Send to control.\n",
		    CmiMyPe()));
		SetEnv_destPeFixed(x, FALSE);
		CkSend(x->destPE, TotalMsgSize(x), x);
	}
}




LdbFillBlock(env)
ENVELOPE *env;
{
	LDB_ELEMENT * ldb;

	ldb = LDB_ELEMENT_PTR(env);
	ldb->srcPE = CmiMyPe();
	if (CONTROLLER(ldb->srcPE))
		ldb->piggybackLoad = LdbMyLoad();
	else	
		ldb->piggybackLoad = QsMyLoad();
}


LdbRecvUpdateStatus(ldb, ldb_type)
LDB_ELEMENT * ldb;
BOOLEAN ldb_type;
{
	int index;

	index = get_index(ldb->srcPE);
	if (CONTROLLER(ldb->srcPE))
	{
		load_boss[index] = ldb->piggybackLoad;
		if (ldb_type)
			do_redistribution(ldb->srcPE, load_boss[index]);
	}
	else
		load_cluster[index] = ldb->piggybackLoad;
}


LdbPrintNodeNeighbours()
{
}


LdbAddSysBocEps()
{
	EpTable[LdbNbrStatus_EP] = LdbProcessMsg;
}


LdbProcessorIdle()
{
}


LdbLeastLoadPe()
{
	int pe;
	int boss;
	int kid_load;
	int kid = LdbLeastLoadKids(&kid_load);

	if (kid==-1)
	 	pe = LdbLeastLoadBosses();
	else
		if (kid_load < MINIMUM_KID_LOAD)
			pe = kid;
		else
		{
			pe = LdbLeastLoadBosses();
			/*
			if (pe == -1)
				pe = kid;
			*/
		}

	return pe;
}

LdbLeastLoadKids(load)
int *load;
{
	int pe;
	int index;
	int min_pe = 0;
	int min = HUGE_INT;
	int start_pe, end_pe;

	end_pe = CmiMyPe();
	start_pe = (end_pe/CLUSTER_SIZE)*CLUSTER_SIZE;
	for (pe=start_pe; pe<end_pe; pe++)
	{
		index = get_index(pe);
		if (load_cluster[index] < min)
		{
			min = load_cluster[index];
			min_pe = pe;
		}
	}
	*load = min;
	if (min < KID_SATURATION)
		return(min_pe);
	return -1;
}


LdbLeastLoadBosses()
{
	int i, j;
	int min_pe;
	int min = HUGE_INT;
	static int start_pe = 0;

	if (numBoss <= 1) return -1;
	for (j=0; j<exchanges; j++)
	{
		i = (start_pe + j) % exchanges;
		if (load_boss[i] < min)
		{
			min = load_boss[i];
			min_pe = nbr_boss[i];
		}
	}
	if (min < BOSS_SATURATION)
	{
		start_pe = min_pe; 
		return min_pe;
	}
	else
		start_pe = 0;
	return -1;
}


LdbMyLoad()
{
	return CqsLength(LdbFreeChareQueue);
}


LdbEmptyQueue()
{
	if (CqsEmpty(LdbFreeChareQueue))
		return TRUE;
	return FALSE;
}




LdbPickFreeChare(Penvelope)
ENVELOPE ** Penvelope;
{

	if ( !CqsEmpty(LdbFreeChareQueue))
		CqsDeQueue(LdbFreeChareQueue,Penvelope);
	else 
		*Penvelope = (ENVELOPE *) NULL;
}




LdbEnqMsg(envelope)
ENVELOPE * envelope;
{
	CqsEnQueue(LdbFreeChareQueue,envelope);

}





void LdbPeriodicStatus(bocNum)
ChareNumType bocNum;
{
}


void LdbPeriodicKidStatus(bocNum)
ChareNumType bocNum;
{
	long status;
	ENVELOPE *env;
	LDB_ELEMENT * ldb;
	int load = QsMyLoad();

	
	/* fill the LdbBlock with load status */
	env = (ENVELOPE *) ENVELOPE_UPTR(statusMsg);
	ldb = LDB_ELEMENT_PTR(env);
	ldb->piggybackLoad = load;

	/* McAsyncSend(GetEnv_destPE(env), TotalMsgSize(env), env, &status); */
	COPY_AND_SEND(env);
	CallBocAfter(LdbPeriodicKidStatus, LdbBocNum,
			KID_STATUS_UPDATE_INTERVAL);
}



void LdbPeriodicBossStatus(bocNum)
ChareNumType bocNum;
{
	long status;
	ENVELOPE *env;
	LDB_ELEMENT * ldb;
	int load = LdbMyLoad();
	static int index = 0;


	/* fill the LdbBlock with load status */
	env = (ENVELOPE *) ENVELOPE_UPTR(boss_statusMsg[index]);
	ldb = LDB_ELEMENT_PTR(env);
	ldb->piggybackLoad = load;

	/* McAsyncSend(GetEnv_destPE(env), TotalMsgSize(env), env, &status); */
	COPY_AND_SEND(env);
	index = (index+1) % exchanges;
	CallBocAfter(LdbPeriodicBossStatus, LdbBocNum, 
	    		BOSS_STATUS_UPDATE_INTERVAL);
}


void LdbPeriodicRedist(bocNum)
ChareNumType bocNum;
{
	/*
	LdbPeriodicBossesRedist(bocNum);
	*/
	LdbPeriodicKidsRedist(bocNum);
	CallBocAfter(LdbPeriodicRedist, LdbBocNum, 
		BOSS_REDIST_UPDATE_INTERVAL);
}


void LdbPeriodicKidsRedist(bocNum)
ChareNumType bocNum;
{
	int i, j;
	int index;
	int picked;
	BOOLEAN done;
	ENVELOPE *env;
	int start_pe, end_pe;

	end_pe = CmiMyPe();
	start_pe = (end_pe/CLUSTER_SIZE) * CLUSTER_SIZE;
	done = FALSE;

	while (!done)
	{
		picked=0;
		for (i=start_pe; i<end_pe; i++)
		{	
			index = get_index(i);
			if (load_cluster[index] < KID_SATURATION)
			{
			   if (SendFreeChare(i, TRUE))
			   {
				picked++;
				load_cluster[index]++;
			   }
			   else
			   {
				done = TRUE;
				break;
			   }
			}
		}
		if (!picked)
			done = TRUE;
	}
}

void LdbPeriodicBossesRedist(bocNum)
ChareNumType bocNum;
{
	int i;

	for (i=0; i<exchanges; i++)
		if (load_boss[i] < BOSS_SATURATION)
			if (SendFreeChare(nbr_boss[i], FALSE))
				load_boss[i]++;
			else
				break;
}



LdbStrategy(x)
ENVELOPE *x;
{
	int load;
	ENVELOPE * env;
	LDB_ELEMENT *ldb;
	int least_loaded_pe;

	ldb = LDB_ELEMENT_PTR(x);
	if (CONTROLLER(ldb->srcPE))
		least_loaded_pe = LdbLeastLoadKids(&load);
	else
		least_loaded_pe = LdbLeastLoadPe();

TRACE(CkPrintf("[%d] LdbStrategy: srcPE=%d, destPE=%d\n",
		CmiMyPe(), ldb->srcPE, least_loaded_pe));

	if (least_loaded_pe >= 0)
	{
#ifdef PRIORITY
		if (LdbEmptyQueue()) 
		{
			x->destPE = least_loaded_pe;
			if (!CONTROLLER(least_loaded_pe))
				SetEnv_destPeFixed(x, TRUE);
			else
				SetEnv_destPeFixed(x, FALSE);
TRACE(CkPrintf("[%d] LdbStrategy: x = 0x%x, size = %d, dest = %d\n",
			    CmiMyPe(), x, TotalMsgSize(x), x->destPE));
			CkSend(x->destPE, TotalMsgSize(x), x);
			increment_load(least_loaded_pe);
		}
		else
#endif
		{
			LdbEnqMsg(x);
			if (SendFreeChare(least_loaded_pe, 
			    !CONTROLLER(least_loaded_pe)))
				increment_load(least_loaded_pe);
		}
	}
	else
		LdbEnqMsg(x);
}


SendFreeChare(pe, fixed)
int pe;
BOOLEAN fixed;
{	
	ENVELOPE *env;

	LdbPickFreeChare(&env);
	if (env)
	{
		SetEnv_destPE(env, pe);
		SetEnv_destPeFixed(env, fixed);
		CkSend(GetEnv_destPE(env), TotalMsgSize(env), env);
		return 1;
   	}	
	return 0;
}
