/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: node_ldb.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.6 $	$Date: 1995/04/23 20:57:18 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: node_ldb.c,v $
 * Revision 1.6  1995/04/23  20:57:18  sanjeev
 * Removed Core....
 *
 * Revision 1.5  1995/04/14  07:12:18  milind
 * Mc --> Cmi
 *
 * Revision 1.4  1995/03/24  05:19:31  brunner
 * Uses converse messages to enqueue tokens for load balancing,
 * but still prints diagnostic messages.  Not entirely tested yet.
 *
 * Revision 1.3  1995/03/23  20:32:10  brunner
 * Works with new language tags, but still expects the system to
 * maintain a separate queue of chares.
 *
 * Revision 1.2  1994/12/02  00:00:10  sanjeev
 * interop stuff
 *
 * Revision 1.1  1994/11/03  17:39:07  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /home/kale/milind/RCS/node_ldb.c,v 1.6 1995/04/23 20:57:18 sanjeev Exp $";
#include "chare.h"
#include "stat.h"
#include "ldb.h"
#include "node.globals.h"

#include <memory.h>

int lastPeZeroLoadIndex = 0;

void LdbPeriodicRedist();
void LdbPeriodicStatus();

void LdbInitTokens();
void LdbEnqueue();
void LdbTokenHandler();
void LdbNullHandler();
ENVELOPE *LdbDequeue();

LdbBocInit()
{
    BOC_BLOCK *bocBlock;

    bocBlock = (BOC_BLOCK *) CreateBocBlock(sizeof(DATA_BR_LDB));
    TRACE(CkPrintf("Node %d: LdbBocInit:created block with size %d\n",CmiMyPe(), sizeof(DATA_BR_LDB)));
    bocBlock->boc_num = LdbBocNum;
    SetBocDataPtr(LdbBocNum, (void *) (bocBlock + 1));
    TRACE(CkPrintf("Node %d: LdbBocInit: BocDataTbl entry filled.\n",CmiMyPe()));

    LdbInit();
    LdbInitTokens();
    StatInit();
}


LdbPeriodicCheckInit()
{
    if (numPe > 1)
    {  
    	CallBocAfter(LdbPeriodicRedist, LdbBocNum, REDIST_UPDATE_INTERVAL);
	CallBocAfter(LdbPeriodicStatus, LdbBocNum, STATUS_UPDATE_INTERVAL); 
    }
}


LdbProcessMsg(msgPtr, localdataPtr)
void *msgPtr, *localdataPtr;
{
	CkFreeMsg(msgPtr);
}


/* LDB Branch Office Chare Functions */

LdbInit()
{
	int i;
	ENVELOPE *env;
	LDB_ELEMENT *ldb;

	TRACE(CkPrintf("Enter Node LdbInit()\n"));

	numPe = CmiNumPe();
	numNeighbours = McNumNeighbours(CmiMyPe());

	if (numPe > 1)
	{
	    neighboursList = (int *) CkAlloc( numNeighbours * sizeof(int) );
            CkMemError(neighboursList);
	    McGetNodeNeighbours(CmiMyPe(), neighboursList );
	    statusList = (LDB_STATUS *) CkAlloc(numNeighbours * sizeof(LDB_STATUS)); 
            CkMemError(statusList);
	    LdbPrintNodeNeighbours();

	    for (i=0; i < numNeighbours; i++)
	    {
	        statusList[i].peLoad = 0;
	        statusList[i].myLoadSent = 0;
	        statusList[i].timeLoadSent = 0;

		/* Allocate status msgs and initialze */
	        statusList[i].statusMsg = (DUMMY_MSG *) CkAllocMsg(sizeof(DUMMY_MSG));
                CkMemError(statusList[i].statusMsg);
	        env = ENVELOPE_UPTR(statusList[i].statusMsg);
	        SetEnv_destPE(env, 0);
    	        SetEnv_category(env, IMMEDIATEcat);
    	        SetEnv_msgType(env, LdbMsg);
    	        SetEnv_destPeFixed(env, TRUE);
    
    	        SetEnv_boc_num(env, LdbBocNum);
    	        SetEnv_EP(env, LdbNbrStatus_EP);

	        statusList[i].myLoadSent = 0;

	        /* fill the LdbBlock with load status */
    	        ldb = LDB_ELEMENT_PTR(env);
    	        ldb->srcPE = CmiMyPe();
    	        ldb->msgHops = 100;
    	        ldb->piggybackLoad =0;

	    }

	    leastLoadedPe = neighboursList[0];
	    leastLoad = MAXINT;
	    neighbourhoodLoad = LIGHT;
	    minHops = MINHOPS;
	    maxHops = MAXHOPS;
	    lowMark = LOWMARK;
	    highMark = HIGHMARK;
	    deltaLoad = DELTALOAD;
	    deltaRedist = DELTAREDIST;
	    deltaStatus = DELTASTATUS;
	    saturated = FALSE;


	    /* send Initial Status update msgs to all neighbours */
	    for (i=0; i < numNeighbours; i++)
	    {
	    	env = ENVELOPE_UPTR(statusList[i].statusMsg);
	    	SetEnv_destPE(env, neighboursList[i]); 
	    	statusList[i].myLoadSent = 0;

	    	/* fill the LdbBlock with load status */
    	    	ldb = LDB_ELEMENT_PTR(env);
    	    	ldb->piggybackLoad = 0;

	    	/* McAsyncSend(GetEnv_destPE(env), TotalMsgSize(env),
			 env, &(statusList[i].statusMsgID));  */
		COPY_AND_SEND(env) ;  
	    }

	}
	else /* for a single processor */
	{
	    neighboursList = NULL;
	    statusList = NULL;
	}

	TRACE(CkPrintf("Node LdbInit() Done: numPe %d, numNeighbours %d\n",
		numPe, numNeighbours));
}


/* Load Balance messages received at the Node from the Network */
LdbStripMsg(env)
ENVELOPE * env;
{
    LDB_ELEMENT *ldb;

    ldb = LDB_ELEMENT_PTR(env);
    if ((numPe > 1) && (ldb->srcPE != CmiMyPe()) 
        &&  (ldb->srcPE != CmiNumPe()))
    		LdbRecvUpdateStatus(ldb);
}


Ldb_NewChare_FromNet(x)
ENVELOPE *x;
{
	LdbStrategy(x);
}


Ldb_NewChare_FromLocal(x)
ENVELOPE *x;
{
    LDB_ELEMENT * ldb;

    ldb = LDB_ELEMENT_PTR(x);
    ldb->msgHops = 0;  /* This stmt and the previous two moved here
 			  on 5/22/93, by Sanjay   */
    LdbStrategy(x);
}

/* 
   This performs the ACWN strategy for Load Balancing.
   Load is balanced only if the number of PEs are > 1.
*/
LdbStrategy(env)
ENVELOPE * env;
{
    LDB_ELEMENT * ldb;
    int MyPeLoad;

    ldb = LDB_ELEMENT_PTR(env);
    ldb->srcPE = CmiMyPe();
    ldb->msgHops++;

    leastLoad = MAXINT;
    LdbLeastLoadPe();
    LdbUpdateMinMaxHops();
    /* Msg MUST travel minimum hops to reduce Horizon effect */
    if (ldb->msgHops < minHops)
    {
    	SetEnv_destPE(env, leastLoadedPe);
	LdbSentUpdateStatus(GetEnv_destPE(env));
	CmiSetHandler(env,HANDLE_INCOMING_MSG_Index);
	CkSend(GetEnv_destPE(env), TotalMsgSize(env), env);
    }
    /* Msg has travelled maxHops, time to enqueue and process it on this node */
    else if (ldb->msgHops >= maxHops)
    {
    	SetEnv_destPE(env, CmiMyPe());

	TRACE(CkPrintf("LdbNodeStrategy:Node %d: Hops>=maxHops(%d), Enqueue Msg 0x%x\n", CmiMyPe(), maxHops, env));

	CmiSetHandler(env,CallProcessMsg_Index);
	QsEnqMsg(env);  /* Not LdbEnqueue(), since it must execute here */
    }
    /* Msg has travelled between minHops and maxHops */
    else /* ( (minHops <= ldb->msgHops) && (ldb->msgHops < maxHops) ) */
    {
	switch (neighbourhoodLoad)
	{
	    /* Lightly loaded neighbourhood: Send it to least loaded PE */
	    case LIGHT:
    		SetEnv_destPE(env, leastLoadedPe);
	    	LdbSentUpdateStatus(GetEnv_destPE(env));
		CmiSetHandler(env,HANDLE_INCOMING_MSG_Index);
		CkSend(GetEnv_destPE(env), TotalMsgSize(env), env);
		break;

	    case MODERATE:
    		MyPeLoad = QsMyLoad();
		if (MyPeLoad - leastLoad > deltaLoad)
		{
	     	    /* Update the load status for the least loaded PE */
    	            SetEnv_destPE(env, leastLoadedPe);
	     	    LdbSentUpdateStatus(GetEnv_destPE(env));
		    CmiSetHandler(env,HANDLE_INCOMING_MSG_Index);
	            CkSend(GetEnv_destPE(env), TotalMsgSize(env), env);
	        }
	        else
	        {
	            SetEnv_destPE(env, CmiMyPe());
		    CmiSetHandler(env,CallProcessMsg_Index);
	            LdbEnqueue(env);
	        }
		break;

    	    /*  Heavily Loaded Neighbourhood:
       	        maxHops = 0, such that NewChares are Enqueued at local PE.  */
	    case HEAVY:
    		SetEnv_destPE(env, CmiMyPe());
		CmiSetHandler(env,CallProcessMsg_Index);
		LdbEnqueue(env);
		break;
	}
    }
}


LdbFillBlock(env)
ENVELOPE *env;
{
    LDB_ELEMENT * ldb;

    ldb = LDB_ELEMENT_PTR(env);
    ldb->srcPE = CmiMyPe();
    ldb->piggybackLoad = QsMyLoad();
    /* ldb->msgHops = 0; shouldn't be here. Moved to NewChare From Local
	on 5/22/93 by Sanjay */
	if (GetEnv_destPE(env) != CmiNumPe())
    	LdbSentUpdateStatus(GetEnv_destPE(env));
}


LdbRecvUpdateStatus(ldb)
LDB_ELEMENT * ldb;
{
    int i;

    i = McNeighboursIndex(CmiMyPe(), ldb->srcPE);
    if (i > -1)
    {
        statusList[i].peLoad = ldb->piggybackLoad;

        if ( statusList[i].peLoad < leastLoad)
	{
	    leastLoad = statusList[i].peLoad;
	    leastLoadedPe = neighboursList[i]; 
	}
    }
}


LdbSentUpdateStatus(peNum)
int peNum;
{
    int i;

    if (peNum >=0)
    {
    	i = McNeighboursIndex(CmiMyPe(), peNum);
    	if (i > -1)
    	{
	 	statusList[i].myLoadSent = QsMyLoad();
	 	/*statusList[i].timeLoadSent = McTimer();*/
    	}
    }
}


LdbLeastLoadPe()
{
    int i;

    /* get leastloaded PE and the least Load */
    for (i=0; i < numNeighbours; i++)
        if ( statusList[i].peLoad < leastLoad)
	{
	    leastLoad = statusList[i].peLoad;
	    leastLoadedPe = neighboursList[i]; 
	}

    /* Random selection of a Neighbour if leastLoad == 0 */
    /*
    if (leastLoad == 0)
    {
    	i = rand() % numNeighbours;
	leastLoadedPe = neighboursList[i]; 
    }
    */

    /* RoundRobin selection of a Neighbour if leastLoad == 0 */
    if (leastLoad == 0)
    {
	lastPeZeroLoadIndex = (lastPeZeroLoadIndex + 1) % numNeighbours;
	leastLoadedPe = neighboursList[lastPeZeroLoadIndex]; 
    }

}


LdbUpdateMinMaxHops()
{
    	if (leastLoad < lowMark)
    	{
		minHops = MINHOPS; maxHops = MAXHOPS;
		neighbourhoodLoad = LIGHT;
    	}
    	else if (leastLoad > highMark)
    	{
		minHops = 0; maxHops = 0;
		neighbourhoodLoad = HEAVY;
    	}
    	else /* (lowMark <= leastLoad && leastLoad <= highMark)*/
    	{
		minHops = 0; maxHops = MAXHOPS;
		neighbourhoodLoad = MODERATE;
    	}
}


void LdbPeriodicRedist(bocNum)
ChareNumType bocNum;
{
    int i;
    int MyPeLoad;
    ENVELOPE *env;


 if (maxHops > 0) /* if Neighbourhood NOT in a HEAVY state */
 {
    MyPeLoad = QsMyLoad();
    leastLoad = MAXINT;
    LdbLeastLoadPe();

    if ( (MyPeLoad - leastLoad) > deltaRedist )
    {
/*
 *	QsPickFreeChare(&env);
 */
        env = LdbDequeue();
	if (env)
	{
	    SetEnv_destPE(env, leastLoadedPe);
	    SetEnv_destPeFixed(env, TRUE); /* want this Msg to be processed destPE*/
	    LdbSentUpdateStatus(GetEnv_destPE(env));

	    CmiSetHandler(env,HANDLE_INCOMING_MSG_Index);
	    CkSend(GetEnv_destPE(env), TotalMsgSize(env), env);
	}
    }
 }

    /* call LdbPeriodicRedist() AGAIN after REDIST_UPDATE_INTERVAL time */
    CallBocAfter(LdbPeriodicRedist, LdbBocNum, REDIST_UPDATE_INTERVAL);
}


void LdbPeriodicStatus(bocNum)
ChareNumType bocNum;
{
    int i;
    int MyPeLoad;
    ENVELOPE *env; 
    LDB_ELEMENT * ldb;

    MyPeLoad = QsMyLoad();

    for (i=0; i < numNeighbours; i++)
        if ( abs(MyPeLoad - statusList[i].myLoadSent) > deltaStatus )
	{
	    env = ENVELOPE_UPTR(statusList[i].statusMsg);
	    SetEnv_destPE(env, neighboursList[i]); 
	    statusList[i].myLoadSent = MyPeLoad;

	    /* fill the LdbBlock with load status */
    	    ldb = LDB_ELEMENT_PTR(env);
    	    ldb->piggybackLoad = MyPeLoad;

	     /*  McAsyncSend(GetEnv_destPE(env), TotalMsgSize(env),
			 env, &(statusList[i].statusMsgID));  */
	    COPY_AND_SEND(env) ;  
	}

    /* call LdbPeriodicStatus() AGAIN after STATUS_UPDATE_INTERVAL time */
    CallBocAfter(LdbPeriodicStatus, LdbBocNum, STATUS_UPDATE_INTERVAL);
}



LdbPrintNodeNeighbours()
{
	int i;

	TRACE(CkPrintf("Node %d: Neighbours: ",CmiMyPe()));
	for (i=0; i < numNeighbours; i++)
		TRACE(CkPrintf("%d, ", neighboursList[i]));
	TRACE(CkPrintf("\n"));
}


LdbAddSysBocEps()
{
   EpTable[LdbNbrStatus_EP] = LdbProcessMsg;
}



LdbProcessorIdle()
{
}

/*
 *  LdbInitLocalQueue() sets up two local stacks which are initially empty.
 *  One is the free stack and the other is the token-in-use stack
 */

typedef struct ldblist  {
  int language;  /* language bits used by system */
  ENVELOPE *msg;
  struct ldblist *nxt,*prv;
} LDBLIST;
  
LDBLIST *free_list, *in_use_list;
int ldb_token_handler_indx, ldb_null_handler_indx;

void LdbInitTokens()
{
  CkPrintf("LdbInitLocalList\n");
  /*  Set the two lists to NULL */

  free_list=in_use_list=NULL;  

  /* Register the load balance handler */
  ldb_token_handler_indx = registerHandler(LdbTokenHandler);
  ldb_null_handler_indx = registerHandler(LdbNullHandler);
}

/*
 *  LdbTokenHandler() recieves the LDB handler message off the stack
 *  and executes the handler for the original message just as the
 * scheduler would normally.
 */

void LdbTokenHandler(tok)
LDBLIST *tok;
{
  ENVELOPE *env;

  CkPrintf("LdbTokenHandler\n");
  /*
   *  Save the pointer to the original message
   */
  env=tok->msg;

  /* 
   * Remove the token from the in_use_list
   */
  if (tok==in_use_list)
    in_use_list=tok->nxt;
  if (tok->prv != NULL)
    tok->prv->nxt = tok->nxt;
  if (tok->nxt!= NULL)
    tok->nxt->prv = tok->prv;

  /*
   *  Add the token to the free_list
   */
  tok->nxt=free_list;
  if (free_list != NULL)  {
    tok->prv=free_list->prv;  /* free_list->prv should always be null */
  } else tok->prv=NULL;
  free_list=tok;

  /*
   * Now execute the handler for the original message
   */
  (CmiGetHandlerFunction(env))(env);
}

/*
 *  LdbNullHandler() is just like LdbTokenHandler, except
 *  don't execute the original message
 */
void LdbNullHandler(tok)
LDBLIST *tok;
{
  CkPrintf("LdbNullHandler\n");
  /* 
   * Remove the token from the in_use_list
   */
  if (tok==in_use_list)
    in_use_list=tok->nxt;
  if (tok->prv != NULL)
    tok->prv->nxt = tok->nxt;
  if (tok->nxt!= NULL)
    tok->nxt->prv = tok->prv;

  /*
   *  Add the token to the free_list
   */
  tok->nxt=free_list;
  if (free_list != NULL)  {
    tok->prv=free_list->prv;  /* free_list->prv should always be null */
  } else tok->prv=NULL;
  free_list=tok;
}


/*
 *  LdbEnqueue() will put a trigger message on the qm stack.  All
 *  seed messages should go through here if they are ever to be
 *  moved by load balancing
 */

void LdbEnqueue(env)
ENVELOPE *env;
{
  LDBLIST *tok;

  CkPrintf("LdbEnqueue\n");
  /* Create a new token message in the free list if
   * the free list is currently empty
   */
  if (free_list==NULL)  {
    free_list=(LDBLIST *)CkAlloc(sizeof(LDBLIST));
    if (free_list!=NULL)
      free_list->prv=free_list->nxt=NULL;
  }

  /*
   * There should be a node in free_list now, so we will use that
   * to allocate a new token
   */
  if (free_list != NULL)  {
    /*
     * Remove the token from the free list
     */
    tok = free_list;
    free_list = free_list->nxt;
    if (free_list != NULL)
      free_list->prv=NULL;
    /*
     * Set some fields in the token
     */
    CmiSetHandler(tok,ldb_token_handler_indx);
    tok->msg=env;
    /*
     * Add the token to the in_use_list
     */
    tok->nxt=in_use_list;
    tok->prv=NULL;
    if (in_use_list != NULL)
      in_use_list->prv=tok;
    in_use_list=tok;
    /*
     * enqueue the token message
     */
    QsEnqMsg(tok);
  } else {
    /*
     *  I couldn't get a message off the free list, so I will just enqueue
     *  the original message.  Should print message here.
     */
    QsEnqMsg(env);
  }
}

/*
 *  LdbDequeue() will get a message which can be sent off for
 *  load balancing, and set the handler field for the ldb message to null
 */
ENVELOPE *LdbDequeue()
{
  LDBLIST *tok;
  ENVELOPE *env;

  CkPrintf("LdbDequeue\n");
  
  if (in_use_list==NULL)  {
    /* No chares to deliver */
    return NULL;
  } /*  else   */
  /*
   * Get a token which still has a message from the in_use_list,
   * but don't remove it
   */
  tok = in_use_list;
  while ((tok != NULL) && (tok->msg == NULL))  {
    tok=tok->nxt;
  }
  if (tok==NULL)  {
    /* I scanned through the in_use_list and found no tokens
     * which still had messages associated with them
     */
    return NULL;
  }
  /*
   *  Save the message and set the msg field in the token to NULL.
   *  Then redirect the token to the NULL handler
   */
  env=tok->msg;
  tok->msg=NULL;
  CmiSetHandler(tok,ldb_null_handler_indx);

  return env;
}




