
#include "pparam.h"

/*****************************************************************************
 *                                                                           *
 * PPARAM - obtaining "program parameters" from the user.                    *
 *                                                                           *
 *****************************************************************************/

typedef struct ppdef
    {
    union
        {
        double r;
        int i;
        char *s;
        int f;
        } value;
    char *lname;
    char *doc;
    char  type;
    struct ppdef *next;
    }
    *ppdef;

static ppdef ppdefs;

static int     pparam_pos;
static char  **pparam_argv;
static char    pparam_optc='-';
char    pparam_error[100];

static ppdef pparam_find(lname)
    char *lname;
    {
    ppdef def;
    for (def=ppdefs; def; def=def->next)
        if (strcmp(def->lname, lname)==0)
            return def;
    return 0;
    }

static ppdef pparam_cell(lname)
    char *lname;
    {
    ppdef def = pparam_find(lname);
    if (def) return def;
    def = (ppdef)malloc(sizeof(struct ppdef));
    def->lname = lname;
    def->type  = 's';
    def->doc   = "(undocumented)";
    def->next  = ppdefs;
    ppdefs = def;
    return def;
    }

void pparam_doc(lname, doc)
    char *lname; char *doc;
    {
    ppdef def = pparam_cell(lname);
    def->doc = doc;
    }

void pparam_defint(lname, value)
    char *lname; int value;
    {
    ppdef def = pparam_cell(lname);
    def->type  = 'i';
    def->value.i = value;
    }

void pparam_defreal(lname, value)
    char *lname; double value;
    {
    ppdef def = pparam_cell(lname);
    def->type  = 'r';
    def->value.r = value;
    }

void pparam_defstr(lname, value)
    char *lname; char *value;
    {
    ppdef def = pparam_cell(lname);
    def->type  = 's';
    def->value.s = value;
    }

void pparam_defflag(lname)
    char *lname;
    {
    ppdef def = pparam_cell(lname);
    def->type  = 'f';
    def->value.f = 0;
    }

static ppdef pparam_hfind(lname)
    char *lname;
    {
    ppdef def = pparam_find(lname);
    if (def) return def;
    printf("No such program parameter %s\n",lname);
    exit(1);
    }

int pparam_getint(lname)
    char *lname;
    {
    ppdef def = pparam_hfind(lname);
    if (def->type != 'i') return 0;
    return def->value.i;
    }

double pparam_getreal(lname)
    char *lname;
    {
    ppdef def = pparam_hfind(lname);
    if (def->type != 'r') return 0.0;
    return def->value.r;
    }

char *pparam_getstr(lname)
    char *lname;
    {
    ppdef def = pparam_hfind(lname);
    if (def->type != 's') return 0;
    return def->value.s;
    }

int pparam_getflag(lname)
    char *lname;
    {
    ppdef def = pparam_hfind(lname);
    if (def->type != 'f') return 0;
    return def->value.f;
    }

static int pparam_setdef(def, value)
    ppdef def; char *value;
    {
    char *p;
    switch(def->type)
        {
        case 'i' :
            def->value.i = strtol(value, &p, 10);
            if (*p) return -1;
            return 0;
        case 'r' :
            def->value.r = strtod(value, &p);
            if (*p) return -1;
            return 0;
        case 's' :
            def->value.s = value;
            return 0;
        case 'f' :
            def->value.i = strtol(value, &p, 10);
            if (*p) return -1;
            return 0;
        }
    }

int pparam_set(lname, value)
    char *lname, *value;
    {
    ppdef def = pparam_cell(lname);
    return pparam_setdef(def, value);
    }

char *pparam_getdef(def)
    ppdef def;
    {
    static char result[100];
    switch(def->type)
        {
        case 'i': sprintf(result,"%d", def->value.i); return result;
        case 'r': sprintf(result,"%lf",def->value.r); return result;
        case 's': return def->value.s;
        case 'f': sprintf(result,"%d", def->value.f); return result;
        }
    }

void pparam_printdocs()
    {
    ppdef def; int i, len, maxname, maxdoc;
    maxname = 0;
    maxdoc = 0;
    for (def=ppdefs; def; def=def->next)
        {
        len = strlen(def->lname);
        if (len>maxname) maxname=len;
        len = strlen(def->doc);
        if (len>maxdoc) maxdoc=len;
        }
    printf("\n");
    printf("parameters recognized are:\n");
    printf("\n");
    for (def=ppdefs; def; def=def->next)
        {
        len = strlen(def->lname);
        printf("  %c%c%s ",pparam_optc,pparam_optc,def->lname);
        for(i=0; i<maxname-len; i++) printf(" ");
        len = strlen(def->doc);
        printf("  %s ",def->doc);
        for(i=0; i<maxdoc-len; i++) printf(" ");
        printf("[%s]\n",pparam_getdef(def));
        }
    printf("\n");
    }

void pparam_delarg(i)
    int i;
    {
    int j;
    for (j=i; pparam_argv[j]; j++)
        pparam_argv[j]=pparam_argv[j+1];
    }

int pparam_countargs(argv)
    char **argv;
    {
    int argc;
    for (argc=0; argv[argc]; argc++);
    return argc;
    }

int pparam_parseopt()
    {
    int ok; ppdef def;
    char *opt = pparam_argv[pparam_pos];
    /* handle ++ by skipping to end */
    if ((opt[1]=='+')&&(opt[2]==0))
        {
        pparam_delarg(pparam_pos);
        while (pparam_argv[pparam_pos]) pparam_pos++;
        return 0;
        }
    /* handle + by itself - an error */
    if (opt[1]==0) 
        {
        sprintf(pparam_error,"Illegal option +\n");
        return -1;
        }
    /* look up option definition */
    if (opt[1]=='+') def = pparam_find(opt+2);
    else
        {
        char name[2];
        name[0]=opt[1];
        name[1]=0;
        def = pparam_find(name);
        }
    if (def==0)
        {
        pparam_pos++;
	return 0;
/*
        sprintf(pparam_error,"Option %s not recognized.",opt);
        return -1;
*/
        }
    /* handle flag-options */
    if ((def->type=='f')&&(opt[1]!='+')&&(opt[2]))
        {
        sprintf(pparam_error,"Option %s should not include a value",opt);
        return -1;
        }
    if (def->type=='f')
        {
        def->value.f = 1;
        pparam_delarg(pparam_pos);
        return 0;
        }
    /* handle non-flag options */
    if ((opt[1]=='+')||(opt[2]==0))
        {
        pparam_delarg(pparam_pos);
        opt = pparam_argv[pparam_pos];
        }
    else opt+=2;
    if ((opt == 0)||(opt[0] == 0))
        {
        sprintf(pparam_error,"%s must be followed by a value.",opt);
        return -1;
        }
    ok = pparam_setdef(def, opt);
    pparam_delarg(pparam_pos);
    if (ok<0)
        {
        sprintf(pparam_error,"Illegal value for %s",opt);
        return -1;
        }
    return 0;
    }

int pparam_parsecmd(optchr, argv)
    char   optchr; char **argv;
    {
    pparam_error[0]=0;
    pparam_argv = argv;
    pparam_optc = optchr;
    pparam_pos  = 0;
    while(1)
        {
        char *opt = pparam_argv[pparam_pos];
        if (opt==0) break;
        if (opt[0]!=optchr) pparam_pos++;
        else if (pparam_parseopt()<0) return -1;
        }
    return 0;
    }

