
#ifndef CONVERSE_H
#define CONVERSE_H

/******** CONVERSE INTERNAL VARIABLES ********/

typedef void (*HANDLER_PTR)();

extern void *SchedQueue ;
extern int sysDone ;
extern HANDLER_PTR *LanguageHandlerTable ;




/******** CONVERSE MACROS *******/

#define CmiMsgHeaderSizeBytes 4

#define CmiGetHandler(env)  *((int *)(env))

#define CmiSetHandler(env,x)  *((int *)(env)) = x

#define CmiGetHandlerFunction(env) \
                        (LanguageHandlerTable[CmiGetHandler(env)])

#define CsdExitScheduler()  sysDone = TRUE 

#define CsdEnqueue(x)  CqsEnQueue(SchedQueue,x)



/******** CONVERSE FUNCTIONS *******/

extern int CmiRegisterHandler( /* FUNCTION_PTR */ ) ;

extern void CsdScheduler( /* int */ ) ;




#endif  /* CONVERSE_H */
