/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: spantree.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/05/10 20:19:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: spantree.c,v $
 * Revision 1.2  1995/05/10  20:19:05  milind
 * *** empty log message ***
 *
 * Revision 1.1  1994/11/03  17:37:41  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /home/kale/milind/E3dir/Charm/machines/sp1/RCS/spantree.c,v 1.2 1995/05/10 20:19:05 milind Exp $";
/* This file contains all the spanning tree functions */
#include "machine.h"
#define MAXSPAN    4          /* The maximum permitted span on 
				 each node of the spanning tree */
#define MAXNODES   1024
#define MAXCUBEDIM  10         /* log_2 (MAXNODES) */


typedef struct spantreearray {
    int noofchildren;
    int parent;
    int *children;
} SpanTreeArray;

SpanTreeArray *SpanArray;
int *NodeStore;   /* used to store the nodes in the spanning 
		       tree in breadth first order */
extern int _MC_dim;
int numnodes;

CmiSpanTreeInit()
{
    int i, j;
    BOOLEAN visited[MAXNODES];
    int next, currentnode;
    int neighbours[MAXCUBEDIM];

    numnodes = (1 << _MC_dim);
    SpanArray = (SpanTreeArray *)CkAlloc(sizeof(SpanTreeArray) * numnodes);
    NodeStore = (int *) CkAlloc(sizeof(int) * numnodes);
    visited[0] = TRUE;
    NodeStore[0] = 0;  /* the root of the spanning tree */
    SpanArray[0].parent = -1;  /* no parent */

    for (i = 1; i < numnodes; i++)
        visited[i] = FALSE;

    for (next = 1, i = 0; i < numnodes; i++)
    {
	currentnode = NodeStore[i];
	McGetNodeNeighbours(currentnode, neighbours);
	SpanArray[currentnode].noofchildren = 0;
	for (j = 0; j < _MC_dim && 
	            SpanArray[currentnode].noofchildren < MAXSPAN; j++)
	{
	    if (!visited[neighbours[j]])
	    {
		NodeStore[next + SpanArray[currentnode].noofchildren] = 
								neighbours[j];
		SpanArray[currentnode].noofchildren++;
		SpanArray[neighbours[j]].parent = currentnode;
		visited[neighbours[j]] = TRUE;
		
	    }
	}
	if (SpanArray[currentnode].noofchildren != 0)
	{
	    SpanArray[currentnode].children = &NodeStore[next];
	    next += SpanArray[currentnode].noofchildren;
	}
    }

    for (i = 0; i < numnodes; i++)  /* check */
	if (!visited[i])
	   CkError("node %d not part of spanning tree: initialization error!\n",i);
}


int CmiSpanTreeRoot()
{
    return 0;  /* node 0 is always the root of the spanning tree on the 
		  hypercubes */
}


int CmiSpanTreeParent(node)
int node;
{
    return SpanArray[node].parent;
}


CmiSpanTreeChild(node, children)
int node, *children;
{
    int i;

    for( i = 0; i < SpanArray[node].noofchildren; i++)
         children[i] = SpanArray[node].children[i];
}


int CmiNumSpanTreeChildren(node)
int node;
{
    return SpanArray[node].noofchildren;
}




PrintSpanTree()
{
    int i,j;

    for (i = 0; i < numnodes; i++)
    {
	CkPrintf("node: %d, parent: %d, numchildren: %d, children: ",
		 i, SpanArray[i].parent, SpanArray[i].noofchildren); 
	for (j = 0; j < SpanArray[i].noofchildren; j++)
	     CkPrintf("%d ",SpanArray[i].children[j]);
	CkPrintf("\n");
    }
}



CmiSendToSpanTreeLeaves(size, msg)
int size;
char * msg;
{
    int node;

    /* node 0 cannot be a leaf of a spanning tree: it is the root */
    for (node = 1; node < numnodes; node++)
    if (SpanArray[node].noofchildren == 0)  /* it is a leaf */
        CmiAsyncSend(node, size, msg, PROCESS_PID);
}
