/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: machine.node.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/05/10 20:19:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: machine.node.c,v $
 * Revision 1.3  1995/05/10  20:19:05  milind
 * *** empty log message ***
 *
 * Revision 1.2  1994/11/22  17:05:24  narain
 * Changed main to SetupCharm and put in a empty McEndCharm
 *
 * Revision 1.1  1994/11/03  17:37:40  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /home/kale/milind/E3dir/Charm/machines/sp1/RCS/machine.node.c,v 1.3 1995/05/10 20:19:05 milind Exp $";
#include <stdio.h>
#include <sys/time.h>
#include <mpproto.h>
#include "machine.h" 
#include "converse.h"


#define FLIPBIT(node,bitnumber) (node ^ (1 << bitnumber))

int _MC_mypenum, _MC_dim /* used in spantree.c */  ;   
int _MC_maxpenum ;   

static int msglength=0 ;
static int numpes ;
static double itime;

void
CmiDeclareArgs()
{
	return;
}

CmiInit(argc,argv)
int argc ;
char *argv[] ;
{
	int n;

	McTimerInit();
	mpc_environ(&_MC_maxpenum, &_MC_mypenum);
	numpes = _MC_maxpenum;

	/* find dim = log2(numpes), to pretend we are a hypercube */
	for ( _MC_dim=0,n=numpes; n>1; n/=2 )
		_MC_dim++ ;
}

CmiExit()
{
	exit(0);
}


/**************************  TIMER FUNCTIONS **************************/

McTimerInit()
{
    struct timestruc_t time;

    gettimer(TIMEOFDAY,&time);
    itime=(double)time.tv_sec + 1.0e-9*((double) time.tv_nsec);
}

McUTimerInit()
{
/* Nothing, since we use just one timer for both usec and msec. */
}


double CmiTimer()
{
    double t;
    struct timestruc_t time;

    gettimer(TIMEOFDAY,&time);
    t=(double)time.tv_sec + 1.0e-9*((double) time.tv_nsec);
    return (t-itime);
}

unsigned int McTimer()
{
	return (unsigned int) (1000.0*CmiTimer());
}


unsigned int McUTimer()
{
	return (unsigned int) (1.0e6*CmiTimer());
}


McHTimer()
{
	return (unsigned int)(CmiTimer()/3600.0);
}



/********************* MESSAGE SEND / RECEIVE FUNCTIONS ******************/

void *CmiGetMsg()
{
        void *env;
        int msglength;

        if (!McProbe())
                return NULL;
        msglength = McArrivedMsgLength();
        env = (void *)  CkAlloc(msglength);
        if (env == NULL)
	{
                CkPrintf("*** ERROR *** Memory Allocation Failed.\n");
		fflush(stdout);
	}
        McSyncReceive(msglength, env);
	printf("In GetMsg, env[4] = %d\n", ((int *)env)[4]);
        return env;
}

McProbe()
{
	int src, type, nbytes;

	src = DONTCARE;
	type = 0;
	mpc_probe(&src, &type, &nbytes);
	if(nbytes<0)
		return 0;
        msglength = nbytes;
	return(1) ;
}

McArrivedMsgLength()
{
        return msglength;
}

McSyncReceive(size, buffer)
int size ;
char *buffer ;
{
	int src, type, nbytes;

	src = DONTCARE;
	type = 0;
	mpc_brecv(buffer,size,&src, &type,&nbytes);
}

CmiDeliverMsgs()
{
	int *envelope ;
        while ((envelope = (int *) CmiGetMsg()) != NULL) {
                /* This calls HANDLE_INCOMING_MSG for Charm */
                (CmiGetHandlerFunction(envelope))(envelope) ;
        }
}



CommHandle
CmiAsyncSend(destPE, size, msg)
int destPE;
int size;
char * msg;
{
	printf("In async_send , tag3 = %d\n", ((int *)msg)[4]);
	mpc_bsend(msg, size, destPE, 0);
	return NULL;
}


int CmiAsyncMsgSent(CommHandle phandle)
{
	return 1;
}

void
CmiReleaseCommHandle(CommHandle phandle)
{
	return;
}

void
CmiGrabBuffer(void **pbuf)
{
	return;
}
/* Used only from broadcast for now */
CmiSyncSend(destPE, size, msg)
int destPE;
int size;
char * msg;
{
	mpc_bsend(msg, size, destPE, 0);
}


/*********************** BROADCAST FUNCTIONS **********************/

CmiSyncBroadcastAndFree(size, msg)     /* ALL_EXCEPT_ME  */
int size;
char * msg;
{
	int i ;

	for ( i=_MC_mypenum+1; i<numpes; i++ ) 
		CmiSyncSend(i, size,msg) ;
	for ( i=0; i<_MC_mypenum; i++ ) 
		CmiSyncSend(i, size,msg) ;
	CkFree(msg) ;
}

CmiSyncBroadcast(size, msg)     /* ALL_EXCEPT_ME  */
int size;
char * msg;
{
        int i ;

        for ( i=_MC_mypenum+1; i<numpes; i++ )
                CmiSyncSend(i, size,msg) ;
        for ( i=0; i<_MC_mypenum; i++ )
                CmiSyncSend(i, size,msg) ;
}

CmiSyncBroadcastAllAndFree(size, msg)
int size;
char * msg;
{
	int i ;

	for ( i=0; i<numpes; i++ ) 
		CmiSyncSend(i,size,msg,0) ;
	CkFree(msg) ;
}

CmiSyncBroadcastAll(size, msg)
int size;
char * msg;
{
	int i ;

	for ( i=0; i<numpes; i++ ) 
		CmiSyncSend(i,size,msg,0) ;
}

CmiAsyncBroadcastAll(size, msg)
int size;
char *msg;
{
	int i ;

	for ( i=0; i<numpes; i++ ) 
		CmiSyncSend(i,size,msg,0) ;
}

CmiAsyncBroadcast(size, msg)  /* same as McBroadcast for now */
int size;
char * msg;
{
	int i ;

	for ( i=_MC_mypenum+1; i<numpes; i++ ) 
		CmiSyncSend(i,size,msg) ;
	for ( i=0; i<_MC_mypenum; i++ ) 
		CmiSyncSend(i,size,msg) ;
}

/* Neighbour functions used mainly in LDB : pretend the SP1 is a hypercube */

int McNumNeighbours(node)
int node;
{
    return _MC_dim;
}


McGetNodeNeighbours(node, neighbours)
int node, *neighbours;
{
    int i;

    for (i = 0; i < _MC_dim; i++)
        neighbours[i] = FLIPBIT(node,i);
}




int McNeighboursIndex(node, neighbour)
int node, neighbour;
{
    int index = 0;
    int linenum = node ^ neighbour;

    while (linenum > 1)
    {
        linenum = linenum >> 1;
        index++;
    }
    return index;
}
