############################################################################
# RCS INFORMATION:
#
# 	$RCSfile: pgm.Makefile,v $
# 	$Author: brunner $	$Locker:  $		$State: Exp $
#	$Revision: 1.1 $	$Date: 1994/11/07 16:08:25 $
#
############################################################################
# DESCRIPTION:
#
############################################################################
# REVISION HISTORY:
#
# $Log: pgm.Makefile,v $
# Revision 1.1  1994/11/07  16:08:25  brunner
# Initial revision
#
############################################################################
include choices.mk

#######################################################################
#Program makefile begins 
#######################################################################
include $(BINPATH)/path.mk
include $(BINPATH)/trace.mk
include $(BINPATH)/machine.mk

INCLUDES = -I. -I$(HEADERS)


#This is the main Charm object
CKOBJHOST=$(CKEXEC)/ck_objdir/ckobj.host.o
CKOBJNODE=$(CKEXEC)/ck_objdir/ckobj.node.$(SUF)
LOGSTRAT=$(CKEXEC)/ck_objdir/$(LOGEXEC).$(SUF)
EXTRASTRAT=$(CKEXEC)/ck_objdir/node_$(EXTRAEXEC).$(SUF)

#This is the memory strategy
HOSTMEMSTRAT=$(CKEXEC)/mem_objdir/h_mem_table.o
NODEMEMSTRAT=$(CKEXEC)/mem_objdir/n_mem_table.$(SUF)

#This is the queueing strategy
HOSTQUEUESTRAT=$(CKEXEC)/qs_objdir/h_qs_$(QUEUE).o
NODEQUEUESTRAT=$(CKEXEC)/qs_objdir/n_qs_$(QUEUE).$(SUF)

#This is the load balancing strategy
HOSTLDBSTRAT=$(CKEXEC)/ldb_objdir/h_ldb.$(BALANCE).o
NODELDBSTRAT=$(CKEXEC)/ldb_objdir/n_ldb.$(BALANCE).$(SUF)

#Other stuff we need
CHARMLOAD=-L$(CKLIB) -lm
TRANSLATE=$(CKEXEC)/translate
SPACEFILTER=$(CKEXEC)/spacefilter


PGM = pgm
all: n$(PGM) $(HOST)

h$(PGM) : $(CKOBJHOST) $(HOSTMEMSTRAT) $(HOSTQUEUESTRAT) \
	  $(HOSTLDBSTRAT)
	$(HOST_LINK) -o h$(PGM) $(CKOBJHOST) $(HOSTMEMSTRAT) \
	$(HOSTQUEUESTRAT) $(HOSTLDBSTRAT) $(HOST_LOADS)

n$(PGM) : $(PGM).$(SUF) $(NODEMEMSTRAT) $(NODEQUEUESTRAT) $(NODELDBSTRAT) \
	$(CKOBJNODE) $(LOGSTRAT) $(EXTRASTRAT) Makefile
	$(NODE_LINK) -O -o n$(PGM) \
			$(CKOBJNODE) $(LOGSTRAT) $(EXTRASTRAT) \
		 	$(NODEQUEUESTRAT) $(NODELDBSTRAT) \
		 	$(NODEMEMSTRAT)  $(PGM).$(SUF) \
			$(CHARMLOAD) $(NODE_LOADS)

$(PGM).$(SUF): $(PGM).c $(CKINCL)/chare.h 
	$(NODE_CC) $(TRACING) $(PGM).c

$(PGM).c: $(PGM).p
	$(CPP) $(TRACING) -I$(CKINCL) $(PGM).p | $(SPACEFILTER) | m4 > $(PGM).tmp
	$(TRANSLATE) $(PGM).tmp $(PGM)
	rm -f $(PGM).tmp
	mv $(PGM) $(PGM).c	
	
