############################################################################
# RCS INFORMATION:
#
# 	$RCSfile: lib.Makefile,v $
# 	$Author: brunner $	$Locker:  $		$State: Exp $
#	$Revision: 1.1 $	$Date: 1994/11/07 16:08:03 $
#
############################################################################
# DESCRIPTION:
#
############################################################################
# REVISION HISTORY:
#
# $Log: lib.Makefile,v $
# Revision 1.1  1994/11/07  16:08:03  brunner
# Initial revision
#
############################################################################
include path.mk
include $(LIBPATH)/path.mk
include $(LIBPATH)/trace.mk
include $(LIBPATH)/machine.mk

INCLUDES= -I. -I$(HEADERS)

TRANSLATE=$(CKEXEC)/translate.$(MACHTYPE)
SPACEFILTER=$(CKEXEC)/spacefilter.$(MACHTYPE)

ACC_DIR=$(COMMON_LIB)/accumulators
REDUC_DIR=$(COMMON_LIB)/reduction
DAGGER_DIR=$(COMMON_LIB)/dagger
PG_DIR=$(COMMON_LIB)/pg
CACHE_DIR=$(COMMON_LIB)/cache

DEPENDENCE1 = 	$(ACC_DIR)/generic_acc.p $(ACC_DIR)/generic_acc.int \
		$(CKINCL)/chare.h
DEPENDENCE2 = 	$(ACC_DIR)/generic_acc_hist.p $(ACC_DIR)/generic_acc_hist.int \
		$(CKINCL)/chare.h	
DEPENDENCE3 = 	$(REDUC_DIR)/generic_redn.p $(REDUC_DIR)/generic_redn.int \
		$(CKINCL)/chare.h $(CKINCL)/pg.int
DEPENDENCE4 = 	$(REDUC_DIR)/barrier_redn.p $(REDUC_DIR)/barrier_redn.int \
		$(CKINCL)/chare.h	
DEPENDENCE5 =   $(DAGGER_DIR)/daglib.c $(DAGGER_DIR)/dag.h $(CKINCL)/machine.h
DEPENDENCE6 =   $(PG_DIR)/pglib.p $(PG_DIR)/pg.int $(CKINCL)/chare.h

ACC_OBJECTS = 	iacc_count.$(SUF) facc_count.$(SUF) dacc_count.$(SUF) \
		iacc_hist.$(SUF) facc_hist.$(SUF) dacc_hist.$(SUF)

REDUC_OBJECTS=	iminredn.$(SUF) imaxredn.$(SUF) isumredn.$(SUF) \
		iprodredn.$(SUF) icountredn.$(SUF) \
		fminredn.$(SUF) fmaxredn.$(SUF) fsumredn.$(SUF) \
		fprodredn.$(SUF) \
		dminredn.$(SUF) dmaxredn.$(SUF) dsumredn.$(SUF) \
		dprodredn.$(SUF) barrier_redn.$(SUF)

DAGGER_OBJECTS= daglib.$(SUF)
PG_OBJECTS = pglib.$(SUF)
CACHE_OBJECTS=cache.$(SUF)

all: archive

# pglib needs to go before the reduction stuff.
archive: $(ACC_OBJECTS) $(PG_OBJECTS) $(REDUC_OBJECTS) $(DAGGER_OBJECTS) \
				$(CACHE_OBJECTS)
	$(AR) libcharm.a $(ACC_OBJECTS) $(PG_OBJECTS) $(REDUC_OBJECTS) \
	$(DAGGER_OBJECTS)  $(CACHE_OBJECTS); $(RANLIB) 

archiveonly:
	$(AR) libcharm.a $(ACC_OBJECTS) $(PG_OBJECTS) $(REDUC_OBJECTS) \
	$(DAGGER_OBJECTS); $(RANLIB) 


pglib.$(SUF): $(DEPENDENCE6)
	$(CPP) $(INCLUDES) $(PG_DIR)/pglib.p | $(SPACEFILTER) | m4 > pglib.tmp
	$(TRANSLATE) pglib.tmp pglib
	rm -r pglib.tmp; mv pglib pglib.c;
	$(NODE_CC) pglib.c; rm -f pglib.c pglib.*.h;

cache.$(SUF): $(CACHE_DIR)/cache.p $(CACHE_DIR)/cache.int
	$(CPP) $(INCLUDES) $(CACHE_DIR)/cache.p | $(SPACEFILTER) | m4 > cache.tmp
	$(TRANSLATE) cache.tmp cache
	rm -r cache.tmp; mv cache cache.c;
	$(NODE_CC) cache.c; rm -f cache.c cache.*.h;


iacc_count.$(SUF):	$(DEPENDENCE1)
	$(CPP) -DINT $(ACC_DIR)/generic_acc.int | $(SPACEFILTER) | m4 > iacc_count.int
	#mv iacc_count.int $(CKINCL)
	$(CPP) -DINT $(INCLUDES) $(ACC_DIR)/generic_acc.p | $(SPACEFILTER) | m4 > acc.tmp
	$(TRANSLATE) acc.tmp acc
	rm -f acc.tmp; mv acc acc.c; $(NODE_CC)  acc.c; rm -f acc.c acc.*.h;
	mv acc.o iacc_count.o

facc_count.$(SUF):	$(DEPENDENCE1)
	$(CPP) -DFLOAT $(ACC_DIR)/generic_acc.int | $(SPACEFILTER) | m4 > facc_count.int
	#mv facc_count.int $(CKINCL)
	$(CPP) -DFLOAT $(INCLUDES) $(ACC_DIR)/generic_acc.p | $(SPACEFILTER) | m4 > acc.tmp
	$(TRANSLATE) acc.tmp acc
	rm -f acc.tmp; mv acc acc.c; $(NODE_CC)  acc.c; rm -f acc.c acc.*.h;
	mv acc.o facc_count.o

dacc_count.$(SUF):	$(DEPENDENCE1)
	$(CPP) -DDOUBLE $(ACC_DIR)/generic_acc.int | $(SPACEFILTER) | m4 > dacc_count.int
	#mv dacc_count.int $(CKINCL)
	$(CPP) -DDOUBLE $(INCLUDES) $(ACC_DIR)/generic_acc.p | $(SPACEFILTER) | m4 > acc.tmp
	$(TRANSLATE) acc.tmp acc
	rm -f acc.tmp; mv acc acc.c; $(NODE_CC)  acc.c; rm -f acc.c acc.*.h;
	mv acc.o dacc_count.o

iacc_hist.$(SUF):	$(DEPENDENCE2)
	$(CPP) -DINT $(ACC_DIR)/generic_acc_hist.int | $(SPACEFILTER) | m4 > iacc_hist.int
	#mv iacc_hist.int $(CKINCL)
	$(CPP) -DINT $(INCLUDES) $(ACC_DIR)/generic_acc_hist.p | $(SPACEFILTER) | m4 > acc.tmp
	$(TRANSLATE) acc.tmp acc
	rm -f acc.tmp; mv acc acc.c; $(NODE_CC)  acc.c; rm -f acc.c acc.*.h;
	mv acc.o iacc_hist.o

facc_hist.$(SUF):	$(DEPENDENCE2)
	$(CPP) -DFLOAT $(ACC_DIR)/generic_acc_hist.int | $(SPACEFILTER) | m4 > facc_hist.int
	#mv facc_hist.int $(CKINCL)
	$(CPP) -DFLOAT $(INCLUDES) $(ACC_DIR)/generic_acc_hist.p | $(SPACEFILTER) | m4 > acc.tmp
	$(TRANSLATE) acc.tmp acc
	rm -f acc.tmp; mv acc acc.c; $(NODE_CC)  acc.c; rm -f acc.c acc.*.h;
	mv acc.o facc_hist.o

dacc_hist.$(SUF):	$(DEPENDENCE2)
	$(CPP) -DDOUBLE $(ACC_DIR)/generic_acc_hist.int | $(SPACEFILTER) | m4 > dacc_hist.int
	#mv dacc_hist.int $(CKINCL)
	$(CPP) -DDOUBLE $(INCLUDES) $(ACC_DIR)/generic_acc_hist.p | $(SPACEFILTER) | m4 > acc.tmp
	$(TRANSLATE) acc.tmp acc
	rm -f acc.tmp; mv acc acc.c; $(NODE_CC)  acc.c; rm -f acc.c acc.*.h;
	mv acc.o dacc_hist.o



imaxredn.$(SUF):	$(DEPENDENCE3)
	$(CPP) -DR_INT -DR_MAX  $(REDUC_DIR)/generic_redn.int | $(SPACEFILTER) | m4 > imaxredn.int
	#mv imaxredn.int $(CKINCL)
	$(CPP) -DR_INT -DR_MAX $(INCLUDES) $(REDUC_DIR)/generic_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o imaxredn.o

iminredn.$(SUF):	$(DEPENDENCE3)
	$(CPP) -DR_INT -DR_MIN  $(REDUC_DIR)/generic_redn.int | $(SPACEFILTER) | m4 > iminredn.int
	#mv iminredn.int $(CKINCL)
	$(CPP) -DR_INT -DR_MIN $(INCLUDES) $(REDUC_DIR)/generic_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o iminredn.o

isumredn.$(SUF):	$(DEPENDENCE3)
	$(CPP) -DR_INT -DR_SUM  $(REDUC_DIR)/generic_redn.int | $(SPACEFILTER) | m4 > isumredn.int
	#mv isumredn.int $(CKINCL)
	$(CPP) -DR_INT -DR_SUM $(INCLUDES) $(REDUC_DIR)/generic_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o isumredn.o

iprodredn.$(SUF):	$(DEPENDENCE3)
	$(CPP) -DR_INT -DR_PROD  $(REDUC_DIR)/generic_redn.int | $(SPACEFILTER) | m4 > iprodredn.int
	#mv iprodredn.int $(CKINCL)
	$(CPP) -DR_INT -DR_PROD $(INCLUDES) $(REDUC_DIR)/generic_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o iprodredn.o

icountredn.$(SUF):	$(DEPENDENCE3)
	$(CPP) -DR_INT -DR_COUNT  $(REDUC_DIR)/generic_redn.int | $(SPACEFILTER) | m4 > icountredn.int
	#mv icountredn.int $(CKINCL)
	$(CPP) -DR_INT -DR_COUNT $(INCLUDES) $(REDUC_DIR)/generic_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o icountredn.o

fmaxredn.$(SUF):	$(DEPENDENCE3)
	$(CPP) -DR_FLOAT -DR_MAX  $(REDUC_DIR)/generic_redn.int | $(SPACEFILTER) | m4 > fmaxredn.int
	#mv fmaxredn.int $(CKINCL)
	$(CPP) -DR_FLOAT -DR_MAX $(INCLUDES) $(REDUC_DIR)/generic_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o fmaxredn.o

fminredn.$(SUF):	$(DEPENDENCE3)
	$(CPP) -DR_FLOAT -DR_MIN  $(REDUC_DIR)/generic_redn.int | $(SPACEFILTER) | m4 > fminredn.int
	#mv fminredn.int $(CKINCL)
	$(CPP) -DR_FLOAT -DR_MIN $(INCLUDES) $(REDUC_DIR)/generic_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o fminredn.o



fsumredn.$(SUF):	$(DEPENDENCE3)
	$(CPP) -DR_FLOAT -DR_SUM  $(REDUC_DIR)/generic_redn.int | $(SPACEFILTER) | m4 > fsumredn.int
	#mv fsumredn.int $(CKINCL)
	$(CPP) -DR_FLOAT -DR_SUM $(INCLUDES) $(REDUC_DIR)/generic_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o fsumredn.o

fprodredn.$(SUF):	$(DEPENDENCE3)
	$(CPP) -DR_FLOAT -DR_PROD  $(REDUC_DIR)/generic_redn.int | $(SPACEFILTER) | m4 > fprodredn.int
	#mv fprodredn.int $(CKINCL)
	$(CPP) -DR_FLOAT -DR_PROD $(INCLUDES) $(REDUC_DIR)/generic_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o fprodredn.o


dmaxredn.$(SUF):	$(DEPENDENCE3)
	$(CPP) -DR_DOUBLE -DR_MAX  $(REDUC_DIR)/generic_redn.int | $(SPACEFILTER) | m4 > dmaxredn.int
	#mv dmaxredn.int $(CKINCL)
	$(CPP) -DR_DOUBLE -DR_MAX $(INCLUDES) $(REDUC_DIR)/generic_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o dmaxredn.o


dminredn.$(SUF):	$(DEPENDENCE3)
	$(CPP) -DR_DOUBLE -DR_MIN  $(REDUC_DIR)/generic_redn.int | $(SPACEFILTER) | m4 > dminredn.int
	#mv dminredn.int $(CKINCL)
	$(CPP) -DR_DOUBLE -DR_MIN $(INCLUDES) $(REDUC_DIR)/generic_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o dminredn.o


dsumredn.$(SUF):	$(DEPENDENCE3)
	$(CPP) -DR_DOUBLE -DR_SUM  $(REDUC_DIR)/generic_redn.int | $(SPACEFILTER) | m4 > dsumredn.int
	#mv dsumredn.int $(CKINCL)
	$(CPP) -DR_DOUBLE -DR_SUM $(INCLUDES) $(REDUC_DIR)/generic_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o dsumredn.o

dprodredn.$(SUF):	$(DEPENDENCE3)
	$(CPP) -DR_DOUBLE -DR_PROD  $(REDUC_DIR)/generic_redn.int | $(SPACEFILTER) | m4 > dprodredn.int
	#mv dprodredn.int $(CKINCL)
	$(CPP) -DR_DOUBLE -DR_PROD $(INCLUDES) $(REDUC_DIR)/generic_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o dprodredn.o

barrier_redn.$(SUF):	$(DEPENDENCE3)
	$(CPP) $(INCLUDES) $(REDUC_DIR)/barrier_redn.p | $(SPACEFILTER) | m4 > redn.tmp
	$(TRANSLATE) redn.tmp redn
	rm -f redn.tmp; mv redn redn.c; 
	$(NODE_CC) redn.c; rm -f redn.c redn.*.h;
	mv redn.o barrier_redn.o


daglib.$(SUF): $(DEPENDENCE5)
	$(NODE_CC) $(DAGGER_DIR)/daglib.c
