############################################################################
# RCS INFORMATION:
#
# 	$RCSfile: common.qs.Makefile,v $
# 	$Author: jyelon $	$Locker:  $		$State: Exp $
#	$Revision: 1.2 $	$Date: 1995/05/04 18:20:16 $
#
############################################################################
# DESCRIPTION:
#
############################################################################
# REVISION HISTORY:
#
# $Log: common.qs.Makefile,v $
# Revision 1.2  1995/05/04  18:20:16  jyelon
# *** empty log message ***
#
# Revision 1.1  1994/11/07  16:07:55  brunner
# Initial revision
#
############################################################################
include ../path.mk
include ../machine.mk
include ../trace.mk

INCLUDES 			= -I. -I$(HEADERS) -I$(QSPRIOINCLDIR) 

QSDIR   		= $(COMMON_QS)
QMDIR    		= $(COMMON)/qm
QSPRIOINCLDIR		= $(COMMON_QS)/prio_include

DEPEND             = $(HEADERS)/chare.h  $(MACHINE)/machine.h $(HEADERS)/const.h $(HEADERS)/msg_macros.h $(HEADERS)/prio_macros.h $(HEADERS)/env_macros.h  $(COMMON_MEM)/mem.h $(HEADERS)/sys_macros.h $(HEADERS)/communication.h

all: 	n_qs_stack.$(SUF) n_qs_fifo.$(SUF) n_qs_fl.$(SUF) \
	n_qs_bstack.$(SUF) n_qs_bfifo.$(SUF) \
	n_qs_istack.$(SUF) n_qs_ififo.$(SUF)  \
	n_qs_rand.$(SUF) $(NODE_REPLAY_QS)

n_qs_stack.$(SUF): 	$(QSDIR)/stack/qs.c $(QSDIR)/stack/queue.h $(DEPEND)
			rm -f n_qs_stack.$(SUF)
			$(NODE_CC)  $(QSDIR)/stack/qs.c
			mv qs.$(SUF) n_qs_stack.$(SUF)
			chmod o+rx n_qs_stack.$(SUF)


n_qs_fifo.$(SUF): 	$(QSDIR)/fifo/qs.c $(QSDIR)/fifo/queue.h $(DEPEND)
			rm -f n_qs_fifo.$(SUF)
			$(NODE_CC)  $(QSDIR)/fifo/qs.c
			mv qs.$(SUF) n_qs_fifo.$(SUF)
			chmod o+rx n_qs_fifo.$(SUF)


n_qs_fl.$(SUF): 	$(QSDIR)/fifolifo/qs.c $(QSDIR)/fifolifo/queue.h $(DEPEND)
			rm -f n_qs_fl.$(SUF)
			$(NODE_CC)  $(QSDIR)/fifolifo/qs.c
			mv qs.$(SUF) n_qs_fl.$(SUF)
			chmod o+rx n_qs_fl.$(SUF)

n_qs_bstack.$(SUF):	$(QSDIR)/prio_stack/qs.c $(QSDIR)/prio_stack/queue.h \
			$(QSDIR)/prio_include/bitvec_int_macros.c $(DEPEND)
			rm -f n_qs_bstack.$(SUF)
			$(NODE_CC) -DBITVECTOR  \
				$(QSDIR)/prio_stack/qs.c
			mv qs.$(SUF) n_qs_bstack.$(SUF)
			chmod o+rx n_qs_bstack.$(SUF)

n_qs_bfifo.$(SUF):	$(QSDIR)/prio_fifo/qs.c $(QSDIR)/prio_fifo/queue.h \
			$(QSDIR)/prio_include/bitvec_int_macros.c $(DEPEND)
			rm -f n_qs_bfifo.$(SUF)
			$(NODE_CC) -DBITVECTOR  \
				$(QSDIR)/prio_fifo/qs.c
			mv qs.$(SUF) n_qs_bfifo.$(SUF)
			chmod o+rx n_qs_bfifo.$(SUF)

n_qs_istack.$(SUF):	$(QSDIR)/prio_stack/qs.c $(QSDIR)/prio_stack/queue.h \
			$(QSDIR)/prio_include/bitvec_int_macros.c $(DEPEND)
			rm -f n_qs_istack.$(SUF)
			$(NODE_CC)  $(QSDIR)/prio_stack/qs.c
			mv qs.$(SUF) n_qs_istack.$(SUF)
			chmod o+rx n_qs_istack.$(SUF)

n_qs_ififo.$(SUF):	$(QSDIR)/prio_fifo/qs.c $(QSDIR)/prio_fifo/queue.h \
			$(QSDIR)/prio_include/bitvec_int_macros.c $(DEPEND)
			rm -f n_qs_ififo.$(SUF)
			$(NODE_CC)  $(QSDIR)/prio_fifo/qs.c
			mv qs.$(SUF) n_qs_ififo.$(SUF)
			chmod o+rx n_qs_ififo.$(SUF)

n_qs_rand.$(SUF): $(QSDIR)/random/qs.c $(QSDIR)/random/queue.h $(DEPEND)
		rm -f n_qs_rand.$(SUF)
		$(NODE_CC)  $(QSDIR)/random/qs.c
		mv qs.$(SUF) n_qs_rand.$(SUF)
		chmod o+rx n_qs_rand.$(SUF)

n_qs_replay.$(SUF): $(QSDIR)/replay/qs.c $(QSDIR)/replay/queue.h $(DEPEND)
		rm -f n_qs_replay.$(SUF)
		$(NODE_CC)  $(QSDIR)/replay/qs.c
		mv qs.$(SUF) n_qs_replay.$(SUF)
		chmod o+rx n_qs_replay.$(SUF)

