############################################################################
# RCS INFORMATION:
#
#       $RCSfile: common.main.Makefile,v $
#       $Author: jyelon $      $Locker:  $              $State: Exp $
#       $Revision: 1.12 $        $Date: 1995/05/04 18:20:16 $
#
############################################################################
# DESCRIPTION:
#
############################################################################
# REVISION HISTORY:
#
# $Log: common.main.Makefile,v $
# Revision 1.12  1995/05/04  18:20:16  jyelon
# *** empty log message ***
#
# Revision 1.11  1995/04/25  19:18:10  narain
# Added tempdumdecls addition (file with temp dummy declarations of Charm
# stuff for converse only programs
#
# Revision 1.10  1995/04/14  20:11:20  milind
# changed again to conform to sanjeev's charmc
#
# Revision 1.9  1995/04/14  19:48:21  milind
# corrected dependences to include converse.o
#
# Revision 1.8  1995/04/14  05:43:38  milind
# added converse.o to runtime library
#
# Revision 1.7  1995/04/02  00:46:39  sanjeev
# changes for separating Converse
#
# Revision 1.6  1995/03/23  22:11:30  sanjeev
# *** empty log message ***
#
# Revision 1.5  1995/03/17  23:32:34  sanjeev
# added converse.c
#
# Revision 1.4  1994/12/01  23:53:50  sanjeev
# added register.c
#
# Revision 1.3  1994/11/18  20:30:20  narain
# Added the dependencies for default_main.o
#  - Sanjeev and Narain
#
# Revision 1.2  1994/11/09  21:24:37  sanjeev
# separated qm, etc
#
# Revision 1.1  1994/11/07  16:07:51  brunner
# Initial revision
#
############################################################################
include path.mk
include machine.mk
include trace.mk


INCLUDES               	= -I. -I$(HEADERS) 

COMDIR   		= $(COMMON)
BOCDIR	 		= $(COMDIR)/boc
CKDIR	 		= $(COMDIR)/ck
MAINDIR	 		= $(COMDIR)/main
INITDIR	 		= $(COMDIR)/initialization
CONDSDIR 		= $(COMDIR)/condsends
QUIESDIR 		= $(COMDIR)/quiescence
QMDIR    		= $(COMDIR)/qm
VIDDIR   		= $(COMDIR)/vid
STATDIR	 		= $(COMDIR)/stats
PSEUDODIR 		= $(COMDIR)/pseudo_global
PERFDIR 		= $(COMDIR)/performance
FIFODIR			= $(COMDIR)/fifo

MEM_OBJDIR 		= mem_objdir
QS_OBJDIR 		= qs_objdir
LDB_OBJDIR 		= ldb_objdir

CKNODE			= $(CKDIR)/node_ck.c
NODEBOC 		= $(BOCDIR)/node_boc.c
NODEMAIN 		= $(MAINDIR)/node_main.c

NODE_DEPEND             = $(HEADERS)/chare.h  $(MACHINE)/machine.h $(HEADERS)/const.h $(HEADERS)/msg_macros.h $(HEADERS)/prio_macros.h $(HEADERS)/env_macros.h $(HEADERS)/node.globals.h $(COMMON_MEM)/mem.h  $(HEADERS)/sys_macros.h $(HEADERS)/communication.h $(HEADERS)/performance.h


OBJECTS = node_common.$(SUF) node_globals.$(SUF) node_init.$(SUF) \
	  register.$(SUF) node_boc.$(SUF) \
	  node_condsnd.$(SUF) node_qd.$(SUF) node_vid.$(SUF) node_read.$(SUF) \
	  node_stat.$(SUF) node_wrtone.$(SUF) \
	  node_acc.$(SUF) node_mono.$(SUF) node_tbl.$(SUF) 


ADDITIONAL_NORMAL_OBJECTS = node_main.$(SUF) node_ck.$(SUF) 
ADDITIONAL_REPLAY_OBJECTS = node_main_replay.$(SUF) node_ck_replay.$(SUF) 
ADDITIONAL_RECORD_OBJECTS = node_main.$(SUF) node_ck.$(SUF) 


all: ckobj.node.$(SUF) cplus.o $(ADDITIONAL_CHARM_OBJECTS)\
	$(ADDITIONAL_LOG_OBJECTS) converse.$(SUF) machine.$(SUF) \
	fifo.$(SUF) tempdumdecls.$(SUF) charmhost

machine.$(SUF) : machine.node.$(SUF) spantree.$(SUF) $(NODE_SOURCES)
	$(NODE_LD) machine.$(SUF) machine.node.$(SUF) spantree.$(SUF) $(NODE_SOURCES)
	chmod o+rx machine.$(SUF)
	cp machine.$(SUF) ck_objdir

ckobj.node.$(SUF)  :   $(OBJECTS)
	$(NODE_LD)  ckobj.node.$(SUF) $(OBJECTS) $(NODE_LDFLAGS) 
	chmod o+rx ckobj.node.$(SUF)
	cp ckobj.node.$(SUF) ck_objdir/ckobj.node.$(SUF) 

cplus.$(SUF) : $(CPLUS_NODE_SOURCES) dummy_cplus.o
	$(NODE_LD) cplus.$(SUF) $(CPLUS_NODE_SOURCES) $(NODE_LDFLAGS)
	chmod o+rx cplus.$(SUF)
	cp cplus.$(SUF) ck_objdir/cplus.$(SUF) 

node_normal.$(SUF):   $(ADDITIONAL_NORMAL_OBJECTS) default_main.$(SUF)
	$(NODE_LD)  node_normal.$(SUF) $(ADDITIONAL_NORMAL_OBJECTS) \
 				$(NODE_LDFLAGS) 
	chmod o+rx node_normal.$(SUF)
	cp node_normal.$(SUF) ck_objdir/node_normal.$(SUF) 

node_record.$(SUF):   $(ADDITIONAL_RECORD_OBJECTS) default_main.$(SUF)
	$(NODE_LD)  node_record.$(SUF) $(ADDITIONAL_RECORD_OBJECTS) \
 				$(NODE_LDFLAGS) 
	chmod o+rx node_record.$(SUF)
	cp node_record.$(SUF) ck_objdir/node_record.$(SUF) 

node_replay.$(SUF):   $(ADDITIONAL_REPLAY_OBJECTS) default_main.$(SUF)
	$(NODE_LD)  node_replay.$(SUF) $(ADDITIONAL_REPLAY_OBJECTS) \
 				$(NODE_LDFLAGS) 
	chmod o+rx node_replay.$(SUF)
	cp node_replay.$(SUF) ck_objdir/node_replay.$(SUF) 

machine.node.$(SUF): $(MACHINE)/machine.node.c $(NODE_DEPEND)
	$(NODE_CC)  $(MACHINE)/machine.node.c

spantree.$(SUF): $(MACHINE)/spantree.c $(NODE_DEPEND)
	$(NODE_CC)  $(MACHINE)/spantree.c

node_common.$(SUF): $(MAINDIR)/common.c $(NODE_DEPEND)
	$(NODE_CC)  $(MAINDIR)/common.c
	mv common.$(SUF) node_common.$(SUF)

node_globals.$(SUF): $(MAINDIR)/node_globals.c $(NODE_DEPEND)
	$(NODE_CC)  $(MAINDIR)/node_globals.c

node_init.$(SUF): $(INITDIR)/node_init.c $(NODE_DEPEND)
	$(NODE_CC)  $(INITDIR)/node_init.c

register.$(SUF): $(INITDIR)/register.c $(NODE_DEPEND)
	$(NODE_CC)  $(INITDIR)/register.c

default_main.$(SUF): $(INITDIR)/default_main.c $(NODE_DEPEND)
	$(NODE_CC)  $(INITDIR)/default_main.c

cplus_node_init.$(SUF): $(INITDIR)/cplus_node_init.c $(NODE_DEPEND) $(HEADERS)/c++interface.h
	$(NODE_C++)  $(INITDIR)/cplus_node_init.c

node_main.$(SUF): $(NODEMAIN)  $(NODE_DEPEND)
	$(NODE_CC)  $(NODEMAIN)

converse.$(SUF): $(MAINDIR)/converse.c
	$(NODE_CC)  $(MAINDIR)/converse.c

tempdumdecls.$(SUF): $(MAINDIR)/tempdumdecls.c
	$(NODE_CC)  $(MAINDIR)/tempdumdecls.c

dummy_cplus.$(SUF): $(MAINDIR)/dummy_cplus.c 
	$(NODE_CC) $(MAINDIR)/dummy_cplus.c 
	cp dummy_cplus.$(SUF) ck_objdir/dummy_cplus.$(SUF)

cplus_node_main.$(SUF): $(MAINDIR)/cplus_node_main.c  $(NODE_DEPEND) $(HEADERS)/c++interface.h
	$(NODE_C++) $(MAINDIR)/cplus_node_main.c 

node_ck.$(SUF): $(CKNODE) $(NODE_DEPEND)
	$(NODE_CC)  $(CKNODE)

cplus_node_ck.$(SUF): $(CKDIR)/cplus_node_ck.c $(NODE_DEPEND) $(HEADERS)/c++interface.h
	$(NODE_C++) $(CKDIR)/cplus_node_ck.c

node_boc.$(SUF): $(NODEBOC) $(BOCDIR)/boc_tables.c $(NODE_DEPEND)
	$(NODE_CC)  $(NODEBOC)

node_condsnd.$(SUF): $(CONDSDIR)/node_condsnd.c $(HEADERS)/condsend.h  \
			 $(NODE_DEPEND)
	$(NODE_CC)  $(CONDSDIR)/node_condsnd.c

node_qd.$(SUF): $(QUIESDIR)/node_qd.c $(HEADERS)/qd.h  $(NODE_DEPEND)
	$(NODE_CC)  $(QUIESDIR)/node_qd.c

node_vid.$(SUF): $(VIDDIR)/node_vid.c $(HEADERS)/vid.h \
			 $(NODE_DEPEND)
	$(NODE_CC)   $(VIDDIR)/node_vid.c

node_asend.$(SUF): $(MACHINE)/node_asend.c $(MACHINE)/asyncsend.c \
			 $(NODE_DEPEND)
	$(NODE_CC)   $(MACHINE)/node_asend.c

node_stat.$(SUF): $(STATDIR)/node_stat.c $(HEADERS)/stat.h \
			  $(NODE_DEPEND)
	$(NODE_CC)  $(STATDIR)/node_stat.c

node_read.$(SUF): $(PSEUDODIR)/node_read.c $(NODE_DEPEND)
	$(NODE_CC)   $(PSEUDODIR)/node_read.c

node_acc.$(SUF): $(PSEUDODIR)/node_acc.c $(HEADERS)/acc.h \
			 $(NODE_DEPEND)
	$(NODE_CC)   $(PSEUDODIR)/node_acc.c

cplus_node_acc.$(SUF): $(PSEUDODIR)/cplus_node_acc.c $(NODE_DEPEND) \
		       $(HEADERS)/c++interface.h $(HEADERS)/acc.h
	$(NODE_C++)  $(PSEUDODIR)/cplus_node_acc.c

node_mono.$(SUF): $(PSEUDODIR)/node_mono.c $(HEADERS)/mono.h \
			 $(NODE_DEPEND)
	$(NODE_CC)   $(PSEUDODIR)/node_mono.c

cplus_node_mono.$(SUF): $(PSEUDODIR)/cplus_node_mono.c $(NODE_DEPEND) \
			$(HEADERS)/c++interface.h $(HEADERS)/mono.h
	$(NODE_C++)  $(PSEUDODIR)/cplus_node_mono.c

node_tbl.$(SUF): $(PSEUDODIR)/node_tbl.c $(HEADERS)/tbl.h \
			 $(NODE_DEPEND)
	$(NODE_CC)   $(PSEUDODIR)/node_tbl.c

node_wrtone.$(SUF): $(PSEUDODIR)/node_wrtone.c $(HEADERS)/wrtone.h \
			 $(NODE_DEPEND)
	$(NODE_CC)   $(PSEUDODIR)/node_wrtone.c

fifo.$(SUF): $(FIFODIR)/fifo.c $(NODE_DEPEND)
	$(NODE_CC)   $(FIFODIR)/fifo.c

nothing.$(SUF): $(PERFDIR)/nothing.c $(HEADERS)/performance.h \
			 $(NODE_DEPEND)
	$(NODE_CC)   $(PERFDIR)/nothing.c
	cp nothing.$(SUF) ck_objdir/nothing.$(SUF)

summary.$(SUF): $(PERFDIR)/summary.c $(HEADERS)/performance.h  \
			 $(NODE_DEPEND)
	$(NODE_CC)   $(PERFDIR)/summary.c
	cp summary.$(SUF) ck_objdir/summary.$(SUF)

projections.$(SUF): $(PERFDIR)/projections.c $(PERFDIR)/io.c \
				$(HEADERS)/performance.h $(NODE_DEPEND)
	$(NODE_CC)   $(PERFDIR)/projections.c
	cp projections.$(SUF) ck_objdir/projections.$(SUF)

record.$(SUF): $(PERFDIR)/record.c $(PERFDIR)/io.c \
				$(HEADERS)/performance.h $(NODE_DEPEND)
	$(NODE_CC)   $(PERFDIR)/record.c
	cp record.$(SUF) ck_objdir/record.$(SUF)

replay.$(SUF): $(PERFDIR)/replay.c $(PERFDIR)/io.c \
				$(HEADERS)/performance.h $(NODE_DEPEND)
	$(NODE_CC)   $(PERFDIR)/replay.c
	cp replay.$(SUF) ck_objdir/replay.$(SUF)

node_qm_default.$(SUF): $(QMDIR)/qm.c $(NODE_DEPEND)
	$(NODE_CC)  $(QMDIR)/qm.c
	mv qm.$(SUF) node_qm_default.$(SUF)

node_qm_simple.$(SUF): $(QMDIR)/qm.simple.c $(NODE_DEPEND)
	$(NODE_CC)  $(QMDIR)/qm.simple.c
	mv qm.simple.$(SUF) node_qm_simple.$(SUF)

node_qm_easy.$(SUF): $(QMDIR)/qm.easy.c $(NODE_DEPEND)
	$(NODE_CC)  $(QMDIR)/qm.easy.c
	mv qm.easy.$(SUF) node_qm_easy.$(SUF)

node_qm_replay.$(SUF): $(QMDIR)/qm_replay.c  $(NODE_DEPEND)
	$(NODE_CC)  $(QMDIR)/qm_replay.c
	mv qm_replay.$(SUF) node_qm_replay.$(SUF)

node_main_replay.$(SUF): $(NODEMAIN)  $(NODE_DEPEND)
	cp $(NODEMAIN) node_main_replay.c
	$(NODE_CC) $(REPLAYING)  node_main_replay.c
	rm -f node_main_replay.c

node_ck_replay.$(SUF): $(CKNODE)  $(NODE_DEPEND)
	cp $(CKNODE) node_ck_replay.c
	$(NODE_CC) $(REPLAYING)  node_ck_replay.c
	rm -f node_ck_replay.c

# Next few files are for CM5
sendrecv.$(SUF): $(MACHINE)/sendrecv.c $(NODE_DEPEND)
	$(NODE_CC)  $(MACHINE)/sendrecv.c

broadcast.$(SUF): $(MACHINE)/broadcast.c $(NODE_DEPEND)
	$(NODE_CC)  $(MACHINE)/broadcast.c


clean:	
	rm -f *.o
	cd ck_objdir; rm -f *.o; cd ..
	cd qs_objdir; rm -f *.o; cd ..
	cd mem_objdir; rm -f *.o; cd ..
	cd ldb_objdir; rm -f *.o; cd ..

