############################################################################
# RCS INFORMATION:
#
# 	$RCSfile: common.ldb.Makefile,v $
# 	$Author: jyelon $	$Locker:  $		$State: Exp $
#	$Revision: 1.2 $	$Date: 1995/05/04 18:20:16 $
#
############################################################################
# DESCRIPTION:
#
############################################################################
# REVISION HISTORY:
#
# $Log: common.ldb.Makefile,v $
# Revision 1.2  1995/05/04  18:20:16  jyelon
# *** empty log message ***
#
# Revision 1.1  1994/11/07  16:07:50  brunner
# Initial revision
#
############################################################################
include ../path.mk
include ../machine.mk
include ../trace.mk


INCLUDES 			= -I. -I$(HEADERS)

LDB_ACWN 		= $(COMMON_LDB)/acwn
LDB_RANDOM 		= $(COMMON_LDB)/random
LDB_MANAGER		= $(COMMON_LDB)/manager
LDB_TOKEN		= $(COMMON_LDB)/token
LDB_REPLAY              = $(COMMON_LDB)/replay
LDB_RECV	= $(COMMON_LDB)/receiver


NODE_DEPEND             = $(HEADERS)/chare.h  $(MACHINE)/machine.h $(HEADERS)/const.h $(HEADERS)/msg_macros.h $(HEADERS)/prio_macros.h $(HEADERS)/env_macros.h $(HEADERS)/node.globals.h $(COMMON_MEM)/mem.h $(HEADERS)/sys_macros.h $(HEADERS)/communication.h



all: 		n_ldb.acwn.$(SUF) n_ldb.rand.$(SUF) \
		n_ldb.mngr.$(SUF)  n_ldb.prio_mngr.$(SUF) n_ldb.recv.$(SUF) \
		n_ldb.tok.$(SUF) n_ldb.btok.$(SUF) $(NODE_REPLAY_LDB)

n_ldb.acwn.$(SUF): 	$(LDB_ACWN)/node_ldb.c $(LDB_ACWN)/ldb.h $(NODE_DEPEND) 
			rm -f n_ldb.acwn.$(SUF) 
			$(NODE_CC)  $(LDB_ACWN)/node_ldb.c
			mv node_ldb.$(SUF) n_ldb.acwn.$(SUF)
			chmod o+rx n_ldb.acwn.$(SUF)


n_ldb.rand.$(SUF): 	$(LDB_RANDOM)/node_ldb.c $(LDB_RANDOM)/ldb.h $(NODE_DEPEND)
			rm -f n_ldb.rand.$(SUF) 
			$(NODE_CC)  $(LDB_RANDOM)/node_ldb.c
			mv node_ldb.$(SUF) n_ldb.rand.$(SUF)
			chmod o+rx n_ldb.rand.$(SUF)
		

n_ldb.mngr.$(SUF): 	$(LDB_MANAGER)/node_ldb.c $(LDB_MANAGER)/ldb.h $(NODE_DEPEND)
			rm -f n_ldb.mngr.$(SUF)
			$(NODE_CC)  $(LDB_MANAGER)/node_ldb.c
			mv node_ldb.$(SUF) n_ldb.mngr.$(SUF)
			chmod o+rx n_ldb.mngr.$(SUF)

n_ldb.prio_mngr.$(SUF): $(LDB_MANAGER)/node_ldb.c $(LDB_MANAGER)/ldb.h $(NODE_DEPEND)
			rm -f n_ldb.prio_mngr.$(SUF)
			$(NODE_CC) -DPRIORITY  $(LDB_MANAGER)/node_ldb.c
			mv node_ldb.$(SUF) n_ldb.prio_mngr.$(SUF)
			chmod o+rx n_ldb.prio_mngr.$(SUF)
		
n_ldb.tok.$(SUF): $(LDB_TOKEN)/node_ldb.c $(LDB_TOKEN)/ldb.h  $(NODE_DEPEND)
			rm -f n_ldb.tok.$(SUF)
			$(NODE_CC)  $(LDB_TOKEN)/node_ldb.c
			mv node_ldb.$(SUF) n_ldb.tok.$(SUF)
			chmod o+rx n_ldb.tok.$(SUF)
		
n_ldb.btok.$(SUF): $(LDB_TOKEN)/node_ldb.c $(LDB_TOKEN)/ldb.h  $(NODE_DEPEND)
			rm -f n_ldb.btok.$(SUF)
			$(NODE_CC)  -DBITVECTOR $(LDB_TOKEN)/node_ldb.c
			mv node_ldb.$(SUF) n_ldb.btok.$(SUF)
			chmod o+rx n_ldb.btok.$(SUF)
		
n_ldb.replay.$(SUF): $(LDB_REPLAY)/node_ldb.c $(LDB_REPLAY)/ldb.h $(NODE_DEPEND)
			rm -f n_ldb.replay.$(SUF)
			$(NODE_CC)  $(LDB_REPLAY)/node_ldb.c
			mv node_ldb.$(SUF) n_ldb.replay.$(SUF)
			chmod o+rx n_ldb.replay.$(SUF)

n_ldb.recv.$(SUF): $(LDB_RECV)/node_ldb.c $(LDB_RECV)/ldb.h $(NODE_DEPEND)
			rm -f n_ldb.recv.$(SUF)
			$(NODE_CC)  $(LDB_RECV)/node_ldb.c
			mv node_ldb.$(SUF) n_ldb.recv.$(SUF)
			chmod o+rx n_ldb.recv.$(SUF)

