/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: qs.c,v $
 *	$Author: narain $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/04/13 04:09:30 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: qs.c,v $
 * Revision 1.2  1995/04/13  04:09:30  narain
 * Mc -> Cmi
 *
 * Revision 1.1  1994/11/03  17:34:15  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /home/kale/milind/RCS/qs.c,v 1.2 1995/04/13 04:09:30 narain Exp $";
/* Replay Queue Strategy */
#include <stdio.h>
#include "chare.h"
#include "queue.h"

int required_pe, required_event;
int QUEUE_ELEM_SIZE = sizeof(QUEUE_ELEMENT);

#define hash(x,y) ((43*x+37*y)%MAX_QUEUE_LENGTH)

void *Qs_Create()
{
	int i;
	QUEUE *queue;

	queue            = (QUEUE *) CkAlloc(sizeof(QUEUE));
	queue->length    = 0;
	queue->maxlength = 0;
	for (i=0; i<MAX_QUEUE_LENGTH; i++)
		queue->list[i] = (QUEUE_ELEMENT *) NULL;

	return (void *) queue;
}



Qs_Length(queue)
QUEUE *queue;
{
	return queue->length;
}


Qs_MaxLength(queue)
QUEUE *queue;
{
	return queue->maxlength;
}



Qs_Empty(queue)
QUEUE *queue;
{
	int index;
	ENVELOPE *element;
	QUEUE_ELEMENT *qptr;

	determine_current_event(&required_event, &required_pe);

	check_it_out(queue, required_event, required_pe);

	index = hash(required_pe, required_event);
	qptr = queue->list[index];
	while (qptr != NULL)
	{
		element = ENVELOPE_QPTR(qptr);
		if ((element->event == required_event) &&
		    (element->pe == required_pe))
			return 0;
		else
			qptr = qptr->next;
	}
	return 1;
} 


Qs_EnQueue(queue,element)
QUEUE         *queue;
ENVELOPE      *element;
{
	int index;
	QUEUE_ELEMENT *qptr;

	qptr = QUEUE_ELEMENT_PTR(element);
	index = hash(element->pe, element->event);

	TRACE(CkPrintf("[%d] Enqueuing event=%d, pe=%d\n", CmiMyPe(), 
	element->event, element->pe));

	qptr->next = queue->list[index];
	queue->list[index] = qptr;

	queue->length++;
	if (queue->length > queue->maxlength) queue->maxlength = queue->length;
}


Qs_DeQueue(queue,element)
QUEUE         *queue;
ENVELOPE      **element;
{
	int index;
	QUEUE_ELEMENT *current, *previous;

	determine_current_event(&required_event, &required_pe);

	check_it_out(queue, required_event, required_pe);

	index = hash(required_pe, required_event);
	current = queue->list[index];
	previous = NULL;
	while (current != NULL)
	{
		*element = ENVELOPE_QPTR(current);
		if (((*element)->event==required_event) &&
			((*element)->pe==required_pe))
		{
			if (previous == NULL)
				queue->list[index] = current->next;
			else
				previous->next = current->next;
			current->next = NULL;
			break;
		}
		else
			current = current->next;
	}
	queue->length--;
}


PVECTOR *Qs_MyPriority(queue)
QUEUE *queue;
{
}


PVECTOR *Qs_MySecondPriority(queue)
QUEUE *queue;
{
}

give_me_a_break(queue, event, pe, required_event, required_pe)
QUEUE         *queue;
int event, pe, required_event, required_pe;
{
	if (required_event==event && required_pe==pe)
	{
		int i;
		ENVELOPE *e;
        	QUEUE_ELEMENT *qptr;

		CkPrintf("[%d] For event %d from %d\n", CmiMyPe(), event, pe);
		for (i=0; i<MAX_QUEUE_LENGTH; i++)
		{
        		qptr = queue->list[i];
        		while (qptr != NULL)
        		{
				e = ENVELOPE_QPTR(qptr); 
				CkPrintf("\tindex=%d, event=%d, pe=%d\n",
						i, e->event, e->pe);
                        	qptr = qptr->next;
			}
		}
	}
}

check_it_out(queue, required_event, required_pe)
QUEUE         *queue;
int required_event, required_pe;
{
return;
	give_me_a_break(queue, required_event, required_pe, 254, 12);
	give_me_a_break(queue, required_event, required_pe, 206, 6);
	give_me_a_break(queue, required_event, required_pe, 252, 13);
}
