/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: qs.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/03/27 19:11:09 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: qs.c,v $
 * Revision 1.2  1995/03/27  19:11:09  milind
 * Changed to include fixed size blocks and exchange on dequeue.
 *
 * Revision 1.1  1994/11/03  17:34:09  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /home/kale/milind/RCS/qs.c,v 1.2 1995/03/27 19:11:09 milind Exp $";
/* Random Queue Strategy */
#include <stdio.h>
#include "chare.h"
#include "queue.h"

static void **
AllocBlock(num)
int num;
{
	void **ptr;

	ptr = (void **) CkAlloc(sizeof(void *) * num);
	return ptr;
}


static void
SpillBlock(dest, src, len)
void **dest, **src;
unsigned int len;
{
	memcpy(dest, src, len*sizeof(void *));
}

void *CqsCreate()
{
	int i;
	QUEUE *queue;

	srand(10);
	queue            = (QUEUE *) CkAlloc(sizeof(QUEUE));
	queue->tail 	 = 0;
	queue->length    = 0;
	queue->maxlength = 0;
	for (i=0; i<MAX_QUEUE_LENGTH; i++)
	{
		queue->list[i].my_list_length = 0;
		queue->list[i].total_length = BLK_LEN;
		queue->list[i].my_list = AllocBlock(BLK_LEN);
	}
	return (void *) queue;
}



CqsLength(queue)
QUEUE *queue;
{
	return queue->length;
}


CqsMaxLength(queue)
QUEUE *queue;
{
	return queue->maxlength;
}



CqsEmpty(queue)
QUEUE *queue;
{
	return (queue->length == 0) ? TRUE : FALSE;
} 


CqsEnQueue(queue,element)
QUEUE         *queue;
void      *element;
{
	int index;

	if (queue->tail == MAX_QUEUE_LENGTH)
		index = rand() % MAX_QUEUE_LENGTH;
	else
		index = (queue->tail)++; 
	if(queue->list[index].my_list_length == queue->list[index].total_length)
	{
		void **blk = queue->list[index].my_list;
		queue->list[index].total_length *= 3;
		queue->list[index].my_list = 
			AllocBlock(queue->list[index].total_length);
		SpillBlock(queue->list[index].my_list, blk, 
				queue->list[index].my_list_length);
		CkFree(blk);
	}
	queue->list[index].my_list[queue->list[index].my_list_length] = element;
	(queue->list[index].my_list_length)++;

	queue->length++;
	if (queue->length > queue->maxlength) queue->maxlength = queue->length;
}


CqsDeQueue(queue,element)
QUEUE         *queue;
void      **element;
{
	int top_index;
	int bot_index;
	LIST_ELEMENT *mylist;

	top_index = rand() % queue->tail;

	mylist = &(queue->list[top_index]);
	bot_index = rand() % mylist->my_list_length;

	*element = mylist->my_list[bot_index];
	mylist->my_list[bot_index] = mylist->my_list[mylist->my_list_length-1];
	(mylist->my_list_length)--;

	if (mylist->my_list_length == 0)
	{
		int total_len;
		void **list;
		int index;

		list = mylist->my_list;
		total_len = mylist->total_length;
		index = queue->tail - 1;
		mylist->my_list = queue->list[index].my_list;
		mylist->my_list_length = queue->list[index].my_list_length;
		mylist->total_length = queue->list[index].total_length;
		queue->list[index].my_list = list;
		queue->list[index].my_list_length = 0;
		queue->list[index].total_length = total_len;
		(queue->tail)--;
	}
	queue->length--;
}


PVECTOR *CqsMyPriority(queue)
QUEUE *queue;
{
}


PVECTOR *CqsMySecondPriority(queue)
QUEUE *queue;
{
}
