/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: qs.c,v $
 *	$Author: narain $	$Locker:  $		$State: Exp $
 *	$Revision: 1.4 $	$Date: 1995/04/13 04:07:52 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: qs.c,v $
 * Revision 1.4  1995/04/13  04:07:52  narain
 * Mc -> Cmi
 *
 * Revision 1.3  1995/03/27  18:40:00  milind
 * Changed Names of all Qs_ functions to Cqs function.
 *
 * Revision 1.2  1995/03/27  18:26:14  milind
 * Modified functions for explicit priority
 *
 * Revision 1.1  1994/11/03  17:33:53  brunner
 * Initial revision
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /home/kale/milind/RCS/qs.c,v 1.4 1995/04/13 04:07:52 narain Exp $";
#include <stdio.h>
#include "chare.h"
#include "queue.h"
#include "bitvec_int_macros.c"

#define TRACEQS(p) 

/* 4294967295 corresponds to all ones for the bitvector corresponding
   to the integer for a 32 bit integer.		*/

#ifdef BITVECTOR 
PVECTOR QSLOWESTPRIO[8] = {
		4294967295, 4294967295, 4294967295, 4294967295, 
		4294967295, 4294967295, 4294967295, 4294967295 
		};
#else
unsigned int QSLOWESTPRIO[1] = { 4294967295};
#endif


int	QUEUE_ELEM_SIZE = sizeof(QUEUE_ELEMENT);

CqsLength(queue)
QUEUE *queue;
{
        return (queue->length);
}


CqsMaxLength(queue)
QUEUE *queue;
{
       return (queue->maxlength);
}

CqsMaxHeapLength(queue)
QUEUE *queue;
{
      return (queue->maxheaplength);
}




PVECTOR *CqsMyPriority(queue)
QUEUE *queue;
{
    PVECTOR *myHighestPriority;

    if (queue->HeapTop >= 0)
    {
	myHighestPriority = queue->Heap[0].stack_ptr->prioptr;
    }
    else
	myHighestPriority = QSLOWESTPRIO;

    return(myHighestPriority);
}


PVECTOR *CqsMySecondPriority(queue)
QUEUE *queue;
{
    PVECTOR *mySecondHighestPriority;

    if (queue->HeapTop >= 1)
    {
	mySecondHighestPriority = queue->Heap[1].stack_ptr->prioptr;
    }
    else
	mySecondHighestPriority = QSLOWESTPRIO;

    return(mySecondHighestPriority);
}






void *CqsCreate()
{
        int i;
        QUEUE *queue;
      
TRACEQS(CkPrintf("[%d] CqsCreate: Allocating QUEUE\n", CmiMyPe()));
        queue = (QUEUE *) CkAlloc(sizeof(QUEUE)); 
TRACEQS(CkPrintf("[%d] CqsCreate: Allocated QUEUE\n", CmiMyPe()));
	CkMemError(queue);
        
	queue->HeapTop         	= (-1);
	queue->length          	= 0;
	queue->maxlength  	= 0;
	queue->maxheaplength   	= (-1);

	for (i=0; i < MAXHEAPSIZE; i++)
	{
		queue->Heap[i].hash_ptr = NULL; 
		queue->Heap[i].stack_ptr = NULL;
	}

	for(i=0; i < INDEX; i++)
		queue->HashTable[i] = NULL;
	return (void *) queue;
}



CqsEmpty(queue)
QUEUE *queue;
{
    return (queue->HeapTop < 0);
}



CqsEnQueue(queue,element, prioptr, priolen)
QUEUE    *queue;
void *element;
PVECTOR *prioptr;
unsigned int priolen;
{

    	QUEUE_ELEMENT 	*mPtr;
	HASH_ELEMENT	*c_ht_elt, *l_ht_elt, *ht_element, *sent_element;
	PVECTOR		*b_vec, *bit_vec, *hash_elt_priority;
	int		index_1, vector_size, hash_vec_size;
	int		vector_length;

	mPtr = (QUEUE_ELEMENT *) CkAlloc(sizeof(QUEUE_ELEMENT));
	mPtr->mesg = element;
	mPtr->prioptr = prioptr;
	mPtr->priolen = priolen;
	bit_vec = prioptr;


        queue->length++;
        if ( queue->length > queue->maxlength)
		queue->maxlength = queue->length;



	/* hash table index is the MOD of 8191 */
        HASH_FUNCTION  /* defined in qs_bitvec_macros */

/*
TRACEQS(CkPrintf("hash table index_1 = %d\n", index_1));
*/

	if( queue->HashTable[ index_1 ] == NULL )
	{
			NEWHASHELEMENT(sent_element,NULL,0,NULL);
			INSERT_HASHTABLE(index_1,sent_element);
/*
TRACEQS(CkPrintf("hash entry sentinel element put\n"));
*/
	}

	if(queue->HashTable[ index_1 ]->next_htlist_element == NULL)
	{
		NEWHASHELEMENT(ht_element,bit_vec,priolen,queue->HashTable[index_1]);
		InsertHeapMsg(queue,ht_element);
		INSERT_HASHTABLE(index_1,ht_element);
		INSERT_HEAP_GOAL_STACK(ht_element, mPtr);
		mPtr->next = NULL;

/*
TRACEQS(CkPrintf("system msg inserted in an empty hash table entry ----------------\n"));
*/
	}
	else
	{
	   c_ht_elt = queue->HashTable[ index_1 ];

	   while( (c_ht_elt->next_htlist_element != NULL) &&
	          (NotEqual(c_ht_elt->priority_vector,c_ht_elt->priolen,bit_vec,priolen) == TRUE ) )
	      {
		l_ht_elt = c_ht_elt;
		c_ht_elt = c_ht_elt->next_htlist_element;
       	      }

           if (c_ht_elt->next_htlist_element == NULL) 
	      {
		NEWHASHELEMENT(ht_element,bit_vec,priolen,queue->HashTable[index_1]);
	        InsertHeapMsg(queue,ht_element);
		INSERT_HASHTABLE(index_1,ht_element);
		INSERT_HEAP_GOAL_STACK(ht_element, mPtr);
		mPtr->next = NULL;
	      }
	   else
              {
		mPtr->next = (c_ht_elt->heap_ptr)->stack_ptr;
		INSERT_HEAP_GOAL_STACK(c_ht_elt, mPtr);
/*
TRACEQS(CkPrintf("system msg inserted top of an existing stack\n"));
*/
	      }
	}

/*
TRACEQS(CkPrintf("\n"));
*/
}





/* remove the top of stack from the top element of the heap and return
   a pointer to the stack element removed.
   if the top of stack is the last element then reorganize the heap
   and delete the hash table list element from the chain of the hash
   table */

CqsDeQueue(queue,element)
QUEUE    *queue;
ENVELOPE **element;
{

	HASH_ELEMENT	*ht_ptr;
	QUEUE_ELEMENT	*ptr;

    TRACE(CkPrintf("in CqsDeQueue: queue->Heap[0].stack_ptr = 0x%x\n", queue->Heap[0].stack_ptr));

	*element = queue->Heap[0].stack_ptr->mesg;
	ptr = queue->Heap[0].stack_ptr ;
	queue->Heap[0].stack_ptr=(queue->Heap[0].stack_ptr)->next;
	queue->length--;
	CkFree(ptr);

	/* if queue->Heap[0] stack becomes empty then reorganize the heap */
	if ( queue->Heap[0].stack_ptr == NULL ) 
	{
		ht_ptr = queue->Heap[0].hash_ptr;
		ht_ptr->priority_vector = NULL;
		ht_ptr->priolen = 0;
		RestoreHeap(queue);
		RemoveHashTableElt(ht_ptr);
	} 
	else
	{
		(queue->Heap[0].hash_ptr)->priority_vector = queue->Heap[0].stack_ptr->prioptr;
		(queue->Heap[0].hash_ptr)->priolen = queue->Heap[0].stack_ptr->priolen;
	}
}




/* insert a new hash table list element pointed by p into the heap */
InsertHeapMsg(queue,p)
QUEUE           *queue;
HASH_ELEMENT	*p;
{

	int parent, child;

	queue->HeapTop++;
        if ( queue->HeapTop > queue->maxheaplength)
		queue->maxheaplength = queue->HeapTop;

	if (queue->HeapTop >= MAXHEAPSIZE)
		{CkPrintf("CHARE HEAP OVERFLOW: Need A Larger Heap Than %d\n", MAXHEAPSIZE);
		 exit(1);}

	child = queue->HeapTop;
	parent = (queue->HeapTop-1) >> 1; /* array starts at zero */

	/* while child >0 & parent bit vector >= p->bit vector */
	while ( (child > 0) && 
		( GreaterThan((queue->Heap[parent].hash_ptr)->priority_vector, 
				(queue->Heap[parent].hash_ptr)->priolen,
					p->priority_vector, p->priolen ) ) ) {
		queue->Heap[child].hash_ptr = queue->Heap[parent].hash_ptr;
		queue->Heap[child].stack_ptr = queue->Heap[parent].stack_ptr;
		(queue->Heap[child].hash_ptr)->heap_ptr = &(queue->Heap[child]);

		child = parent;
		parent = (parent-1) >> 1; /* array starts at zero */
	}
	queue->Heap[child].hash_ptr = p;
	p->heap_ptr = &(queue->Heap[child]);

}


/* reorganize the heap */
RestoreHeap(queue)
QUEUE *queue;
{

	QUEUE_ELEMENT	*temp_stack_ptr;
	HASH_ELEMENT	*temp_hash_ptr;
	int 		parent=0, child1=1, child2=2, min;
	int		NotDone=1, last_item;

	last_item = queue->HeapTop;
   	queue->HeapTop--;

	switch (last_item)
	{
	case 0 :
	   	queue->Heap[0].hash_ptr = NULL;
	   	queue->Heap[0].stack_ptr = NULL;
		break;

	case 1 :
		queue->Heap[0].hash_ptr = queue->Heap[1].hash_ptr;
		(queue->Heap[0].hash_ptr)->heap_ptr = &(queue->Heap[0]);
		queue->Heap[0].stack_ptr = queue->Heap[1].stack_ptr;

	   	queue->Heap[1].hash_ptr = NULL;
	   	queue->Heap[1].stack_ptr = NULL;
		break;

	default :
	   temp_hash_ptr = queue->Heap[last_item].hash_ptr;
	   temp_stack_ptr = queue->Heap[last_item].stack_ptr;
	   queue->Heap[last_item].hash_ptr = NULL;
	   queue->Heap[last_item].stack_ptr = NULL;

	   while ( child1 <= queue->HeapTop && NotDone==1 )
	   {
		min = child1;
		if((child2 <= queue->HeapTop) && 
	          (GreaterThan((queue->Heap[child1].hash_ptr)->priority_vector,
				(queue->Heap[child1].hash_ptr)->priolen,
		      (queue->Heap[child2].hash_ptr)->priority_vector,
		      (queue->Heap[child2].hash_ptr)->priolen) ) )
		   min = child2;

		if ( GreaterThan(temp_hash_ptr->priority_vector,
				temp_hash_ptr->priolen,
		     (queue->Heap[min].hash_ptr)->priority_vector,
		     (queue->Heap[min].hash_ptr)->priolen) ) 
		{
		   queue->Heap[parent].hash_ptr = queue->Heap[min].hash_ptr;
		   (queue->Heap[parent].hash_ptr)->heap_ptr  =  
                                                   &(queue->Heap[parent]);
		   queue->Heap[parent].stack_ptr = queue->Heap[min].stack_ptr;

		   parent = min;
	   	   child2 = (parent +1) << 1;
	   	   child1 = child2 - 1;
		}
		else  
		   NotDone = 0;
	   } /* while */
	   queue->Heap[parent].hash_ptr = temp_hash_ptr;
	   (queue->Heap[parent].hash_ptr)->heap_ptr = &queue->Heap[parent];
	   queue->Heap[parent].stack_ptr = temp_stack_ptr;

	} /* switch */
}



/* remove the hash table list element pointed by ht_ptr from the chain of hash
   table list elements */
RemoveHashTableElt(ht_ptr)
HASH_ELEMENT	*ht_ptr;
{

	HASH_ELEMENT	*c_ht_elt, *n_ht_elt;

	c_ht_elt = ht_ptr;
	n_ht_elt = ht_ptr->next_htlist_element;

	if ( n_ht_elt->next_htlist_element == NULL )
	{
		c_ht_elt->next_htlist_element = NULL;
		c_ht_elt->priority_vector = NULL;
		c_ht_elt->priolen = 0;
		c_ht_elt->heap_ptr = NULL;
		CkFree(n_ht_elt);
	}
	else
	{
		c_ht_elt->priority_vector = n_ht_elt->priority_vector;
		c_ht_elt->priolen = n_ht_elt->priolen;
		c_ht_elt->next_htlist_element = n_ht_elt->next_htlist_element;
		c_ht_elt->heap_ptr = n_ht_elt->heap_ptr;
		(c_ht_elt->heap_ptr)->hash_ptr = c_ht_elt;
		CkFree(n_ht_elt);
	}
}



