/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: bitvec_int_macros.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/03/27 18:12:29 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: bitvec_int_macros.c,v $
 * Revision 1.3  1995/03/27  18:12:29  milind
 * Modified macros for explicit priorities.
 *
 * Revision 1.2  1994/11/11  21:25:22  brunner
 * Remove "static char ident..." which is already in the file which
 * includes this one.
 *
 * Revision 1.1  1994/11/03  17:34:05  brunner
 * Initial revision
 *
 ***************************************************************************/

/************************************************************************/
/*									*/
/*	       Queueing Strategy Malloc Macro definitions		*/
/*									*/
/************************************************************************/

/*************** CkAlloc & CkFree defined in mem.c **********************/

#define QsAlloc(Ptr,Size,Type)		Ptr = (Type *) CkAlloc(Size)
#define QsFree(ptr,size)		CkFree(ptr)

#define INSERT_PVECTOR(ptr, priority_vector1)\
	ptr->priority_vector = priority_vector1

#define INSERT_PLEN(ptr, plen)\
	ptr->priolen = plen

#define INSERT_HEAP_PTR(ptr, heap_ptr1)\
	ptr->heap_ptr = heap_ptr1

#define INSERT_NEXT_HTLIST_PTR(ptr, next_ht_ptr)\
	ptr->next_htlist_element = next_ht_ptr

#define INSERT_HASHTABLE(index_i, ptr)\
	queue->HashTable[index_i] = ptr

#define INSERT_HEAP_GOAL_STACK(ptr, stack_elt)\
	(ptr->heap_ptr)->stack_ptr = stack_elt


#define NEWHASHELEMENT(ht_element, vector_ptr, plen, next_ptr)\
	{\
	QsAlloc(ht_element,sizeof(HASH_ELEMENT),HASH_ELEMENT);\
	INSERT_PVECTOR(ht_element, vector_ptr);\
	INSERT_PLEN(ht_element, plen);\
	INSERT_NEXT_HTLIST_PTR(ht_element, next_ptr);\
	}


/************************************************************************/
/* Hash function, GreaterThan function, NotEqual Function definitions	*/
/* for bitvector and integer priorities.				*/
/************************************************************************/

#ifdef BITVECTOR
#define HASH_FUNCTION  index_1 = (*bit_vec & 0x0ffffff); \
	vector_size = priolen; \
	if ( vector_size > 1 ) \
	  for (b_vec=bit_vec, b_vec++; b_vec<bit_vec+vector_size; b_vec++)\
		index_1 = ( index_1 ^ (*b_vec) ); \
	if (index_1 < 0)  \
		index_1 = (-index_1); \
	index_1 = index_1 % 8191;
#else
#define HASH_FUNCTION      index_1 = *bit_vec % 8191;
#endif
/* define GreaterThan(), NotEqual(), PrioritySize() */
#ifdef BITVECTOR

/* if bit vector pointed by p > bit vector pointed by q return TRUE else
   return FALSE */
int GreaterThan(p,plen, q,qlen)
unsigned *p, *q;
unsigned int plen, qlen;
{
	unsigned	*p_ptr, *q_ptr;
	int		p_size, q_size, max_size, min_size, count;

	/* compare the first words */
	if ( (*p & 0x0ffffff) > (*q & 0x0ffffff) )
		return(TRUE);

	if ( (*p & 0x0ffffff) < (*q & 0x0ffffff) )
		return(FALSE);

	/* Proceed since the first words are Equal */
	p_ptr = p;
	q_ptr = q;
#if 0
	/* get vector sizes */
	if ( (*p_ptr >> 24) > 24 )
		p_size = (( (*p_ptr >> 24) - 25) >> 5) + 2;
	else
		p_size = 1;

	if ( (*q_ptr >> 24) > 24 )
		q_size = (( (*q_ptr >> 24) - 25) >> 5) + 2;
	else
		q_size = 1;
#endif
	p_size = plen;
	q_size = qlen;
	if ( p_size > q_size ) 
	{
		min_size = q_size;
		max_size = p_size;
	}
	else
	{
		min_size = p_size;
		max_size = q_size;
	}

	/* go to the 2nd word */
	p_ptr++;
	q_ptr++;
	count = 2;

	while ( (count <= min_size) && (*p_ptr == *q_ptr) )
	{
		p_ptr++;
		q_ptr++;
		count++;
	}

	if ( count <= min_size )
	{
		if ( *p_ptr > *q_ptr )
			return(TRUE);
		else
			return(FALSE);
	}
	else
	{
	    if ( count > max_size )
		return(FALSE);
	    else
	    {
		if ( max_size == p_size )
			while( count <= max_size )
			{
			   if ( *p_ptr != 0 )
				return(TRUE);
			   else
			   {
				p_ptr++;
				count++;
			   }
			}
		else
			while( count <= max_size )
			{
			   if ( *q_ptr != 0 )
				return(FALSE);
			   else
			   {
				q_ptr++;
				count++;
			   }
			}

		if ( count > max_size )
			return(FALSE);
	    }

	}

}


/* if bit vector pointed by p > bit vector pointed by q return TRUE else
   return FALSE */
int NotEqual(p,plen, q,qlen)
unsigned *p, *q;
unsigned int plen, qlen;
{
	unsigned	*p_ptr, *q_ptr;
	int		p_size, q_size, max_size, min_size, count;

	/* compare the first words */
	if ( (*p & 0x0ffffff) != (*q & 0x0ffffff) )
		return(TRUE);

	/* Proceed since the first words are Equal */
	p_ptr = p;
	q_ptr = q;
#if 0
	/* get vector sizes */
	if ( (*p_ptr >> 24) > 24 )
		p_size = (( (*p_ptr >> 24) - 25) >> 5) + 2;
	else
		p_size = 1;

	if ( (*q_ptr >> 24) > 24 )
		q_size = (( (*q_ptr >> 24) - 25) >> 5) + 2;
	else
		q_size = 1;
#endif
	p_size = plen;
	q_size = qlen;
	if ( p_size > q_size ) 
	{
		min_size = q_size;
		max_size = p_size;
	}
	else
	{
		min_size = p_size;
		max_size = q_size;
	}

	/* go to the 2nd word */
	p_ptr++;
	q_ptr++;
	count = 2;

	while ( (count <= min_size) && (*p_ptr == *q_ptr) )
	{
		p_ptr++;
		q_ptr++;
		count++;
	}

	if ( count <= min_size )
		return(TRUE);
	else
	{
	    if ( count > max_size )
		return(FALSE);
	    else
	    {
		if ( max_size == p_size )
		{
			while( count <= max_size )
			{
			   if ( *p_ptr != 0 )
				return(TRUE);
			   else
			   {
				p_ptr++;
				count++;
			   }
			}
		}
		else
		{
			while( count <= max_size )
			{
			   if ( *q_ptr != 0 )
				return(TRUE);
			   else
			   {
				q_ptr++;
				count++;
			   }
			}
		}

		if ( count > max_size )
			return(FALSE);
	    }

	}

}


#if 0
int PrioritySize(priority)
int *priority;
{  
    if ( (*priority >> 24) > 24)
       return ( ((((*priority >> 24) - 25) >> 5) +2) << 2);
    else 
       return(4);
}
#endif



#else

int GreaterThan(p,q)
unsigned *p, *q;
{
    return (*p > *q);
}

AssignPriority(p, q)
unsigned int p, q;
{
  	p = q; 
}

int NotEqual(p,q)
unsigned *p, *q;
{
    return (*p != *q);
}


#if 0
PrioritySize(priority)
int *priority;
{  
    return 4; 
}
#endif

#endif


int	qs_vector_size( vector_ptr )
unsigned	*vector_ptr;
{
	int	k;

	if ( (*vector_ptr >> 24) > 24 )
		k = (((*vector_ptr >> 24) - 25) >> 5) + 2;
	else
		k = 1;

	return(k);
}


qs_copy_vector(vector1_ptr, vector2_ptr)
unsigned 	*vector1_ptr, *vector2_ptr;
{
	unsigned	vector1_length, *p_ptr, *c_ptr;
	int		vector1_size;

	p_ptr = vector1_ptr;
	c_ptr = vector2_ptr;
	vector1_length = (*p_ptr >> 24) & 0x0ff;

	if ( vector1_length > 24 )
		vector1_size = ((vector1_length-25) >> 5) + 2;
	else
		vector1_size = 1;

        for (p_ptr=vector1_ptr;p_ptr<(vector1_ptr+vector1_size);p_ptr++,c_ptr++)
		*c_ptr = *p_ptr;
}



qs_print_sys_vector(vector_ptr)
unsigned	*vector_ptr;
{
	unsigned	*ptr, vector_length;
	int		vector_size;

	vector_length = (*vector_ptr >> 24) & 0x0ff;

	if ( vector_length <= 24 )
		vector_size = 1;
	else
		vector_size = ((vector_length - 25) >> 5) + 2;

	CkPrintf("QS:SysVec Length = %d, Size = %d\n",vector_length,vector_size);
	CkPrintf("QS:SysVec: ");
	for (ptr=vector_ptr; ptr < vector_ptr+vector_size; ptr++)
		CkPrintf("%x %o\t", ptr, *ptr);

	CkPrintf("\n");
}


qs_print_bit_vector(vector_ptr)
unsigned	*vector_ptr;
{
	unsigned	*ptr, vector_length;
	int		vector_size;

	vector_length = (*vector_ptr >> 24) & 0x0ff;

	if ( vector_length <= 24 )
		vector_size = 1;
	else
		vector_size = ((vector_length - 25) >> 5) + 2;

	CkPrintf("Priority = ");
	for (ptr=vector_ptr; ptr < vector_ptr+vector_size; ptr++)
		CkPrintf("%o\t", *ptr);

	CkPrintf("\n");
}
