/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: qs.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.5 $	$Date: 1995/04/13 21:40:10 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: qs.c,v $
 * Revision 1.5  1995/04/13  21:40:10  milind
 * changed blklen to blk_len in queue->blklen refs.
 *
 * Revision 1.4  1995/04/13  03:09:59  milind
 * removed the first++ bug.
 *
 * Revision 1.3  1995/03/26  03:28:50  milind
 * Fixed two bugs.
 *
 * Revision 1.2  1995/03/24  20:45:01  milind
 * common functions for fifo/lifo/fifolifo
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /home/kale/milind/RCS/qs.c,v 1.5 1995/04/13 21:40:10 milind Exp $";
#include "chare.h"
#include "queue.h"

#define Threshold 20

static Element **
AllocBlock(len)
unsigned int len;
{
	Element ** blk;

	blk = (Element **) AllocFn(len*sizeof(Element *));
	AllocErrorFn(blk);
	return blk;
}

static void
SpillBlock(srcblk, destblk, first, len)
Element **srcblk, **destblk;
unsigned int first, len;
{
	memcpy(destblk, &srcblk[first], (len-first)*sizeof(Element *));
	memcpy(&destblk[len-first],srcblk,first*sizeof(Element *));
}

Queue *
QueueCreate()
{
	Queue *queue;

	queue = (Queue *) AllocFn(sizeof(Queue));
	AllocErrorFn(queue);
	queue->blk = AllocBlock(BLK_LEN);
	queue->blk_len = BLK_LEN;
	queue->first = 0;
	queue->len = 0;
	queue->maxlen = 0;
	return queue;
}

unsigned int
QueueLength(queue)
Queue *queue;
{
	return queue->len;
}

unsigned int
QueueMaxLength(queue)
Queue *queue;
{
	return queue->maxlen;
}

Boolean
QueueEmpty(queue)
Queue *queue;
{
	return (queue->len==0);
}

void
QueueAddToBack(queue, element)
Queue *queue;
Element *element;
{
	if(queue->len==queue->blk_len)
	{
		Element **blk;

		queue->blk_len *= 3;
		blk = AllocBlock(queue->blk_len);
		SpillBlock(queue->blk, blk, queue->first, queue->len);
		FreeFn(queue->blk);
		queue->blk = blk;
		queue->first = 0;
	}
	queue->blk[(queue->first+queue->len++)%queue->blk_len] = element;
	if(queue->len>queue->maxlen)
		queue->maxlen = queue->len;
}

void
QueueAddToFront(queue, element)
Queue *queue;
Element *element;
{
	if(queue->len==queue->blk_len)
	{
		Element **blk;

		queue->blk_len *= 3;
		blk = AllocBlock(queue->blk_len);
		SpillBlock(queue->blk, blk, queue->first, queue->len);
		FreeFn(queue->blk);
		queue->blk = blk;
		queue->first = 0;
	}
	queue->first = (queue->first + queue->blk_len - 1) % queue->blk_len;
	queue->len++;
	queue->blk[queue->first] = element;
	if(queue->len>queue->maxlen)
		queue->maxlen = queue->len;
}

void
QueueRemoveFromBack(queue, element)
Queue *queue;
Element **element;
{
	*element = (Element *) 0;
	if(queue->len)
		*element=queue->blk[(queue->first+queue->len--)%queue->blk_len];
}

void
QueueRemoveFromFront(queue, element)
Queue *queue;
Element **element;
{
	*element = (Element *) 0;
	if(queue->len)
	{
		*element = queue->blk[queue->first--];
		queue->first = (queue->first+queue->blk_len)%queue->blk_len;
		queue->len--;
	}
}

PVECTOR *
QueueMyPriority(queue)
Queue *queue;
{
}

PVECTOR *
QueueMySecondPriority(queue)
Queue *queue;
{
}

void
CqsEnqueue(queue, element)
Queue *queue;
Element *element;
{
	if (queue->len < Threshold)
		QueueAddToBack(queue, element);
	else
		QueueAddToFront(queue, element);
}
