/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: generic_acc_hist.p,v $
 *	$Author: brunner $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/10/17 15:52:37 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: generic_acc_hist.p,v $
 * Revision 1.1  1994/10/17  15:52:37  brunner
 * Initial revision
 *
 ***************************************************************************/

#ifdef INT
#include "iacc_hist.int"
#define Module IHistogram
#define AccName IHistAcc
#endif

#ifdef FLOAT
#include "facc_hist.int"
#define Module FHistogram
#define AccName FHistAcc
#endif

#ifdef DOUBLE
#include "dacc_hist.int"
#define Module DHistogram
#define AccName DHistAcc
#endif

module Module {

#ifdef INT
#define GenericMsg 	MSG
#define GenericType	int
message {
	int size;
    	varSize int  data[];
} MSG;
#endif

#ifdef FLOAT
#define GenericMsg 	MSG
#define GenericType	float
message {
	int size;
    	varSize float  data[];
} MSG;
#endif

#ifdef DOUBLE
#define GenericMsg 	MSG
#define GenericType	double
message {
	int size;
    	varSize double  data[];
} MSG;
#endif

message {
	int data;
} DataMsg;

accumulator {

	GenericMsg *msg;

	GenericMsg *initfn (x)
	DataMsg *x;
	{
		int i;
		int sizes[1];

		sizes[0] = x->data;
		msg = (GenericMsg *) CkAllocMsg(GenericMsg, sizes);
		msg->size = x->data;
		for (i=0; i<msg->size; i++)
			msg->data[i] = (GenericType) 0;
		return(msg);
	}
	
	addfn (x, y)
	int x;
	GenericType y;
	{
		msg->data[x] += y;
	}

	combinefn (y)
	GenericMsg *y;
	{
		int 	i;
		for (i=0; i<msg->size; i++)
			msg->data[i] += y->data[i];
	}

} AccName;



Create(n)
int n;
{
	DataMsg *msg;

	msg = (DataMsg *) CkAllocMsg(DataMsg);
	msg->data = n;
	return(CreateAcc(AccName, msg));
}

Add(id, i, j)
int id; 
int i;
GenericType j;
{	
    	Accumulate(id, addfn(i, j));
}

Collect(id, ep, cid)
int id;
int ep;
ChareIDType *cid;
{
  	CollectValue(id, ep, cid);
}

}
