/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: generic_acc.p,v $
 *	$Author: brunner $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/10/17 15:52:37 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: generic_acc.p,v $
 * Revision 1.1  1994/10/17  15:52:37  brunner
 * Initial revision
 *
 ***************************************************************************/

#ifdef INT
#include "iacc_count.int"
#define Module		ICount
#define AccName		IAcc
#endif

#ifdef FLOAT
#include "facc_count.int"
#define Module		FCount
#define AccName		FAcc
#endif

#ifdef DOUBLE
#include "dacc_count.int"
#define Module		DCount
#define AccName		DAcc
#endif

module Module {

#ifdef INT
#define GenericMsg 	MSG
#define GenericType 	int 
message {
    	int 	data;
} MSG;
#endif

#ifdef FLOAT 
#define GenericMsg 	MSG
#define GenericType 	float
message {
    	float data;
} MSG;
#endif

#ifdef DOUBLE
#define GenericMsg 	MSG
#define GenericType	double
message {
    	double data;
} MSG;
#endif


accumulator {

	GenericMsg *msg;

	GenericMsg *initfn(x)
	GenericMsg *x;
	{
		msg = (GenericMsg *) CkAllocMsg(GenericMsg);
		msg->data = (GenericType) 0;
		return(msg);
	}

	addfn (x)
	GenericType x;
	{
		msg->data +=x;
	}

	combinefn (y)
	GenericMsg *y;
	{
		msg->data += y->data;
	}
}  AccName;


Create()
{
	GenericMsg *msg;

	msg = (GenericMsg *) CkAllocMsg(GenericMsg);
	return(CreateAcc(AccName, msg));
}

Add(id, i)
int id; 
GenericType i;
{	
    	Accumulate(id, addfn(i));
}

Collect(id, ep, cid)
int id;
int ep;
ChareIDType *cid;
{
  	CollectValue(id, ep, cid);
}

}
