/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: FirstCut.p,v $
 *	$Author: brunner $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/10/14 21:56:25 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: FirstCut.p,v $
 * Revision 1.1  1994/10/14  21:56:25  brunner
 * Initial revision
 *
 ***************************************************************************/

module Nqueens {
#include <strings.h>

#define N 10

readonly int grain;

message { int nextRow;
          int Queens[N];  
} PartialBoard;

chare main {

  entry DataInit: 
  { CkScanf("%d", &grain);
    ReadInit(grain); }

  entry ChareInit:
  { PartialBoard * pMsg ;
    pMsg = (PartialBoard *) CkAllocMsg(PartialBoard);
    pMsg->nextRow = 0;
    CreateChare(queens, queens@NewBoard, pMsg);  }

  entry QUIESCENCE: 
  {  CkPrintf("All Solutions reported. time = %d\n", CkTimer());
     CkExit();
  }
}

chare queens {
  /* No local variables */
  entry NewBoard: (message PartialBoard *m)
    { int col,i, row;
      PartialBoard * newMsg;
      row = m->nextRow;
      if (row == N) printSolution(m->Queens);
      else if ( (N-row) < ReadValue(grain)) seqQueens(m->Queens, row); 
      else
	for (col = 0; col<N; col++) 
	  if (consistent(m->Queens, row, col)) {
	    newMsg = (PartialBoard *) CkAllocMsg(PartialBoard);
	    newMsg->nextRow = row + 1;
	    for (i = 0; i < N; i++) newMsg->Queens[i] = m->Queens[i];
	    newMsg->Queens[row] = col;
	    CreateChare(queens, queens@NewBoard, newMsg);  }
      CkFreeMsg(m); 
      ChareExit(); 
    }
}

seqQueens(queens, nextRow)
 int queens[], nextRow;
{ int col;
  if (nextRow == N) { printSolution(queens); return; }
  for (col = 0; col<N; col++) 
    if (consistent(queens, nextRow, col)) {
      queens[nextRow] = col;
      seqQueens(queens, nextRow+1);}
}

int consistent(queens, lastRow, col)
 int queens[], lastRow, col;
{ /* check if the new queen is safe from each of the previously placed queens */
  int x,y;
  for (x=0; x<lastRow; x++)
    { y = queens[x];
      if ((y==col)  || ((lastRow-x) == (col-y)) || ((lastRow-x) == (y-col)) )
	return(0);}
  return(1);
}

printSolution(queens)
int queens[];
{ int row;
  char buf[80], tmp[80];

   buf[0] = '\0';
     for (row=0; row<N; row++)
       { sprintf(tmp, "(%d,%d) ", row, queens[row]);
         strcat(buf, tmp);}
     CkPrintf("%s\n", buf);


}
}

