/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: jacobi.p,v $
 *	$Author: brunner $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/10/14 21:40:54 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: jacobi.p,v $
 * Revision 1.1  1994/10/14  21:40:54  brunner
 * Initial revision
 *
 ***************************************************************************/

#include "jacobi.int"
#include "fmaxredn.int"
module Jacobi {
#define n          4   /* nxn is the size of the sub-domain */
#define THRESHOLD        1e-4
#define EAST  0
#define WEST  1
#define NORTH 2
#define SOUTH 3
#define TRUE  1
#define FALSE 0
message { ChareNumType redn;}  DOMAINInit;
message { int from;  float boundary[n+2]; }  BOUNDARY;

BranchOffice domain {
       float P[n+2][n+2],Q[n+2][n+2];
       float localMax[2];
       int   count,numOfNeighbours;
       int   reductionDone;
       int   valid[4], penum, ref;
       int   K;                          /* KxK is the number of processors */
       ChareNumType redn, mybocid; 
       
       entry BranchInit: (message DOMAINInit *msg)
         {   private void initialize() ;
	     private void sendBoundaries() ;

	     redn = msg->redn;
             CkFreeMsg(msg);
             mybocid = MyBocNum();
             PrivateCall(initialize());
             PrivateCall(sendBoundaries());
             count = numOfNeighbours;
             reductionDone = TRUE;  }

       entry recvBoundary : (message BOUNDARY *msg)
         {   private void iterate();
	     private void copyBoundary() ;
             PrivateCall(copyBoundary(msg->from,msg->boundary));
             CkFreeMsg(msg);
             if (--count == 0 && reductionDone) PrivateCall(iterate());  }

       private void iterate()
         {   static int update();
             static int localMaximum();
             update(P,Q);
             localMaximum( &(localMax[0]), &(localMax[1]),P,Q);
             reductionDone = FALSE;
             count = numOfNeighbours;
	     ref++ ;
             FMaxRedn::DepositData(redn, localMax, localMax, 2, ref, recvReduction, &mybocid);  } 

#define relError(x,y) ((y>0) ? x/y : x)
       public recvReduction() 
         { static int copyP();
           static int result();
	   private void sendBoundaries() ;
	   private void iterate() ;
           if (relError(localMax[0],localMax[1])  < THRESHOLD )
                result(penum,K,P);
           else { reductionDone = TRUE;
                  copyP(P,Q);
                  PrivateCall(sendBoundaries());
                  if (count == 0) PrivateCall(iterate()); } }

       private void initialize() 
         {   int i,j,posi,posj, Pe;
             extern double sqrt();
             penum = McMyPeNum();
             Pe = McTotalNumPe(); K  = (int) sqrt((double) Pe); 
	     ref = 50 ;
             if (K*K != Pe) { CkPrintf("error. The number of processors must be a square.\n");
                              CkExit();}
             posi  = penum / K;   posj  = penum % K; 
             numOfNeighbours = 4; 
             for(i=0;i<4; i++) valid[i] = TRUE; 
             if (posi == 0)   {numOfNeighbours--; valid[NORTH] = FALSE;} 
             if (posi == K-1) {numOfNeighbours--; valid[SOUTH] = FALSE;} 
             if (posj == 0)   {numOfNeighbours--; valid[WEST]= FALSE;} 
             if (posj == K-1) {numOfNeighbours--; valid[EAST]= FALSE;} 
             /* initialize external boundaries */
             for (i=0; i<n+2; i++)
                 for(j=0; j<n+2; j++) Q[i][j] = P[i][j] = 0.0;
             if (posi == 0) for(i=1; i<=n; i++) P[0][i] = 1.0;
         }

       private void sendBoundaries()
         { int i,dir,destPe;
           BOUNDARY *msg;
           for(dir=0; dir<4; dir++) 
              if (valid[dir]) {
                 msg = (BOUNDARY *) CkAllocMsg(BOUNDARY);
                 switch (dir) {
                    case NORTH : msg->from = SOUTH;  destPe = penum-K;
                                 for(i=1; i<=n; i++) msg->boundary[i]=P[1][i];
                                 break; 
                    case SOUTH : msg->from = NORTH;  destPe = penum+K;
                                 for(i=1; i<=n; i++) msg->boundary[i]=P[n][i];
                                 break; 
                    case EAST  : msg->from = WEST;   destPe = penum+1;
                                 for(i=1; i<=n; i++) msg->boundary[i]=P[i][n];
                                 break; 
                    case WEST  : msg->from = EAST;   destPe = penum-1;
                                 for(i=1; i<=n; i++) msg->boundary[i]=P[i][1];     }
                 SendMsgBranch(recvBoundary,msg,destPe);
              }
         }
       private void copyBoundary(from,boundary)
       int    from;
       float  boundary[];
         {   int i;
             switch (from) {
               case NORTH: for(i=1; i<=n; i++) P[0][i]    = boundary[i]; break;
               case SOUTH: for(i=1; i<=n; i++) P[n+1][i] = boundary[i]; break;
               case EAST : for(i=1; i<=n; i++) P[i][n+1] = boundary[i]; break;
               case WEST : for(i=1; i<=n; i++) P[i][0]    = boundary[i]; 
             }
         }
 }
       update(P,Q)
       float P[n+2][n+2], Q[n+2][n+2];
         { int i,j;
           for(i=1; i<=n; i++)
             for(j=1; j<=n; j++) 
               Q[i][j] = 0.25*(P[i-1][j]+P[i+1][j]+P[i][j-1]+P[i][j+1]);
         }

       copyP(P,Q)
       float P[n+2][n+2], Q[n+2][n+2];
         { int i,j;
           for(i=1; i<=n; i++)
             for(j=1; j<=n; j++) P[i][j] = Q[i][j];
         }
             
#define mymax(x,y) ((x>y)?x:y)  /* if (x>y) then x  else y  */
#define myabs(x) ((x<0)?-x:x)   /* if (x<0) then -x else x */
       localMaximum (maxDiff,maxPrev,P,Q)
       float *maxDiff, *maxPrev, P[n+2][n+2], Q[n+2][n+2];
         { int   i,j;
           *maxPrev = myabs(P[1][1]);
           *maxDiff = myabs(Q[1][1] - *maxPrev);
           for(i=1; i<=n; i++)
             for(j=1; j<=n; j++) {
              *maxDiff= mymax(*maxDiff, myabs((Q[i][j]-P[i][j])));
              *maxPrev= mymax(*maxPrev, myabs(P[i][j]));
             }
         } 

       result(penum,K,P)
       int penum,K;
       float P[n+2][n+2];
         {  int i,j;
            for(i=1; i<=n; i++)
              for(j=0; j<=n; j++)
                CkPrintf("(%d,%d)    %f\n", (penum/K)*n+i, (penum%K)*n+j, P[i][j]);
         }

}
