# 1 "jacobi.p" 



















# 1 "./jacobi.int" 1



















interface module Jacobi {
    message {ChareNumType redn; } DOMAINInit;
    BranchOffice domain {
      entry BranchInit;
    }
}
# 21 "jacobi.p" 2
# 1 "/home/kale/milind/E3dir/Charm/network-sun/include/fmaxredn.int" 1






















































































interface module FMaxRedn {

    message { varSize float data[];} REDN_MSG;

    Create();
    CreateOverGroup();
    LocalReduction();
    DepositData();
    DepositDataMsg();
}

# 22 "jacobi.p" 2
module Jacobi {








message { ChareNumType redn;}  DOMAINInit;
message { int from;  float boundary[4+2]; }  BOUNDARY;

BranchOffice domain {
       float P[4+2][4+2],Q[4+2][4+2];
       float localMax[2];
       int   count,numOfNeighbours;
       int   reductionDone;
       int   valid[4], penum, ref;
       int   K;                          
       ChareNumType redn, mybocid; 
       
       entry BranchInit: (message DOMAINInit *msg)
         {   private void initialize() ;
	     private void sendBoundaries() ;

	     redn = msg->redn;
             CkFreeMsg(msg);
             mybocid = MyBocNum();
             PrivateCall(initialize());
             PrivateCall(sendBoundaries());
             count = numOfNeighbours;
             reductionDone = 1;  }

       entry recvBoundary : (message BOUNDARY *msg)
         {   private void iterate();
	     private void copyBoundary() ;
             PrivateCall(copyBoundary(msg->from,msg->boundary));
             CkFreeMsg(msg);
             if (--count == 0 && reductionDone) PrivateCall(iterate());  }

       private void iterate()
         {   static int update();
             static int localMaximum();
             update(P,Q);
             localMaximum( &(localMax[0]), &(localMax[1]),P,Q);
             reductionDone = 0;
             count = numOfNeighbours;
	     ref++ ;
             FMaxRedn::DepositData(redn, localMax, localMax, 2, ref, recvReduction, &mybocid);  } 


       public recvReduction() 
         { static int copyP();
           static int result();
	   private void sendBoundaries() ;
	   private void iterate() ;
           if (((localMax[1]>0) ? localMax[0]/localMax[1] : localMax[0])  < 1e-4 )
                result(penum,K,P);
           else { reductionDone = 1;
                  copyP(P,Q);
                  PrivateCall(sendBoundaries());
                  if (count == 0) PrivateCall(iterate()); } }

       private void initialize() 
         {   int i,j,posi,posj, Pe;
             extern double sqrt();
             penum = McMyPeNum();
             Pe = McTotalNumPe(); K  = (int) sqrt((double) Pe); 
	     ref = 50 ;
             if (K*K != Pe) { CkPrintf("error. The number of processors must be a square.\n");
                              CkExit();}
             posi  = penum / K;   posj  = penum % K; 
             numOfNeighbours = 4; 
             for(i=0;i<4; i++) valid[i] = 1; 
             if (posi == 0)   {numOfNeighbours--; valid[2] = 0;} 
             if (posi == K-1) {numOfNeighbours--; valid[3] = 0;} 
             if (posj == 0)   {numOfNeighbours--; valid[1]= 0;} 
             if (posj == K-1) {numOfNeighbours--; valid[0]= 0;} 
             
             for (i=0; i<4+2; i++)
                 for(j=0; j<4+2; j++) Q[i][j] = P[i][j] = 0.0;
             if (posi == 0) for(i=1; i<=4; i++) P[0][i] = 1.0;
         }

       private void sendBoundaries()
         { int i,dir,destPe;
           BOUNDARY *msg;
           for(dir=0; dir<4; dir++) 
              if (valid[dir]) {
                 msg = (BOUNDARY *) CkAllocMsg(BOUNDARY);
                 switch (dir) {
                    case 2 : msg->from = 3;  destPe = penum-K;
                                 for(i=1; i<=4; i++) msg->boundary[i]=P[1][i];
                                 break; 
                    case 3 : msg->from = 2;  destPe = penum+K;
                                 for(i=1; i<=4; i++) msg->boundary[i]=P[4][i];
                                 break; 
                    case 0  : msg->from = 1;   destPe = penum+1;
                                 for(i=1; i<=4; i++) msg->boundary[i]=P[i][4];
                                 break; 
                    case 1  : msg->from = 0;   destPe = penum-1;
                                 for(i=1; i<=4; i++) msg->boundary[i]=P[i][1];     }
                 SendMsgBranch(recvBoundary,msg,destPe);
              }
         }
       private void copyBoundary(from,boundary)
       int    from;
       float  boundary[];
         {   int i;
             switch (from) {
               case 2: for(i=1; i<=4; i++) P[0][i]    = boundary[i]; break;
               case 3: for(i=1; i<=4; i++) P[4+1][i] = boundary[i]; break;
               case 0 : for(i=1; i<=4; i++) P[i][4+1] = boundary[i]; break;
               case 1 : for(i=1; i<=4; i++) P[i][0]    = boundary[i]; 
             }
         }
 }
       update(P,Q)
       float P[4+2][4+2], Q[4+2][4+2];
         { int i,j;
           for(i=1; i<=4; i++)
             for(j=1; j<=4; j++) 
               Q[i][j] = 0.25*(P[i-1][j]+P[i+1][j]+P[i][j-1]+P[i][j+1]);
         }

       copyP(P,Q)
       float P[4+2][4+2], Q[4+2][4+2];
         { int i,j;
           for(i=1; i<=4; i++)
             for(j=1; j<=4; j++) P[i][j] = Q[i][j];
         }
             


       localMaximum (maxDiff,maxPrev,P,Q)
       float *maxDiff, *maxPrev, P[4+2][4+2], Q[4+2][4+2];
         { int   i,j;
           *maxPrev = ((P[1][1]<0)?-P[1][1]:P[1][1]);
           *maxDiff = ((Q[1][1] - *maxPrev<0)?-Q[1][1] - *maxPrev:Q[1][1] - *maxPrev);
           for(i=1; i<=4; i++)
             for(j=1; j<=4; j++) {
              *maxDiff= ((*maxDiff> (((Q[i][j]-P[i][j])<0)?-(Q[i][j]-P[i][j]):(Q[i][j]-P[i][j])))?*maxDiff: (((Q[i][j]-P[i][j])<0)?-(Q[i][j]-P[i][j]):(Q[i][j]-P[i][j])));
              *maxPrev= ((*maxPrev> ((P[i][j]<0)?-P[i][j]:P[i][j]))?*maxPrev: ((P[i][j]<0)?-P[i][j]:P[i][j]));
             }
         } 

       result(penum,K,P)
       int penum,K;
       float P[4+2][4+2];
         {  int i,j;
            for(i=1; i<=4; i++)
              for(j=0; j<=4; j++)
                CkPrintf("(%d,%d)    %f\n", (penum/K)*4+i, (penum%K)*4+j, P[i][j]);
         }

}
