/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: pgm.p,v $
 *	$Author: brunner $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/10/14 21:37:28 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: pgm.p,v $
 * Revision 1.1  1994/10/14  21:37:28  brunner
 * Initial revision
 *
 ***************************************************************************/

module TABLE {


/************************************************************************/
/*Counting the number of fib of n identical objects into K piles */
/* Using dynamic tables to avoid duplication			        */
/************************************************************************/

#include "tbl.h"

readonly int grainSize, topFib;
table fibtbl;

message { 
	int n;
	ChareIDType parentID;
	EntryPointType sendToEp;
} 
ProblemMsg;

message {
	int fib;
} 
SolutionMsg;

chare main {
	int k;
entry CharmInit:
{  
	ProblemMsg * pMsg ;

	CkPrintf("Enter n: ");
	CkScanf("%d", &topFib);
	ReadInit(topFib);
	CkPrintf("Enter grain-size: ");
	CkScanf("%d", &grainSize);
	ReadInit(grainSize); 

	pMsg = (ProblemMsg *) CkAllocMsg( ProblemMsg);
	pMsg->n = topFib;
	pMsg->sendToEp = main@Solution;
	MyChareID( & (pMsg->parentID) );
	CreateChare(fib, fib@InitSubGoal, pMsg);  
}

entry Solution:  (message SolutionMsg * msg)
{ 
	CkPrintf("The answer is: %d at %d milli-seconds.\n", msg->fib,
		 CkTimer());
	CkExit();   
}
}

chare fib 
{
	ChareIDType parent;
	EntryPointType parentEP;
	int total, count;
	int n,k;
	int store;
	int key;

entry InitSubGoal: (message ProblemMsg *msg)
{ 
	ChareIDType myID;

	parent = msg->parentID;     /* struct copy. */
	parentEP = msg->sendToEp;
	n = msg->n; 
	store = 1;
	key = n ;
	MyChareID(&myID);
	TblFind(fibtbl, key, TblChecked, &myID, TBL_WAIT_AFTER_FIRST); 
	CkFreeMsg(msg);
}

entry TblChecked: (message TBL_MSG *msg)
{ 
	ProblemMsg *msg1, *msg2;
	int temp;
        static Fib();

	if (msg->data != NULL)
	{
		temp = *((int *) msg->data);
		store = 0;
		PrivateCall(sendResponse(temp));
	}
	else 
	{
		if (n  < ReadValue(grainSize)) 
			PrivateCall(sendResponse( Fib(n)) );
		else       /* Otherwise, start parallel subcomputations. */
		{
			total = 0; 
			count = 2;
			msg1 =  (ProblemMsg *) CkAllocMsg( ProblemMsg );
			msg2 =  (ProblemMsg *) CkAllocMsg( ProblemMsg );
			msg1->n = n-1;      
			msg1->sendToEp = fib@Response;
			MyChareID( &(msg1->parentID) );
			CreateChare(fib, InitSubGoal, msg1);   /* fib(n-1,k-1) */
			msg2->n = n-2; 
			MyChareID( &(msg2->parentID) );
			msg2->sendToEp = fib@Response;
			CreateChare(fib, InitSubGoal, msg2);    /* fib(n-k,k) */
		}
	}
	CkFreeMsg(msg);
}

entry Response: (message SolutionMsg * msg)
{ 
	total += msg->fib;
	CkFreeMsg(msg);
	if (--count == 0)
		PrivateCall(sendResponse(total));
}

private sendResponse(value)
int value;
{ 
	SolutionMsg * resp;
	resp = (SolutionMsg *) CkAllocMsg( SolutionMsg);
	resp->fib = value;
	SendMsg(parentEP, resp, &parent);
	if (store) TblInsert(fibtbl, key, &value, sizeof(value), -1, NULL);
}
}

Fib(n)
int n;
{ 
	if (n<2)
		return(n);
	else
		return(Fib(n-1)+Fib(n-2));
}
}
