/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: pgm.P,v $
 *	$Author: brunner $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/10/14 21:30:05 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: pgm.P,v $
 * Revision 1.1  1994/10/14  21:30:05  brunner
 * Initial revision
 *
 ***************************************************************************/

/* program to solve the Travelling Salesperson Problem, using parallel
   branch and bound techniques */

#include "quiescence.h"

#define Max 40
#define MaxSquare 50
#define INFINITY 999999		/* indicates to edge present	*/
#define SMALL	-999999		/* very small			*/
#define RANDOM_BOUND 200	/* limit on weight of edges	*/
#define ROUTINE1 1
#define ROUTINE2 2
#define TRUE 1
#define FALSE 0

#define IsFree(a,ind)  !( (a[(ind/32)]) & (1<<(ind % 32)) )
#define Set(a,ind) a[(ind/32)] = ( a[(ind/32)] | (1<<(ind % 32)) )
#define Reset(a,ind) a[(ind/32)] = ( a[(ind/32)] & (~(1<<(ind % 32))) )

#define DETERMINE_MATRIX determine_matrix0
#define BRANCH_OUT branch_out0
#define SOLVE_RELAXATION reduce_matrix

message MSG1 {
	int cost;
	unsigned int isDefined[MaxSquare];
	unsigned int in[MaxSquare];
} ;

message SolnMsg {
	int cost;
	int cycle[Max];
} ;

readonly int N;			/* number of rows and columns	*/
readonly int matrix[Max][Max];	/* initial cost matrix		*/ 

message ACC_MSG {
	int nodes;
} ;



// counts number of nodes in branch and bound tree
accumulator class ACC_INT { 

	ACC_MSG *msg;

public:
	// This is the initialization function.				
	ACC_INT(ACC_MSG *data)
	{
		msg = (ACC_MSG *) new_message(ACC_MSG);
		msg->nodes = data->nodes;
	}

	// This is the increment function for the accumulator that 
	// will count the number of nodes in the tree.		
	void Accumulate() 
	{
		(msg->nodes)++;
	}


	// This is the combine function for the accumulator. 
	void Combine(ACC_MSG *b)
	{
		(msg->nodes) += (b->nodes);
	}
} ;			



message MONO_MSG {
	int bound;
} ;


// the current bound on the solution in the branch-and-bound tree
monotonic class MONO_INT {
	
	MONO_MSG *msg;

public:
	// This is the initfn.					
	MONO_INT(MONO_MSG *data)
	{
		msg = (MONO_MSG *) new_message(MONO_MSG);
		msg->bound = data->bound;
	}


	// This is the comparison function for the monotonic variable.	
	int Update(MONO_MSG *ne)
	{
		if (msg->bound > ne->bound)
		{
			msg->bound = ne->bound;
			return(1);
		}
		else 
			return(0);
	}
} ;			


readonly ACC_INT handle acc_nodes;
readonly MONO_INT handle mono_bound;


void read_in_matrix(int A[Max][Max], int n) ;
void printout_new_solution(int soln[Max][Max] , int n) ;
int reduce_matrix(int A[Max][Max], int soln[Max][Max], int n, int rows[Max], int columns[Max]) ;
void get_cycle_edge(MSG1 *msg, int v1, int v2, int n, int *cycle_start, int *cycle_end) ;
int least_in_row(int A[Max][Max], int row, int n) ;
int least_in_col(int A[Max][Max], int col, int n) ;
int find_best_zero(int A[Max][Max], int n, int *best_i, int *best_j) ;
void branch_out0(MSG1 *msg, int A[Max][Max], int n, int cost, int rows[Max], int columns[Max]) ;
void determine_matrix0(MSG1 *msg, int matrix[Max][Max], int A[Max][Max], int n) ;
int isSolution(MSG1 *msg, int soln[Max][Max], int n) ;


// This does the computation for each node of the tree
chare class start {

entry: 	void LEAF (MSG1 *msg)
	{
		int n;
		int cost;
		MONO_MSG *tmsg;
		int A[Max][Max];
		int soln[Max][Max];
		int rows[Max], columns[Max];

		n = N;
		DETERMINE_MATRIX(msg, matrix, A, n);
		cost = SOLVE_RELAXATION(A, soln, n, rows, columns);
		cost += msg->cost;
		if (cost < ( (MONO_MSG *)(mono_bound->MonoValue()) )->bound)
			if (isSolution(msg, soln, n))
			{
				tmsg = (MONO_MSG *)  new_message(MONO_MSG);
				tmsg->bound = cost;
				mono_bound->Update(tmsg);
				printout_new_solution(soln, n);
			}
			else
			{
				BRANCH_OUT(msg, A, n, cost, rows, columns);
			}
		delete_message(msg);
		ChareExit();
	}
} ;


chare class main {

	int cost;
	int temp[Max][Max];
	int temp1[Max], temp2[Max];
	int starttime ;

entry: 	void Quiescence(QUIESCENCE_MSG *) ;

public:
	main()
	{
		int *x;
		int i, j;
		int index;
		MSG1 *msg;
		ACC_MSG *acc_msg;
		int choice, upper;
		MONO_MSG *mono_msg;


     		CScanf("%d", &N);
		CPrintf("The number of cities are : %d\n", N);
		CScanf("%d", &choice); 
		CScanf("%d", &upper);

     		read_in_matrix(matrix, N); 	

		starttime = CTimer() ;
		cost = reduce_matrix(matrix, temp, N, temp1, temp2);

		acc_msg = (ACC_MSG *) new_message(ACC_MSG);
		mono_msg = (MONO_MSG *) new_message(MONO_MSG);

		if (choice)
			mono_msg->bound = upper;
		else
			mono_msg->bound = INFINITY;

		acc_msg->nodes = 0;

		mono_bound = new_monotonic(MONO_INT, mono_msg);
		acc_nodes =  new_accumulator(ACC_INT, acc_msg);

		msg = (MSG1 *) new_prio_message(MSG1, sizeof(int));
		x = (int *) CPriorityPtr(msg);
		*x = cost;

		msg->cost = cost;
		for (i=0; i<N; i++)
			for (j=0; j<N; j++)
			{
				index = i*N + j;
				Reset(msg->isDefined, index);
				Reset(msg->in, index);

			}
		new_chare(start, &(start::LEAF), msg);
	
		CStartQuiescence(&(main::Quiescence),mainhandle) ;
	}

entry:
	void MAINEP1 (ACC_MSG * msg)
	{
		CPrintf("Total number of nodes in the tree = %d\n",
				msg->nodes);

		CPrintf("---------------------------------------------------------------\n");
		CharmExit();
	}

	void RECEIVE (SolnMsg *msg)
	{
		int i ;
		MONO_MSG *tmsg;

		if (msg->cost <= ( (MONO_MSG *)(mono_bound->MonoValue()) )->bound)
		{
			tmsg = (MONO_MSG *) new_message(MONO_MSG);
			tmsg->bound = msg->cost;
			mono_bound->Update(tmsg);

			CPrintf("New Tour of cost %d found at time %d :\n\n\t",
					msg->cost, CTimer());
			for (i=0; i<N; i++)
				CPrintf("%2d->", msg->cycle[i]);
			CPrintf("%2d\n", msg->cycle[0]);
		}	
		delete_message(msg);
	}

} ;

void main::Quiescence(QUIESCENCE_MSG *dmsg)
{
CPrintf("Found optimal tour at time %d\n\n",CTimer()-starttime) ;
	CPrintf("Totalling number of nodes in the tree.\n");
	acc_nodes->CollectValue(&(main::MAINEP1), mainhandle);
	delete_message(dmsg) ;
}
	

/****************************************************************/
/* This function reads in the initial cost matrix.		*/
/****************************************************************/

void read_in_matrix(int A[Max][Max], int n)
{
	int i, j;

	for (i=0; i<n; i++)
		for (j=0; j<n; j++)
		{
			CScanf("%d", &A[i][j]); 
			/* A[i][j] = rand() % RANDOM_BOUND; */ 
		}
	for (i=0; i<n; i++)
		A[i][i] = INFINITY;
}



/****************************************************************/
/* This function prints out a solution. Since the monotonic	*/
/* variable does not guarantee the global best on every node 	*/
/* the solution found may not necessarily be the best.		*/
/****************************************************************/

void printout_new_solution(int soln[Max][Max] , int n)
{
	int *x;
	int i, j;
	int next; 
	int index = 0;
	SolnMsg *msg;

	msg = (SolnMsg *) new_prio_message(SolnMsg,sizeof(int));
	x = (int *) CPriorityPtr(msg);
	*x = 0;
	msg->cost = ( (MONO_MSG *)(mono_bound->MonoValue()) )->bound;
	for (i=0; i<n; i++)
		if (soln[0][i] == 1)
			break;

	msg->cycle[index++] = 0;
	next = i;
	while (next != 0)
	{
		msg->cycle[index++] = next;
		for (j=0; j<n; j++)
			if (soln[next][j])
			{
				next = j;
				break;
			}
	}
	mainhandle=>RECEIVE(msg) ;
}


/****************************************************************/
/* This function reduces the cost matrix to a non-negative 	*/
/* matrix. We use this to fire off the computations, and also	*/
/* to determine the first reasonable lower bound.		*/
/****************************************************************/

int reduce_matrix(int A[Max][Max], int soln[Max][Max], int n, int rows[Max], int columns[Max])
{
	int i,j;
	int lowest;
	int cost = 0;

	for (i=0; i<n; i++)
	{
		lowest = INFINITY;
		for (j=0; j<n; j++)
			if (A[i][j] < lowest)
				lowest = A[i][j];

		if (lowest != INFINITY)
		{
			for (j=0; j<n; j++)
				if (A[i][j] != INFINITY)
					A[i][j] -= lowest;
			cost += lowest;	
		}
		rows[i] = lowest;
	}

	for (j=0; j<n; j++)
	{
		lowest = INFINITY;
		for (i=0; i<n; i++)
			if (A[i][j] < lowest)
				lowest = A[i][j];

		if (lowest != INFINITY)
		{
			for (i=0; i<n; i++)
				if (A[i][j] != INFINITY)
					A[i][j] -= lowest;
			cost += lowest;
		}
		columns[j] = lowest;
	}
	for (i=0; i<n; i++)
		for (j=0; j<n; j++)
			soln[i][j] = 0;
	return(cost);
}



/****************************************************************/
/* This function determines whether the solution to the 	*/
/* assignment problem is also a solution to the traveling 	*/
/* salesman problem.						*/
/****************************************************************/

int isSolution(MSG1 *msg, int soln[Max][Max], int n)
{
	int x, y;
	int i, j;
	int index;
	int length = 0;
	int cycle_start, cycle_end;

	for (i=0; i<n; i++)
		for (j=0; j<n; j++)
		{
			index = i*n + j;
			if (!IsFree(msg->in, index))
			{
				x = i;
				y = j;
				soln[i][j] = 1;
				length++;
			}
		}

	if (length != n - 1)
		return(0);

	get_cycle_edge(msg, x, y, n, &cycle_start, &cycle_end);
	soln[cycle_end][cycle_start] = 1;
	return(1);
}



/****************************************************************/
/* This function gets  for the sub-branch that edge which	*/
/* could contribute to a cycle.					*/
/****************************************************************/

void get_cycle_edge(MSG1 *msg, int v1, int v2, int n, int *cycle_start, int *cycle_end)
{
	int i;
	int index;
	int end = v2;
	int start1 = v1;
	int done = FALSE;

	while (!done)
	{
		for (i=0; i<n; i++)
		{
			index = end*n + i;
			if (!IsFree(msg->in, index))
			{
				end = i;
				break;
			}
		}
		if (i==n)
			done = TRUE;
	}

	*cycle_end = end;
	done = FALSE;

	while (!done)
	{
		for (i=0; i<n; i++)
		{
			index = i*n + start1;
			if (!IsFree(msg->in, index))
			{
				start1 = i;
				break;
			}
		}
		if (i==n)
			done = TRUE;
	}
	*cycle_start = start1;
}



/****************************************************************/
/* This function returns the index of the least element in the	*/
/* row.								*/
/****************************************************************/

int least_in_row(int A[Max][Max], int row, int n)
{
	int j;
	int least = INFINITY;

	for (j=0; j<n; j++)
		if (least > A[row][j])
			least = A[row][j];
	return(least);
}


/****************************************************************/
/* This function returns the index of the least element in the	*/
/* column.							*/
/****************************************************************/

int least_in_col(int A[Max][Max], int col, int n)
{
	int i;
	int least = INFINITY;

	for (i=0; i<n; i++)
		if (least > A[i][col])
			least = A[i][col];
	return(least);
}

/****************************************************************/
/* This function determines the best zero according to the 	*/
/* criterion established in the book by Reingold.		*/
/****************************************************************/

int find_best_zero(int A[Max][Max], int n, int *best_i, int *best_j)
{
	int temp;
	int store;
	int i, j;
	int best = SMALL;

	for (i=0; i<n; i++)
		for (j=0; j<n; j++)
		{
			temp = 0;
			if (A[i][j] == 0)
			{
				store = A[i][j];
				A[i][j] = INFINITY;
				temp = least_in_row(A, i, n);
				temp += least_in_col(A, j, n);
				A[i][j] = store;
				if (temp > best)
				{
					best = temp;
					*best_i = i;
					*best_j = j;
				}
			}
		}
	return(best);
}


/****************************************************************/
/* This is the trivial branching out procedure. It determines 	*/
/* the best node in the relaxation problem and then branches 	*/
/* out on in a binary fashion with one branch excluding the	*/
/* edge and the other including the edge.			*/
/****************************************************************/

void branch_out0(MSG1 *msg, int A[Max][Max], int n, int cost, int rows[Max], int columns[Max])
{
	int *x;
	int i,j;
	int temp;
	int best;
	int index;
	MSG1 *msg1, *msg2;
	int best_i, best_j;
	int cycle_start, cycle_end;
	int temp1[Max], temp2[Max], temp3[Max][Max];
	
	best_i = best_j = (-1);
	best = find_best_zero(A, n, &best_i, &best_j);
	if (best_i != -1)
	{
		msg1 = (MSG1 *) new_prio_message(MSG1, sizeof(int));
		msg2 = (MSG1 *) new_prio_message(MSG1, sizeof(int));
		msg1->cost = msg2->cost = msg->cost;
	
		for (i=0; i<n; i++)
			for (j=0; j<n; j++)
			{
				index = i*n + j;
				if (IsFree(msg->isDefined, index))
				{
					Reset(msg1->isDefined, index);
				 	Reset(msg2->isDefined, index);
				}
				else
				{
					Set(msg1->isDefined, index);
				 	Set(msg2->isDefined, index);
				}
				if (IsFree(msg->in, index))
				{
					Reset(msg1->in, index);
				 	Reset(msg2->in, index);
				}
				else
				{
					Set(msg1->in, index);
				 	Set(msg2->in, index);
				}
			}	

		index = best_i*n + best_j;
		if ( (cost < ((MONO_MSG *) (mono_bound->MonoValue()))->bound &&
		     	(best >= INFINITY)) ||
		     (cost + best <
			((MONO_MSG *) (mono_bound->MonoValue()))->bound))
		{
			Set(msg1->isDefined, index);
			Reset(msg1->in, index); 

			A[best_i][best_j] = INFINITY;
			if (least_in_row(A, best_i, n) == INFINITY)
				if (rows[best_i] < INFINITY)
					msg1->cost += rows[best_i];
			if (least_in_col(A, best_j, n) == INFINITY)
				if (columns[best_j] < INFINITY)
					msg1->cost += columns[best_j];

			x = (int *) CPriorityPtr(msg1);
			*x = cost + best;
			A[best_i][best_j] = 0;

			new_chare(start, &(start::LEAF), msg1);
			acc_nodes->Accumulate();
		}

		/* include best edge, and exclude its symmetric partner */
		if (rows[best_i] < INFINITY)
			msg2->cost += rows[best_i];
		if (columns[best_j] < INFINITY)
			msg2->cost += columns[best_j];
		Set(msg2->isDefined, index);
		Set(msg2->in, index);
		index = best_j*n + best_i;
		Set(msg2->isDefined, index);
		Reset(msg2->in, index);
	
		temp = A[best_j][best_i];
		A[best_j][best_i] = INFINITY;
		if (least_in_row(A, best_j, n) == INFINITY)
			if (rows[best_j] < INFINITY)
				msg2->cost += rows[best_j];
		if (least_in_col(A, best_i, n) == INFINITY)
			if (columns[best_i] < INFINITY)
				msg2->cost += columns[best_i];
		A[best_j][best_i] = temp;
	
		/* Get the edge that completes the cycle and exclude it. */
		get_cycle_edge(msg2, best_i, best_j, n,
				&cycle_start, &cycle_end);
		index = cycle_end*n + cycle_start;
		Set(msg2->isDefined, index);
		Reset(msg2->in, index);
		temp = A[cycle_end][cycle_start];
		A[cycle_end][cycle_start] = INFINITY;
		if (least_in_row(A, cycle_end, n) == INFINITY)
			if (rows[cycle_end] < INFINITY)
				msg2->cost += rows[cycle_end];
		if (least_in_col(A, cycle_start, n) == INFINITY)
			if (columns[cycle_start] < INFINITY)
				msg2->cost += columns[cycle_start];
		A[cycle_end][cycle_start] = temp;

		A[best_j][best_i] = A[cycle_end][cycle_start] = INFINITY;
		for (i=0; i<n; i++)
			A[best_i][i] = A[i][best_j] = INFINITY;
		x = (int *) CPriorityPtr(msg2);
		*x = SOLVE_RELAXATION(A, temp3, n, temp1, temp2) +
			cost;

		new_chare(start, &(start::LEAF), msg2);
		acc_nodes->Accumulate();
	}
}


/****************************************************************/
/* This function determines the updated cost matrix after 	*/
/* looking at the edges excluded and included in this branch.	*/
/****************************************************************/

void determine_matrix0(MSG1 *msg, int matrix[Max][Max], int A[Max][Max], int n)
{
	int index;
	int i, j, k;

	for (i=0; i<n; i++)
		for (j=0; j<n; j++)
			A[i][j] = matrix[i][j];
	for (i=0; i<n; i++)
		for (j=0; j<n; j++)
		{
			index = i*n +j;
			if (!IsFree(msg->isDefined, index))	
				if (!IsFree(msg->in, index))
				{
					for (k=0; k<n; k++)
						A[k][j] = INFINITY;
					for (k=0; k<n; k++)
						A[i][k] = INFINITY;
					A[j][i] = INFINITY;
				}
				else
					A[i][j] = INFINITY;

		}
}
