/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: pgm.P,v $
 *	$Author: brunner $	$Locker:  $		$State: Exp $
 *	$Revision: 1.1 $	$Date: 1994/10/14 21:27:25 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: pgm.P,v $
 * Revision 1.1  1994/10/14  21:27:25  brunner
 * Initial revision
 *
 ***************************************************************************/


/* CHARM++ sample program : Finding the number of primes from
   1 to a large number using a variant of parallel Eratosthenes' sieve */

// this file has to be included before using quiescence
#include "quiescence.h"


#define Set(a,ind) a[(ind/32)] = ( a[(ind/32)] | (1<<(ind % 32)) )


// 2*3*5*7*11*13  
const int LENGTH=30030 ;


/* This primes array has all primes from 2 to sqrt(upper limit).
   It is initialized in the main function of the main chare, then
   can be used on all processors */
readonly int primes[1300] ;


message MsgAccCount { // message holding data inside the accumulator
    int     data;
} ;

message InitMsg {
    int     data;
} ;

message RangeMsg {  // specifies the sub-problem range
    int L, H;
} ;

accumulator class AccCount {  
// accumulator which sums the number of primes from all chares

    MsgAccCount *msg;

public:
    AccCount(InitMsg *initmsg)
    {
        msg = (MsgAccCount *) new_message(MsgAccCount);
        msg->data = initmsg->data;
    }

    void Accumulate (int x)
    {	// The program calls this function to accumulate
	
        msg->data += x;
    }

    void Combine(MsgAccCount *y)
    {	// The system calls this function to combine counts from different
 	// chares
        msg->data += y->data ;
    }
}  ;


// This is the handle of the accumulator which adds all counts 
// It is also a read-only variable so it can be accessed from all processors
readonly AccCount handle total ;


// The sequential Eratosthenes-sieve function
int seqSieve(int L,int H, int* primes) ;



chare class sieve {

entry:
    void Goal(RangeMsg * msg1)
    { 	// This entry point is executed when this chare is created

        int L = msg1->L; 
        int H = msg1->H;
        /* L-1 is always a multiple of LENGTH */

        if ((H-L+1) > LENGTH)	// divide the problem into two
        { 
            int Mid = (H-L+1)/(2*LENGTH);
            if (Mid == 0) Mid++;
            Mid =  L + LENGTH*Mid;
            RangeMsg *msg2 = (RangeMsg *) new_message( RangeMsg);
            msg2->L = Mid; 
            msg2->H = H;
            msg1->H = Mid-1; /* msg1->L == L already */
            new_chare(sieve, &(sieve::Goal), msg1);
            new_chare(sieve, &(sieve::Goal), msg2);
        }
        else { /* H-L+1 == LENGTH in all cases, except at the high end, 
		  where H-L+1 may be less than LENGTH */

            int count = seqSieve(L,H,primes);
            delete_message(msg1);

	    // accumulate the count from this chare
	    total->Accumulate(count);
        }
        ChareExit();
    }
};



chare class main {

    int Limit;

entry:
    void PrintResult(MsgAccCount * result)
    { 	// The accumulator sends its results here
        CPrintf("The # of primes in the range 2:%d is: %d. \nTime = %d msec\n",
            	Limit, result->data, CTimer());
        CharmExit();
    }

    void Quiescence(QUIESCENCE_MSG *m) {
	// called by the system when quiescence is detected
	delete_message(m) ;

	// request the accumulator to send its count to PrintResult
        total->CollectValue(&(main::PrintResult), mainhandle);
    }

public:
    main() 
    {
	int primeSquares[1300] ;

	// Input the problem spec
        CPrintf("Enter N : ") ;
        CScanf("%d", &Limit);

	// Fill the array of primes from 1 to sqrt(Limit)
        primes[1] = 2;       
        primes[2] = 3;
        primeSquares[1] = 4; 
        primeSquares[2] = 9;
        int next = 3;
        for (int n=5; 1; n+=2)
        {
        /*  if (n*n > Limit) flag = 1;  stop after the next prime is found */
            int isPrime = 1;
            for (int i=2; primeSquares[i]<=n; i++)
            { 
                if ( (n % primes[i]) == 0) {
			isPrime = 0 ;
			break ;
		}
            }
            if (isPrime)
            { 
                primes[next] = n;
                primeSquares[next] = n*n;
                next++;
		if ( n*n > Limit )
			break ;
            }
        }


	// Create the accumulator and initialize it
        MsgAccCount *acc_msg = (MsgAccCount *) new_message(MsgAccCount);
        acc_msg->data = 0;
        total = new_accumulator(AccCount, acc_msg);

	// Create the chare at the root of the tree-structured problem
        RangeMsg *msg = (RangeMsg *) new_message(RangeMsg);
        msg->L = 1;
        msg->H = Limit;
        new_chare(sieve, &(sieve::Goal), msg);

	// Start Quiescence detection
	CStartQuiescence(&(main::Quiescence),mainhandle) ;
    }

};



// The sequential Eratosthenes sieve program

int seqSieve(int L,int H, int* primes)
{
    int  count;
    int i,j,k,prime;
    int length, startFrom;
    int m, sqr;
    int bitVector[LENGTH/64 + 1];

    if ((L % 2) == 0) L++;

    for (i=0; i<((LENGTH/64) + 1); i++) bitVector[i] = 0 ;

/* length should have the total number of "active" bits. 
     if H is odd, (11-15 -> 3 [11, 13, 15])  (H-L)/2 +1
     if H is even:  (H-L)/2 + 1 (as in 11-16 -> [11,13,15] ) */

    length = (H-L)/2+1;


/* bitVector has only odd numbers now, beginning with L.
   number k is represented by the bit at index (k-L)/2.
   conversely, i'th bit represents the number L+2*i.  0'th bit has L */

/*  begin marking multiples with 3, the second prime */

    k = 0;
    while (( (primes[k]) * (primes[k]) ) <= H)
        k++;

    for (i=2; i <k; i++)
    { 
        prime = (primes[i]);
        sqr = prime*prime;

        /* mark the multiples of prime in the bit-vector.*/
        /* multiples less than prime*prime are already ruled out by smaller primes */

        /* startFrom = the first odd value >= L, and >= prime*prime, 
            that is a multiple of prime. */

        if (sqr > L) startFrom = sqr;
        else if ((L % prime) == 0) startFrom = L;
        else { 
            m = L/prime;
            if ((m % 2 == 0)) m++; 
            else m += 2;
            startFrom = m*prime;
        }

        for (j = (startFrom - L)/2; j <= length; j+=prime)
            Set(bitVector, j);
    }

    count = 0;
    /* i'th bit corresponds to the number 2*i+1 */

    /* Set the (unused) trailing bits to 1, so they don't get counted as primes */
    for (i=length; i < 32*((LENGTH/64) + 1); i++)
        Set(bitVector, i);

    for (i=0; i<((LENGTH/64) + 1); i++)
    { 
        int b, c;
        b = bitVector[i];
        c = 32;
        while (b) {
            c--;
            b = b & (b-1);
        }
        count += c;
    }

    return(count);
}

