/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: pgm.P,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/04/16 20:46:11 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: pgm.P,v $
 * Revision 1.2  1995/04/16  20:46:11  sanjeev
 * moved SolutionMsg's pack and unpack fns outside the msg decl
 *
 * Revision 1.1  1994/10/14  21:10:46  brunner
 * Initial revision
 *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>

/************************************************************************/
/* Finding the Nth fibonacci number				        */
/* Using dynamic tables to avoid duplication			        */
/************************************************************************/

typedef void (*FNPTR)(float) ;

void func(float f)
{	
/*	CPrintf("[%d] In func, f=%f\n",CMyPeNum(),f) ;	*/
}

int Fib(int) ;

extern readonly int grainSize, topFib;
#include "dtable.h"
table fibtbl, table2;

chare class basechare {
} ;

message  ProblemMsg {
	int n;
	basechare handle parentID;
	EntryPointType sendToEp;
	int vartest1[VARSIZE] ;
	int vartest2[VARSIZE] ;
	FunctionRefType afn ;
} ;

message PackedMsg {
	int mfib ;
	float f[5] ;
} ;

message SolutionMsg {
        int mfib;
        float *f ;
 
        void *pack(int *length) ;  // Pack and unpack functions, used to send
        void unpack(void *in) ;    // arbitrary data structures across PEs.
} ;


void *SolutionMsg::pack(int *length)
{	// Pack the array pointed to by f into a contiguous buffer
	// inside a PackedMsg. Return the length and the new buffer

	PackedMsg *p = (PackedMsg *)new_packbuffer((void *)this, sizeof(PackedMsg) ) ;
	for ( int i=0; i<5; i++ ) 
		p->f[i] = f[i] ;	
	p->mfib = mfib ;
	*length = sizeof(PackedMsg) ;
	
	delete f ;

	return((void *)p) ;
}

void SolutionMsg::unpack(void *in)
{	// Unpack the buffer inside "in" and put it in f

	f = new float[5] ;
	for ( int i=0; i<5; i++ ) 
		f[i] = ((PackedMsg *)in)->f[i] ;	
	mfib = ((PackedMsg *)in)->mfib ;
}


chare class fib :public basechare  
{
	basechare handle parent;
	EntryPointType parentEP;
	int total, count;
	int n,k;
	int store;
	int key;

entry:

void Response (SolutionMsg * msg)
{ 
	total += msg->mfib;
/*	CPrintf("[%d] Pack data = %f %f %f %f %f\n",CMyPeNum(),msg->f[0],msg->f[1],msg->f[2],msg->f[3],msg->f[4]) ;	*/
	delete_message(msg);

	if (--count == 0)	// if all children chares have responded
		sendResponse(total);
}

void InitSubGoal(ProblemMsg *msg) ;

void TblChecked (TBL_MSG *msg)
{ 
	ProblemMsg *msg1, *msg2;
	int temp;
	int sizes[2] ;
	sizes[0] = 2 ;
	sizes[1] = 1 ;

	if (msg->data != NULL)
	{
		temp = *((int *) msg->data);
		store = 0;
		sendResponse(temp);
	}
	else 
	{
		if (n  < grainSize) 
			sendResponse( Fib(n)) ;
		else       /* Otherwise, start parallel subcomputations. */
		{
			total = 0; 
			count = 2;
			msg1 =  (ProblemMsg *) new_message(ProblemMsg, sizes) ;
			msg2 =  (ProblemMsg *) new_message(ProblemMsg, sizes) ;
			msg1->n = n-1;      
			msg1->vartest1[0] = 12 ;
			msg1->vartest1[1] = 0xffff0000 ;
			msg1->vartest2[0] = 108 ;
			msg1->sendToEp = &(fib::Response) ;
			msg1->parentID = thishandle ;
			msg1->afn = (FunctionRefType)FunctionNameToRef(func) ;
			// create a child chare 
			new_chare(fib, &(fib::InitSubGoal), msg1);   /* fib(n-1,k-1) */
			msg2->n = n-2; 
			msg2->vartest1[0] = 12 ;
			msg2->vartest1[1] = 0xffff0000 ;
			msg2->vartest2[0] = 108 ;
			msg2->parentID = thishandle ;
			msg2->sendToEp = &(fib::Response) ;
			msg2->afn = (FunctionRefType)FunctionNameToRef(func) ;
			// create a child chare 
			new_chare(fib, &(fib::InitSubGoal), msg2);    /* fib(n-k,k) */
		}
	}
	delete_message(msg);
}

private :
void sendResponse(int value)
{ 
	SolutionMsg * resp;

	resp = (SolutionMsg *) new_message( SolutionMsg );
	resp->mfib = value;
	resp->f = new float[5] ;
	resp->f[0] = 0.1 ;
	resp->f[1] = 1.0 ;
	resp->f[2] = 10.0 ;
	resp->f[3] = 100.0 ;
	resp->f[4] = 10000000000.0 ;

	// send response to the parent
	parent=>parentEP(resp) ;

	// insert current value into the distributed table
	if (store) 
		fibtbl.Insert(key, &value, sizeof(value), NULL_EP, 
				NULL_HANDLE, TBL_NOWAITFORDATA);
}

} ;

void fib::InitSubGoal(ProblemMsg *msg)
{ 
	// This entry point is executed when a chare is created 

	// This is an example of how to get the function pointer back
	FNPTR funcptr = (FNPTR)FunctionRefToName(msg->afn) ;

	(*funcptr)((float)CMyPeNum()) ;

/*	CPrintf("[%d] vartest1[0]=%d, vartest1[1]=%x, vartest2[0]=%d\n",
		CMyPeNum(),msg->vartest1[0],msg->vartest1[1],msg->vartest2[0]);
*/

	parent = msg->parentID;     
	parentEP = msg->sendToEp;
	n = msg->n; 
	store = 1;
	key = n ;

	// Check if this fib number has already been computed
	fibtbl.Find(key, &(fib::TblChecked), thishandle, TBL_WAIT_AFTER_FIRST);

	delete_message(msg);
}


Fib(int n)
{ 
	// the sequential fib

	if (n<2)
		return(n);
	else
		return(Fib(n-1)+Fib(n-2));
}
