#ifndef _fboc_P_
#define _fboc_P_

#include "fboc.h"
readonly int fboc_topFib, fboc_GrainSize;
readonly fboc_RMSG *read_msg;

void fboc_initfn()
{
     int i;
     int sizes[2];
     
     /*
     CPrintf("FBOC:Enter Fibnocci number: ");
     CScanf("%d",&topFib);
     CPrintf("FBOC:Enter Grain size: ");
     CScanf("%d",&GrainSize);
     */
     fboc_topFib = 10;
     fboc_GrainSize = 5;

     sizes[0] = 10; 
     sizes[1] = 25;

     read_msg = new (sizes) fboc_RMSG;
     read_msg->x = 10;

     for (i=0; i<sizes[0]; i++)
     	read_msg->dummy[i] = (int)3.14*i;

     for (i=0; i<sizes[1]; i++)
	read_msg->bull[i] = i;

}

/************************************************************/
/************************************************************/
/************************************************************/

fboc_start::fboc_start (INIT_MSG *imsg) {

     fboc_MSG2 *msg;
     ChareIDType myid;
     
     store = imsg;

     found = 0;
     msg = new fboc_MSG2 ;
     msg->n = (fboc_topFib - fboc_GrainSize  + 1);
     myid = thishandle;

     EntryPointType e = &(fboc_start::bocCreated) ;
     
     newgroup (e, &myid) fboc_Counter(msg) ;
  
}

void 
fboc_start::bocCreated (GroupIdMessage *msg) {

     fboc_MSG1 *pMsg;

     BocNum = msg->groupid;
     delete msg ;

     pMsg  = new fboc_MSG1 ;
     pMsg->fibNum = fboc_topFib;  
     pMsg->BocNum=BocNum;
     pMsg->level = 0;
     pMsg->ParentID = thishandle;
     newchare fboc_fib(pMsg);
     
     mainid = thishandle;
     CStartQuiescence(&(fboc_start::Quiescence1), mainid);

}

void
fboc_start::Quiescence1 (QuiescenceMessage  *dmsg) {

     fboc_NMSG *msg;
     msg = new fboc_NMSG ;
     msg->startchareID = thishandle;
     // This is how this call was originally:
     newchare (&NULL_HANDLE, 1) dynamic(msg) ;

     CStartQuiescence(&(fboc_start::Quiescence2), mainid);
     delete dmsg ;
}

void
fboc_start::Quiescence2 (QuiescenceMessage  *dmsg) {

     IT_MSG *imsg;
     
     imsg = new IT_MSG ;
     imsg->iteration = store->iteration;
     
     generic_class handle h = store->retID;
     EntryPointType ep = store->retEP;
     h=>ep(imsg);

     delete dmsg ;
     delete store ;
}


void 
fboc_start::ReturnBocNum (GroupIdMessage *msg) {

     fboc_MSG1 *pMsg;
     
     BocNum = msg->groupid;
     pMsg  = new fboc_MSG1 ;
     pMsg->fibNum = fboc_topFib;  
     pMsg->BocNum=BocNum;
     pMsg->level = 0;

     pMsg->ParentID = thishandle;
     newchare fboc_fib(pMsg);

     delete msg ;
}

void 
fboc_start::MAINEP1 (fboc_MSGUP *m) {

     CPrintf("FBOC:Main ep message received.\n");
     CPrintf("FBOC:Result = %d\n", m->rspData);
     delete m ;
     
     fboc_Counter group h = BocNum;
     h[LOCAL]->Collect();

//     BranchCall(BocNum, Counter@Collect());

}

/************************************************************/
/************************************************************/
/************************************************************/

fboc_fib::fboc_fib (fboc_MSG1 *msg1P) {

     int 	n,i, fibVal;
     fboc_MSG1	*ptr1;
     fboc_MSGUP	*ptr2;
     int 	level;
     int        bocNum;
     
     bocNum = msg1P->BocNum;
     n = msg1P->fibNum;
     fibNum = n;
     level = msg1P->level;

     fboc_Counter group h = bocNum;

     h[LOCAL]->increment(level);

     ParentID = msg1P->ParentID;
     isFinal = ( n == fboc_topFib ) ? TRUE : FALSE;

     if (n <= fboc_GrainSize)
     {
	  ptr2 = new fboc_MSGUP ;
	  fibVal = Fib(n);
	  delete msg1P ;
	  fboc_ProcessResult(isFinal, &ParentID, fibVal, ptr2);
     }
     else 
     {
	  rspNum= 2;
	  rspData= 0;
	  ptr1 = new fboc_MSG1 ;
	  ptr1->fibNum = n-1;
	  ptr1->BocNum = msg1P->BocNum;
	  ptr1->level = msg1P->level + 1;
	  msg1P->level += 1;
	  ptr1->ParentID = thishandle;
	  msg1P->fibNum = n-2;
	  msg1P->ParentID = thishandle;
	  newchare fboc_fib(ptr1);
	  newchare fboc_fib(msg1P);
     }
}

void 
fboc_fib::RESPONSE (fboc_MSGUP *msg2P) {

     rspNum--;
     rspData += msg2P->rspData;
     if (rspNum == 0) 
	  fboc_ProcessResult(isFinal, &ParentID,  rspData, msg2P);
     else
	  delete msg2P ;

}

/************************************************************/
/************************************************************/
/************************************************************/

fboc_Counter::fboc_Counter (fboc_MSG2 *msg) {

     int j;
     ChareIDType chareid;
     
     n = msg->n;
     for (i=0;i<n;i++)
     {
	  aggregate[i] = 0;
	  count[i] = 0;
     }
     total = CMaxPeNum();
     delete msg ;

}

void 
fboc_Counter::CollectFromBranches (fboc_MSG3 *msg) {

     total--;
     for (i=0;i<n;i++)
	  aggregate[i]+=msg->count[i];
     if (total==0)
	  for (i=0;i<n;i++)
	       CPrintf("FBOC:Number of nodes at level %3d = %3d\n",
		       i, aggregate[i]);
     delete msg ;

}

void 
fboc_Counter::NodeCollect (fboc_NMSG *msg) {

     int mainpe;
     fboc_MSG3 *tmsg;
     
     mainpe = 0;
     tmsg = new fboc_MSG3 ;
     for (i=0;i<n;i++)
	  tmsg->count[i]=count[i];
     fboc_Counter group h = thisgroup;

     h[mainpe]=>CollectFromBranches(tmsg);

     delete msg ;

}

void
fboc_Counter::increment(int j) {

     (count[j])++;
}

void
fboc_Counter::Collect() {

     fboc_NMSG *msg;
     
     msg= new fboc_NMSG ;
     fboc_Counter group h = thisgroup;

     h[ALL]=>NodeCollect(msg);

}

/************************************************************/
/************************************************************/
/************************************************************/

dynamic::dynamic (fboc_NMSG *nmsg) {

     fboc_MSG2 *msg;
     fboc_RMSG *tmsg;
     
     tmsg = read_msg;

     CPrintf("FBOC:\nCharacteristics of Read Message :\n");
     CPrintf("FBOC:\tx = %d\n", tmsg->x);
     CPrintf("FBOC:\tdummy[5] = %d\n", tmsg->dummy[5]);
     CPrintf("FBOC:\tbull[13] = %d\n", tmsg->bull[13]);
     CPrintf("FBOC:\n\n");
     
     msg = new fboc_MSG2 ;
     msg->n = fboc_topFib - fboc_GrainSize + 1;

     EntryPointType e = &(fboc_start::ReturnBocNum) ;

     newgroup (e, &(nmsg->startchareID))
		fboc_Counter(msg) ;

     delete nmsg ;
}

/************************************************************/
/************************************************************/
/************************************************************/

void fboc_ProcessResult(int top, ChareIDType *CID, int value, 
			fboc_MSGUP *msg) {

     if (top) {
	  CPrintf("FBOC:Fib %d = %d at Time %d Millisec.\n", 
		  ReadValue(fboc_topFib) , value, CTimer());
	  /*CExit(); Commented out to test Quiescence */

	  msg->rspData = value;

	  fboc_start handle h = *CID;
	  h=>MAINEP1(msg);

     }

     else {

	  msg->rspData = value;

	  fboc_fib handle h = *CID;
	  h=>RESPONSE(msg);

     }

     ChareExit();
}

#endif
