/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: testpgm.p,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 2.2 $	$Date: 1995/11/15 21:04:20 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: testpgm.p,v $
 * Revision 2.2  1995/11/15 21:04:20  jyelon
 * changed 'MyChareID' to 'ThisChareID'
 *
 * Revision 2.1  1995/10/27  21:55:28  jyelon
 * Changed CmiNumPe to CkNumPes or CNumPes or CmiNumPes
 *
 * Revision 2.0  1995/07/05  20:13:28  brunner
 * Separated out multi stuff, and including in charm_pgms tree
 *
 * Revision 1.3  1995/05/04  20:07:02  jyelon
 * Removed PGL test.
 *
 * Revision 1.2  1995/04/24  22:42:39  narain
 * *** empty log message ***
 *
 * Revision 1.1  1995/02/25  01:27:08  jyelon
 * Initial revision
 *
 ***************************************************************************/
#include "testpgm.interface"
#include "acc.interface"
#include "fam.interface"
#include "fboc.interface"
#include "ftab.interface"
#include "hello.interface"
#include "pgl.interface"
#include "rdl.interface"
#include "sfb.interface"
#include "tam.interface"
#include "tex.interface"
#include "tpk.interface"
#include "ttab.interface"
#include "tvid.interface"
#include "null.interface"

module main_test {

#define last  13 /* How many tests do we have + 1*/

message {
	int iteration;
	} IT_MSG;

message {
	int iteration;		/* Used to keep touch of tests performed */
	EntryPointType retEP;   /* The entry point to acknowledge completion */
	ChareIDType retID;	/* The ChareId to reply to */
	} INIT_MSG;

chare main {

entry CharmInit :
{
	int i;
	IT_MSG * it;
	
	CkPrintf("Initializing...\n");
	if(CkNumPes() < 1)
	{
		CkPrintf("This test program should be run on 4 or more PEs.\n");
		CkExit(); 
	}
	else
	{
		it = (IT_MSG *) CkAllocMsg(IT_MSG);
		it->iteration = 1;
	
		for(i=0;i<last;i++)
		{
			switch(i)
			{
				case 0: null::initfn();break;
				case 1: acc::initfn();break;
				case 2: fam::initfn();break;
				case 3: fboc::initfn();break;
				case 4: ftab::initfn();break;
				case 5: hello::initfn();break;
				case 6: tvid::initfn();break;
				case 7: rdl::initfn();break;
				case 8: sfb::initfn();break;
				case 9: tam::initfn();break;
				case 10: tex::initfn();break;
				case 11: tpk::initfn();break;
				case 12: ttab::initfn();break;
			}
		}
		CkPrintf("Starting Tests...\n");
		CreateChare(do_all_tests, do_all_tests@start, it);
	}
}

entry end_testing : (message INIT_MSG * initmsg)
{
	CkPrintf("All tests completed to satisfaction\n");
	CkFreeMsg(initmsg);
	CkExit(); 
}
}

chare do_all_tests {
entry start : (message IT_MSG * imsg)
{
	INIT_MSG *initmsg;
	ChareIDType mainID;
	ChareIDType vid;

	initmsg = (INIT_MSG *) CkAllocMsg(INIT_MSG);
	
	initmsg->iteration = imsg->iteration;
	initmsg->retEP = do_all_tests@recv_results;
	MainChareID(&mainID);
	initmsg->retID = ThisChareID;
	switch(imsg->iteration)
	{
		case 1: CkPrintf(" Test 1 - ACC\n");
			CreateChare(acc::start, acc::start@begin, initmsg, &vid, 0 );
			break;
		case 2: CkPrintf(" Test 2 - FAM.....\n");
			CreateChare(fam::start, fam::start@begin, initmsg);
			break;
		case 3: CkPrintf(" Test 3 - FBOC....\n");
			CreateChare(fboc::start, fboc::start@begin, initmsg);
			break;
		case 4: CkPrintf(" Test 4 - FTAB....\n");
			CreateChare(ftab::start, ftab::start@begin, initmsg);
			break;
		case 5: CkPrintf(" Test 5 - HELLO\n");
			CreateChare(hello::start, hello::start@begin,initmsg);
			break;
		case 6: CkPrintf(" Test 6 - TVID....\n");
			CreateChare(tvid::start, tvid::start@begin, initmsg);
			break;
		case 7: CkPrintf(" Test 7 - RDL.....\n");
			CreateChare(rdl::start, rdl::start@begin, initmsg);
			break;
		case 8: CkPrintf(" Test 8 - SFB.....\n");
			CreateChare(sfb::start, sfb::start@begin, initmsg);
			break;
		case 9: CkPrintf(" Test 9 - TAM.....\n");
			CreateChare(null::start, null::start@begin, initmsg);
			break;
		case 10: CkPrintf(" Test 10 - TEX.....\n");
			CreateChare(tex::start, tex::start@begin, initmsg);
			break;
		case 11: CkPrintf(" Test 11 - TPK.....\n");
			CreateChare(tpk::start, tpk::start@begin, initmsg);
			break;
		case 12: CkPrintf(" Test 12 - TTAB....\n");
			CreateChare(ttab::start, ttab::start@begin, initmsg);
			break;
		case last : 
			SendMsg(main@end_testing, initmsg, &mainID);
			break;
	}
	CkFreeMsg(imsg);
}

entry recv_results : (message IT_MSG *rmsg)
{
	IT_MSG *imsg;
	rmsg->iteration += 1;
	SendMsg(start, rmsg, &ThisChareID);
}

} /* End chare */

} /* End module */

/* Each test module must have an entry point which takes in a message of type
   INIT_MSG, and sends back a reply of type REPLY_MSG 
*/










