/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: xs.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/02/24 23:23:11 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: xs.c,v $
 * Revision 1.2  1995/02/24 23:23:11  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/trivia/xs.c,v 1.2 1995/02/24 23:23:11 jyelon Exp $";
#include "head.h"
#include "common.h"
#define XS
#include "xs.h"
#undef XS


data_xs_create_menu_buttons(menu, menulist, nitems, data)
Widget menu;
xs_menu_struct *menulist;
int nitems;
graphics_data *data;
{
        int i, n;
        Arg wargs[10];
        WidgetList buttons;
        int separators = 0;

        buttons = (WidgetList) XtMalloc(nitems * sizeof(Widget));
        for (i=0; i<nitems; i++)
        {
                if (menulist[i].name ==  NULL)
                {
                        XtCreateManagedWidget("separator",
                                        xmSeparatorWidgetClass, menu,
                                        NULL, 0);
                        separators++;
                }
                else
                if (menulist[i].func)
                {
						n=0;
                        XtSetArg(wargs[n], XmNuserData, menulist[i].data); n++;
                        buttons[i-separators] =
                                XtCreateWidget(menulist[i].name,
                                        xmPushButtonWidgetClass, menu,
                                        wargs, n);
                        XtAddCallback(buttons[i - separators],
                                        XmNactivateCallback, menulist[i].func,
                                        data);

                }
                else
                if (!menulist[i].sub_menu)
                        buttons[i-separators] =
                                        XtCreateWidget(menulist[i].name,
                                                xmLabelWidgetClass,
                                                menu, NULL, 0);
                else
                {
                        Widget sub_menu;
                        sub_menu = XmCreatePulldownMenu(menu,
                                        menulist[i].sub_menu_title,
                                        NULL, 0);
                        XtSetArg(wargs[0], XmNsubMenuId, sub_menu);
                        buttons[i-separators] =
                        XtCreateWidget(menulist[i].name,
                                        xmCascadeButtonWidgetClass,
                                        menu, wargs, 1);
                        data_xs_create_menu_buttons(sub_menu,
                                        menulist[i].sub_menu,
                                        menulist[i].n_sub_items, data);
                }
        }
        XtManageChildren(buttons, nitems - separators);
}


data_toggle_buttons(menu, menulist, nitems, data)
Widget menu;
xs_menu_struct *menulist;
int nitems;
graphics_data *data;
{
        int i, n;
        Arg wargs[10];
        WidgetList buttons;
        int separators = 0;

        buttons = (WidgetList) XtMalloc(nitems * sizeof(Widget));
        for (i=0; i<nitems; i++)
        {
                if (menulist[i].name ==  NULL)
                {
                        XtCreateManagedWidget("separator",
                                        xmSeparatorWidgetClass, menu,
                                        NULL, 0);
                        separators++;
                }
                else
                if (menulist[i].func)
                {
						n=0;
                        XtSetArg(wargs[n], XmNuserData, menulist[i].data); n++;
                        XtSetArg(wargs[n], XmNshadowThickness, 3); n++;
						data->toggle_buttons[data->no_toggle_buttons++] =
                        	buttons[i-separators] =
								XmCreateToggleButtonGadget(menu,
                        				menulist[i].name, wargs, n);
                        XtAddCallback(buttons[i - separators],
                                        XmNvalueChangedCallback,
										menulist[i].func, data);
                }
                else
                if (!menulist[i].sub_menu)
                        buttons[i-separators] =
                                        XtCreateWidget(menulist[i].name,
                                                xmLabelWidgetClass,
                                                menu, NULL, 0);
                else
                {
                        Widget sub_menu;
                        sub_menu = XmCreatePulldownMenu(menu,
                                        menulist[i].sub_menu_title,
                                        NULL, 0);
                        XtSetArg(wargs[0], XmNsubMenuId, sub_menu);
                        buttons[i-separators] =
                        XtCreateWidget(menulist[i].name,
                                        xmCascadeButtonWidgetClass,
                                        menu, wargs, 1);
                        data_toggle_buttons(sub_menu,
                                        menulist[i].sub_menu,
                                        menulist[i].n_sub_items, data);
                }
        }
        XtManageChildren(buttons, nitems - separators);
}


/** Page 104 **/
xs_create_menu_buttons(title, menu, menulist, nitems)
char *title;
Widget menu;
xs_menu_struct *menulist;
int nitems;
{
	Arg wargs[1];
	int i;
	WidgetList buttons;
	int separators = 0;

	buttons = (WidgetList) XtMalloc(nitems * sizeof(Widget));
	if (title)
	{
		XtCreateManagedWidget(title, xmLabelWidgetClass, menu,
				NULL, 0);
		XtCreateManagedWidget("separator", xmSeparatorWidgetClass,
				menu, NULL, 0);
	}

	for (i=0; i<nitems; i++)
	{
		if (menulist[i].name ==  NULL)
		{
			XtCreateManagedWidget("separator",
					xmSeparatorWidgetClass, menu,
					NULL, 0);
			separators++;
		}
		else
		if (menulist[i].func)
		{
			buttons[i-separators] =
				XtCreateWidget(menulist[i].name,
					xmPushButtonWidgetClass, menu, NULL,
					0);
			XtAddCallback(buttons[i - separators],
					XmNactivateCallback, menulist[i].func,
					menulist[i].data);
		}
		else
		if (!menulist[i].sub_menu)
			buttons[i-separators] =
					XtCreateWidget(menulist[i].name,
						xmLabelWidgetClass,
						menu, NULL, 0);
		else
		{
			Widget sub_menu;
			sub_menu = XmCreatePulldownMenu(menu,
					menulist[i].sub_menu_title,
					NULL, 0);
			XtSetArg(wargs[0], XmNsubMenuId, sub_menu);
			buttons[i-separators] =
			XtCreateWidget(menulist[i].name, 
					xmCascadeButtonWidgetClass,
					menu, wargs, 1);
			xs_create_menu_buttons(menulist[i].sub_menu_title,
					sub_menu, menulist[i].sub_menu,
					menulist[i].n_sub_items);
		}
	}
	XtManageChildren(buttons, nitems - separators);
}


/** 198 **/
xs_register_pattern(w, name, bits, width, height)
Widget w;
char *name;
unsigned char *bits;
int width, height;
{
	XImage *image;

	image = XCreateImage(XtDisplay(w),
			DefaultVisualOfScreen(XtScreen(w)),
			1, XYBitmap, 0,
			bits, width, height, 8 , 2);
	XmInstallImage(image, name);
}


Widget xs_create_pixmap_button(parent, pattern)
Widget parent;
char *pattern;
{
	Pixmap tile;
	Widget button;
	Arg wargs[10];
	Pixel foreground, background;
	int n;

	button = XtCreateWidget(pattern, xmToggleButtonWidgetClass,
			parent, NULL, 0);
	n = 0;
	XtSetArg(wargs[n], XtNforeground, &foreground);  n++;
	XtSetArg(wargs[n], XtNbackground, &background);  n++;
	XtGetValues(button, wargs, n);

	tile = XmGetPixmap(XtScreen(button), pattern, 
			foreground, background);
	n = 0;
	XtSetArg(wargs[n], XmNlabelType, XmPIXMAP);  n++;
	XtSetArg(wargs[n], XmNlabelPixmap, tile);  n++;
	XtSetArg(wargs[n], XmNuserData, tile);  n++;
	XtSetValues(button, wargs, n);

	return button;
}


Widget xs_create_pixmap_browser(parent, tiles, n_tiles, callback, data)
Widget parent;
char *tiles[];
int n_tiles;
void (*callback)();
caddr_t data;
{
	Widget browser;
	WidgetList buttons;
	int i;
	Arg wargs[10];

	buttons = (WidgetList)  XtMalloc(n_tiles * sizeof(Widget));
	XtSetArg(wargs[0], XmNentryClass, xmToggleButtonWidgetClass);
	browser = XmCreateRadioBox(parent, "browser", wargs, 1);

	for (i=0; i<n_tiles; i++)
	{
		buttons[i] = xs_create_pixmap_button(browser, tiles[i]);
		if (callback)
			XtAddCallback(buttons[i], XmNvalueChangedCallback,
				callback, data);
	}
	XtManageChildren(buttons, n_tiles);
	return browser;
}
	

/** 261 **/
GC xs_create_xor_gc(w)
Widget w;
{
	XGCValues values;
	GC gc;
	Arg wargs[10];

	XtSetArg(wargs[0], XtNforeground, &values.foreground);
	XtSetArg(wargs[1], XtNbackground, &values.background);
	XtGetValues(w, wargs, 2);

	values.foreground = values.foreground ^ values.background;
	values.line_style = LineOnOffDash;
	values.function = GXxor;
	gc = XtGetGC(w, GCForeground | GCBackground | GCFunction |
			GCLineStyle, &values);
	return gc;
}



XmString xs_concat_words(n, words)
int n;
char *words[];
{
	XmString xmstr;
	int 	 i, len = 0;

	if (n<=0)
		return(XmStringCreate("", XmSTRING_DEFAULT_CHARSET));
	xmstr = (XmString) NULL;

	for (i=0; i<n; i++)
	{
		XmString tmp;

		if (i>0)
		{
			tmp = XmStringCreate(" ", XmSTRING_DEFAULT_CHARSET);
			xmstr = XmStringConcat(xmstr, tmp);
		}

		tmp = XmStringCreate(words[i], XmSTRING_DEFAULT_CHARSET);
		xmstr = XmStringConcat(xmstr, tmp);
	}
	return xmstr;
}


count_toggle_buttons(menulist, nitems, data)
xs_menu_struct *menulist;
int nitems;
graphics_data *data;
{
		int i;
        int count = 0;

        for (i=0; i<nitems; i++)
        {
                if (!menulist[i].name)
					continue;
                if (menulist[i].func) {
					count++;
					continue;
				}
                if (menulist[i].sub_menu)
                        count += count_toggle_buttons(menulist[i].sub_menu,
                                        menulist[i].n_sub_items, data);
        }
		return count;
}


