/***************************************************************************
 * RCS INFORMATION:
 *
 *  $RCSfile: main.c,v $
 *  $Author: milind $  $Locker:  $    $State: Exp $
 *  $Revision: 1.5 $  $Date: 1997/04/03 17:59:36 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: main.c,v $
 * Revision 1.5  1997/04/03 17:59:36  milind
 * Got projections to run on HPUX. Restored the timeline view.
 * Detected a bug in tachyon removal that causes -ve percentatges.
 * Haven't a clue as to why it is happening.
 * Forced a workaround.
 *
 * Revision 1.4  1995/10/27 18:26:52  sanjeev
 * removed Message Utilizations menu item.
 *
 * Revision 1.3  1995/09/21  21:08:09  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:23:10  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/main/main.c,v 1.5 1997/04/03 17:59:36 milind Exp $";
#include <sys/param.h>
#define MAIN
#include "head.h"
#include "common.h"
#undef MAIN

#define DEFAULT_TIMESTEP 2000
#define DEFAULT_PE    1

extern int print_upshot_file;

void animation_callback();
void quit_callback();
void total_callback();
void detailed_callback();
void options_callback();
void overview_callback();
void timestep_callback();
void parallelism_callback();
void grainsize_callback();
void util_callback();
void legend_callback();
void create_expert_window();


xs_menu_struct detailed_charm_entries[] = {
  {"Time", detailed_callback, CONSTANT_PE},
  {"Processor", detailed_callback, CONSTANT_STAGE}
};
xs_menu_struct detailed_charm[] = {
  {"Detailed    ", NULL, 0, 
    detailed_charm_entries, XtNumber(detailed_charm_entries),
    ""}
};


xs_menu_struct overview_pe_entries[] = {
  {"Number of messages", overview_callback, OVERVIEW_PE},
  {"Granularity of tasks", grainsize_callback, OVERVIEW_PE}/* , */
/*  {"Message utilizations", util_callback, UTIL_PE}  */
};
xs_menu_struct overview_stage_entries[] = {
  {"Number of messages", overview_callback, OVERVIEW_STAGE},
  {"Granularity of tasks", grainsize_callback, OVERVIEW_STAGE}
};

xs_menu_struct overview_charm_entries[] = {
  {"Time", NULL, 0, overview_stage_entries,
        XtNumber(overview_stage_entries), ""},
  {"Processor", NULL, 0, overview_pe_entries,
        XtNumber(overview_pe_entries), ""}
};
xs_menu_struct overview_charm[] = {
  {"OverView     ", NULL, 0, 
    overview_charm_entries, XtNumber(overview_charm_entries),
    ""}
};

xs_menu_struct animation_charm_entries[] = {
  {"Topologies", animation_callback, 0} 
};
xs_menu_struct animation_charm[] = {
  {"Animation   ", NULL, 0, 
    animation_charm_entries, XtNumber(animation_charm_entries),
    ""}
};

xs_menu_struct analysis_charm_entries[] = {
  {"Expert Analysis", create_expert_window, 0}
};
xs_menu_struct analysis_charm[] = {
  {"Analysis   ", NULL, 0, 
    analysis_charm_entries, XtNumber(analysis_charm_entries),
    ""}
};

xs_menu_struct file_charm_entries[] = {
  {"Quit", quit_callback, 0}
};
xs_menu_struct file_charm[] = {
  {"File    ", NULL, 0, 
    file_charm_entries, XtNumber(file_charm_entries), ""}
};

xs_menu_struct edit_charm_entries[] = {
  {"Set Time Step", timestep_callback, 0}
};
xs_menu_struct edit_charm[] = {
  {"Edit    ", NULL, 0, 
    edit_charm_entries, XtNumber(edit_charm_entries), ""}
};

xs_menu_struct view_charm_entries[] = {
  {"Show Legend", legend_callback, 0}
};

xs_menu_struct view_charm[] = {
  {"View    ", NULL, 0, 
    view_charm_entries, XtNumber(view_charm_entries), ""}
};

/*************************************************************************/
/** prints usage.                            **/
/*************************************************************************/
print_usage()
{
  printf("Usage: Projections +l <file> [+t <n>] [+y]  \n");
  exit(0);
}

/*************************************************************************/
/** This function is called to quit the program.      **/
/*************************************************************************/
void quit_callback(w, flag, data)
Widget w;
int *flag;
XmAnyCallbackStruct *data;
{
  XtCloseDisplay(XtDisplay(w));
  exit(0);
}


/*************************************************************************/
/** Function to determine user-defined options for the tool.    **/
/*************************************************************************/

ParseCommandOptions(argc, argv)
int argc;
char **argv;
{
    int i;
  char pathname[1024];
  char *pwd = (char *) getcwd(pathname, 1024);

  timestep = DEFAULT_TIMESTEP;

  i=1;
  if (argc<=1) {
    print_usage();
    exit(0);
  }
  while (i<argc) 
  {
    if( strcmp( argv[i], "+t") == 0)
    {  
      if (i+1<argc )
        sscanf(argv[i+1], "%d", &timestep) ;
      i+=2;
    }
    else
    if( strcmp( argv[i], "+l") == 0)
    {
      pgm_filename = (char *) malloc(strlen(argv[i+1]) +
            strlen(pwd) + 3);
      if (i+1<argc )
        sprintf(pgm_filename, "%s/%s",
             pwd, argv[i+1]) ;
      i+=2;
    }  
    else
    if( strcmp( argv[i], "+y") == 0) {
      adjust_for_tachyon  = 1;
      tachyon_algo=1;
      i += 1;
    }
    else
      print_usage();
  }
}



/*************************************************************************/
/** This is the main body of the program.        **/
/*************************************************************************/

main(argc, argv)
int argc;
char *argv[];
{
  int n;
  Arg wargs[10];

  Widget toplevel; 
  Widget selections, menu_bar;
  Widget main_window, framework; 


  adjust_for_tachyon  = 0;
  ParseCommandOptions(argc, argv);
  current_window_pos = 0;

  toplevel = XtInitialize(argv[0], "Charmer",
        NULL, 0, &argc, argv);

  n=0;
  XtSetArg(wargs[n], XtNtitle, "Projections.2.0"); n++;
  main_window = XmCreateMainWindow(toplevel, "main_window", wargs, n);
  XtManageChild(main_window);

  /*********************************************************/
  /** Create the menu as a bulletin board. The resources  **/
  /** file will specify the position of the kids.    **/
  /*********************************************************/
  n=0;
  XtSetArg(wargs[n], XmNorientation, XmVERTICAL); n++;
  framework = XtCreateManagedWidget("framework", 
        xmRowColumnWidgetClass,
        main_window, wargs, n);

  /*************************************************/
  /** Create the frame containing the quit and the**/
  /** parameters buttons.        **/
  /*************************************************/
  menu_bar = XmCreateMenuBar(main_window, "menu_bar", NULL, 0);
  XtManageChild(menu_bar);

  xs_create_menu_buttons(NULL, menu_bar, file_charm,
        XtNumber(file_charm));
  xs_create_menu_buttons(NULL, menu_bar, edit_charm,
        XtNumber(edit_charm));
  xs_create_menu_buttons(NULL, menu_bar, view_charm,
        XtNumber(view_charm));

  /*********************************************************/
  /** Now create the menu buttons for the main menu.  **/
  /*********************************************************/
  selections = XmCreateMenuBar(framework, "selection", NULL, 0);
  XtManageChild(selections);
  xs_create_menu_buttons(NULL, selections, overview_charm,
        XtNumber(overview_charm));

  xs_create_menu_buttons(NULL, selections, detailed_charm,
        XtNumber(detailed_charm));

  xs_create_menu_buttons(NULL, selections, animation_charm,
        XtNumber(animation_charm));
  xs_create_menu_buttons(NULL, selections, analysis_charm,
        XtNumber(analysis_charm));


  analyse();

  create_options_struct(chare_list, number_chares);
  create_grainsize_struct(chare_list, number_chares);
  create_util_struct(chare_list, number_chares);

  XtRealizeWidget(toplevel);
  XtMainLoop();
}


