#include "head.h"
#include "common.h"
#include "graphics.h"

char *determine_title();

/*****************************************************************/
/** Draw the scales for this graph.				**/
/*****************************************************************/
draw_util_scale(data)
graphics_data *data;
{
	int i, j;
	int pixels;
	int ydispl;
	char str[100];
	int xpeno, ypeno;
	Font font1, font2;
	int xoffset, yoffset;
    int busy_xoffset, busy_length;
	YAXISTITLE *ytitle1, *ytitle2;
	XFontStruct *font_struct1, *font_struct2;

	int type = data->type ;

	int xstep = data->xstep;
	int xscale = data->xscale;
	int xheight = data->xheight;
	int xorigin 	= (3*XDISPLACEMENT)/2;
	int xdivisons = data->xdivisons;

	int ystep = data->ystep;
	int yscale = data->yscale;
	int yheight = data->yheight;
	int yorigin 	= YDISPLACEMENT;
	int ydivisons = data->ydivisons;	

    int busy_step = data->busy_ystep;
    int busy_scale = data->busy_yscale;

	int start_xdivs = data->start_xdivs;
	int finish_xdivs = data->finish_xdivs;

	int min = data->min; 
	int max = data->max;
    int busy_min = data->busy_min;
    int busy_max = data->busy_max;

	GC gc = data->gc2;
	Widget w = data->canvas2;
	
	font1 = XLoadFont(XtDisplay(w), "8x13");
	font_struct1 = XQueryFont(XtDisplay(w), font1);

	ytitle1 = (YAXISTITLE *) malloc(sizeof(YAXISTITLE));
	ytitle1->count_y_title = 2;
	ytitle1->y_title[0] = (char *) malloc(strlen("PERCENT") + 1);
	strcpy(ytitle1->y_title[0], "PERCENT");
	ytitle1->y_title[1] = (char *) malloc(strlen("BUSY") + 1);
	strcpy(ytitle1->y_title[1], "BUSY");


	/*********************************************************/
	/** First figure out the origin and offset. Reverse y	**/
	/** coordinates because otherwise we get an inverted 	**/
	/** coordinate system.					**/
	/*********************************************************/
	data->xoffset = xoffset = xorigin;
	data->yoffset = yoffset = yheight - yorigin;
    busy_xoffset = xoffset + ((xdivisons-1)*xscale)/xstep;
	draw_line(w, gc, 	
			xoffset, yoffset, 
			xoffset + ((xdivisons - 1)*xscale)/xstep, yoffset);
	draw_line(w, gc, 
			xoffset, yoffset, 
			xoffset, yoffset - int_ceil(ydivisons, ystep)*yscale); 

	/*********************************************************/
	/** Draw the x-axis, its divisons, and the labels.	**/
	/*********************************************************/
	sprintf(str, "%d", 0);
	pixels = XTextWidth(font_struct1, str, strlen(str));
	ypeno = yoffset + 2*pixels;
	for (i=start_xdivs; i<=finish_xdivs; i+=xstep)
	{
		int k;
		int xpe;

		k = i - start_xdivs;
		xpe = xoffset + (k*xscale)/xstep; 
		draw_line(w, gc, 
			xpe, yoffset - YSCALE/4,
			xpe, yoffset + YSCALE/4);
		sprintf(str, "%d", i);
		xpe -= 4;
		draw_string(w, gc, xpe, yoffset + YSCALE, str,
				strlen(str), "8x13");
	}

	/*********************************************************/
	/** Draw the y-axis, its divisons, and the labels.	**/
	/*********************************************************/
/**
	for (j=min; j<max+ystep; j+=ystep)
	{
		int k;

		k = j - min;
		draw_line(w, gc, 
			xoffset - XSCALE/4, yoffset - (k*yscale)/ystep,
			xoffset + XSCALE/4, yoffset - (k*yscale)/ystep);
		sprintf(str, "%d", j);
		pixels = XTextWidth(font_struct1, str, strlen(str));
		xpeno = xoffset - pixels -
			XTextWidth(font_struct1, "0", 
			strlen("0"));
		ypeno = yoffset - (k*yscale)/ystep; 
		draw_string(w, gc, xpeno, ypeno, str, strlen(str), "8x13");
	}
*/

    busy_length = 0;
    for (j=busy_min; j<data->busy_max+busy_step; j+=busy_step)
    {
        int k;
 
        k = j-busy_min;
        draw_line(w, gc, 
            busy_xoffset - XSCALE/4,
            yoffset - (k*busy_scale)/busy_step,
            busy_xoffset + XSCALE/4,
            yoffset - (k*busy_scale)/busy_step);
        sprintf(str, "%d", j);
        xpeno = busy_xoffset + 
                XTextWidth(font_struct1, "00", strlen("00"));
        ypeno = yoffset - (k*busy_scale)/busy_step; 
        draw_string(w, gc, xpeno, ypeno, str, strlen(str), "8x13");
        busy_length += busy_scale;
    }
 
    busy_length -= busy_scale;
    draw_line(w, gc, 
            busy_xoffset, yoffset, 
            busy_xoffset, yoffset - busy_length);

	/*********************************************************/
	/** Get the fonts for the axis titles.			**/
	/*********************************************************/
	font2 = XLoadFont(XtDisplay(w),  "6x12");
	font_struct2 = XQueryFont(XtDisplay(w), font2);

	/*********************************************************/
	/** First write the title for the X-axis.		**/
	/*********************************************************/
	pixels = XTextWidth(font_struct2, data->xtitle, strlen(data->xtitle));
	xpeno = ((xscale*(xdivisons-1))/xstep - pixels)/2 + XDISPLACEMENT;
	ypeno = (yoffset + YDISPLACEMENT/2); 
	draw_string(w, gc, xpeno, ypeno, data->xtitle, strlen(data->xtitle), "6x12");
	ypeno =  (yoffset + YDISPLACEMENT/2);

	/*********************************************************/
	/** Now write the title for the y-axis.			**/
	/*********************************************************/
/*
	ydispl = yoffset - 
		((yscale*ydivisons)/ystep + 
			(ytitle1->count_y_title*
			(font_struct2->ascent + YSEPARATION)))/2;

	for (i=0; i<ytitle1->count_y_title; i++)
	{
		pixels = XTextWidth(font_struct2, ytitle1->y_title[i],
					strlen(ytitle1->y_title[i]));
		ypeno = ydispl + i*(font_struct2->ascent + YSEPARATION);
		xpeno = (xoffset - (3*XDISPLACEMENT)/2 + 10); 
		draw_string(w, gc, xpeno, ypeno, ytitle1->y_title[i], 
			strlen(ytitle1->y_title[i]),  "6x12");
	}
*/

    ydispl = yoffset -
        ((yscale*ydivisons)/ystep +
            (ytitle1->count_y_title*
            (font_struct2->ascent + YSEPARATION)))/2;
 
    for (i=0; i<ytitle1->count_y_title; i++)
    {
        pixels = XTextWidth(font_struct2, ytitle1->y_title[i],
                    strlen(ytitle1->y_title[i]));
        ypeno = ydispl + i*(font_struct2->ascent + YSEPARATION);
        xpeno = busy_xoffset + 50;
        draw_string(w, gc, xpeno, ypeno, ytitle1->y_title[i],
            strlen(ytitle1->y_title[i]),  "6x12");
    }

}





/*****************************************************************/
/** This function is called to draw the graph. The last parameter**/
/** is necessary to know which type of graph it is -- scrolled/	**/
/** stage-by-stage.						**/
/*****************************************************************/
draw_util_graph(data, is_ep, is_creation, table, ydivisons, min, yscale, ystep, count) 
graphics_data *data;
int is_ep, is_creation, table;
int ydivisons, min, yscale, ystep, count;
{
	int i, j;
	int idash;
	Font font; 
	char *str;
	XPoint *points;
	int current_point = 0;
	XFontStruct *font_struct;
	int per_row, start_xmap, start_ymap;

    int xheight = data->xheight;
    int yheight = data->yheight;
    int xdivisons = data->xdivisons;

    int start_xdivs = data->start_xdivs;
    int finish_xdivs = data->finish_xdivs;
	int xoffset = data->xoffset;
	int yoffset = data->yoffset;
    int xscale = data->xscale;
    int xstep = data->xstep;

	int begin_pe = data->begin_pe;
	int end_pe = data->end_pe;
	int begin_stages = data->begin_stages;
	int end_stages = data->end_stages;

	GC gc = data->gc2;
	Widget w = data->canvas2;
	
    set_color_and_line_type(w, gc, is_creation, table);

	points = (XPoint *) malloc(sizeof(XPoint)*xdivisons);
	switch (data->view_type) {
	case UTIL_PE: 
		for (i=start_xdivs; i<=finish_xdivs; i++)
		{
			int total;
			double dtot=0.0 ;
	
			total = 0;
			idash = i - start_xdivs;
			for (j=begin_stages; j<=end_stages; j++) {
				if ( is_ep ) 
					dtot += grainsize_table[table].list[i][j].sum;
				else 
					total += display_table[table][i][j];
			}
			if ( is_ep ) { 
				dtot = 100.0*dtot/((end_stages-begin_stages+1)*timestep) ;
				total = (int)dtot ;
			}
			else 
				total /= (end_stages - begin_stages + 1);

			points[current_point].x = 
				xoffset + (idash*xscale)/xstep;
			points[current_point].y = 
				yoffset - (yscale* (total - min))/ystep;
			current_point++;
		}
		break;

	case UTIL_STAGE:
		for (i=start_xdivs; i<=finish_xdivs; i++)
		{
			int total, number;
	
			total = number = 0;
			idash = i - start_xdivs;
			for (j=begin_pe; j<=end_pe; j++) {
				total += grainsize_table[table].list[j][i].sum;
				number += grainsize_table[table].list[j][i].no;
			}
			if (number) total /= (number*1000);
			else total = 0;
			points[current_point].x = 
				xoffset + (idash*xscale)/xstep;
			points[current_point].y = 
				yoffset - (yscale* (total - min))/ystep;
	
			current_point++;
		}
		break;
	}

	for (i=0; i<current_point-1; i++)
		if (points[i].y != yoffset || points[i+1].y != yoffset)
			draw_line(w, gc, points[i].x, points[i].y, 
					points[i+1].x, points[i+1].y);
}


/*****************************************************************/
/** This procedure is called to draw the bar diagram. It first	**/
/** calls the function, draw_scale, to draw the scales, and then**/
/** it calls the functions draw_bars to draw the bars. 		**/
/*****************************************************************/
void draw_util(data)
graphics_data *data;
{
	int i;
	int page;
	int count;
	int min, max;
	int busy_step; 
	int xdivisons, start_xdivs, finish_xdivs;
	int xstep, ystep, xscale, yscale, ydivisons;
	int busy_scale;

	XClearArea(XtDisplay(data->canvas2), XtWindow(data->canvas2),
			0, 0, 0, 0, FALSE);

    set_util_parameters(data, 
			data->begin_pe, data->end_pe, data->begin_stages,
			data->end_stages);

    xstep = data->xstep;
    xscale = data->xscale;
    ystep = data->ystep;
    yscale = data->yscale;
    ydivisons = data->ydivisons;
    min = data->min;
    max = data->max;
    start_xdivs = data->start_xdivs;
    finish_xdivs = data->finish_xdivs;
    xdivisons = finish_xdivs - start_xdivs + 1;

	draw_util_scale(data);
	draw_legend_information(data);


	for (i=0; i<NUMBER_DISPLAYS; i++)
	{
		if (data->chosen[i])
		{
			if (i==IDLE_TIME || i==OVERHEAD_TIME)
				draw_util_graph(data, FALSE, FALSE, i,data->busy_ydivisons,
						data->busy_min, data->busy_yscale, data->busy_ystep);
		}
	}

	for (i=0; i<number_entries; i++)
		if (data->ep_p_chosen[i])
			draw_util_graph(data, TRUE, FALSE, i, data->busy_ydivisons,
						data->busy_min, data->busy_yscale, data->busy_ystep);

	XSetLineAttributes(XtDisplay(data->canvas2), data->gc2, 1,
		 LineSolid, CapButt, JoinMiter);
	XSetForeground(XtDisplay(data->canvas2), data->gc2,
		data->foreground);
}
