/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: legend_graphics.c,v $
 *	$Author: jyelon $	$Locker:  $		$State: Exp $
 *	$Revision: 1.2 $	$Date: 1995/02/24 23:23:03 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: legend_graphics.c,v $
 * Revision 1.2  1995/02/24 23:23:03  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/graphics/legend_graphics.c,v 1.2 1995/02/24 23:23:03 jyelon Exp $";
#include "head.h"
#include "common.h"
#include "graphics.h"
#include "legend.h"

extern graphics_data *current_data;
extern char *determine_title();


/*****************************************************************/
/** Draw the legend.											**/
/*****************************************************************/
draw_complete_legend(data)
graphics_data *data;
{
	int i;
	int x, y;
	Font font;
	char string[100];
	GC gci = data->gci;
	XFontStruct *font_struct;
	Widget wi = data->information;

    XClearArea(XtDisplay(wi), XtWindow(wi), 0, 0, 0, 0, FALSE);
	font = XLoadFont(XtDisplay(wi),  "8x13");
	font_struct = XQueryFont(XtDisplay(wi), font);

    /*********************************************************/
    /** Now write the timestep and the processors.          **/
    /*********************************************************/
	x=XOFFSET;
	y=YOFFSET;
    sprintf(string, "Timestep: %d", timestep);
    draw_string(wi, gci, x, y, string, strlen(string), "6x12");
	y += YSKIP;
    sprintf(string, "Stages: %d", stages);
    draw_string(wi, gci, x, y, string, strlen(string), "6x12");
	y += YSKIP;
    sprintf(string, "Processors: %d", number_pe);
    draw_string(wi, gci, x, y, string, strlen(string), "6x12");
	y += YSKIP;

	for (i=0; i<NUMBER_DISPLAYS; i++)
	{
		set_color_and_line_type(wi, gci, FALSE, i);
		legend_information(wi, gci, FALSE, FALSE, i, x, y, 50);
		y += YSKIP;
	}

    for (i=0; i<number_entries; i++)
	{	
		set_color_and_line_type(wi, gci, TRUE, i);
		legend_information(wi, gci, TRUE, TRUE, i, x, y, 50);
		y += YSKIP;

		set_color_and_line_type(wi, gci, FALSE, i);
		legend_information(wi, gci, TRUE, FALSE, i, x, y, 50);
		y += YSKIP;
	}

    XSetLineAttributes(XtDisplay(data->information), data->gci, 1,
                 LineSolid, CapButt, JoinMiter);
	XSetForeground(XtDisplay(data->information), data->gci,
					data->foregroundi);
}

