/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: grainsize_graphics.c,v $
 *	$Author: milind $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1997/04/03 17:59:34 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: grainsize_graphics.c,v $
 * Revision 1.3  1997/04/03 17:59:34  milind
 * Got projections to run on HPUX. Restored the timeline view.
 * Detected a bug in tachyon removal that causes -ve percentatges.
 * Haven't a clue as to why it is happening.
 * Forced a workaround.
 *
 * Revision 1.2  1995/02/24 23:23:03  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/graphics/grainsize_graphics.c,v 1.3 1997/04/03 17:59:34 milind Exp $";
#include "head.h"
#include "common.h"
#include "graphics.h"

char *determine_title();

/*****************************************************************/
/** Draw the scales for this graph.				**/
/*****************************************************************/
draw_grainsize_scale(data)
graphics_data *data;
{
	int i, j;
	int pixels;
	int ydispl;
	char str[100];
	int xpeno, ypeno;
	Font font1, font2;
	YAXISTITLE *ytitle1;
	int xoffset, yoffset;
	XFontStruct *font_struct1, *font_struct2;

	int xstep = data->xstep;
	int xscale = data->xscale;
	int xheight = data->xheight;
	int xorigin 	= (3*XDISPLACEMENT)/2;
	int xdivisons = data->xdivisons;

	int ystep = data->ystep;
	int yscale = data->yscale;
	int yheight = data->yheight;
	int yorigin 	= YDISPLACEMENT;
	int ydivisons = data->ydivisons;	

	int start_xdivs = data->start_xdivs;
	int finish_xdivs = data->finish_xdivs;

	int min = data->min; 
	int max = data->max;

	GC gc = data->gc2;
	Widget w = data->canvas2;
	
	font1 = XLoadFont(XtDisplay(w), "8x13");
	font_struct1 = XQueryFont(XtDisplay(w), font1);

	ytitle1 = (YAXISTITLE *) malloc(sizeof(YAXISTITLE));
	ytitle1->count_y_title = 2;
	ytitle1->y_title[0] = (char *) malloc(strlen("GRANULARITY") + 1);
	strcpy(ytitle1->y_title[0], "GRANULARITY");
	ytitle1->y_title[1] = (char *) malloc(strlen("(milliseconds)") + 1);
	strcpy(ytitle1->y_title[1], "(milliseconds)");


	/*********************************************************/
	/** First figure out the origin and offset. Reverse y	**/
	/** coordinates because otherwise we get an inverted 	**/
	/** coordinate system.					**/
	/*********************************************************/
	data->xoffset = xoffset = xorigin;
	data->yoffset = yoffset = yheight - yorigin;
	draw_line(w, gc, 	
			xoffset, yoffset, 
			xoffset + ((xdivisons - 1)*xscale)/xstep, yoffset);
	draw_line(w, gc, 
			xoffset, yoffset, 
			xoffset, yoffset - int_ceil(ydivisons, ystep)*yscale); 

	/*********************************************************/
	/** Draw the x-axis, its divisons, and the labels.	**/
	/*********************************************************/
	sprintf(str, "%d", 0);
	pixels = XTextWidth(font_struct1, str, strlen(str));
	ypeno = yoffset + 2*pixels;
	for (i=start_xdivs; i<=finish_xdivs; i+=xstep)
	{
		int k;
		int xpe;

		k = i - start_xdivs;
		xpe = xoffset + (k*xscale)/xstep; 
		draw_line(w, gc, 
			xpe, yoffset - YSCALE/4,
			xpe, yoffset + YSCALE/4);
		sprintf(str, "%d", i);
		xpe -= 4;
		draw_string(w, gc, xpe, yoffset + YSCALE, str,
				strlen(str), "8x13");
	}

	/*********************************************************/
	/** Draw the y-axis, its divisons, and the labels.	**/
	/*********************************************************/
	for (j=min; j<max+ystep; j+=ystep)
	{
		int k;

		k = j - min;
		draw_line(w, gc, 
			xoffset - XSCALE/4, yoffset - (k*yscale)/ystep,
			xoffset + XSCALE/4, yoffset - (k*yscale)/ystep);
		sprintf(str, "%d", j);
		pixels = XTextWidth(font_struct1, str, strlen(str));
		xpeno = xoffset - pixels -
			XTextWidth(font_struct1, "0", 
			strlen("0"));
		ypeno = yoffset - (k*yscale)/ystep; 
		draw_string(w, gc, xpeno, ypeno, str, strlen(str), "8x13");
	}

	/*********************************************************/
	/** Get the fonts for the axis titles.			**/
	/*********************************************************/
	font2 = XLoadFont(XtDisplay(w),  "6x12");
	font_struct2 = XQueryFont(XtDisplay(w), font2);

	/*********************************************************/
	/** First write the title for the X-axis.		**/
	/*********************************************************/
	pixels = XTextWidth(font_struct2, data->xtitle, strlen(data->xtitle));
	xpeno = ((xscale*(xdivisons-1))/xstep - pixels)/2 + XDISPLACEMENT;
	ypeno = (yoffset + YDISPLACEMENT/2); 
	draw_string(w, gc, xpeno, ypeno, data->xtitle, strlen(data->xtitle), "6x12");
	ypeno =  (yoffset + YDISPLACEMENT/2);

	/*********************************************************/
	/** Now write the title for the y-axis.			**/
	/*********************************************************/
	ydispl = yoffset - 
		((yscale*ydivisons)/ystep + 
			(ytitle1->count_y_title*
			(font_struct2->ascent + YSEPARATION)))/2;

	for (i=0; i<ytitle1->count_y_title; i++)
	{
		pixels = XTextWidth(font_struct2, ytitle1->y_title[i],
					strlen(ytitle1->y_title[i]));
		ypeno = ydispl + i*(font_struct2->ascent + YSEPARATION);
		xpeno = (xoffset - (3*XDISPLACEMENT)/2 + 10); 
		draw_string(w, gc, xpeno, ypeno, ytitle1->y_title[i], 
			strlen(ytitle1->y_title[i]),  "6x12");
	}
}





/*****************************************************************/
/** This function is called to draw the graph. The last parameter**/
/** is necessary to know which type of graph it is -- scrolled/	**/
/** stage-by-stage.						**/
/*****************************************************************/
draw_grainsize_graph(data, is_ep, is_creation, table, ydivisons, min, yscale, ystep, count) 
graphics_data *data;
int is_ep, is_creation, table;
int ydivisons, min, yscale, ystep, count;
{
	int i, j;
	int temp;
	int idash;
	Font font; 
	char *str;
	XPoint *points;
	int current_point = 0;
	XFontStruct *font_struct;
	int per_row, start_xmap, start_ymap;

    int xheight = data->xheight;
    int yheight = data->yheight;
    int xdivisons = data->xdivisons;

    int start_xdivs = data->start_xdivs;
    int finish_xdivs = data->finish_xdivs;
	int xoffset = data->xoffset;
	int yoffset = data->yoffset;
    int xscale = data->xscale;
    int xstep = data->xstep;

	int begin_pe = data->begin_pe;
	int end_pe = data->end_pe;
	int begin_stages = data->begin_stages;
	int end_stages = data->end_stages;

	GC gc = data->gc2;
	Widget w = data->canvas2;
	
    set_color_and_line_type(w, gc, is_creation, table);

	points = (XPoint *) malloc(sizeof(XPoint)*xdivisons);
	switch (data->view_type) {
	case OVERVIEW_PE: 
		for (i=start_xdivs; i<=finish_xdivs; i++)
		{
			int total, number;
	
			total = number = 0;
			idash = i - start_xdivs;
			for (j=begin_stages; j<=end_stages; j++) {
				total += grainsize_table[table].list[i][j].sum;
				/*number += temp*grainsize_table[table].list[i][j].no;*/
				number += grainsize_table[table].list[i][j].no;
			}
			if (number) total /= (number*1000);
			else total = 0;
			points[current_point].x = 
				xoffset + (idash*xscale)/xstep;
			points[current_point].y = 
				yoffset - (yscale* (total - min))/ystep;
			current_point++;
		}
		break;

	case OVERVIEW_STAGE:
		for (i=start_xdivs; i<=finish_xdivs; i++)
		{
			int total, number;
	
			total = number = 0;
			idash = i - start_xdivs;
			for (j=begin_pe; j<=end_pe; j++) {
				total += grainsize_table[table].list[j][i].sum;
				/*number += temp*grainsize_table[table].list[j][i].no;*/
				number += grainsize_table[table].list[j][i].no;
			}
			if (number) total /= (number*1000);
			else total = 0;
			points[current_point].x = 
				xoffset + (idash*xscale)/xstep;
			points[current_point].y = 
				yoffset - (yscale* (total - min))/ystep;
	
			current_point++;
		}
		break;
	}

	for (i=0; i<current_point-1; i++)
		if (points[i].y != yoffset || points[i+1].y != yoffset)
			draw_line(w, gc, points[i].x, points[i].y, 
					points[i+1].x, points[i+1].y);
}


/*****************************************************************/
/** This procedure is called to draw the bar diagram. It first	**/
/** calls the function, draw_scale, to draw the scales, and then**/
/** it calls the functions draw_bars to draw the bars. 		**/
/*****************************************************************/
void draw_grainsize(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	int n;
	Arg wargs[10];

	int i;
	int page;
	int count;
	int min, max;
	int busy_step; 
	int xdivisons, start_xdivs, finish_xdivs;
	int xstep, ystep, xscale, yscale, ydivisons;
	int busy_scale;

	n=0;
	XtSetArg(wargs[n], XmNuserData, &i); n++;
	XtGetValues(w, wargs, n);
	if (data->ep_p_chosen[i])
		data->ep_p_chosen[i] = FALSE;
	else
		data->ep_p_chosen[i] = TRUE;

	XClearArea(XtDisplay(data->canvas2), XtWindow(data->canvas2),
			0, 0, 0, 0, FALSE);

    set_grainsize_parameters(data, 
			data->begin_pe, data->end_pe, data->begin_stages,
			data->end_stages);

    xstep = data->xstep;
    xscale = data->xscale;
    ystep = data->ystep;
    yscale = data->yscale;
    ydivisons = data->ydivisons;
    min = data->min;
    max = data->max;
    start_xdivs = data->start_xdivs;
    finish_xdivs = data->finish_xdivs;
    xdivisons = finish_xdivs - start_xdivs + 1;

	draw_grainsize_scale(data);
	draw_legend_information(data);


	for (i=0; i<number_entries; i++)
		if (data->ep_p_chosen[i])
			draw_grainsize_graph(data, TRUE, FALSE, i, data->ydivisons,
						data->min, data->yscale, data->ystep);

	XSetLineAttributes(XtDisplay(data->canvas2), data->gc2, 1,
		 LineSolid, CapButt, JoinMiter);
	XSetForeground(XtDisplay(data->canvas2), data->gc2,
		data->foreground);
}
