/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: timeline.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/09/21 21:09:15 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: timeline.c,v $
 * Revision 1.3  1995/09/21 21:09:15  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:53  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/callbacks/timeline.c,v 1.3 1995/09/21 21:09:15 sanjeev Exp $";
#include "head.h"
#include "common.h"
#include "xs.h"
#include "graphics.h"
#include "timeline.h"
#include "data.h"


void timeline_quit_callback();
void timeline_enlarge_callback();
void timeline_shrink_callback();
void timeline_creation_callback();

static xs_menu_struct timeline_file_entries[] = {
        {"Quit", timeline_quit_callback, 0} };

static xs_menu_struct timeline_file[] = {
        {"File     ", NULL, 0,
                timeline_file_entries, XtNumber(timeline_file_entries), ""} };

static xs_menu_struct timeline_view_entries[] = {
		{"Creation relation", timeline_creation_callback, 0}, 
		{"Enlarge", timeline_enlarge_callback, 0}, 
		{"Shrink",  timeline_shrink_callback, 0}
};

static  xs_menu_struct timeline_view[] = {
	{"View", NULL, 0, timeline_view_entries, 
			XtNumber(timeline_view_entries), ""}
};


/*****************************************************************/
/*****************************************************************/
void timeline_quit_callback(w, data, call_data)
Widget w;
timeline_data *data;
XmAnyCallbackStruct *call_data;
{
	free(data);
	XtDestroyWidget(data->shell);
}

/*****************************************************************/
/*****************************************************************/
void timeline_creation_callback(w, data, call_data)
Widget w;
timeline_data *data;
XmAnyCallbackStruct *call_data;
{
	data->creator = TRUE;
    draw_timeline(data->gdata, data->gc1, data->gc2,
                    data->canvas1, data->canvas2,
                    data->start_pe, data->finish_pe,
                    data->start_time, data->finish_time, data->min,
                    data->xmagnify, data->creator);
}


void timeline_enlarge_callback(w, data, call_data)
Widget w;
timeline_data *data;
XmAnyCallbackStruct *call_data;
{
	int n;
	Arg wargs[10];

	data->xmagnify = data->xmagnify/2;
	if (data->xmagnify < 20) return;

	XClearArea(XtDisplay(data->canvas1), XtWindow(data->canvas1), 
						0, 0, 0, 0, FALSE);
	XClearArea(XtDisplay(data->canvas2), XtWindow(data->canvas2), 
						0, 0, 0, 0, FALSE);
    n=0;
	XtSetArg(wargs[n], XtNwidth, 
			2*XS + (data->max - data->min + 1)/data->xmagnify); n++;
	XtSetValues(data->canvas2, wargs, n);

	draw_timeline(data->gdata, data->gc1, data->gc2, 
					data->canvas1, data->canvas2, 
					data->start_pe, data->finish_pe, 
					data->start_time, data->finish_time, data->min,
					data->xmagnify, data->creator);
}

/*****************************************************************/
/*****************************************************************/
void timeline_shrink_callback(w, data, call_data)
Widget w;
timeline_data *data;
XmAnyCallbackStruct *call_data;
{
	int n;
	Arg wargs[10];

	data->xmagnify = 2*data->xmagnify;
	XClearArea(XtDisplay(data->canvas1), XtWindow(data->canvas1), 
						0, 0, 0, 0, FALSE);
	XClearArea(XtDisplay(data->canvas2), XtWindow(data->canvas2), 
						0, 0, 0, 0, FALSE);
    n=0;
	XtSetArg(wargs[n], XtNwidth, 
			2*XS + (data->max - data->min + 1)/data->xmagnify); n++;
	XtSetValues(data->canvas2, wargs, n);

	draw_timeline(data->gdata, data->gc1, data->gc2, 
					data->canvas1, data->canvas2, 
					data->start_pe, data->finish_pe, 
					data->start_time, data->finish_time, data->min,
					data->xmagnify, data->creator);
}


/*****************************************************************/
/** This callback is called when the button on the processor is **/
/** clicked for any of the selections. temp_data is the name of **/
/** the selection. A shell is created, and the command and 	**/
/** canvas widgets are created as children of this shell.	**/
/*****************************************************************/
void timeline_callback(w, data, event)
Widget w;
graphics_data *data;
XEvent *event;
{
	int i;
	int n;
	GC gc1, gc2;
	int min, max;
	Arg wargs[10];
    XGCValues values;
	timeline_data *tdata;
	XSetWindowAttributes w_attr;
	Widget shell1, main_window1, framework1, menu_bar; 
	Widget canvas_form, scrolled_window, canvas1, canvas2;
	unsigned int t1, t2, start_pe, finish_pe, start_time, finish_time;

	/* if (data->type == TOTAL_PE || data->type == TOTAL_STAGE) return; */

	tdata = (timeline_data *) malloc(sizeof(timeline_data));
	tdata->gdata = data;
	tdata->xmagnify = 200;

	data->clicks_coords[data->clicks][0] = event->xbutton.x;
	data->clicks_coords[data->clicks][1] = event->xbutton.y;
	if (++data->clicks == 1)
		return;
	data->clicks = 0;

	n=0;
    XtSetArg(wargs[n], XtNtitle, "Time Line"); n++;
	tdata->shell = shell1 =
				XtCreateApplicationShell("shell1", topLevelShellWidgetClass,
				wargs, n);

	main_window1 = XmCreateMainWindow(shell1, "main_window1", NULL, 0);
	XtManageChild(main_window1);

	n=0;
	XtSetArg(wargs[n], XmNmarginWidth, 2); n++;
	XtSetArg(wargs[n], XmNmarginHeight, 2); n++;
	XtSetArg(wargs[n], XmNshadowThickness, 1); n++;
	XtSetArg(wargs[n], XmNshadowType, XmSHADOW_OUT); n++;
	framework1 = XtCreateManagedWidget("framework1",
			xmFrameWidgetClass, main_window1, wargs, n);

	/*************************************************/
	/** Create the canvas and the command frames.	**/
	/*************************************************/
	canvas_form = XtCreateManagedWidget("canvas_form",
			xmFormWidgetClass, framework1, NULL, 0);
	create_and_init_canvas(canvas_form, &canvas1, &gc1, data);

    n=0;
	XtSetArg(wargs[n], XmNscrollingPolicy, XmAUTOMATIC); n++;
	scrolled_window = XtCreateManagedWidget("scrolled_window",
					xmScrolledWindowWidgetClass, canvas_form, wargs, n);

	create_and_init_canvas(scrolled_window, &canvas2, &gc2, data);

    n=0;
	XtSetArg(wargs[n], XmNworkWindow, canvas2); n++;
	XtSetValues(scrolled_window, wargs, n);

    /* XtAddCallback(canvas_form, XmNresizeCallback,
            resize_timeline_callback, tdata); */

	/*************************************************/
	/** Create the frame containing the quit and the**/
	/** parameters buttons.				**/
	/*************************************************/
	n=0;
	XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_FORM); n++;
	XtSetValues(canvas1, wargs, n);

	n=0;
	XtSetArg(wargs[n], XmNtopAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNbottomAttachment, XmATTACH_FORM); n++;
	XtSetArg(wargs[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
	XtSetArg(wargs[n], XmNleftWidget, canvas1); n++;
	XtSetArg(wargs[n], XmNrightAttachment, XmATTACH_FORM); n++;
	XtSetValues(scrolled_window, wargs, n);

    /*************************************************/
    /** Create the frame containing the quit and the**/
    /** parameters buttons.             **/
    /*************************************************/
    menu_bar = XmCreateMenuBar(main_window1, "menu_bar", NULL, 0);
    XtManageChild(menu_bar);
    data_xs_create_menu_buttons(menu_bar, timeline_file,
                XtNumber(timeline_file), tdata);
    data_xs_create_menu_buttons(menu_bar, timeline_view,
                XtNumber(timeline_view), tdata);


	/*********************************************************/
    /** Draw the y-axis, its divisons, and the labels.      **/
	/*********************************************************/
	t1 = ((data->clicks_coords[0][0]-data->xoffset)*data->xstep)/data->xscale +
				data->start_xdivs;
	t2 = ((data->clicks_coords[1][0]-data->xoffset)*data->xstep)/data->xscale + 
				data->start_xdivs;

	if (t1 > t2)
	{
		start_pe = t1;
		t1 = t2;
		t2 = start_pe;
	}

	switch (data->type)
	{  
	case TOTAL_STAGE:
		start_time = data->begin_stages*timestep + begin_time;
		finish_time = data->end_stages*timestep + begin_time;
		start_pe = t1;
		finish_pe = t2;
		break;

	case CONSTANT_STAGE:
		start_pe = t1;
		finish_pe = t2;
		start_time =  data->current*timestep + begin_time;
		finish_time =  (data->current+1)*timestep + begin_time - 1;
		break;

	case TOTAL_PE:
		start_pe = data->begin_pe;
		finish_pe = data->end_pe;
		start_time = begin_time + t1*timestep;
		finish_time = begin_time + t2*timestep;
		break;

	case CONSTANT_PE:	
		start_time = begin_time + t1*timestep;
		finish_time = begin_time + t2*timestep;
		start_pe = finish_pe = data->current;
		break;
	}


	min = start_time;
	max = finish_time;
	for (i=start_pe; i<=finish_pe; i++)
	{
		TRANSACTION *t;

		t = find_lesser(i, start_time);
		if (t == NULL) return;
		if (min > t->info->timep1)
			min =  t->info->timep1;

		t = find_greater(i, finish_time);
		if (t == NULL) return;
		if (max < t->info->timep2)
			max = t->info->timep2;
	}

    n=0;
	XtSetArg(wargs[n], XtNwidth, 2*XS); n++;
	XtSetArg(wargs[n], XtNheight,
			2*YS + YS*(finish_pe - start_pe + 2)); n++;
	XtSetValues(canvas1, wargs, n);

	if ((max-min+1)/tdata->xmagnify > 1000)
		tdata->xmagnify = (max-min+1)/1000;
    n=0;
	XtSetArg(wargs[n], XtNwidth, 
			2*XS + (max - min + 1)/tdata->xmagnify); n++;
	XtSetArg(wargs[n], XtNheight, 
			2*YS + YS*(finish_pe - start_pe + 2)); n++;
	XtSetValues(canvas2, wargs, n);

    n=0;
	XtSetArg(wargs[n], XtNwidth, SCROLL_WIDTH); n++;
	XtSetArg(wargs[n], XtNheight, 
				2*YS + YS*(finish_pe - start_pe+2)); 
	n++;
	XtSetValues(scrolled_window, wargs, n);


    /*************************************************/
	/** Now initialize some of the canvas parametes.**/
	/*************************************************/
	w_attr.backing_store = Always;

	XtRealizeWidget(shell1);
	XChangeWindowAttributes(XtDisplay(canvas1), XtWindow(canvas1),
						CWBackingStore, &w_attr);
	XChangeWindowAttributes(XtDisplay(canvas2),
							XtWindow(canvas2), CWBackingStore, &w_attr);

	XClearArea(XtDisplay(canvas1), XtWindow(canvas1), 0, 0, 0, 0, FALSE);
	XClearArea(XtDisplay(canvas2), XtWindow(canvas2), 0, 0, 0, 0, FALSE);


	/*************************************************/
	/** Draw it.									**/
	/*************************************************/
	tdata->gc1 = gc1;
	tdata->gc2 = gc2;
	tdata->canvas1 = canvas1;
	tdata->canvas2 = canvas2;
	tdata->start_pe = start_pe; 
	tdata->finish_pe = finish_pe; 
	tdata->start_time = start_time; 
	tdata->finish_time = finish_time;
    tdata->scrolled_window = scrolled_window;
    tdata->canvas_form = canvas_form;
	tdata->min = min;
	tdata->max = max;
	tdata->creator = 0;
	draw_timeline(data, gc1, gc2, canvas1, canvas2, 
					start_pe, finish_pe, start_time, finish_time, min,
					tdata->xmagnify, tdata->creator);
}

void timeline_activate_callback(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
    XtAddEventHandler(data->canvas2, ButtonPressMask, FALSE,
						timeline_callback, data);
    XGrabButton(XtDisplay(data->canvas2), AnyButton, AnyModifier,
                XtWindow(data->canvas2), TRUE, ButtonPressMask,
                GrabModeAsync, GrabModeAsync, XtWindow(data->canvas2),
                XCreateFontCursor(XtDisplay(data->canvas2), XC_crosshair));
}
