/***************************************************************************
 * RCS INFORMATION:
 *
 *	$RCSfile: parameters.c,v $
 *	$Author: sanjeev $	$Locker:  $		$State: Exp $
 *	$Revision: 1.3 $	$Date: 1995/09/21 21:09:15 $
 *
 ***************************************************************************
 * DESCRIPTION:
 *
 ***************************************************************************
 * REVISION HISTORY:
 *
 * $Log: parameters.c,v $
 * Revision 1.3  1995/09/21 21:09:15  sanjeev
 * *** empty log message ***
 *
 * Revision 1.2  1995/02/24  23:22:53  jyelon
 * *** empty log message ***
 *
 ***************************************************************************/
static char ident[] = "@(#)$Header: /expand1/cvsroot/projections/sources/callbacks/parameters.c,v 1.3 1995/09/21 21:09:15 sanjeev Exp $";
#include "head.h"
#include "common.h"
#include "xs.h"
#include "graphics.h"
#include "parameters.h"


/*****************************************************************/
/** This function is the call back when the cancel button in 	**/
/** the command menu is pressed.				**/
/*****************************************************************/
void parameters_cancel_callback(w, data, call_data)
Widget w;
struct parameters_widgets *data;
XmAnyCallbackStruct *call_data;
{
	XtDestroyWidget(data->parameters);
}


/*****************************************************************/
/** This function is the call back when the ok button in 	**/
/** the command menu is pressed.				**/
/*****************************************************************/
void parameters_ok_callback(w, data, call_data)
Widget w;
struct parameters_widgets *data;
XmAnyCallbackStruct *call_data;
{
	int status = 0;
	int begin_pe, end_pe, begin_stages, end_stages;

	begin_pe = atoi (XmTextGetString(data->pe_begin_text));
	status = check_for_range(begin_pe, number_pe);

	end_pe   = atoi (XmTextGetString(data->pe_end_text));
	status = status && check_for_range(end_pe, number_pe);

	begin_stages = atoi (XmTextGetString(data->stages_begin_text));
	status = status && check_for_range(begin_stages, stages);

	end_stages   = atoi (XmTextGetString(data->stages_end_text));
	status = status && check_for_range(end_stages, stages);

	if (status)
	{
		graphics_data *gdata = data->data;

		switch (gdata->type) {

		case TOTAL_PE:
		case TOTAL_STAGE:
		case CONSTANT_PE:
		case CONSTANT_STAGE:
			set_detailed_parameters(gdata, gdata->type,
			 	begin_pe, end_pe,
				begin_stages, end_stages);
			draw_display(gdata, gdata->type); 
			break;

		case OVERVIEW_PE:
		case OVERVIEW_STAGE:
			set_overview_parameters(gdata, 
				gdata->type, begin_pe, end_pe,
				begin_stages, end_stages);
			draw_overview(gdata);
			break;

		case UTIL_PE:
		case UTIL_STAGE:
			gdata->view_type = gdata->type ;
			set_util_parameters(gdata, 
				begin_pe, end_pe,
				begin_stages, end_stages);
			draw_util(gdata);
			break;

		case GRID:
			gdata->begin_pe = begin_pe;
			gdata->end_pe = end_pe;
			gdata->begin_stages = begin_stages;
			gdata->end_stages = end_stages;
			gdata->current = 0;
			break;

		case EXPERT:
			gdata->begin_pe = begin_pe;
			gdata->end_pe = end_pe;
			gdata->begin_stages = begin_stages;
			gdata->end_stages = end_stages;
			break;
		}
	}
	else
		printf("*** ERROR *** Unable to change range.\n");
	XtDestroyWidget(data->parameters);
}


/*****************************************************************/
/** This function is the call back for the clicking of the time	**/
/** options button in the display menu. A new shell is 		**/
/** created. 							**/
/*****************************************************************/
void parameters_callback(w, data, call_data)
Widget w;
graphics_data *data;
XmAnyCallbackStruct *call_data;
{
	int n;
	Arg wargs[10];
	char string[100];
	XmString message;
	Widget pe_frame, pe_board;
	Widget framework4, ok, cancel;
	Widget processor, pe_begin, pe_end;
	Widget pe_begin_text, pe_end_text;
	Widget stages_frame, stages_board;
	Widget stages_widget, stages_begin, stages_end;
	Widget stages_begin_text, stages_end_text;
	struct parameters_widgets *parameters_widget_data;



        n=0;
	sprintf(string, "Set Ranges");
	message = XmStringCreate(string, XmSTRING_DEFAULT_CHARSET);
	XtSetArg(wargs[n], XmNdialogTitle, message);  n++;
        XtSetArg(wargs[n], XmNdialogStyle, XmDIALOG_SYSTEM_MODAL); n++;
        framework4  = XmCreateBulletinBoardDialog(w, "framework4", wargs, n);

	/*************************************************/
	/** First create the frame for the processor 	**/
	/** display. Then create the labels, and finally**/
	/** the text widgets. 				**/
	/*************************************************/
	n=0;
	XtSetArg(wargs[n], XmNx, PE_FRAME_X);  n++;
	XtSetArg(wargs[n], XmNy, PE_FRAME_Y);  n++;
	pe_frame = XtCreateManagedWidget("pe_frame", 
					xmFrameWidgetClass,
					framework4, wargs, n);
	n=0;
	XtSetArg(wargs[n], XmNx, PE_BOARD_X);  n++;
	XtSetArg(wargs[n], XmNy, PE_BOARD_Y);  n++;
	pe_board = XtCreateManagedWidget("pe_board", 
					xmBulletinBoardWidgetClass,
					pe_frame, wargs, n);

	sprintf(string, "Processors: 0 --- %d", number_pe - 1);
	message = XmStringCreate(string, XmSTRING_DEFAULT_CHARSET);
	n=0;
	XtSetArg(wargs[n], XmNlabelString, message);  n++;
	XtSetArg(wargs[n], XmNx, PROCESSOR_X);  n++;
	XtSetArg(wargs[n], XmNy, PROCESSOR_Y);  n++;
	processor = XtCreateManagedWidget(PROCESSOR,
					xmLabelWidgetClass, 
					pe_board, wargs, n);
	string[0] = '\0';

	sprintf(string, "Begin:");
	message = XmStringCreate(string, XmSTRING_DEFAULT_CHARSET);
	n=0;
	XtSetArg(wargs[n], XmNlabelString, message); n++; 
	XtSetArg(wargs[n], XmNx, PE_BEGIN_X);  n++;
	XtSetArg(wargs[n], XmNy, PE_BEGIN_Y);  n++;
	pe_begin = XtCreateManagedWidget(PE_BEGIN,
					xmLabelWidgetClass, 
					pe_board, wargs, n);
	string[0] = '\0';

	sprintf(string, "End:");
	message = XmStringCreate(string, XmSTRING_DEFAULT_CHARSET);
	n=0;
	XtSetArg(wargs[n], XmNlabelString, message); n++; 
	XtSetArg(wargs[n], XmNx, PE_END_X);  n++;
	XtSetArg(wargs[n], XmNy, PE_END_Y);  n++;
	pe_end = XtCreateManagedWidget(PE_END,
					xmLabelWidgetClass, 
					pe_board, wargs, n);
	string[0] = '\0';

	n=0;
	XtSetArg(wargs[n], XmNx, PE_BEGIN_TEXT_X);  n++;
	XtSetArg(wargs[n], XmNy, PE_BEGIN_TEXT_Y);  n++;
	pe_begin_text = XtCreateManagedWidget(PE_BEGIN_TEXT,
					xmTextWidgetClass, 
					pe_board, wargs, n);
	sprintf(string, "%d", data->begin_pe);
	XmTextSetString(pe_begin_text, string); n++;

	n=0;
	XtSetArg(wargs[n], XmNx, PE_END_TEXT_X);  n++;
	XtSetArg(wargs[n], XmNy, PE_END_TEXT_Y);  n++;
	pe_end_text = XtCreateManagedWidget(PE_END_TEXT,
					xmTextWidgetClass, 
					pe_board, wargs, n);
	sprintf(string, "%d", data->end_pe);
	XmTextSetString(pe_end_text, string); n++;

	/*************************************************/
	/** Similar to the creation of the processor	**/
	/** display, create the frame, then the bulletin**/
	/** board for the children widgets, then the 	**/
	/** label and the text widgets.			**/ 
	/*************************************************/
	n=0;
	XtSetArg(wargs[n], XmNx, STAGES_FRAME_X);  n++;
	XtSetArg(wargs[n], XmNy, STAGES_FRAME_Y);  n++;
	stages_frame = XtCreateManagedWidget("stages_frame", 
					xmFrameWidgetClass,
					framework4, wargs, n);
	n=0;
	XtSetArg(wargs[n], XmNx, STAGES_BOARD_X);  n++;
	XtSetArg(wargs[n], XmNy, STAGES_BOARD_Y);  n++;
	stages_board = XtCreateManagedWidget("stages_board", 
					xmBulletinBoardWidgetClass,
					stages_frame, wargs, n);

	sprintf(string, "Stages: 0 --- %d", stages - 1);
	message = XmStringCreate(string, XmSTRING_DEFAULT_CHARSET);
	n=0;
	XtSetArg(wargs[n], XmNlabelString, message);  n++;
	XtSetArg(wargs[n], XmNx, STAGES_WIDGET_X);  n++;
	XtSetArg(wargs[n], XmNy, STAGES_WIDGET_Y);  n++;
	stages_widget = XtCreateManagedWidget(STAGES_WIDGET,
					xmLabelWidgetClass, 
					stages_board, wargs, n);
	string[0] = '\0';

	sprintf(string, "Begin:");
	message = XmStringCreate(string, XmSTRING_DEFAULT_CHARSET);
	n=0;
	XtSetArg(wargs[n], XmNlabelString, message); n++; 
	XtSetArg(wargs[n], XmNx, STAGES_BEGIN_X);  n++;
	XtSetArg(wargs[n], XmNy, STAGES_BEGIN_Y);  n++;
	stages_begin = XtCreateManagedWidget(STAGES_BEGIN,
					xmLabelWidgetClass, 
					stages_board, wargs, n);
	string[0] = '\0';

	sprintf(string, "End:");
	message = XmStringCreate(string, XmSTRING_DEFAULT_CHARSET);
	n=0;
	XtSetArg(wargs[n], XmNlabelString, message); n++; 
	XtSetArg(wargs[n], XmNx, STAGES_END_X);  n++;
	XtSetArg(wargs[n], XmNy, STAGES_END_Y);  n++;
	stages_end = XtCreateManagedWidget(STAGES_END,
					xmLabelWidgetClass, 
					stages_board, wargs, n);
	string[0] = '\0';

	n=0;
	XtSetArg(wargs[n], XmNx, STAGES_BEGIN_TEXT_X);  n++;
	XtSetArg(wargs[n], XmNy, STAGES_BEGIN_TEXT_Y);  n++;
	stages_begin_text = XtCreateManagedWidget(STAGES_BEGIN_TEXT,
					xmTextWidgetClass, 
					stages_board, wargs, n);
	sprintf(string, "%d", data->begin_stages);
	XmTextSetString(stages_begin_text, string); n++;

	n=0;
	XtSetArg(wargs[n], XmNx, STAGES_END_TEXT_X);  n++;
	XtSetArg(wargs[n], XmNy, STAGES_END_TEXT_Y);  n++;
	stages_end_text = XtCreateManagedWidget(STAGES_END_TEXT,
					xmTextWidgetClass, 
					stages_board, wargs, n);
	sprintf(string, "%d", data->end_stages);
	XmTextSetString(stages_end_text, string); n++;

	/*************************************************/
	/** Now store the values of the widgets in 	**/
	/** the data for the parameters.		**/
	/*************************************************/
	parameters_widget_data = (struct parameters_widgets *)
			malloc(sizeof(struct parameters_widgets));
	parameters_widget_data->parameters = framework4;
	parameters_widget_data->pe_begin_text = pe_begin_text;
	parameters_widget_data->pe_end_text = pe_end_text;
	parameters_widget_data->stages_begin_text = stages_begin_text;
	parameters_widget_data->stages_end_text = stages_end_text;

	parameters_widget_data->data = data;

        n=0;
        XtSetArg(wargs[n], XmNx, OK_X);  n++;
        XtSetArg(wargs[n], XmNy, OK_Y);  n++;
        ok = XtCreateManagedWidget(OK, xmPushButtonWidgetClass,
                                        framework4, wargs, n);
	XtAddCallback(ok, XmNactivateCallback,
			parameters_ok_callback, parameters_widget_data);

        n=0;
        XtSetArg(wargs[n], XmNx, CANCEL_X);  n++;
        XtSetArg(wargs[n], XmNy, CANCEL_Y);  n++;
        cancel = XtCreateManagedWidget(CANCEL, xmPushButtonWidgetClass,
                                        framework4, wargs, n);
	XtAddCallback(cancel, XmNactivateCallback,
			parameters_cancel_callback, parameters_widget_data);

	XtManageChild(framework4);
}

